/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.OCSPRequestExtension;
import com.rsa.certj.cert.extensions.X509V3Extension;

public class OCSPNonce
extends X509V3Extension
implements OCSPRequestExtension {
    private byte[] nonceValue;
    private int nonceValueLen;
    ASN1Template asn1TemplateValue;

    public OCSPNonce() {
        this.extensionTypeFlag = 120;
        this.criticality = false;
        this.setSpecialOID(OCSP_NONCE_OID);
        this.extensionTypeString = "OCSPNonce";
        this.nonceValue = null;
        this.nonceValueLen = 0;
    }

    public OCSPNonce(byte[] nonce, int offset, int len) {
        this.extensionTypeFlag = 120;
        this.setSpecialOID(OCSP_NONCE_OID);
        this.extensionTypeString = "OCSPNonce";
        this.criticality = false;
        this.setNonceValue(nonce, offset, len);
    }

    public void setNonceValue(byte[] nonce, int offset, int len) {
        if (nonce == null || len == 0) {
            return;
        }
        this.nonceValue = new byte[len];
        System.arraycopy(nonce, offset, this.nonceValue, 0, len);
        this.nonceValueLen = len;
    }

    public byte[] getNonceValue() {
        if (this.nonceValue == null) {
            return null;
        }
        return this.nonceValue;
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        OctetStringContainer localNonceValue = new OctetStringContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{localNonceValue};
        try {
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            this.nonceValue = null;
            this.nonceValueLen = 0;
            throw new CertificateException("Could not decode OCSPNonce extension.");
        }
        this.setNonceValue(localNonceValue.data, localNonceValue.dataOffset, localNonceValue.dataLen);
    }

    public int derEncodeValueInit() {
        if (this.nonceValue == null || this.nonceValueLen == 0) {
            return 0;
        }
        try {
            OctetStringContainer nonceValueDER = new OctetStringContainer(0, true, 0, this.nonceValue, 0, this.nonceValueLen);
            ASN1Container[] asn1Def = new ASN1Container[]{nonceValueDER};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        OCSPNonce otherSelf = new OCSPNonce();
        if (this.nonceValue != null) {
            otherSelf.nonceValueLen = this.nonceValueLen;
            otherSelf.nonceValue = new byte[otherSelf.nonceValueLen];
            System.arraycopy(this.nonceValue, 0, otherSelf.nonceValue, 0, otherSelf.nonceValueLen);
        }
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.asn1TemplateValue = null;
    }
}

