/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.GenTimeContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.OCSPSingleExtension;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.extensions.AuthorityInfoAccess;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCSPServiceLocator
extends X509V3Extension
implements OCSPSingleExtension {
    private X500Name issuer;
    private AuthorityInfoAccess locator;
    ASN1Template asn1TemplateValue;

    public OCSPServiceLocator() {
        this.extensionTypeFlag = 122;
        this.criticality = false;
        this.setSpecialOID(OCSP_SERVICE_LOCATOR_OID);
        this.extensionTypeString = "OCSPServiceLocator";
        this.issuer = null;
        this.locator = null;
    }

    public OCSPServiceLocator(X500Name name, AuthorityInfoAccess locator) throws CertificateException {
        if (name == null || locator == null) {
            throw new CertificateException("Missing values");
        }
        this.extensionTypeFlag = 122;
        this.criticality = false;
        this.setSpecialOID(OCSP_SERVICE_LOCATOR_OID);
        this.extensionTypeString = "OCSPServiceLocator";
        try {
            this.issuer = (X500Name)name.clone();
            this.locator = (AuthorityInfoAccess)locator.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new CertificateException(ex);
        }
    }

    @Override
    public int derEncodeValueInit() {
        if (this.issuer == null) {
            return 0;
        }
        int nameDERLen = this.issuer.getDERLen(0);
        byte[] nameDER = new byte[nameDERLen];
        try {
            this.issuer.getDEREncoding(nameDER, 0, nameDER.length);
        }
        catch (NameException ex) {
            return 0;
        }
        try {
            EncodedContainer locatorExtDER;
            SequenceContainer seq = new SequenceContainer(0, true, 0);
            EncodedContainer issuerNameDER = new EncodedContainer(65280, true, 0, nameDER, 0, nameDER.length);
            if (this.locator != null) {
                byte[] locatorDER = this.getAIADER(this.locator);
                locatorExtDER = new EncodedContainer(65536, true, 0, locatorDER, 0, locatorDER.length);
            } else {
                locatorExtDER = new EncodedContainer(65536, false, 0, null, 0, 0);
            }
            EndContainer anEnd = new EndContainer();
            ASN1Container[] asn1Def = new ASN1Container[]{seq, issuerNameDER, locatorExtDER, anEnd};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    private EncodedContainer encodeDescription(int index, Vector<byte[]> accessMethod, Vector<GeneralName> accessLocation) throws CertificateException {
        EncodedContainer next;
        SequenceContainer seq = new SequenceContainer(0, true, 0);
        EndContainer end = new EndContainer();
        byte[] oid = accessMethod.elementAt(index);
        try {
            OIDContainer id = new OIDContainer(0x1000000, true, 0, oid, 0, oid.length);
            GeneralName location = accessLocation.elementAt(index);
            byte[] encoding = new byte[location.getDERLen(0)];
            int len = location.getDEREncoding(encoding, 0, 0);
            EncodedContainer loc = new EncodedContainer(0, true, 0, encoding, 0, len);
            ASN1Container[] asn1Def = new ASN1Container[]{seq, id, loc, end};
            ASN1Template templ = new ASN1Template(asn1Def);
            int encodingLen = templ.derEncodeInit();
            byte[] desc = new byte[encodingLen];
            encodingLen = templ.derEncode(desc, 0);
            next = new EncodedContainer(12288, true, 0, desc, 0, encodingLen);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException(" Can't encode Access Description");
        }
        catch (NameException nameException) {
            throw new CertificateException("Could not encode Access Description ");
        }
        return next;
    }

    private byte[] getAIADER(AuthorityInfoAccess locator) {
        Vector<GeneralName> accessLocation = new Vector<GeneralName>();
        Vector<byte[]> accessMethod = new Vector<byte[]>();
        int aiaCount = locator.getAccessDescriptionCount();
        if (aiaCount == 0) {
            return null;
        }
        try {
            for (int i = 0; i < aiaCount; ++i) {
                byte[] locatorAccessMethod = locator.getAccessMethod(i);
                byte[] method = new byte[locatorAccessMethod.length];
                System.arraycopy(locatorAccessMethod, 0, method, 0, locatorAccessMethod.length);
                accessMethod.addElement(method);
                accessLocation.addElement(locator.getAccessLocation(i));
            }
        }
        catch (CertificateException ex) {
            return null;
        }
        try {
            Vector<OfContainer> asn1Def = new Vector<OfContainer>();
            OfContainer seqOf = new OfContainer(0, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
            asn1Def.addElement(seqOf);
            for (int i = 0; i < accessMethod.size(); ++i) {
                EncodedContainer encContainer = this.encodeDescription(i, accessMethod, accessLocation);
                seqOf.addContainer((ASN1Container)encContainer);
            }
            Object[] asn1DefArray = new ASN1Container[asn1Def.size()];
            asn1Def.copyInto(asn1DefArray);
            ASN1Template templateValue = new ASN1Template((ASN1Container[])asn1DefArray);
            int derLen = templateValue.derEncodeInit();
            byte[] derEncoding = new byte[derLen];
            templateValue.derEncode(derEncoding, 0);
            return derEncoding;
        }
        catch (Exception anyExc) {
            return null;
        }
    }

    @Override
    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    @Override
    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        GenTimeContainer dateValue = new GenTimeContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{dateValue};
        try {
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode ArchiveCutoff extension.");
        }
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public AuthorityInfoAccess getLocator() {
        return this.locator;
    }

    public void setIssuer(X500Name issuer) throws CloneNotSupportedException {
        if (issuer == null) {
            throw new CloneNotSupportedException("Missing value");
        }
        try {
            this.issuer = (X500Name)issuer.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new CloneNotSupportedException(ex.getMessage());
        }
    }

    public void setLocator(AuthorityInfoAccess locator) throws CloneNotSupportedException {
        if (locator == null) {
            throw new CloneNotSupportedException("Missing value");
        }
        try {
            this.locator = (AuthorityInfoAccess)locator.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new CloneNotSupportedException(ex.getMessage());
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        OCSPServiceLocator otherSelf = new OCSPServiceLocator();
        if (this.issuer != null) {
            otherSelf.issuer = (X500Name)this.issuer.clone();
        }
        if (this.locator != null) {
            otherSelf.locator = (AuthorityInfoAccess)this.locator.clone();
        }
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }
}

