/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.BuiltInDomainDefinedAttributes;
import com.rsa.certj.cert.extensions.BuiltInStandardAttributes;
import com.rsa.certj.cert.extensions.ExtensionAttributes;
import java.io.Serializable;

public class ORAddress
implements Cloneable,
Serializable {
    private BuiltInStandardAttributes standardAttr;
    private BuiltInDomainDefinedAttributes domainAttr;
    private ExtensionAttributes extensionAttr;
    protected int special;
    protected ASN1Template asn1Template;

    public ORAddress(byte[] valueBER, int offset, int special) throws NameException {
        this.special = special;
        if (valueBER == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            SequenceContainer seq = new SequenceContainer(special);
            EndContainer anEnd = new EndContainer();
            EncodedContainer standard = new EncodedContainer(12288);
            EncodedContainer domain = new EncodedContainer(77824);
            EncodedContainer extension = new EncodedContainer(78080);
            ASN1Container[] nameDef = new ASN1Container[]{seq, standard, domain, extension, anEnd};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])nameDef);
            this.standardAttr = new BuiltInStandardAttributes(standard.data, standard.dataOffset, 0);
            if (domain.dataPresent) {
                this.domainAttr = new BuiltInDomainDefinedAttributes(domain.data, domain.dataOffset, 0);
            }
            if (extension.dataPresent) {
                this.extensionAttr = new ExtensionAttributes(extension.data, extension.dataOffset, 0);
            }
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Cannot decode the BER of the ORAddress.", (Exception)((Object)asnException));
        }
    }

    public ORAddress() {
    }

    public void setBuiltInStandardAttributes(BuiltInStandardAttributes attr) {
        if (attr != null) {
            this.standardAttr = attr;
        }
    }

    public void setBuiltInDomainDefinedAttributes(BuiltInDomainDefinedAttributes attr) {
        if (attr != null) {
            this.domainAttr = attr;
        }
    }

    public void setExtensionAttributes(ExtensionAttributes attr) {
        if (attr != null) {
            this.extensionAttr = attr;
        }
    }

    public BuiltInStandardAttributes getBuiltInStandardAttributes() {
        return this.standardAttr;
    }

    public BuiltInDomainDefinedAttributes getBuiltInDomainDefinedAttributes() {
        return this.domainAttr;
    }

    public ExtensionAttributes getExtensionAttributes() {
        return this.extensionAttr;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.standardAttr != null) {
            buffer.append(this.standardAttr.toString());
        }
        if (this.domainAttr != null) {
            if (buffer.length() != 0) {
                buffer.append(",");
            }
            buffer.append(this.domainAttr.toString());
        }
        if (this.extensionAttr != null) {
            if (buffer.length() != 0) {
                buffer.append(",");
            }
            buffer.append(this.extensionAttr.toString());
        }
        return buffer.toString();
    }

    public static int getNextBEROffset(byte[] nameBER, int offset) throws NameException {
        if (nameBER == null) {
            throw new NameException("Encoding is null.");
        }
        if (nameBER[offset] == 0 && nameBER[offset + 1] == 0) {
            return offset + 2;
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])nameBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])nameBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Unable to determine length of the BER", (Exception)((Object)asnException));
        }
    }

    public int getDERLen(int special) {
        this.special = special;
        return this.derEncodeInit();
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws NameException {
        if (encoding == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            int len;
            if ((this.asn1Template == null || special != this.special) && (len = this.getDERLen(special)) == 0) {
                throw new NameException("Unable to encode ORAddress");
            }
            int returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new NameException("Unable to encode ORAddress", (Exception)((Object)asnException));
        }
    }

    private int derEncodeInit() {
        if (this.asn1Template != null) {
            return 0;
        }
        try {
            SequenceContainer seq = new SequenceContainer(this.special, true, 0);
            EndContainer anEnd = new EndContainer();
            EncodedContainer domain = null;
            EncodedContainer extension = null;
            int flag = 0;
            if (this.standardAttr == null) {
                return 0;
            }
            byte[] standBER = new byte[this.standardAttr.getDERLen(0)];
            int standLen = this.standardAttr.getDEREncoding(standBER, 0, 0);
            EncodedContainer stardard = new EncodedContainer(12288, true, 0, standBER, 0, standLen);
            if (this.domainAttr != null) {
                byte[] domainBER = new byte[this.domainAttr.getDERLen(65536)];
                int domainLen = this.domainAttr.getDEREncoding(domainBER, 0, 65536);
                domain = new EncodedContainer(77824, true, 0, domainBER, 0, domainLen);
                flag = 1;
            }
            if (this.extensionAttr != null) {
                byte[] extBER = new byte[this.extensionAttr.getDERLen(65536)];
                int extLen = this.extensionAttr.getDEREncoding(extBER, 0, 65536);
                extension = new EncodedContainer(78080, true, 0, extBER, 0, extLen);
                flag = flag == 1 ? 2 : 3;
            }
            switch (flag) {
                case 0: {
                    ASN1Container[] nameDef0 = new ASN1Container[]{seq, stardard, anEnd};
                    this.asn1Template = new ASN1Template(nameDef0);
                    break;
                }
                case 1: {
                    ASN1Container[] nameDef1 = new ASN1Container[]{seq, stardard, domain, anEnd};
                    this.asn1Template = new ASN1Template(nameDef1);
                    break;
                }
                case 2: {
                    ASN1Container[] nameDef2 = new ASN1Container[]{seq, stardard, domain, extension, anEnd};
                    this.asn1Template = new ASN1Template(nameDef2);
                    break;
                }
                case 3: {
                    ASN1Container[] nameDef3 = new ASN1Container[]{seq, stardard, extension, anEnd};
                    this.asn1Template = new ASN1Template(nameDef3);
                    break;
                }
            }
            return this.asn1Template.derEncodeInit();
        }
        catch (NameException nameException) {
            return 0;
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ORAddress)) {
            return false;
        }
        ORAddress other = (ORAddress)obj;
        if (this.standardAttr != null ? !this.standardAttr.equals(other.standardAttr) : other.standardAttr != null) {
            return false;
        }
        if (this.domainAttr != null ? !this.domainAttr.equals(other.domainAttr) : other.domainAttr != null) {
            return false;
        }
        return !(this.extensionAttr != null ? !this.extensionAttr.equals(other.extensionAttr) : other.extensionAttr != null);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        ORAddress otherSelf = new ORAddress();
        if (this.standardAttr != null) {
            otherSelf.standardAttr = (BuiltInStandardAttributes)this.standardAttr.clone();
        }
        if (this.domainAttr != null) {
            otherSelf.domainAttr = (BuiltInDomainDefinedAttributes)this.domainAttr.clone();
        }
        if (this.extensionAttr != null) {
            otherSelf.extensionAttr = (ExtensionAttributes)this.extensionAttr.clone();
        }
        otherSelf.special = this.special;
        if (this.asn1Template != null) {
            otherSelf.derEncodeInit();
        }
        return otherSelf;
    }
}

