/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.NumericStringContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.certj.cert.NameException;
import java.io.Serializable;

public class ORName
implements Cloneable,
Serializable {
    public static final int COUNTRY_NAME = 0;
    public static final int ADMIN_DOMAIN_NAME = 1;
    public static final int PRIVATE_DOMAIN_NAME = 2;
    public static final int POSTAL_CODE = 3;
    public static final int PHYSICAL_DELIVERY_COUNTRY_NAME = 4;
    private int flag;
    private String numeric;
    private String printable;
    protected int special;
    protected ASN1Template asn1Template;
    private static final int COUNTRYNAME_SPECIAL = 0x400001;
    private static final int ADMIN_SPECIAL = 0x400002;

    public ORName(int flag, byte[] valueBER, int offset, int special) throws NameException {
        this.special = special;
        this.flag = flag;
        if (valueBER == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            PrintStringContainer printableContainer;
            NumericStringContainer numericContainer;
            ChoiceContainer nameContainer = null;
            EndContainer endContainer = new EndContainer();
            switch (flag) {
                case 0: {
                    nameContainer = new ChoiceContainer(special | 0x400001);
                    break;
                }
                case 1: {
                    nameContainer = new ChoiceContainer(special | 0x400002);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    nameContainer = new ChoiceContainer(special);
                    break;
                }
            }
            switch (flag) {
                case 0: 
                case 4: {
                    numericContainer = new NumericStringContainer(0, 1, 3);
                    printableContainer = new PrintStringContainer(0, 1, 2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    numericContainer = new NumericStringContainer(0, 1, 16);
                    printableContainer = new PrintStringContainer(0, 1, 16);
                    break;
                }
                default: {
                    throw new NameException("Unknown ORName name type!");
                }
            }
            ASN1Container[] nameDef = new ASN1Container[]{nameContainer, numericContainer, printableContainer, endContainer};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])nameDef);
            if (numericContainer.dataPresent) {
                this.numeric = new String(numericContainer.data, numericContainer.dataOffset, numericContainer.dataLen);
            }
            if (printableContainer.dataPresent) {
                this.printable = new String(printableContainer.data, printableContainer.dataOffset, printableContainer.dataLen);
            }
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Cannot decode the BER of the ORName.");
        }
    }

    public ORName(int flag) {
        this.flag = flag;
    }

    public int getNameType() {
        return this.flag;
    }

    public void setNumericValue(String number) {
        if (number != null) {
            this.numeric = number;
        }
    }

    public void setPrintableValue(String print) {
        if (print != null) {
            this.printable = print;
        }
    }

    public String getNumericValue() {
        return this.numeric;
    }

    public String getPrintableValue() {
        return this.printable;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.numeric != null) {
            buffer.append(this.numeric);
        }
        if (this.printable != null) {
            if (buffer.length() != 0) {
                buffer.append(",");
            }
            buffer.append(this.printable);
        }
        return buffer.toString();
    }

    public static int getNextBEROffset(byte[] nameBER, int offset) throws NameException {
        if (nameBER == null) {
            throw new NameException("Encoding is null.");
        }
        if (nameBER[offset] == 0 && nameBER[offset + 1] == 0) {
            return offset + 2;
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])nameBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])nameBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int special) {
        this.special = special;
        return this.derEncodeInit();
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws NameException {
        if (encoding == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            if (this.asn1Template == null || special != this.special) {
                this.getDERLen(special);
            }
            int returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new NameException("Unable to encode ORName");
        }
    }

    private int derEncodeInit() {
        if (this.asn1Template != null) {
            return 0;
        }
        try {
            ChoiceContainer nameContainer;
            EndContainer endContainer = new EndContainer();
            switch (this.flag) {
                case 0: {
                    nameContainer = new ChoiceContainer(this.special | 0x400001, 0);
                    break;
                }
                case 1: {
                    nameContainer = new ChoiceContainer(this.special | 0x400002, 0);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    nameContainer = new ChoiceContainer(this.special, 0);
                    break;
                }
                default: {
                    return 0;
                }
            }
            if (this.numeric != null) {
                NumericStringContainer numericContainer;
                switch (this.flag) {
                    case 0: 
                    case 4: {
                        numericContainer = new NumericStringContainer(0, true, 0, this.numeric, 1, 3);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        numericContainer = new NumericStringContainer(0, true, 0, this.numeric, 1, 16);
                        break;
                    }
                    default: {
                        return 0;
                    }
                }
                ASN1Container[] nameDef1 = new ASN1Container[]{nameContainer, numericContainer, endContainer};
                this.asn1Template = new ASN1Template(nameDef1);
            } else {
                PrintStringContainer printableContainer;
                switch (this.flag) {
                    case 0: 
                    case 4: {
                        printableContainer = new PrintStringContainer(0, true, 0, this.printable, 1, 2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        printableContainer = new PrintStringContainer(0, true, 0, this.printable, 1, 16);
                        break;
                    }
                    default: {
                        return 0;
                    }
                }
                ASN1Container[] nameDef2 = new ASN1Container[]{nameContainer, printableContainer, endContainer};
                this.asn1Template = new ASN1Template(nameDef2);
            }
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ORName)) {
            return false;
        }
        ORName other = (ORName)obj;
        if (this.flag != other.flag) {
            return false;
        }
        if (this.numeric != null ? !this.numeric.equals(other.numeric) : other.numeric != null) {
            return false;
        }
        return !(this.printable != null ? !this.printable.equals(other.printable) : other.printable != null);
    }

    public int hashCode() {
        int hashcode = this.flag;
        if (this.numeric != null) {
            hashcode ^= this.numeric.hashCode();
        }
        if (this.printable != null) {
            hashcode ^= this.printable.hashCode();
        }
        return hashcode;
    }

    public Object clone() throws CloneNotSupportedException {
        ORName otherSelf = new ORName(this.flag);
        if (this.printable != null) {
            otherSelf.printable = this.printable;
        }
        if (this.numeric != null) {
            otherSelf.numeric = this.numeric;
        }
        otherSelf.special = this.special;
        if (this.asn1Template != null) {
            otherSelf.derEncodeInit();
        }
        return otherSelf;
    }
}

