/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.NameException;
import java.io.Serializable;
import java.util.Arrays;

public class OtherName
implements Cloneable,
Serializable {
    private static final int VALUE_SPECIAL = 0xA00000;
    private byte[] typeId;
    private byte[] value;
    private ASN1Template asn1Template;
    private int special;

    public OtherName() {
    }

    public OtherName(byte[] typeId, int typeOffset, int typeLen, byte[] value, int valueOffset, int valueLen) {
        if (typeId != null && typeLen != 0) {
            this.typeId = new byte[typeLen];
            System.arraycopy(typeId, typeOffset, this.typeId, 0, typeLen);
        }
        if (value != null && valueLen != 0) {
            this.value = new byte[valueLen];
            System.arraycopy(value, valueOffset, this.value, 0, valueLen);
        }
    }

    public void decodeValue(byte[] valueBER, int offset, int special) throws NameException {
        this.special = special;
        if (valueBER == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            SequenceContainer seq = new SequenceContainer(special);
            OIDContainer oid = new OIDContainer(0);
            EncodedContainer any = new EncodedContainer(0xA0FF00);
            EndContainer anEnd = new EndContainer();
            ASN1Container[] nameStringDef = new ASN1Container[]{seq, oid, any, anEnd};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])nameStringDef);
            this.typeId = new byte[oid.dataLen];
            System.arraycopy(oid.data, oid.dataOffset, this.typeId, 0, oid.dataLen);
            int numLengthBytes = ASN1Lengths.determineLengthLen((byte[])any.data, (int)(any.dataOffset + 1));
            int numTagAndLengthBytes = 1 + numLengthBytes;
            this.value = new byte[any.dataLen - numTagAndLengthBytes];
            System.arraycopy(any.data, any.dataOffset + numTagAndLengthBytes, this.value, 0, any.dataLen - numTagAndLengthBytes);
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Cannot decode the BER of the OtherName.");
        }
    }

    public void addValues(byte[] typeId, int typeOffset, int typeLen, byte[] value, int valueOffset, int valueLen) {
        if (typeId != null && typeLen != 0) {
            this.typeId = new byte[typeLen];
            System.arraycopy(typeId, typeOffset, this.typeId, 0, typeLen);
        }
        if (value != null && valueLen != 0) {
            this.value = new byte[valueLen];
            System.arraycopy(value, valueOffset, this.value, 0, valueLen);
        }
    }

    public byte[] getTypeID() {
        return this.typeId;
    }

    public byte[] getValue() {
        return this.value;
    }

    public String toString() {
        return new String(this.value);
    }

    public static int getNextBEROffset(byte[] nameBER, int offset) throws NameException {
        if (nameBER == null) {
            throw new NameException("Encoding is null.");
        }
        if (nameBER[offset] == 0 && nameBER[offset + 1] == 0) {
            return offset + 2;
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])nameBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])nameBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int special) throws NameException {
        this.special = special;
        return this.derEncodeInit();
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws NameException {
        if (encoding == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            int len;
            if ((this.asn1Template == null || special != this.special) && (len = this.getDERLen(special)) == 0) {
                throw new NameException("Unable to encode Other Name.");
            }
            int returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new NameException("Unable to encode Other Name.");
        }
    }

    private int derEncodeInit() throws NameException {
        if (this.value == null || this.typeId == null) {
            throw new NameException("Cannot encode OtherName: values are not set.");
        }
        try {
            int arrayLen = ASN1Lengths.getLengthLen((int)this.value.length);
            byte[] newValue = new byte[this.value.length + 1 + arrayLen];
            newValue[0] = -96;
            ASN1Lengths.writeLength((byte[])newValue, (int)1, (int)this.value.length);
            System.arraycopy(this.value, 0, newValue, arrayLen + 1, this.value.length);
            SequenceContainer seq = new SequenceContainer(this.special, true, 0);
            OIDContainer oid = new OIDContainer(0x1000000, true, 0, this.typeId, 0, this.typeId.length);
            EncodedContainer any = new EncodedContainer(65280, true, 0, newValue, 0, newValue.length);
            EndContainer anEnd = new EndContainer();
            ASN1Container[] nameDef = new ASN1Container[]{seq, oid, any, anEnd};
            this.asn1Template = new ASN1Template(nameDef);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new NameException((Exception)((Object)asnException));
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof OtherName)) {
            return false;
        }
        OtherName other = (OtherName)obj;
        if (!CertJUtils.byteArraysEqual(this.typeId, other.typeId)) {
            return false;
        }
        return CertJUtils.byteArraysEqual(this.value, other.value);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.typeId);
        if (this.value != null) {
            result ^= Arrays.hashCode(this.value);
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        OtherName otherSelf = new OtherName();
        otherSelf.typeId = this.typeId;
        otherSelf.value = this.value;
        otherSelf.special = this.special;
        try {
            if (this.asn1Template != null) {
                otherSelf.derEncodeInit();
            }
        }
        catch (NameException nameException) {
            throw new CloneNotSupportedException("Cannot get ASN1 Template");
        }
        return otherSelf;
    }
}

