/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.asn1.TeletexStringContainer;
import com.rsa.certj.cert.NameException;
import java.io.Serializable;

public class PDSParameter
implements Cloneable,
Serializable {
    private String printable;
    private String teletex;
    protected int special;
    protected ASN1Template asn1Template;

    public PDSParameter(byte[] valueBER, int offset, int special) throws NameException {
        this.special = special;
        if (valueBER == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            SetContainer setContainer = new SetContainer(special);
            PrintStringContainer printContainer = new PrintStringContainer(65536, 1, 30);
            TeletexStringContainer teletexContainer = new TeletexStringContainer(65536, 1, 30);
            EndContainer end = new EndContainer();
            ASN1Container[] asn1Def = new ASN1Container[]{setContainer, printContainer, teletexContainer, end};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            if (printContainer.dataPresent) {
                this.printable = printContainer.getValueAsString();
            }
            if (teletexContainer.dataPresent) {
                this.teletex = teletexContainer.getValueAsString();
            }
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Cannot decode the BER of the RDSParameter.");
        }
    }

    public PDSParameter() {
    }

    public void setPrintableString(String value) {
        if (value != null) {
            this.printable = value;
        }
    }

    public void setTeletexString(String value) {
        if (value != null) {
            this.teletex = value;
        }
    }

    public String getPrintableString() {
        return this.printable;
    }

    public String getTeletexString() {
        return this.teletex;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.printable != null) {
            buffer.append(this.printable);
        }
        if (this.teletex != null) {
            if (buffer.length() != 0) {
                buffer.append(",");
            }
            buffer.append(this.teletex);
        }
        return buffer.toString();
    }

    public static int getNextBEROffset(byte[] valueBER, int offset) throws NameException {
        if (valueBER == null) {
            throw new NameException("Encoding is null.");
        }
        if (valueBER[offset] == 0 && valueBER[offset + 1] == 0) {
            return offset + 2;
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])valueBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])valueBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int special) {
        this.special = special;
        return this.derEncodeInit();
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws NameException {
        if (encoding == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            int len;
            if ((this.asn1Template == null || special != this.special) && (len = this.getDERLen(special)) == 0) {
                throw new NameException("Unable to encode PDSParameter.");
            }
            int returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new NameException("Unable to encode PDSParameter.");
        }
    }

    private int derEncodeInit() {
        if (this.asn1Template != null) {
            return 0;
        }
        try {
            int flag = 0;
            SetContainer setContainer = new SetContainer(this.special, true, 0);
            EndContainer end = new EndContainer();
            TeletexStringContainer teletexContainer = null;
            PrintStringContainer printContainer = null;
            if (this.printable != null) {
                printContainer = new PrintStringContainer(65536, true, 0, this.printable, 1, 30);
                flag = 1;
            }
            if (this.teletex != null) {
                teletexContainer = new TeletexStringContainer(65536, true, 0, this.teletex, 1, 30);
                flag = flag == 0 ? 2 : 3;
            }
            switch (flag) {
                case 0: {
                    ASN1Container[] asn1Def0 = new ASN1Container[]{setContainer, end};
                    this.asn1Template = new ASN1Template(asn1Def0);
                    break;
                }
                case 1: {
                    ASN1Container[] asn1Def1 = new ASN1Container[]{setContainer, printContainer, end};
                    this.asn1Template = new ASN1Template(asn1Def1);
                    break;
                }
                case 2: {
                    ASN1Container[] asn1Def2 = new ASN1Container[]{setContainer, teletexContainer, end};
                    this.asn1Template = new ASN1Template(asn1Def2);
                    break;
                }
                case 3: {
                    ASN1Container[] asn1Def3 = new ASN1Container[]{setContainer, printContainer, teletexContainer, end};
                    this.asn1Template = new ASN1Template(asn1Def3);
                    break;
                }
                default: {
                    return 0;
                }
            }
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PDSParameter)) {
            return false;
        }
        PDSParameter other = (PDSParameter)obj;
        if (this.printable != null ? !this.printable.equals(other.printable) : other.printable != null) {
            return false;
        }
        return !(this.teletex != null ? !this.teletex.equals(other.teletex) : other.teletex != null);
    }

    public int hashCode() {
        int hashcode = 0;
        if (this.printable != null) {
            hashcode ^= this.printable.hashCode();
        }
        if (this.teletex != null) {
            hashcode ^= this.teletex.hashCode();
        }
        return hashcode;
    }

    public Object clone() throws CloneNotSupportedException {
        PDSParameter otherSelf = new PDSParameter();
        if (this.printable != null) {
            otherSelf.printable = this.printable;
        }
        if (this.teletex != null) {
            otherSelf.teletex = this.teletex;
        }
        otherSelf.special = this.special;
        if (this.asn1Template != null) {
            otherSelf.derEncodeInit();
        }
        return otherSelf;
    }
}

