/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyMappings
extends X509V3Extension
implements CertExtension {
    private Vector<Object>[] issuerDomainPolicy = this.createVectorArray(3);
    private Vector<Object>[] subjectDomainPolicy = this.createVectorArray(3);
    ASN1Template asn1TemplateValue;

    public PolicyMappings() {
        this.extensionTypeFlag = 33;
        this.criticality = false;
        this.setStandardOID(33);
        this.extensionTypeString = "PolicyMappings";
    }

    public PolicyMappings(byte[] issuerDomainPolicy, int issuerOffset, int issuerLen, byte[] subjectDomainPolicy, int subjectOffset, int subjectLen, boolean criticality) {
        this.extensionTypeFlag = 33;
        this.criticality = criticality;
        this.setStandardOID(33);
        if (issuerDomainPolicy != null && issuerLen != 0) {
            this.issuerDomainPolicy[0].addElement(issuerDomainPolicy);
            this.issuerDomainPolicy[1].addElement(new Integer(issuerOffset));
            this.issuerDomainPolicy[2].addElement(new Integer(issuerLen));
        }
        if (subjectDomainPolicy != null && subjectLen != 0) {
            this.subjectDomainPolicy[0].addElement(subjectDomainPolicy);
            this.subjectDomainPolicy[1].addElement(new Integer(subjectOffset));
            this.subjectDomainPolicy[2].addElement(new Integer(subjectLen));
        }
        this.extensionTypeString = "PolicyMappings";
    }

    private Vector<Object>[] createVectorArray(int size) {
        Vector[] vectorArray = new Vector[size];
        for (int index = 0; index < size; ++index) {
            vectorArray[index] = new Vector();
        }
        return vectorArray;
    }

    @Override
    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            OfContainer seqOf = new OfContainer(this.special, 12288, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] oidDef = new ASN1Container[]{seqOf};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])oidDef);
            int oidCount = seqOf.getContainerCount();
            for (int index = 0; index < oidCount; ++index) {
                ASN1Container encodedOIDContainer = seqOf.containerAt(index);
                SequenceContainer seq = new SequenceContainer(0);
                EndContainer anEnd = new EndContainer();
                OIDContainer issuer = new OIDContainer(0);
                OIDContainer subject = new OIDContainer(0);
                ASN1Container[] asn1Def = new ASN1Container[]{seq, issuer, subject, anEnd};
                ASN1.berDecode((byte[])encodedOIDContainer.data, (int)encodedOIDContainer.dataOffset, (ASN1Container[])asn1Def);
                this.issuerDomainPolicy[0].addElement(issuer.data);
                this.issuerDomainPolicy[1].addElement(new Integer(issuer.dataOffset));
                this.issuerDomainPolicy[2].addElement(new Integer(issuer.dataLen));
                this.subjectDomainPolicy[0].addElement(subject.data);
                this.subjectDomainPolicy[1].addElement(new Integer(subject.dataOffset));
                this.subjectDomainPolicy[2].addElement(new Integer(subject.dataLen));
            }
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode PolicyMappings extension.");
        }
    }

    public void setDomainPolicy(byte[] issData, int issOffset, int issLen, byte[] domData, int domOffset, int domLen) {
        if (issData != null && issLen != 0) {
            this.issuerDomainPolicy[0].addElement(issData);
            this.issuerDomainPolicy[1].addElement(new Integer(issOffset));
            this.issuerDomainPolicy[2].addElement(new Integer(issLen));
        }
        if (domData != null && domLen != 0) {
            this.subjectDomainPolicy[0].addElement(domData);
            this.subjectDomainPolicy[1].addElement(new Integer(domOffset));
            this.subjectDomainPolicy[2].addElement(new Integer(domLen));
        }
    }

    public byte[] getIssuerDomainPolicy(int index) throws CertificateException {
        if (this.issuerDomainPolicy[0].size() <= index) {
            throw new CertificateException("Specified index is invalid.");
        }
        if (this.issuerDomainPolicy[0].elementAt(index) != null) {
            Integer offset = (Integer)this.issuerDomainPolicy[1].elementAt(index);
            Integer len = (Integer)this.issuerDomainPolicy[2].elementAt(index);
            byte[] returnValue = new byte[len.intValue()];
            System.arraycopy(this.issuerDomainPolicy[0].elementAt(index), offset, returnValue, 0, len);
            return returnValue;
        }
        return null;
    }

    public byte[] getSubjectDomainPolicy(int index) throws CertificateException {
        if (this.subjectDomainPolicy[0].size() <= index) {
            throw new CertificateException("Specified index is invalid.");
        }
        if (this.subjectDomainPolicy[0].elementAt(index) != null) {
            Integer offset = (Integer)this.subjectDomainPolicy[1].elementAt(index);
            Integer len = (Integer)this.subjectDomainPolicy[2].elementAt(index);
            byte[] returnValue = new byte[len.intValue()];
            System.arraycopy(this.subjectDomainPolicy[0].elementAt(index), offset, returnValue, 0, len);
            return returnValue;
        }
        return null;
    }

    public int getPolicyCount() {
        return this.subjectDomainPolicy[0].size();
    }

    @Override
    public int derEncodeValueInit() {
        Vector<OfContainer> asn1Def = new Vector<OfContainer>();
        try {
            OfContainer seqOf = new OfContainer(this.special, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
            asn1Def.addElement(seqOf);
            for (int index = 0; index < this.issuerDomainPolicy[0].size(); ++index) {
                try {
                    EncodedContainer oidContainer = this.encodeOID(index);
                    seqOf.addContainer((ASN1Container)oidContainer);
                    continue;
                }
                catch (Exception anyExc) {
                    return 0;
                }
            }
            Object[] asn1DefArray = new ASN1Container[asn1Def.size()];
            asn1Def.copyInto(asn1DefArray);
            this.asn1TemplateValue = new ASN1Template((ASN1Container[])asn1DefArray);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    private EncodedContainer encodeOID(int index) throws CertificateException {
        try {
            SequenceContainer seq = new SequenceContainer(0, true, 0);
            EndContainer end = new EndContainer();
            int offset = (Integer)this.issuerDomainPolicy[1].elementAt(index);
            int len = (Integer)this.issuerDomainPolicy[2].elementAt(index);
            OIDContainer issuerContainer = new OIDContainer(0x1000000, true, 0, (byte[])this.issuerDomainPolicy[0].elementAt(index), offset, len);
            offset = (Integer)this.subjectDomainPolicy[1].elementAt(index);
            len = (Integer)this.subjectDomainPolicy[2].elementAt(index);
            OIDContainer subjectContainer = new OIDContainer(0x1000000, true, 0, (byte[])this.subjectDomainPolicy[0].elementAt(index), offset, len);
            ASN1Container[] asn1Def = new ASN1Container[]{seq, issuerContainer, subjectContainer, end};
            ASN1Template templ = new ASN1Template(asn1Def);
            int encodingLen = templ.derEncodeInit();
            byte[] encoding = new byte[encodingLen];
            encodingLen = templ.derEncode(encoding, 0);
            return new EncodedContainer(12288, true, 0, encoding, 0, encodingLen);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException(" Can't encode PolicyMappings");
        }
    }

    @Override
    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        int oidIndex;
        int index;
        PolicyMappings otherSelf = new PolicyMappings();
        for (index = 0; index < this.issuerDomainPolicy.length; ++index) {
            for (oidIndex = 0; oidIndex < this.issuerDomainPolicy[index].size(); ++oidIndex) {
                otherSelf.issuerDomainPolicy[index].addElement(this.issuerDomainPolicy[index].elementAt(oidIndex));
            }
        }
        for (index = 0; index < this.subjectDomainPolicy.length; ++index) {
            for (oidIndex = 0; oidIndex < this.subjectDomainPolicy[index].size(); ++oidIndex) {
                otherSelf.subjectDomainPolicy[index].addElement(this.subjectDomainPolicy[index].elementAt(oidIndex));
            }
        }
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    @Override
    protected void reset() {
        super.reset();
        this.issuerDomainPolicy = null;
        this.subjectDomainPolicy = null;
        this.asn1TemplateValue = null;
    }

    public Vector<byte[]> getSubjectDomainPolicies(byte[] issuerDomainPolicyOID) {
        Vector<byte[]> result = new Vector<byte[]>();
        int policyCount = this.getPolicyCount();
        for (int i = 0; i < policyCount; ++i) {
            int length;
            int offset;
            byte[] currentIssuerDomainPolicyOIDData = (byte[])this.issuerDomainPolicy[0].get(i);
            if (!CertJUtils.byteArraysEqual(currentIssuerDomainPolicyOIDData, offset = ((Integer)this.issuerDomainPolicy[1].get(i)).intValue(), length = ((Integer)this.issuerDomainPolicy[2].get(i)).intValue(), issuerDomainPolicyOID)) continue;
            byte[] subjectDomainPolicyOIDData = (byte[])this.subjectDomainPolicy[0].get(i);
            int subjectOffset = (Integer)this.subjectDomainPolicy[1].get(i);
            int subjectLength = (Integer)this.subjectDomainPolicy[2].get(i);
            byte[] subjectDomainPolicyOID = new byte[subjectLength];
            System.arraycopy(subjectDomainPolicyOIDData, subjectOffset, subjectDomainPolicyOID, 0, subjectLength);
            result.add(subjectDomainPolicyOID);
        }
        return result;
    }
}

