/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.NameException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Vector;

public class PresentationAddress
implements Cloneable,
Serializable {
    private byte[] pSelector;
    private int pOffset;
    private int pLength;
    private byte[] sSelector;
    private int sOffset;
    private int sLength;
    private byte[] tSelector;
    private int tOffset;
    private int tLength;
    private Vector<byte[]> nAddresses = new Vector();
    protected int special;
    protected ASN1Template asn1Template;
    private static final int P_SPECIAL = 0xA10000;
    private static final int S_SPECIAL = 0xA10001;
    private static final int T_SPECIAL = 10551298;
    private static final int N_SPECIAL = 0xA00003;

    public PresentationAddress(byte[] nameBER, int offset, int special) throws NameException {
        this.special = special;
        if (nameBER == null) {
            throw new NameException("NameBER is null.");
        }
        try {
            SequenceContainer seq = new SequenceContainer(special);
            EndContainer anEnd = new EndContainer();
            OctetStringContainer pContainer = new OctetStringContainer(0xA10000);
            OctetStringContainer sContainer = new OctetStringContainer(0xA10001);
            OctetStringContainer tContainer = new OctetStringContainer(10551298);
            EncodedContainer nContainer = new EncodedContainer(10498307);
            ASN1Container[] asn1Def = new ASN1Container[]{seq, pContainer, sContainer, tContainer, nContainer, anEnd};
            ASN1.berDecode((byte[])nameBER, (int)offset, (ASN1Container[])asn1Def);
            OfContainer setOf = new OfContainer(0xA00003, 12544, (ASN1Container)new OctetStringContainer(0));
            ASN1Container[] nameDef = new ASN1Container[]{setOf};
            ASN1.berDecode((byte[])nContainer.data, (int)nContainer.dataOffset, (ASN1Container[])nameDef);
            int nameCount = setOf.getContainerCount();
            for (int nameIndex = 0; nameIndex < nameCount; ++nameIndex) {
                ASN1Container address = setOf.containerAt(nameIndex);
                byte[] nAddress = new byte[address.dataLen];
                System.arraycopy(address.data, address.dataOffset, nAddress, 0, address.dataLen);
                this.nAddresses.addElement(nAddress);
            }
            if (pContainer.dataPresent) {
                this.pSelector = new byte[pContainer.dataLen];
                System.arraycopy(pContainer.data, pContainer.dataOffset, this.pSelector, 0, pContainer.dataLen);
                this.pOffset = 0;
                this.pLength = pContainer.dataLen;
            }
            if (sContainer.dataPresent) {
                this.sSelector = new byte[sContainer.dataLen];
                System.arraycopy(sContainer.data, sContainer.dataOffset, this.sSelector, 0, sContainer.dataLen);
                this.sOffset = 0;
                this.sLength = sContainer.dataLen;
            }
            if (tContainer.dataPresent) {
                this.tSelector = new byte[tContainer.dataLen];
                System.arraycopy(tContainer.data, tContainer.dataOffset, this.tSelector, 0, tContainer.dataLen);
                this.tOffset = 0;
                this.tLength = tContainer.dataLen;
            }
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Cannot decode the BER of the PresentationAddress.");
        }
    }

    public PresentationAddress() {
    }

    public void setPSelector(byte[] data, int offset, int len) throws NameException {
        if (data == null || len == 0) {
            throw new NameException("Data is null.");
        }
        this.pSelector = new byte[len];
        System.arraycopy(data, offset, this.pSelector, 0, len);
        this.pOffset = 0;
        this.pLength = len;
    }

    public void setSSelector(byte[] data, int offset, int len) throws NameException {
        if (data == null || len == 0) {
            throw new NameException("Data is null.");
        }
        this.sSelector = new byte[len];
        System.arraycopy(data, offset, this.sSelector, 0, len);
        this.sOffset = 0;
        this.sLength = len;
    }

    public void setTSelector(byte[] data, int offset, int len) throws NameException {
        if (data == null || len == 0) {
            throw new NameException("Data is null.");
        }
        this.tSelector = new byte[len];
        System.arraycopy(data, offset, this.tSelector, 0, len);
        this.tOffset = 0;
        this.tLength = len;
    }

    public void setNAddress(byte[] data, int offset, int len) throws NameException {
        if (data == null || len == 0) {
            throw new NameException("Data is null.");
        }
        byte[] address = new byte[len];
        System.arraycopy(data, offset, address, 0, len);
        this.nAddresses.addElement(address);
    }

    public byte[] getPSelector() {
        if (this.pSelector == null) {
            return null;
        }
        byte[] result = new byte[this.pLength];
        System.arraycopy(this.pSelector, this.pOffset, result, 0, this.pLength);
        return result;
    }

    public byte[] getSSelector() {
        if (this.sSelector == null) {
            return null;
        }
        byte[] result = new byte[this.sLength];
        System.arraycopy(this.sSelector, this.sOffset, result, 0, this.sLength);
        return result;
    }

    public byte[] getTSelector() {
        if (this.tSelector == null) {
            return null;
        }
        byte[] result = new byte[this.tLength];
        System.arraycopy(this.tSelector, this.tOffset, result, 0, this.tLength);
        return result;
    }

    public byte[][] getNAddresses() {
        int len = this.nAddresses.size();
        byte[][] result = new byte[len][];
        for (int index = 0; index < len; ++index) {
            byte[] address = this.nAddresses.elementAt(index);
            result[index] = new byte[address.length];
            System.arraycopy(address, 0, result[index], 0, address.length);
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.pSelector != null) {
            buffer.append(new String(this.pSelector, this.pOffset, this.pLength));
        }
        if (this.sSelector != null) {
            if (buffer.length() != 0) {
                buffer.append(",");
            }
            buffer.append(new String(this.sSelector, this.sOffset, this.sLength));
        }
        if (this.tSelector != null) {
            if (buffer.length() != 0) {
                buffer.append(",");
            }
            buffer.append(new String(this.tSelector, this.tOffset, this.tLength));
        }
        for (int index = 0; index < this.nAddresses.size(); ++index) {
            byte[] address = this.nAddresses.elementAt(index);
            if (buffer.length() != 0) {
                buffer.append(",");
            }
            buffer.append(new String(address, 0, address.length));
        }
        return buffer.toString();
    }

    public static int getNextBEROffset(byte[] nameBER, int offset) throws NameException {
        if (nameBER == null) {
            throw new NameException("Encoding is null.");
        }
        if (nameBER[offset] == 0 && nameBER[offset + 1] == 0) {
            return offset + 2;
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])nameBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])nameBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int special) {
        this.special = special;
        return this.derEncodeInit();
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws NameException {
        if (encoding == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            int len;
            if ((this.asn1Template == null || special != this.special) && (len = this.getDERLen(special)) == 0) {
                throw new NameException("Unable to encode PresentationAddress");
            }
            int returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new NameException("Unable to encode PresentationAddress");
        }
    }

    private int derEncodeInit() {
        if (this.asn1Template != null) {
            return 0;
        }
        try {
            Vector<OfContainer> asn1Def = new Vector<OfContainer>();
            OfContainer setOf = new OfContainer(0xA00003, true, 0, 12544, (ASN1Container)new OctetStringContainer(0));
            asn1Def.addElement(setOf);
            for (int index = 0; index < this.nAddresses.size(); ++index) {
                byte[] nAddress = this.nAddresses.elementAt(index);
                OctetStringContainer address = new OctetStringContainer(0, true, 0, nAddress, 0, nAddress.length);
                setOf.addContainer((ASN1Container)address);
            }
            Object[] asn1DefArray = new ASN1Container[asn1Def.size()];
            asn1Def.copyInto(asn1DefArray);
            ASN1Template asn1TemplateValue = new ASN1Template((ASN1Container[])asn1DefArray);
            int encLen = asn1TemplateValue.derEncodeInit();
            byte[] encoding = new byte[encLen];
            encLen = asn1TemplateValue.derEncode(encoding, 0);
            EncodedContainer addresses = new EncodedContainer(10498307, true, 0, encoding, 0, encLen);
            SequenceContainer seq = new SequenceContainer(this.special, true, 0);
            EndContainer anEnd = new EndContainer();
            OctetStringContainer pContainer = this.pSelector != null ? new OctetStringContainer(0xA10000, true, 0, this.pSelector, this.pOffset, this.pLength) : new OctetStringContainer(0xA10000, false, 0, this.pSelector, this.pOffset, this.pLength);
            OctetStringContainer sContainer = this.sSelector != null ? new OctetStringContainer(0xA10001, true, 0, this.sSelector, this.sOffset, this.sLength) : new OctetStringContainer(0xA10001, false, 0, this.sSelector, this.sOffset, this.sLength);
            OctetStringContainer tContainer = this.tSelector != null ? new OctetStringContainer(10551298, true, 0, this.tSelector, this.tOffset, this.tLength) : new OctetStringContainer(10551298, false, 0, this.tSelector, this.tOffset, this.tLength);
            ASN1Container[] asnDef = new ASN1Container[]{seq, pContainer, sContainer, tContainer, addresses, anEnd};
            this.asn1Template = new ASN1Template(asnDef);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public boolean equals(Object obj) {
        int index;
        if (obj == null || !(obj instanceof PresentationAddress)) {
            return false;
        }
        PresentationAddress other = (PresentationAddress)obj;
        if (this.pSelector != null) {
            if (this.pLength != other.pLength || this.pOffset != other.pOffset) {
                return false;
            }
            for (index = 0; index < this.pLength; ++index) {
                if (this.pSelector[index] == other.pSelector[index]) continue;
                return false;
            }
        } else if (other.pSelector != null) {
            return false;
        }
        if (this.sSelector != null) {
            if (this.sLength != other.sLength || this.sOffset != other.sOffset) {
                return false;
            }
            for (index = 0; index < this.sLength; ++index) {
                if (this.sSelector[index] == other.sSelector[index]) continue;
                return false;
            }
        } else if (other.sSelector != null) {
            return false;
        }
        if (this.tSelector != null) {
            if (this.tLength != other.tLength || this.tOffset != other.tOffset) {
                return false;
            }
            for (index = 0; index < this.tLength; ++index) {
                if (this.tSelector[index] == other.tSelector[index]) continue;
                return false;
            }
        } else if (other.tSelector != null) {
            return false;
        }
        if (this.nAddresses.size() != other.nAddresses.size()) {
            return false;
        }
        for (index = 0; index < this.nAddresses.size(); ++index) {
            byte[] otherAddress;
            byte[] thisAddress = this.nAddresses.elementAt(index);
            if (CertJUtils.byteArraysEqual(thisAddress, otherAddress = other.nAddresses.elementAt(index))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int len = this.getDERLen(0);
        if (len == 0) {
            return 0;
        }
        byte[] enc = new byte[len];
        try {
            this.getDEREncoding(enc, 0, 0);
        }
        catch (NameException e) {
            return 0;
        }
        return Arrays.hashCode(enc);
    }

    public Object clone() throws CloneNotSupportedException {
        PresentationAddress otherSelf = new PresentationAddress();
        if (this.pSelector != null) {
            otherSelf.pOffset = this.pOffset;
            otherSelf.pLength = this.pLength;
            otherSelf.pSelector = new byte[this.pLength];
            System.arraycopy(this.pSelector, this.pOffset, otherSelf.pSelector, otherSelf.pOffset, this.pLength);
        }
        if (this.sSelector != null) {
            otherSelf.sOffset = this.sOffset;
            otherSelf.sLength = this.sLength;
            otherSelf.sSelector = new byte[this.sLength];
            System.arraycopy(this.sSelector, this.sOffset, otherSelf.sSelector, otherSelf.sOffset, this.sLength);
        }
        if (this.tSelector != null) {
            otherSelf.tOffset = this.tOffset;
            otherSelf.tLength = this.tLength;
            otherSelf.tSelector = new byte[this.tLength];
            System.arraycopy(this.tSelector, this.tOffset, otherSelf.tSelector, otherSelf.tOffset, this.tLength);
        }
        otherSelf.nAddresses = new Vector<byte[]>(this.nAddresses);
        otherSelf.special = this.special;
        if (this.asn1Template != null) {
            otherSelf.derEncodeInit();
        }
        return otherSelf;
    }
}

