/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.GenTimeContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.util.Date;

public class PrivateKeyUsagePeriod
extends X509V3Extension
implements CertExtension {
    private Date notBefore;
    private Date notAfter;
    private static final int BEFORE_SPECIAL = 0x810000;
    private static final int AFTER_SPECIAL = 0x810001;
    ASN1Template asn1TemplateValue;

    public PrivateKeyUsagePeriod() {
        this.extensionTypeFlag = 16;
        this.criticality = false;
        this.setStandardOID(16);
        this.extensionTypeString = "PrivateKeyUsagePeriod";
    }

    public PrivateKeyUsagePeriod(Date notBefore, Date notAfter, boolean criticality) {
        this.extensionTypeFlag = 16;
        this.criticality = criticality;
        this.setStandardOID(16);
        if (notBefore != null) {
            this.notBefore = new Date(notBefore.getTime());
        }
        if (notAfter != null) {
            this.notAfter = new Date(notAfter.getTime());
        }
        this.extensionTypeString = "PrivateKeyUsagePeriod";
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        SequenceContainer seq = new SequenceContainer(0);
        EndContainer anEnd = new EndContainer();
        GenTimeContainer localNotBefore = new GenTimeContainer(0x810000);
        GenTimeContainer localNotAfter = new GenTimeContainer(0x810001);
        ASN1Container[] asn1Def = new ASN1Container[]{seq, localNotBefore, localNotAfter, anEnd};
        try {
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode PrivateKeyUsagePeriod extension.");
        }
        if (localNotBefore.dataPresent) {
            this.notBefore = new Date(localNotBefore.theTime.getTime());
        }
        if (localNotAfter.dataPresent) {
            this.notAfter = new Date(localNotAfter.theTime.getTime());
        }
    }

    public void setNotBefore(Date theTime) {
        if (theTime != null) {
            this.notBefore = new Date(theTime.getTime());
        }
    }

    public Date getNotBefore() {
        if (this.notBefore == null) {
            return null;
        }
        return new Date(this.notBefore.getTime());
    }

    public void setNotAfter(Date theTime) {
        if (theTime != null) {
            this.notAfter = new Date(theTime.getTime());
        }
    }

    public Date getNotAfter() {
        if (this.notAfter == null) {
            return null;
        }
        return new Date(this.notAfter.getTime());
    }

    public int derEncodeValueInit() {
        SequenceContainer seq = new SequenceContainer(0, true, 0);
        EndContainer anEnd = new EndContainer();
        GenTimeContainer timeBefore = null;
        GenTimeContainer timeAfter = null;
        int flag = 0;
        if (this.notBefore != null) {
            timeBefore = new GenTimeContainer(0x810000, true, 0, this.notBefore);
            flag = 1;
        }
        if (this.notAfter != null) {
            timeAfter = new GenTimeContainer(0x810001, true, 0, this.notAfter);
            flag = flag == 1 ? 3 : 2;
        }
        switch (flag) {
            case 0: {
                ASN1Container[] asn1Def0 = new ASN1Container[]{seq, anEnd};
                this.asn1TemplateValue = new ASN1Template(asn1Def0);
                break;
            }
            case 1: {
                ASN1Container[] asn1Def1 = new ASN1Container[]{seq, timeBefore, anEnd};
                this.asn1TemplateValue = new ASN1Template(asn1Def1);
                break;
            }
            case 2: {
                ASN1Container[] asn1Def2 = new ASN1Container[]{seq, timeAfter, anEnd};
                this.asn1TemplateValue = new ASN1Template(asn1Def2);
                break;
            }
            case 3: {
                ASN1Container[] asn1Def = new ASN1Container[]{seq, timeBefore, timeAfter, anEnd};
                this.asn1TemplateValue = new ASN1Template(asn1Def);
                break;
            }
        }
        try {
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        PrivateKeyUsagePeriod otherSelf = new PrivateKeyUsagePeriod();
        otherSelf.notBefore = this.notBefore;
        otherSelf.notAfter = this.notAfter;
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.notBefore = null;
        this.notAfter = null;
        this.asn1TemplateValue = null;
    }
}

