/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EnumeratedContainer;
import com.rsa.certj.cert.CRLEntryExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.OCSPSingleExtension;
import com.rsa.certj.cert.extensions.X509V3Extension;

public class ReasonCode
extends X509V3Extension
implements CRLEntryExtension,
OCSPSingleExtension {
    public static final int REASON_CODE_UNSPECIFIED = 0;
    public static final int REASON_CODE_KEY_COMPROMISE = 1;
    public static final int REASON_CODE_CA_COMPROMISE = 2;
    public static final int REASON_CODE_AFFILIATION_CHANGED = 3;
    public static final int REASON_CODE_SUPERSEDED = 4;
    public static final int REASON_CODE_CESSATION_OF_OPERATION = 5;
    public static final int REASON_CODE_CERTIFICATE_HOLD = 6;
    public static final int REASON_CODE_REMOVED_FROM_CRL = 8;
    public static final int REASON_CODE_PRIVILEGE_WITHDRAWN = 9;
    public static final int REASON_CODE_AA_COMPROMISE = 10;
    private int reasonCode;
    ASN1Template asn1TemplateValue;

    public ReasonCode() {
        this.extensionTypeFlag = 21;
        this.criticality = false;
        this.setStandardOID(21);
        this.extensionTypeString = "ReasonCode";
    }

    public ReasonCode(int reasonCode, boolean criticality) throws CertificateException {
        this.validateReasonCode(reasonCode);
        this.extensionTypeFlag = 21;
        this.criticality = criticality;
        this.reasonCode = reasonCode;
        this.setStandardOID(21);
        this.extensionTypeString = "ReasonCode";
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        this.reasonCode = 0;
        try {
            EnumeratedContainer code = new EnumeratedContainer(0);
            ASN1Container[] asn1Def = new ASN1Container[]{code};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            if (code.dataLen == 0) {
                return;
            }
            this.reasonCode = code.getValueAsInt();
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode ReasonCode extension.");
        }
        if (this.reasonCode < 0 || this.reasonCode > 8 || this.reasonCode == 7) {
            throw new CertificateException("Could not decode ReasonCode extension: Invalid Reason Code.");
        }
    }

    public void setReasonCode(int code) throws CertificateException {
        this.validateReasonCode(code);
        this.reasonCode = code;
    }

    public int getReasonCode() {
        return this.reasonCode;
    }

    public boolean verifyReasonCode(int codeToVerify) {
        return this.reasonCode == codeToVerify;
    }

    public int derEncodeValueInit() {
        try {
            EnumeratedContainer code = new EnumeratedContainer(0, true, 0, this.reasonCode);
            ASN1Container[] asn1Def = new ASN1Container[]{code};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ReasonCode otherSelf = new ReasonCode();
        otherSelf.reasonCode = this.reasonCode;
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.reasonCode = 0;
        this.asn1TemplateValue = null;
    }

    private void validateReasonCode(int code) throws CertificateException {
        if (code < 0 || code > 10 || code == 7) {
            throw new CertificateException("Invalid Reason Code.");
        }
    }
}

