/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.GeneralNames;
import java.io.Serializable;
import java.util.Arrays;

public class SemanticsInformation
implements Cloneable,
Serializable {
    private byte[] id;
    private GeneralNames name;
    protected int special;
    private ASN1Template asn1Template;

    public SemanticsInformation(byte[] infoBER, int offset, int special) throws NameException {
        if (infoBER == null || offset < 0) {
            throw new NameException("Encoding is null.");
        }
        try {
            SequenceContainer infoContainer = new SequenceContainer(special);
            OIDContainer oidContainer = new OIDContainer(0x1010000);
            EncodedContainer nameContainer = new EncodedContainer(77824);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] asnDef = new ASN1Container[]{infoContainer, oidContainer, nameContainer, endContainer};
            ASN1.berDecode((byte[])infoBER, (int)offset, (ASN1Container[])asnDef);
            if (oidContainer.data == null && nameContainer.data == null) {
                throw new NameException("At least one field in SemanticsInformation shall be present.");
            }
            if (oidContainer.data != null) {
                this.id = new byte[oidContainer.dataLen];
                System.arraycopy(oidContainer.data, oidContainer.dataOffset, this.id, 0, oidContainer.dataLen);
            }
            if (nameContainer.data != null) {
                this.name = new GeneralNames(nameContainer.data, nameContainer.dataOffset, 0);
            }
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Invalid encoding of SemanticsInformation. ", (Exception)((Object)asnException));
        }
    }

    public SemanticsInformation() {
    }

    public void setName(GeneralNames name) {
        this.name = name;
    }

    public GeneralNames getName() {
        return this.name;
    }

    public void setID(byte[] id, int offset, int len) {
        if (id != null && len != 0 && offset >= 0 && id.length >= len + offset) {
            this.id = new byte[len];
            System.arraycopy(id, offset, this.id, 0, len);
        } else {
            this.id = null;
        }
    }

    public byte[] getID() {
        if (this.id == null) {
            return null;
        }
        byte[] returnValue = new byte[this.id.length];
        System.arraycopy(this.id, 0, returnValue, 0, this.id.length);
        return returnValue;
    }

    public static int getNextBEROffset(byte[] valueBER, int offset) throws NameException {
        if (valueBER == null) {
            throw new NameException("Encoding is null.");
        }
        if (valueBER[offset] == 0 && valueBER[offset + 1] == 0) {
            return offset + 2;
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])valueBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])valueBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Unable to determine length of the BER. ", (Exception)((Object)asnException));
        }
    }

    public int getDERLen(int special) throws NameException {
        if (this.name == null && this.id == null) {
            throw new NameException("At least one value should be present.");
        }
        this.special = special;
        return this.derEncodeInit();
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws NameException {
        if (encoding == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            int len;
            if ((this.asn1Template == null || special != this.special) && (len = this.getDERLen(special)) == 0) {
                throw new NameException("Cannot encode SemanticsInformation.");
            }
            int returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new NameException("Unable to encode SemanticsInformation.", (Exception)((Object)asnException));
        }
    }

    private int derEncodeInit() throws NameException {
        try {
            EncodedContainer nameContainer;
            SequenceContainer infoContainer = new SequenceContainer(this.special);
            EndContainer endContainer = new EndContainer();
            OIDContainer oidContainer = this.id != null ? new OIDContainer(0x1010000, true, 0, this.id, 0, this.id.length) : new OIDContainer(0x1010000, false, 0, null, 0, 0);
            if (this.name != null) {
                int returnLen = this.name.getDERLen(0);
                byte[] encoding = new byte[returnLen];
                this.name.getDEREncoding(encoding, 0, 0);
                nameContainer = new EncodedContainer(77824, true, 0, encoding, 0, encoding.length);
            } else {
                nameContainer = new EncodedContainer(77824, true, 0, null, 0, 0);
            }
            ASN1Container[] asnDef = new ASN1Container[]{infoContainer, oidContainer, nameContainer, endContainer};
            this.asn1Template = new ASN1Template(asnDef);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new NameException("cannot create the DER encoding. ", (Exception)((Object)asnException));
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SemanticsInformation)) {
            return false;
        }
        SemanticsInformation other = (SemanticsInformation)obj;
        if (this.name != null ? !this.name.equals(other.name) : other.name != null) {
            return false;
        }
        return !(this.id != null ? !CertJUtils.byteArraysEqual(this.id, other.id) : other.id != null);
    }

    public int hashCode() {
        int hashcode = 0;
        if (this.name != null) {
            hashcode ^= this.name.hashCode();
        }
        if (this.id != null) {
            hashcode ^= 17 * Arrays.hashCode(this.id);
        }
        return hashcode;
    }

    public Object clone() throws CloneNotSupportedException {
        SemanticsInformation otherSelf = new SemanticsInformation();
        if (this.name != null) {
            otherSelf.name = (GeneralNames)this.name.clone();
        }
        if (this.id != null) {
            otherSelf.id = new byte[this.id.length];
            System.arraycopy(this.id, 0, otherSelf.id, 0, this.id.length);
        }
        otherSelf.special = this.special;
        try {
            if (this.asn1Template != null) {
                otherSelf.derEncodeInit();
            }
        }
        catch (NameException nameExc) {
            throw new CloneNotSupportedException("Cannot clone SemanticsInformation object. " + nameExc.getMessage());
        }
        return otherSelf;
    }
}

