/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.attributes.X501Attribute;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.util.Vector;

public class SubjectDirectoryAttributes
extends X509V3Extension
implements CertExtension {
    private Vector<X501Attribute> attributes = new Vector();
    ASN1Template asn1TemplateValue;

    public SubjectDirectoryAttributes() {
        this.extensionTypeFlag = 9;
        this.criticality = false;
        this.setStandardOID(9);
        this.extensionTypeString = "SubjectDirectoryAttributes";
    }

    public SubjectDirectoryAttributes(X501Attribute attribute, boolean criticality) {
        this.extensionTypeFlag = 9;
        this.criticality = criticality;
        this.setStandardOID(9);
        if (attribute != null) {
            this.attributes.addElement(attribute);
        }
        this.extensionTypeString = "SubjectDirectoryAttributes";
    }

    public void addAttribute(X501Attribute attribute) {
        if (attribute != null) {
            this.attributes.addElement(attribute);
        }
    }

    public X501Attribute getAttributes(int index) throws CertificateException {
        if (index < this.attributes.size()) {
            return this.attributes.elementAt(index);
        }
        throw new CertificateException("Invalid Index");
    }

    public int getAttributesCount() {
        return this.attributes.size();
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            OfContainer seqOf = new OfContainer(0, 12288, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] asn1Def = new ASN1Container[]{seqOf};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            int attributeCount = seqOf.getContainerCount();
            if (attributeCount > 0) {
                this.attributes = new Vector();
            }
            for (int index = 0; index < attributeCount; ++index) {
                ASN1Container nextContainer = seqOf.containerAt(index);
                X501Attribute nextAttribute = X501Attribute.getInstance(nextContainer.data, nextContainer.dataOffset, 0);
                this.attributes.addElement(nextAttribute);
            }
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode SubjectDirectoryAttributes extension.");
        }
        catch (AttributeException attrException) {
            throw new CertificateException("Could not decode SubjectDirectoryAttributes extension.");
        }
    }

    public int derEncodeValueInit() {
        try {
            OfContainer seqOf = new OfContainer(0, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
            int attributeCount = 0;
            if (this.attributes != null) {
                attributeCount = this.attributes.size();
            }
            for (int index = 0; index < attributeCount; ++index) {
                X501Attribute nextAttribute = this.attributes.elementAt(index);
                int nextLen = nextAttribute.getDERLen(0);
                byte[] encoding = new byte[nextLen];
                nextLen = nextAttribute.getDEREncoding(encoding, 0, 0);
                EncodedContainer nextContainer = new EncodedContainer(12288, true, 0, encoding, 0, nextLen);
                seqOf.addContainer((ASN1Container)nextContainer);
            }
            ASN1Container[] asn1Def = new ASN1Container[]{seqOf};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (Exception anyExc) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            return this.asn1TemplateValue.derEncode(encoding, offset);
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SubjectDirectoryAttributes otherSelf = new SubjectDirectoryAttributes();
        otherSelf.attributes = new Vector<X501Attribute>(this.attributes);
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.attributes.clear();
    }
}

