/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;

public class SubjectKeyID
extends X509V3Extension
implements CertExtension {
    private byte[] keyID;
    private int keyIDOffset;
    private int keyIDLen;

    public SubjectKeyID() {
        this.extensionTypeFlag = 14;
        this.criticality = false;
        this.setStandardOID(14);
        this.extensionTypeString = "SubjectKeyID";
    }

    public SubjectKeyID(byte[] keyID, int offset, int len, boolean criticality) {
        this.extensionTypeFlag = 14;
        this.criticality = criticality;
        if (keyID != null && len != 0) {
            this.setKeyID(keyID, offset, len);
        }
        this.setStandardOID(14);
        this.extensionTypeString = "SubjectKeyID";
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        OctetStringContainer idValue = new OctetStringContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{idValue};
        try {
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            this.keyID = null;
            throw new CertificateException("Could not decode SubjectKeyID extension.");
        }
        this.setKeyID(idValue.data, idValue.dataOffset, idValue.dataLen);
    }

    public void setKeyID(byte[] keyID, int offset, int len) {
        if (keyID == null || len == 0) {
            return;
        }
        try {
            OctetStringContainer idValue = new OctetStringContainer(0, true, 0, keyID, offset, len);
            ASN1Container[] asn1Def = new ASN1Container[]{idValue};
            this.keyID = ASN1.derEncode((ASN1Container[])asn1Def);
            this.keyIDOffset = 1 + ASN1Lengths.determineLengthLen((byte[])this.keyID, (int)1);
            this.keyIDLen = this.keyID.length - this.keyIDOffset;
        }
        catch (ASN_Exception asnException) {
            this.keyID = null;
            this.keyIDOffset = 0;
            this.keyIDLen = 0;
        }
    }

    public byte[] getKeyID() {
        if (this.keyID == null) {
            return null;
        }
        byte[] returnValue = new byte[this.keyIDLen];
        System.arraycopy(this.keyID, this.keyIDOffset, returnValue, 0, this.keyIDLen);
        return returnValue;
    }

    public int derEncodeValueInit() {
        if (this.keyID != null) {
            return this.keyID.length;
        }
        return 0;
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.keyID == null) {
            return 0;
        }
        System.arraycopy(this.keyID, 0, encoding, offset, this.keyID.length);
        return this.keyID.length;
    }

    public Object clone() throws CloneNotSupportedException {
        SubjectKeyID otherSelf = new SubjectKeyID();
        if (this.keyID != null) {
            otherSelf.keyID = (byte[])this.keyID.clone();
            otherSelf.keyIDOffset = this.keyIDOffset;
            otherSelf.keyIDLen = this.keyIDLen;
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.keyID = null;
    }
}

