/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.asn1.TeletexStringContainer;
import com.rsa.certj.cert.NameException;
import java.io.Serializable;
import java.util.Vector;

public class UnformattedPostalAddress
implements Cloneable,
Serializable {
    private String[] printableAddress = new String[6];
    private int printIndex;
    private String teletex;
    protected int special;
    protected ASN1Template asn1Template;

    public UnformattedPostalAddress(byte[] valueBER, int offset, int special) throws NameException {
        this.special = special;
        if (valueBER == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            SetContainer setContainer = new SetContainer(special);
            EncodedContainer addressContainer = new EncodedContainer(77824);
            TeletexStringContainer teletexContainer = new TeletexStringContainer(65536, 1, 180);
            EndContainer end = new EndContainer();
            ASN1Container[] asn1Def = new ASN1Container[]{setContainer, addressContainer, teletexContainer, end};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            if (addressContainer.dataPresent) {
                OfContainer sequenceOfContainer = new OfContainer(65536, 12288, (ASN1Container)new EncodedContainer(4864));
                ASN1Container[] nameDef = new ASN1Container[]{sequenceOfContainer};
                ASN1.berDecode((byte[])addressContainer.data, (int)addressContainer.dataOffset, (ASN1Container[])nameDef);
                int nameCount = sequenceOfContainer.getContainerCount();
                if (nameCount > 6) {
                    throw new NameException("Too many entries in PrintableAddress: MAX number is 6.");
                }
                for (int index = 0; index < nameCount; ++index) {
                    ASN1Container nameContainer = sequenceOfContainer.containerAt(index);
                    PrintStringContainer printContainer = new PrintStringContainer(0, 1, 30);
                    ASN1Container[] nameStringDef = new ASN1Container[]{printContainer};
                    ASN1.berDecode((byte[])nameContainer.data, (int)nameContainer.dataOffset, (ASN1Container[])nameStringDef);
                    this.printableAddress[this.printIndex] = printContainer.getValueAsString();
                    ++this.printIndex;
                }
            }
            if (teletexContainer.dataPresent) {
                this.teletex = teletexContainer.getValueAsString();
            }
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Cannot decode the BER of the UnformattedPostalAddress.");
        }
    }

    public UnformattedPostalAddress() {
    }

    public void setPrintableAddress(String address) throws NameException {
        if (address == null) {
            throw new NameException("Specified value is null.");
        }
        if (address.length() > 30) {
            throw new NameException("Specified value is too long.");
        }
        if (this.printIndex < 5) {
            this.printableAddress[this.printIndex] = address;
            ++this.printIndex;
        } else {
            throw new NameException("Cannot add PrintableAddress: MAX  number is 6.");
        }
    }

    public void setTeletexString(String teletex) throws NameException {
        if (teletex == null) {
            throw new NameException("Specified value is null.");
        }
        if (teletex.length() > 180) {
            throw new NameException("Specified value is too long.");
        }
        this.teletex = teletex;
    }

    public String[] getPrintableAddress() {
        return this.printableAddress;
    }

    public String getTeletexString() {
        return this.teletex;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int index = 0; index < this.printIndex; ++index) {
            if (buffer.length() != 0) {
                buffer.append(",");
            }
            buffer.append(this.printableAddress[index]);
        }
        if (this.teletex != null) {
            if (buffer.length() != 0) {
                buffer.append(",");
            }
            buffer.append(this.teletex);
        }
        return buffer.toString();
    }

    public static int getNextBEROffset(byte[] nameBER, int offset) throws NameException {
        if (nameBER == null) {
            throw new NameException("Encoding is null.");
        }
        if (nameBER[offset] == 0 && nameBER[offset + 1] == 0) {
            return offset + 2;
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])nameBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])nameBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int special) throws NameException {
        this.special = special;
        return this.derEncodeInit();
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws NameException {
        if (encoding == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            int len;
            if ((this.asn1Template == null || special != this.special) && (len = this.getDERLen(special)) == 0) {
                throw new NameException("Unable to encode UnformattedPostalAddress");
            }
            int returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new NameException("Unable to encode UnformattedPostalAddress");
        }
    }

    private int derEncodeInit() {
        if (this.asn1Template != null) {
            return 0;
        }
        try {
            SetContainer setContainer = new SetContainer(this.special, true, 0);
            EndContainer end = new EndContainer();
            if (this.printIndex > 0) {
                EncodedContainer addressContainer = this.encodePrintAddress();
                if (this.teletex != null) {
                    TeletexStringContainer teletexContainer = new TeletexStringContainer(65536, true, 0, this.teletex, 1, 180);
                    ASN1Container[] nameDef1 = new ASN1Container[]{setContainer, addressContainer, teletexContainer, end};
                    this.asn1Template = new ASN1Template(nameDef1);
                } else {
                    ASN1Container[] nameDef2 = new ASN1Container[]{setContainer, addressContainer, end};
                    this.asn1Template = new ASN1Template(nameDef2);
                }
            } else if (this.teletex != null) {
                TeletexStringContainer teletexContainer = new TeletexStringContainer(65536, true, 0, this.teletex, 1, 180);
                ASN1Container[] nameDef3 = new ASN1Container[]{setContainer, teletexContainer, end};
                this.asn1Template = new ASN1Template(nameDef3);
            } else {
                ASN1Container[] nameDef4 = new ASN1Container[]{setContainer, end};
                this.asn1Template = new ASN1Template(nameDef4);
            }
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
        catch (NameException nameException) {
            return 0;
        }
    }

    private EncodedContainer encodePrintAddress() throws NameException {
        EncodedContainer next;
        Vector<OfContainer> asn1Def = new Vector<OfContainer>();
        try {
            OfContainer sequenceOfContainer = new OfContainer(65536, true, 0, 12288, (ASN1Container)new EncodedContainer(4864));
            asn1Def.addElement(sequenceOfContainer);
            for (int index = 0; index < this.printIndex; ++index) {
                PrintStringContainer printContainer = new PrintStringContainer(0, true, 0, this.printableAddress[index], 1, 30);
                ASN1Container[] asnDef = new ASN1Container[]{printContainer};
                ASN1Template templ = new ASN1Template(asnDef);
                int encodingLen = templ.derEncodeInit();
                byte[] encoding = new byte[encodingLen];
                encodingLen = templ.derEncode(encoding, 0);
                EncodedContainer address = new EncodedContainer(4864, true, 0, encoding, 0, encodingLen);
                sequenceOfContainer.addContainer((ASN1Container)address);
            }
            Object[] asn1DefArray = new ASN1Container[asn1Def.size()];
            asn1Def.copyInto(asn1DefArray);
            ASN1Template asnTemplate = new ASN1Template((ASN1Container[])asn1DefArray);
            int encLen = asnTemplate.derEncodeInit();
            byte[] enc = new byte[encLen];
            encLen = asnTemplate.derEncode(enc, 0);
            next = new EncodedContainer(12288, true, 0, enc, 0, encLen);
        }
        catch (ASN_Exception asnException) {
            throw new NameException(" Can't encode PrintAddress");
        }
        return next;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof UnformattedPostalAddress)) {
            return false;
        }
        UnformattedPostalAddress other = (UnformattedPostalAddress)obj;
        if (this.printIndex != other.printIndex) {
            return false;
        }
        if (this.teletex != null ? !this.teletex.equals(other.teletex) : other.teletex != null) {
            return false;
        }
        for (int index = 0; index < this.printIndex; ++index) {
            if (this.printableAddress[index].equals(other.printableAddress[index])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashcode = this.printIndex;
        if (this.teletex != null) {
            hashcode ^= this.teletex.hashCode();
        }
        for (int index = 0; index < this.printIndex; ++index) {
            hashcode ^= 17 * this.printableAddress[index].hashCode();
        }
        return hashcode;
    }

    public Object clone() throws CloneNotSupportedException {
        UnformattedPostalAddress otherSelf = new UnformattedPostalAddress();
        otherSelf.printIndex = this.printIndex;
        if (this.teletex != null) {
            otherSelf.teletex = this.teletex;
        }
        System.arraycopy(this.printableAddress, 0, otherSelf.printableAddress, 0, this.printIndex);
        otherSelf.special = this.special;
        if (this.asn1Template != null) {
            otherSelf.derEncodeInit();
        }
        return otherSelf;
    }
}

