/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.IA5StringContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;

public class VeriSignFidelityUniqueID
extends X509V3Extension
implements CertExtension {
    private String value;
    ASN1Template asn1TemplateValue;

    public VeriSignFidelityUniqueID() {
        this.extensionTypeFlag = 110;
        this.criticality = false;
        this.setSpecialOID(VERISIGN_FIDELITY_ID_OID);
        this.extensionTypeString = "VeriSignFidelityUniqueID";
    }

    public VeriSignFidelityUniqueID(String value, boolean criticality) {
        this.extensionTypeFlag = 110;
        criticality = false;
        this.setSpecialOID(VERISIGN_FIDELITY_ID_OID);
        this.criticality = criticality;
        if (value != null) {
            this.value = value;
        }
        this.extensionTypeString = "VeriSignFidelityUniqueID";
    }

    public void setFidelityUniqueID(String value) {
        if (value != null) {
            this.value = value;
        }
    }

    public String getFidelityUniqueID() {
        return this.value;
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            IA5StringContainer id = new IA5StringContainer(0);
            ASN1Container[] asn1Def = new ASN1Container[]{id};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            this.value = id.getValueAsString();
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode VeriSignFidelityUniqueID extension.");
        }
    }

    public int derEncodeValueInit() {
        try {
            IA5StringContainer id = new IA5StringContainer(0, true, 0, this.value);
            ASN1Container[] asn1Def = new ASN1Container[]{id};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        VeriSignFidelityUniqueID otherSelf = new VeriSignFidelityUniqueID();
        otherSelf.value = this.value;
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.value = null;
        this.asn1TemplateValue = null;
    }
}

