/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cert.attributes.X501Attribute;
import com.rsa.certj.cert.extensions.X509V3Extension;

public class VeriSignNonVerifiedElements
extends X509V3Extension
implements CertExtension {
    private X501Attributes theAttributes = new X501Attributes();
    ASN1Template asn1TemplateValue;

    public VeriSignNonVerifiedElements() {
        this.extensionTypeFlag = 116;
        this.criticality = false;
        this.setSpecialOID(VERISIGN_NON_VERIFIED_OID);
        this.extensionTypeString = "VeriSignNonVerifiedElements";
    }

    public VeriSignNonVerifiedElements(X501Attributes attributes, boolean criticality) {
        this.extensionTypeFlag = 116;
        criticality = false;
        this.setSpecialOID(VERISIGN_NON_VERIFIED_OID);
        this.extensionTypeString = "VeriSignNonVerifiedElements";
        this.criticality = criticality;
        try {
            if (attributes != null) {
                this.theAttributes = (X501Attributes)attributes.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    public void addAttribute(X501Attribute attribute) {
        if (attribute != null) {
            this.theAttributes.addAttribute(attribute);
        }
    }

    public void setAttributes(X501Attributes attributes) {
        try {
            if (attributes != null) {
                this.theAttributes = (X501Attributes)attributes.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    public int getAttributeCount() {
        return this.theAttributes.getAttributeCount();
    }

    public X501Attribute getAttributeByIndex(int index) throws CertificateException {
        if (index < this.theAttributes.getAttributeCount()) {
            return this.theAttributes.getAttributeByIndex(index);
        }
        throw new CertificateException("Invalid Index");
    }

    public X501Attributes getAttributes() {
        try {
            return (X501Attributes)this.theAttributes.clone();
        }
        catch (CloneNotSupportedException cloneExc) {
            return null;
        }
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            this.theAttributes = new X501Attributes(valueBER, offset, 0);
        }
        catch (AttributeException attException) {
            throw new CertificateException("Could not decode VeriSignNonVerifiedElements extension.");
        }
    }

    public int derEncodeValueInit() {
        try {
            byte[] encoding = new byte[this.theAttributes.getDERLen(0)];
            int len = this.theAttributes.getDEREncoding(encoding, 0, 0);
            EncodedContainer attrContainer = new EncodedContainer(12544, true, 0, encoding, 0, len);
            ASN1Container[] asn1Def = new ASN1Container[]{attrContainer};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (Exception anyExc) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        try {
            if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
                return 0;
            }
            int returnLen = this.asn1TemplateValue.derEncode(encoding, offset);
            return returnLen;
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        VeriSignNonVerifiedElements otherSelf = new VeriSignNonVerifiedElements();
        otherSelf.theAttributes = (X501Attributes)this.theAttributes.clone();
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.theAttributes = null;
    }
}

