/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;

public class VeriSignTokenType
extends X509V3Extension
implements CertExtension {
    public static final int TOKEN_TYPE_BITS = 4;
    public static final int TOKEN_TYPE_MASK = -268435456;
    public static final int PRIVATE_KEY_STORAGE = Integer.MIN_VALUE;
    public static final int GENERATED_AND_STORED = 0x40000000;
    public static final int SAFE_EXPORT = 0x20000000;
    public static final int NON_EXPORTABLE = 0x10000000;
    private int tokenType;
    ASN1Template asn1TemplateValue;

    public VeriSignTokenType() {
        this.extensionTypeFlag = 114;
        this.criticality = false;
        this.setSpecialOID(VERISIGN_TOKEN_TYPE_OID);
        this.extensionTypeString = "VeriSignTokenType";
    }

    public VeriSignTokenType(int value, boolean criticality) {
        this.extensionTypeFlag = 114;
        criticality = false;
        this.setSpecialOID(VERISIGN_TOKEN_TYPE_OID);
        this.extensionTypeString = "VeriSignTokenType";
        this.criticality = criticality;
        this.tokenType = value;
    }

    public void setTokenType(int value) {
        this.tokenType = value & 0xF0000000;
    }

    public int getTokenType() {
        return this.tokenType;
    }

    public void decodeValue(byte[] valueBER, int offset) throws CertificateException {
        if (valueBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        this.tokenType = 0;
        try {
            BitStringContainer type = new BitStringContainer(0);
            ASN1Container[] asn1Def = new ASN1Container[]{type};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            if (type.dataLen == 0) {
                return;
            }
            if (type.dataLen > 4) {
                throw new CertificateException("Could not decode VeriSignTokenType extension.");
            }
            int index = type.dataOffset;
            int shiftCount = 24;
            while (index < type.dataOffset + type.dataLen) {
                this.tokenType |= (type.data[index] & 0xFF) << shiftCount;
                ++index;
                shiftCount -= 8;
            }
            this.tokenType &= 0xF0000000;
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not decode VeriSignTokenType extension.");
        }
    }

    public int derEncodeValueInit() {
        BitStringContainer bits = new BitStringContainer(0, true, 0, this.tokenType, 4, true);
        ASN1Container[] asn1Def = new ASN1Container[]{bits};
        this.asn1TemplateValue = new ASN1Template(asn1Def);
        try {
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] encoding, int offset) {
        if (encoding == null) {
            return 0;
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        VeriSignTokenType otherSelf = new VeriSignTokenType();
        otherSelf.tokenType = this.tokenType;
        if (this.asn1TemplateValue != null) {
            otherSelf.derEncodeValueInit();
        }
        super.copyValues(otherSelf);
        return otherSelf;
    }

    protected void reset() {
        super.reset();
        this.tokenType = 0;
        this.asn1TemplateValue = null;
    }
}

