/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BooleanContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.ArchiveCutoff;
import com.rsa.certj.cert.extensions.AuthorityInfoAccess;
import com.rsa.certj.cert.extensions.AuthorityKeyID;
import com.rsa.certj.cert.extensions.BasicConstraints;
import com.rsa.certj.cert.extensions.BiometricInfo;
import com.rsa.certj.cert.extensions.CRLDistributionPoints;
import com.rsa.certj.cert.extensions.CRLNumber;
import com.rsa.certj.cert.extensions.CRLReference;
import com.rsa.certj.cert.extensions.CertPolicies;
import com.rsa.certj.cert.extensions.CertificateIssuer;
import com.rsa.certj.cert.extensions.DeltaCRLIndicator;
import com.rsa.certj.cert.extensions.ExtendedKeyUsage;
import com.rsa.certj.cert.extensions.FreshestCRL;
import com.rsa.certj.cert.extensions.HoldInstructionCode;
import com.rsa.certj.cert.extensions.InhibitAnyPolicy;
import com.rsa.certj.cert.extensions.InvalidityDate;
import com.rsa.certj.cert.extensions.IssuerAltName;
import com.rsa.certj.cert.extensions.IssuingDistributionPoint;
import com.rsa.certj.cert.extensions.KeyUsage;
import com.rsa.certj.cert.extensions.NameConstraints;
import com.rsa.certj.cert.extensions.NetscapeBaseURL;
import com.rsa.certj.cert.extensions.NetscapeCAPolicyURL;
import com.rsa.certj.cert.extensions.NetscapeCARevocationURL;
import com.rsa.certj.cert.extensions.NetscapeCertRenewalURL;
import com.rsa.certj.cert.extensions.NetscapeCertType;
import com.rsa.certj.cert.extensions.NetscapeComment;
import com.rsa.certj.cert.extensions.NetscapeRevocationURL;
import com.rsa.certj.cert.extensions.NetscapeSSLServerName;
import com.rsa.certj.cert.extensions.NonStandardExtension;
import com.rsa.certj.cert.extensions.OCSPAcceptableResponses;
import com.rsa.certj.cert.extensions.OCSPNoCheck;
import com.rsa.certj.cert.extensions.OCSPNonce;
import com.rsa.certj.cert.extensions.OCSPServiceLocator;
import com.rsa.certj.cert.extensions.PolicyConstraints;
import com.rsa.certj.cert.extensions.PolicyMappings;
import com.rsa.certj.cert.extensions.PrivateKeyUsagePeriod;
import com.rsa.certj.cert.extensions.QCStatements;
import com.rsa.certj.cert.extensions.ReasonCode;
import com.rsa.certj.cert.extensions.SubjectAltName;
import com.rsa.certj.cert.extensions.SubjectDirectoryAttributes;
import com.rsa.certj.cert.extensions.SubjectInfoAccess;
import com.rsa.certj.cert.extensions.SubjectKeyID;
import com.rsa.certj.cert.extensions.VeriSignCZAG;
import com.rsa.certj.cert.extensions.VeriSignFidelityUniqueID;
import com.rsa.certj.cert.extensions.VeriSignJurisdictionHash;
import com.rsa.certj.cert.extensions.VeriSignNetscapeInBoxV1;
import com.rsa.certj.cert.extensions.VeriSignNetscapeInBoxV2;
import com.rsa.certj.cert.extensions.VeriSignNonVerifiedElements;
import com.rsa.certj.cert.extensions.VeriSignSerialNumberRollover;
import com.rsa.certj.cert.extensions.VeriSignTokenType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Vector;

public abstract class X509V3Extension
implements Cloneable,
Serializable {
    protected String extensionTypeString;
    protected static final int OID_BYTE_ONE = 85;
    protected static final int OID_BYTE_TWO = 29;
    public static final int SUBJECT_KEY_ID = 14;
    public static final int AUTHORITY_KEY_ID = 35;
    public static final int KEY_USAGE = 15;
    public static final int PRIVATE_KEY_USAGE_PERIOD = 16;
    public static final int SUBJECT_ALT_NAME = 17;
    public static final int ISSUER_ALT_NAME = 18;
    public static final int BASIC_CONSTRAINTS = 19;
    public static final int SUBJECT_DIRECTORY_ATTRIBUTES = 9;
    public static final int NAME_CONSTRAINTS = 30;
    public static final int CERT_POLICIES = 32;
    public static final int POLICY_MAPPINGS = 33;
    public static final int POLICY_CONSTRAINTS = 36;
    public static final int EXTENDED_KEY_USAGE = 37;
    public static final int CRL_NUMBER = 20;
    public static final int REASON_CODE = 21;
    public static final int HOLD_INSTRUCTION_CODE = 23;
    public static final int INVALIDITY_DATE = 24;
    public static final int DELTA_CRL_INDICATOR = 27;
    public static final int ISSUING_DISTRIBUTION_POINT = 28;
    public static final int CERTIFICATE_ISSUER = 29;
    public static final int CRL_DISTRIBUTION_POINTS = 31;
    public static final int FRESHEST_CRL = 46;
    public static final int INHIBIT_ANY_POLICY = 54;
    private static final int SPECIAL_EXT = 100;
    public static final int AUTHORITY_INFO_ACCESS = 100;
    public static final byte[] AUTHORITY_INFO_OID = new byte[]{43, 6, 1, 5, 5, 7, 1, 1};
    public static final byte[] ANY_POLICY_OID = new byte[]{85, 29, 32, 0};
    public static final int NETSCAPE_CERT_TYPE = 101;
    public static final byte[] NETSCAPE_CERT_TYPE_OID = new byte[]{96, -122, 72, 1, -122, -8, 66, 1, 1};
    public static final int NETSCAPE_BASE_URL = 102;
    public static final byte[] NETSCAPE_BASE_URL_OID = new byte[]{96, -122, 72, 1, -122, -8, 66, 1, 2};
    public static final int NETSCAPE_REVOCATION_URL = 103;
    public static final byte[] NETSCAPE_REVOCATION_URL_OID = new byte[]{96, -122, 72, 1, -122, -8, 66, 1, 3};
    public static final int NETSCAPE_CA_REVOCATION_URL = 104;
    public static final byte[] NETSCAPE_CA_REVOCATION_URL_OID = new byte[]{96, -122, 72, 1, -122, -8, 66, 1, 4};
    public static final int NETSCAPE_CERT_RENEWAL_URL = 105;
    public static final byte[] NETSCAPE_CERT_RENEWAL_URL_OID = new byte[]{96, -122, 72, 1, -122, -8, 66, 1, 7};
    public static final int NETSCAPE_CA_POLICY_URL = 106;
    public static final byte[] NETSCAPE_CA_POLICY_URL_OID = new byte[]{96, -122, 72, 1, -122, -8, 66, 1, 8};
    public static final int NETSCAPE_SSL_SERVER_NAME = 107;
    public static final byte[] NETSCAPE_SSL_SERVER_NAME_OID = new byte[]{96, -122, 72, 1, -122, -8, 66, 1, 12};
    public static final int NETSCAPE_COMMENT = 108;
    public static final byte[] NETSCAPE_COMMENT_OID = new byte[]{96, -122, 72, 1, -122, -8, 66, 1, 13};
    public static final int VERISIGN_CZAG = 109;
    public static final byte[] VERISIGN_CZAG_OID = new byte[]{96, -122, 72, 1, -122, -8, 69, 1, 6, 3};
    public static final int VERISIGN_FIDELITY_ID = 110;
    public static final byte[] VERISIGN_FIDELITY_ID_OID = new byte[]{96, -122, 72, 1, -122, -8, 69, 1, 6, 5};
    public static final int VERISIGN_NETSCAPE_INBOX_V1 = 111;
    public static final byte[] VERISIGN_NETSCAPE_INBOX_V1_OID = new byte[]{96, -122, 72, 1, -122, -8, 69, 1, 6, 6};
    public static final int VERISIGN_NETSCAPE_INBOX_V2 = 112;
    public static final byte[] VERISIGN_NETSCAPE_INBOX_V2_OID = new byte[]{96, -122, 72, 1, -122, -8, 69, 1, 6, 10};
    public static final int VERISIGN_JURISDICTION_HASH = 113;
    public static final byte[] VERISIGN_JURISDICTION_HASH_OID = new byte[]{96, -122, 72, 1, -122, -8, 69, 1, 6, 11};
    public static final int VERISIGN_TOKEN_TYPE = 114;
    public static final byte[] VERISIGN_TOKEN_TYPE_OID = new byte[]{96, -122, 72, 1, -122, -8, 69, 1, 6, 8};
    public static final int VERISIGN_SERIAL_NUMBER = 115;
    public static final byte[] VERISIGN_SERIAL_NUMBER_OID = new byte[]{96, -122, 72, 1, -122, -8, 69, 1, 6, 7};
    public static final int VERISIGN_NON_VERIFIED = 116;
    public static final byte[] VERISIGN_NON_VERIFIED_OID = new byte[]{96, -122, 72, 1, -122, -8, 69, 1, 6, 4};
    public static final int OCSP_NOCHECK = 117;
    public static final byte[] OCSP_NOCHECK_OID = new byte[]{43, 6, 1, 5, 5, 7, 48, 1, 5};
    public static final int ARCHIVE_CUTOFF = 118;
    public static final byte[] ARCHIVE_CUTOFF_OID = new byte[]{43, 6, 1, 5, 5, 7, 48, 1, 6};
    public static final int CRL_REFERENCE = 119;
    public static final byte[] CRL_REFERENCE_OID = new byte[]{43, 6, 1, 5, 5, 7, 48, 1, 3};
    public static final int OCSP_NONCE = 120;
    public static final byte[] OCSP_NONCE_OID = new byte[]{43, 6, 1, 5, 5, 7, 48, 1, 2};
    public static final int OCSP_ACCEPTABLE_RESPONSES = 121;
    public static final byte[] OCSP_ACCEPTABLE_RESPONSES_OID = new byte[]{43, 6, 1, 5, 5, 7, 48, 1, 4};
    public static final int OCSP_SERVICE_LOCATOR = 122;
    public static final byte[] OCSP_SERVICE_LOCATOR_OID = new byte[]{43, 6, 1, 5, 5, 7, 48, 1, 7};
    public static final int QC_STATEMENTS = 123;
    public static final byte[] QC_STATEMENTS_OID = new byte[]{43, 6, 1, 5, 5, 7, 1, 3};
    public static final int BIO_INFO = 124;
    public static final byte[] BIO_INFO_OID = new byte[]{43, 6, 1, 5, 5, 7, 1, 2};
    public static final int SUBJECT_INFO_ACCESS = 125;
    public static final byte[] SUBJECT_INFO_OID = new byte[]{43, 6, 1, 5, 5, 7, 1, 11};
    public static final int NON_STANDARD_EXTENSION = -1;
    private static final int[] STANDARD_EXTENSION_LIST = new int[]{14, 35, 15, 16, 17, 18, 19, 9, 30, 32, 33, 36, 37, 20, 21, 23, 24, 27, 28, 29, 31, 46, 54, -1};
    private static final byte[][] SPECIAL_EXTENSION_LIST = new byte[][]{AUTHORITY_INFO_OID, NETSCAPE_CERT_TYPE_OID, NETSCAPE_BASE_URL_OID, NETSCAPE_REVOCATION_URL_OID, NETSCAPE_CA_REVOCATION_URL_OID, NETSCAPE_CERT_RENEWAL_URL_OID, NETSCAPE_CA_POLICY_URL_OID, NETSCAPE_SSL_SERVER_NAME_OID, NETSCAPE_COMMENT_OID, VERISIGN_CZAG_OID, VERISIGN_FIDELITY_ID_OID, VERISIGN_NETSCAPE_INBOX_V1_OID, VERISIGN_NETSCAPE_INBOX_V2_OID, VERISIGN_JURISDICTION_HASH_OID, VERISIGN_TOKEN_TYPE_OID, VERISIGN_SERIAL_NUMBER_OID, VERISIGN_NON_VERIFIED_OID, OCSP_NOCHECK_OID, ARCHIVE_CUTOFF_OID, CRL_REFERENCE_OID, OCSP_NONCE_OID, OCSP_ACCEPTABLE_RESPONSES_OID, OCSP_SERVICE_LOCATOR_OID, QC_STATEMENTS_OID, BIO_INFO_OID, SUBJECT_INFO_OID};
    private static Vector<byte[]> extendedExtensionOIDs = new Vector();
    private static Vector<X509V3Extension> extendedExtensionObjects = new Vector();
    protected boolean criticality;
    protected int extensionTypeFlag;
    byte[] theOID;
    int theOIDLen;
    protected int special;
    protected ASN1Template asn1Template;
    protected byte[] extEncoding;

    public static void extend(byte[] oid, X509V3Extension extension) throws CertificateException {
        if (oid == null || extension == null) {
            throw new CertificateException("X509V3Extension.extend: neither oid nor extension should be null.");
        }
        if (X509V3Extension.oidAlreadyInUse(oid)) {
            throw new CertificateException("X509V3Extension.extend: oid is already in use.");
        }
        X509V3Extension foundExtension = X509V3Extension.findExtendedExtension(oid, 0, oid.length);
        if (foundExtension == null) {
            extendedExtensionOIDs.addElement(oid);
            extendedExtensionObjects.addElement(extension);
        } else if (!extension.getClass().isInstance(foundExtension)) {
            throw new CertificateException("X509V3Extension.extend: there exists an extended extension using the same OID.");
        }
    }

    private static boolean oidAlreadyInUse(byte[] oid) {
        return X509V3Extension.isStandardOID(oid) || X509V3Extension.isSpecialOID(oid);
    }

    private static boolean isStandardOID(byte[] oid) {
        if (oid.length != 3) {
            return false;
        }
        if (oid[0] != 85) {
            return false;
        }
        if (oid[1] != 29) {
            return false;
        }
        for (int i = 0; i < STANDARD_EXTENSION_LIST.length; ++i) {
            if (oid[2] != STANDARD_EXTENSION_LIST[i]) continue;
            return true;
        }
        return false;
    }

    private static boolean isSpecialOID(byte[] oid) {
        int oidLen = oid.length;
        for (int i = 0; i < SPECIAL_EXTENSION_LIST.length; ++i) {
            byte[] specialOID = SPECIAL_EXTENSION_LIST[i];
            if (!X509V3Extension.oidsMatch(specialOID, oid, 0, oidLen)) continue;
            return true;
        }
        return false;
    }

    private static X509V3Extension findExtendedExtension(byte[] oidBytes, int offset, int len) throws CertificateException {
        int count = extendedExtensionOIDs.size();
        for (int i = 0; i < count; ++i) {
            byte[] extendedOID = extendedExtensionOIDs.elementAt(i);
            if (!X509V3Extension.oidsMatch(extendedOID, oidBytes, offset, len)) continue;
            try {
                X509V3Extension ext = extendedExtensionObjects.elementAt(i);
                return (X509V3Extension)ext.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new CertificateException("X509V3Extension.findExtendedExtension: extended extension should support clone method.", e);
            }
        }
        return null;
    }

    private static boolean oidsMatch(byte[] oid, byte[] oidBytes, int offset, int len) {
        if (oid.length != len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (oid[i] == oidBytes[offset + i]) continue;
            return false;
        }
        return true;
    }

    public static X509V3Extension getInstance(byte[] extensionBER, int offset) throws CertificateException {
        X509V3Extension returnValue;
        ASN1Container[] asn1Def;
        block55: {
            if (extensionBER == null) {
                throw new CertificateException("Encoding is null.");
            }
            asn1Def = X509V3Extension.decodeExtension(extensionBER, offset);
            int extensionType = X509V3Extension.findOID(asn1Def[1].data, asn1Def[1].dataOffset, asn1Def[1].dataLen);
            switch (extensionType) {
                case 14: {
                    returnValue = new SubjectKeyID();
                    break;
                }
                case 35: {
                    returnValue = new AuthorityKeyID();
                    break;
                }
                case 15: {
                    returnValue = new KeyUsage();
                    break;
                }
                case 16: {
                    returnValue = new PrivateKeyUsagePeriod();
                    break;
                }
                case 17: {
                    returnValue = new SubjectAltName();
                    break;
                }
                case 18: {
                    returnValue = new IssuerAltName();
                    break;
                }
                case 19: {
                    returnValue = new BasicConstraints();
                    break;
                }
                case 9: {
                    returnValue = new SubjectDirectoryAttributes();
                    break;
                }
                case 30: {
                    returnValue = new NameConstraints();
                    break;
                }
                case 32: {
                    returnValue = new CertPolicies();
                    break;
                }
                case 33: {
                    returnValue = new PolicyMappings();
                    break;
                }
                case 36: {
                    returnValue = new PolicyConstraints();
                    break;
                }
                case 37: {
                    returnValue = new ExtendedKeyUsage();
                    break;
                }
                case 20: {
                    returnValue = new CRLNumber();
                    break;
                }
                case 21: {
                    returnValue = new ReasonCode();
                    break;
                }
                case 23: {
                    returnValue = new HoldInstructionCode();
                    break;
                }
                case 24: {
                    returnValue = new InvalidityDate();
                    break;
                }
                case 27: {
                    returnValue = new DeltaCRLIndicator();
                    break;
                }
                case 28: {
                    returnValue = new IssuingDistributionPoint();
                    break;
                }
                case 29: {
                    returnValue = new CertificateIssuer();
                    break;
                }
                case 31: {
                    returnValue = new CRLDistributionPoints();
                    break;
                }
                case 46: {
                    returnValue = new FreshestCRL();
                    break;
                }
                case 54: {
                    returnValue = new InhibitAnyPolicy();
                    break;
                }
                case 100: {
                    returnValue = new AuthorityInfoAccess();
                    break;
                }
                case 125: {
                    returnValue = new SubjectInfoAccess();
                    break;
                }
                case 101: {
                    returnValue = new NetscapeCertType();
                    break;
                }
                case 102: {
                    returnValue = new NetscapeBaseURL();
                    break;
                }
                case 103: {
                    returnValue = new NetscapeRevocationURL();
                    break;
                }
                case 104: {
                    returnValue = new NetscapeCARevocationURL();
                    break;
                }
                case 105: {
                    returnValue = new NetscapeCertRenewalURL();
                    break;
                }
                case 106: {
                    returnValue = new NetscapeCAPolicyURL();
                    break;
                }
                case 107: {
                    returnValue = new NetscapeSSLServerName();
                    break;
                }
                case 108: {
                    returnValue = new NetscapeComment();
                    break;
                }
                case 109: {
                    returnValue = new VeriSignCZAG();
                    break;
                }
                case 110: {
                    returnValue = new VeriSignFidelityUniqueID();
                    break;
                }
                case 111: {
                    returnValue = new VeriSignNetscapeInBoxV1();
                    break;
                }
                case 112: {
                    returnValue = new VeriSignNetscapeInBoxV2();
                    break;
                }
                case 113: {
                    returnValue = new VeriSignJurisdictionHash();
                    break;
                }
                case 114: {
                    returnValue = new VeriSignTokenType();
                    break;
                }
                case 115: {
                    returnValue = new VeriSignSerialNumberRollover();
                    break;
                }
                case 116: {
                    returnValue = new VeriSignNonVerifiedElements();
                    break;
                }
                case 117: {
                    returnValue = new OCSPNoCheck();
                    break;
                }
                case 118: {
                    returnValue = new ArchiveCutoff();
                    break;
                }
                case 119: {
                    returnValue = new CRLReference();
                    break;
                }
                case 120: {
                    returnValue = new OCSPNonce();
                    break;
                }
                case 121: {
                    returnValue = new OCSPAcceptableResponses();
                    break;
                }
                case 122: {
                    returnValue = new OCSPServiceLocator();
                    break;
                }
                case 123: {
                    returnValue = new QCStatements();
                    break;
                }
                case 124: {
                    returnValue = new BiometricInfo();
                    break;
                }
                case -1: {
                    returnValue = X509V3Extension.findExtendedExtension(asn1Def[1].data, asn1Def[1].dataOffset, asn1Def[1].dataLen);
                    if (returnValue != null) break;
                    returnValue = new NonStandardExtension();
                    break;
                }
                default: {
                    throw new CertificateException("Unknown extension.");
                }
            }
            returnValue.setCriticality(((BooleanContainer)asn1Def[2]).value);
            try {
                returnValue.setEncoding(asn1Def[3].data, asn1Def[3].dataOffset, asn1Def[3].dataLen);
                returnValue.decodeValue(asn1Def[3].data, asn1Def[3].dataOffset);
            }
            catch (CertificateException certException) {
                if (!returnValue.getCriticality()) break block55;
                throw new CertificateException(certException);
            }
        }
        returnValue.setOID(asn1Def[1].data, asn1Def[1].dataOffset, asn1Def[1].dataLen);
        return returnValue;
    }

    public void setEncoding(byte[] data, int offset, int len) {
        this.extEncoding = new byte[len];
        System.arraycopy(data, offset, this.extEncoding, 0, len);
    }

    public static int getNextBEROffset(byte[] extensionBER, int offset) throws CertificateException {
        if (extensionBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            return offset + ASN1Lengths.determineLength((byte[])extensionBER, (int)offset);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not read the BER encoding.");
        }
    }

    protected static ASN1Container[] decodeExtension(byte[] extensionBER, int offset) throws CertificateException {
        if (extensionBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        SequenceContainer seq1 = new SequenceContainer(0);
        EndContainer anEnd = new EndContainer();
        OIDContainer oid = new OIDContainer(0x1000000);
        BooleanContainer crit = new BooleanContainer(131072);
        OctetStringContainer value = new OctetStringContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{seq1, oid, crit, value, anEnd};
        try {
            ASN1.berDecode((byte[])extensionBER, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Cannot read the BER of the extension.");
        }
        return asn1Def;
    }

    protected void setOID(byte[] oid, int offset, int len) {
    }

    public byte[] getOID() {
        if (this.theOID != null && this.theOIDLen != 0) {
            byte[] returnValue = new byte[this.theOIDLen];
            System.arraycopy(this.theOID, 0, returnValue, 0, this.theOIDLen);
            return returnValue;
        }
        return null;
    }

    public void setStandardOID(int lastByte) {
        this.theOID = new byte[3];
        this.theOID[0] = 85;
        this.theOID[1] = 29;
        this.theOID[2] = (byte)lastByte;
        this.theOIDLen = 3;
    }

    public void setSpecialOID(byte[] extOID) {
        if (extOID != null) {
            this.theOIDLen = extOID.length;
            this.theOID = new byte[this.theOIDLen];
            System.arraycopy(extOID, 0, this.theOID, 0, this.theOIDLen);
        }
    }

    private static int findOID(byte[] theOID, int offset, int len) {
        if (len == 3 && (theOID[offset] & 0xFF) == 85 && (theOID[offset + 1] & 0xFF) == 29) {
            int thirdByte = theOID[offset + 2] & 0xFF;
            int index = 0;
            do {
                if (thirdByte != STANDARD_EXTENSION_LIST[index]) continue;
                return thirdByte;
            } while (STANDARD_EXTENSION_LIST[++index] != -1);
            return -1;
        }
        for (int index = 0; index < SPECIAL_EXTENSION_LIST.length; ++index) {
            if (!X509V3Extension.arrayCompare(SPECIAL_EXTENSION_LIST[index], 0, SPECIAL_EXTENSION_LIST[index].length, theOID, offset, len)) continue;
            return 100 + index;
        }
        return -1;
    }

    private static boolean arrayCompare(byte[] first, int firstOffset, int firstLen, byte[] second, int secondOffset, int secondLen) {
        if (first == null || second == null) {
            return first == null && second == null;
        }
        if (firstLen != secondLen) {
            return false;
        }
        for (int index = 0; index < firstLen; ++index) {
            if (first[index + firstOffset] == second[index + secondOffset]) continue;
            return false;
        }
        return true;
    }

    public void setCriticality(boolean proposedCriticality) {
        if (proposedCriticality == this.criticality) {
            return;
        }
        this.criticality = proposedCriticality;
    }

    public boolean getCriticality() {
        return this.criticality;
    }

    public abstract void decodeValue(byte[] var1, int var2) throws CertificateException;

    public int getExtensionType() {
        return this.extensionTypeFlag;
    }

    public String getExtensionTypeString() {
        return this.extensionTypeString;
    }

    public boolean isExtensionType(int type) {
        return type == this.extensionTypeFlag;
    }

    public int getDERLen(int special) {
        if (this.extEncoding != null) {
            return this.derEncodeExtensionLen(special, this.extEncoding.length);
        }
        return this.derEncodeExtensionLen(special, this.derEncodeValueInit());
    }

    public abstract int derEncodeValueInit();

    public int getDEREncoding(byte[] encoding, int offset, int special) {
        if (encoding == null || offset < 0) {
            return 0;
        }
        return this.derEncodeExtension(encoding, offset, special);
    }

    protected int derEncodeExtensionLen(int special, int valueLen) {
        this.special = special;
        try {
            SequenceContainer seq1 = new SequenceContainer(0, true, 0);
            EndContainer anEnd = new EndContainer();
            OIDContainer oid = new OIDContainer(0x1000000, true, 0, this.theOID, 0, this.theOIDLen);
            BooleanContainer crit = !this.criticality ? new BooleanContainer(131072, false, 0, this.criticality) : new BooleanContainer(131072, true, 0, this.criticality);
            OctetStringContainer value = new OctetStringContainer(0, true, 0, null, 0, valueLen);
            ASN1Container[] asn1Def = new ASN1Container[]{seq1, oid, crit, value, anEnd};
            this.asn1Template = new ASN1Template(asn1Def);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    protected int derEncodeExtension(byte[] encoding, int offset, int special) {
        int totalLen;
        if (encoding == null) {
            return 0;
        }
        if ((this.asn1Template == null || this.special != special) && this.getDERLen(special) == 0) {
            return 0;
        }
        try {
            totalLen = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            return 0;
        }
        if (this.extEncoding != null) {
            if (encoding.length - (offset + totalLen) < this.extEncoding.length) {
                return 0;
            }
            System.arraycopy(this.extEncoding, 0, encoding, offset + totalLen, this.extEncoding.length);
            return this.extEncoding.length + totalLen;
        }
        totalLen += this.derEncodeValue(encoding, offset + totalLen);
        return totalLen;
    }

    public abstract int derEncodeValue(byte[] var1, int var2);

    public abstract Object clone() throws CloneNotSupportedException;

    protected void copyValues(X509V3Extension otherSelf) {
        if (otherSelf == null) {
            return;
        }
        otherSelf.criticality = this.criticality;
        if (this.theOID != null) {
            otherSelf.theOID = (byte[])this.theOID.clone();
            otherSelf.theOIDLen = this.theOIDLen;
        }
        otherSelf.special = this.special;
        if (this.asn1Template != null) {
            otherSelf.getDERLen(this.special);
        }
    }

    protected void reset() {
        this.asn1Template = null;
    }

    protected byte[] intToByteArray(int myInt) {
        int val0 = myInt >>> 24;
        int val1 = myInt >>> 16 & 0xFF;
        int val2 = myInt >>> 8 & 0xFF;
        int val3 = myInt & 0xFF;
        byte[] intBytes = val0 != 0 ? new byte[]{(byte)val0, (byte)val1, (byte)val2, (byte)val3} : (val1 != 0 ? new byte[]{(byte)val1, (byte)val2, (byte)val3} : (val2 != 0 ? new byte[]{(byte)val2, (byte)val3} : new byte[]{(byte)val3}));
        return intBytes;
    }

    protected int byteArrayToInt(byte[] byteArray) {
        int integer = 0;
        for (int i = 0; i < byteArray.length; ++i) {
            byte temp = byteArray[i];
            integer = (integer << 8) + (temp & 0xFF);
        }
        return integer;
    }

    public boolean equals(Object other) {
        if (!(other instanceof X509V3Extension)) {
            return false;
        }
        int len = this.getDERLen(0);
        if (len == 0) {
            return false;
        }
        byte[] enc = new byte[len];
        this.getDEREncoding(enc, 0, 0);
        X509V3Extension otherExt = (X509V3Extension)other;
        int otherLen = otherExt.getDERLen(0);
        if (otherLen == 0) {
            return false;
        }
        byte[] otherEnc = new byte[otherLen];
        otherExt.getDEREncoding(otherEnc, 0, 0);
        return CertJUtils.byteArraysEqual(enc, otherEnc);
    }

    public int hashCode() {
        int len = this.getDERLen(0);
        if (len == 0) {
            return 0;
        }
        byte[] enc = new byte[len];
        this.getDEREncoding(enc, 0, 0);
        return Arrays.hashCode(enc);
    }
}

