/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cms;

public final class Accuracy {
    private final long seconds;
    private final int millis;
    private final int micros;

    public Accuracy(long noOfSeconds, int noOfMillis, int noOfMicros) {
        this.validate(noOfSeconds, noOfMillis, noOfMicros);
        this.seconds = noOfSeconds;
        this.millis = noOfMillis;
        this.micros = noOfMicros;
    }

    private void validate(long noOfSeconds, int noOfMillis, int noOfMicros) {
        if (noOfSeconds < 0L) {
            throw new IllegalArgumentException("Accuracy seconds cannot be negative.");
        }
        if (noOfMillis < 0 || noOfMillis > 1000 || noOfMicros < 0 || noOfMicros > 1000) {
            throw new IllegalArgumentException("Accuracy millis and micros must be between 0 and 999.");
        }
    }

    public long getSeconds() {
        return this.seconds;
    }

    public int getMillis() {
        return this.millis;
    }

    public int getMicros() {
        return this.micros;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Accuracy)) {
            return false;
        }
        Accuracy accuracyObj = (Accuracy)obj;
        return this.seconds == accuracyObj.seconds && this.millis == accuracyObj.millis && this.micros == accuracyObj.micros;
    }

    public int hashCode() {
        return (int)(this.seconds << 20) | this.millis << 10 | this.micros;
    }
}

