/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cms;

import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cms.CMSException;
import com.rsa.certj.cms.CMSUtils;
import com.rsa.certj.cms.Decoder;
import com.rsa.certj.cms.KeyContainer;
import com.rsa.certj.cms.RecipientInfo;
import com.rsa.jsafe.crypto.FIPS140Context;
import com.rsa.jsafe.provider.JsafeJCE;

public final class AuthenticatedDataDecoder
extends Decoder {
    AuthenticatedDataDecoder(com.rsa.jsafe.cms.Decoder jceDecoder, FIPS140Context jceCtx) {
        super(jceDecoder, jceCtx);
    }

    public boolean verify() throws CMSException {
        try {
            return ((com.rsa.jsafe.cms.AuthenticatedDataDecoder)this.jceDecoder).verify();
        }
        catch (com.rsa.jsafe.cms.CMSException e) {
            throw new CMSException(e);
        }
    }

    public RecipientInfo[] getRecipientInfos() {
        com.rsa.jsafe.cms.AuthenticatedDataDecoder jceAuthDecoder = (com.rsa.jsafe.cms.AuthenticatedDataDecoder)this.jceDecoder;
        return CMSUtils.convertToJsafeRecipientInfo(jceAuthDecoder.getRecipientInfos());
    }

    public X509Certificate[] getOriginatorCertificates() {
        com.rsa.jsafe.cms.AuthenticatedDataDecoder jceAuthDecoder = (com.rsa.jsafe.cms.AuthenticatedDataDecoder)this.jceDecoder;
        return CMSUtils.convertToJsafeCertificates(jceAuthDecoder.getOriginatorCertificates());
    }

    public X509CRL[] getOriginatorCRLs() {
        com.rsa.jsafe.cms.AuthenticatedDataDecoder jceAuthDecoder = (com.rsa.jsafe.cms.AuthenticatedDataDecoder)this.jceDecoder;
        return CMSUtils.convertToJsafeCRLs(jceAuthDecoder.getOriginatorCRLs());
    }

    public X501Attributes getAuthenticatedAttributes() throws CMSException {
        com.rsa.jsafe.cms.AuthenticatedDataDecoder jceAuthDecoder = (com.rsa.jsafe.cms.AuthenticatedDataDecoder)this.jceDecoder;
        try {
            return CMSUtils.convertToJsafeAttributes(jceAuthDecoder.getAuthenticatedAttributes());
        }
        catch (com.rsa.jsafe.cms.CMSException e) {
            throw new CMSException(e);
        }
    }

    public X501Attributes getUnauthenticatedAttributes() throws CMSException {
        com.rsa.jsafe.cms.AuthenticatedDataDecoder jceAuthDecoder = (com.rsa.jsafe.cms.AuthenticatedDataDecoder)this.jceDecoder;
        try {
            return CMSUtils.convertToJsafeAttributes(jceAuthDecoder.getUnauthenticatedAttributes());
        }
        catch (com.rsa.jsafe.cms.CMSException e) {
            throw new CMSException(e);
        }
    }

    public void decryptAuthenticationKey(RecipientInfo info, KeyContainer decryptionKey) throws CMSException {
        if (info == null) {
            throw new CMSException("RecipientInfo cannot be null.");
        }
        com.rsa.jsafe.cms.AuthenticatedDataDecoder jceAuthDecoder = (com.rsa.jsafe.cms.AuthenticatedDataDecoder)this.jceDecoder;
        JsafeJCE jceProv = CMSUtils.createJceProvider(this.jceCtx);
        try {
            jceAuthDecoder.decryptAuthenticationKey(info.getJceRecipientInfo(jceProv), CMSUtils.convertToJceKeyContainer(decryptionKey, jceProv));
        }
        catch (com.rsa.jsafe.cms.CMSException e) {
            throw new CMSException(e);
        }
    }
}

