/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cms;

import com.rsa.certj.CertJ;
import com.rsa.certj.cms.AuthenticatedDataDecoder;
import com.rsa.certj.cms.CMSException;
import com.rsa.certj.cms.CMSParameters;
import com.rsa.certj.cms.CMSUtils;
import com.rsa.certj.cms.ContentInfoDecoder;
import com.rsa.certj.cms.ContentType;
import com.rsa.certj.cms.Decoder;
import com.rsa.certj.cms.DigestedDataDecoder;
import com.rsa.certj.cms.Encoder;
import com.rsa.certj.cms.EncryptedDataDecoder;
import com.rsa.certj.cms.EnvelopedDataDecoder;
import com.rsa.certj.cms.SignedDataDecoder;
import com.rsa.certj.cms.TimeStampTokenDecoder;
import com.rsa.jsafe.crypto.FIPS140Context;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class CMS {
    private static final String CONTENT_TYPE_CANNOT_BE_NULL = "ContentType cannot be null.";

    private CMS() {
    }

    public static Decoder newDecoder(ContentType contentType, InputStream encodedInputStream) throws IOException {
        return CMS.wrapDecoder(contentType, encodedInputStream, null);
    }

    public static Decoder newDecoder(ContentType contentType, InputStream encodedInputStream, CertJ certj) throws IOException {
        return CMS.wrapDecoder(contentType, encodedInputStream, certj);
    }

    public static Decoder newDetachedDecoder(ContentType contentType, InputStream encodedInputStream, InputStream detachedContentStream) throws IOException {
        return CMS.wrapDetachedDecoder(contentType, encodedInputStream, detachedContentStream, null);
    }

    public static Decoder newDetachedDecoder(ContentType contentType, InputStream encodedInputStream, InputStream detachedContentStream, CertJ certj) throws IOException {
        return CMS.wrapDetachedDecoder(contentType, encodedInputStream, detachedContentStream, certj);
    }

    public static Encoder newEncoder(ContentType contentType, OutputStream encodedOutputStream) throws IOException {
        return CMS.wrapEncoder(contentType, encodedOutputStream, null, null, null);
    }

    public static Encoder newEncoder(ContentType contentType, OutputStream encodedOutputStream, CMSParameters params) throws IOException {
        return CMS.wrapEncoder(contentType, encodedOutputStream, null, params, null);
    }

    public static Encoder newEncoder(ContentType contentType, OutputStream encodedOutputStream, CertJ certj) throws IOException {
        return CMS.wrapEncoder(contentType, encodedOutputStream, null, null, certj);
    }

    public static Encoder newEncoder(ContentType contentType, OutputStream encodedOutputStream, CMSParameters params, CertJ certj) throws IOException {
        return CMS.wrapEncoder(contentType, encodedOutputStream, null, params, certj);
    }

    public static Encoder newDetachedEncoder(ContentType contentType, OutputStream encodedOutputStream, OutputStream detachedContentStream, CMSParameters params) throws IOException {
        if (detachedContentStream == null) {
            throw new IllegalArgumentException("Detached content stream cannot be null");
        }
        return CMS.wrapDetachedEncoder(contentType, encodedOutputStream, detachedContentStream, params, null);
    }

    public static Encoder newDetachedEncoder(ContentType contentType, OutputStream encodedOutputStream, OutputStream detachedContentStream, CMSParameters params, CertJ certj) throws IOException {
        if (detachedContentStream == null) {
            throw new IllegalArgumentException("Detached content stream cannot be null");
        }
        return CMS.wrapDetachedEncoder(contentType, encodedOutputStream, detachedContentStream, params, certj);
    }

    public static Encoder newDetachedEncoder(ContentType contentType, OutputStream encodedOutputStream, CMSParameters params) throws IOException {
        return CMS.wrapDetachedEncoder(contentType, encodedOutputStream, null, params, null);
    }

    public static Encoder newDetachedEncoder(ContentType contentType, OutputStream encodedOutputStream, CMSParameters params, CertJ certj) throws IOException {
        return CMS.wrapDetachedEncoder(contentType, encodedOutputStream, null, params, certj);
    }

    private static Decoder wrapDecoder(ContentType contentType, InputStream encodedInputStream, CertJ certj) throws IOException {
        com.rsa.jsafe.cms.Decoder jceDecoder;
        if (contentType == null) {
            throw new IllegalArgumentException(CONTENT_TYPE_CANNOT_BE_NULL);
        }
        FIPS140Context jceCtx = CMSUtils.getJceCtx(certj);
        try {
            jceDecoder = com.rsa.jsafe.cms.CMS.newDecoder((com.rsa.jsafe.cms.ContentType)contentType.getJceContextType(), (InputStream)encodedInputStream, (FIPS140Context)jceCtx);
        }
        catch (IOException e) {
            throw new CMSException(e);
        }
        return CMS.createNewDecoder(contentType, jceDecoder, jceCtx);
    }

    private static Decoder wrapDetachedDecoder(ContentType contentType, InputStream encodedInputStream, InputStream detachedContentStream, CertJ certj) throws IOException {
        com.rsa.jsafe.cms.Decoder jceDecoder;
        if (contentType == null) {
            throw new IllegalArgumentException(CONTENT_TYPE_CANNOT_BE_NULL);
        }
        FIPS140Context jceCtx = CMSUtils.getJceCtx(certj);
        try {
            jceDecoder = com.rsa.jsafe.cms.CMS.newDetachedDecoder((com.rsa.jsafe.cms.ContentType)contentType.getJceContextType(), (InputStream)encodedInputStream, (InputStream)detachedContentStream, (FIPS140Context)jceCtx);
        }
        catch (IOException e) {
            throw new CMSException(e);
        }
        return CMS.createNewDecoder(contentType, jceDecoder, jceCtx);
    }

    private static Encoder wrapEncoder(ContentType contentType, OutputStream encodedOutputStream, OutputStream detachedContentStream, CMSParameters params, CertJ certj) throws CMSException {
        com.rsa.jsafe.cms.Encoder jceEncoder;
        if (contentType == null) {
            throw new IllegalArgumentException(CONTENT_TYPE_CANNOT_BE_NULL);
        }
        FIPS140Context jceCtx = CMSUtils.getJceCtx(certj);
        com.rsa.jsafe.cms.CMSParameters jceParams = params == null ? null : params.getJceParameters(jceCtx);
        try {
            jceEncoder = com.rsa.jsafe.cms.CMS.newEncoder((com.rsa.jsafe.cms.ContentType)contentType.getJceContextType(), (OutputStream)encodedOutputStream, (com.rsa.jsafe.cms.CMSParameters)jceParams, (FIPS140Context)jceCtx);
        }
        catch (IOException e) {
            throw new CMSException(e);
        }
        return new Encoder(jceEncoder, jceCtx);
    }

    private static Encoder wrapDetachedEncoder(ContentType contentType, OutputStream encodedOutputStream, OutputStream detachedContentStream, CMSParameters params, CertJ certj) throws IOException {
        com.rsa.jsafe.cms.Encoder jceEncoder;
        if (contentType == null) {
            throw new IllegalArgumentException(CONTENT_TYPE_CANNOT_BE_NULL);
        }
        FIPS140Context jceCtx = CMSUtils.getJceCtx(certj);
        com.rsa.jsafe.cms.CMSParameters jceParams = params == null ? null : params.getJceParameters(jceCtx);
        try {
            jceEncoder = detachedContentStream == null ? com.rsa.jsafe.cms.CMS.newDetachedEncoder((com.rsa.jsafe.cms.ContentType)contentType.getJceContextType(), (OutputStream)encodedOutputStream, (com.rsa.jsafe.cms.CMSParameters)jceParams, (FIPS140Context)jceCtx) : com.rsa.jsafe.cms.CMS.newDetachedEncoder((com.rsa.jsafe.cms.ContentType)contentType.getJceContextType(), (OutputStream)encodedOutputStream, (OutputStream)detachedContentStream, (com.rsa.jsafe.cms.CMSParameters)jceParams, (FIPS140Context)jceCtx);
        }
        catch (IOException e) {
            throw new CMSException(e);
        }
        return new Encoder(jceEncoder, jceCtx);
    }

    static Decoder createNewDecoder(ContentType contentType, com.rsa.jsafe.cms.Decoder jceDecoder, FIPS140Context jceCtx) {
        if (contentType == ContentType.CONTENT_INFO) {
            return new ContentInfoDecoder(jceDecoder, jceCtx);
        }
        if (contentType == ContentType.AUTHENTICATED_DATA) {
            return new AuthenticatedDataDecoder(jceDecoder, jceCtx);
        }
        if (contentType == ContentType.DIGESTED_DATA) {
            return new DigestedDataDecoder(jceDecoder, jceCtx);
        }
        if (contentType == ContentType.ENCRYPTED_DATA) {
            return new EncryptedDataDecoder(jceDecoder, jceCtx);
        }
        if (contentType == ContentType.ENVELOPED_DATA) {
            return new EnvelopedDataDecoder(jceDecoder, jceCtx);
        }
        if (contentType == ContentType.SIGNED_DATA) {
            return new SignedDataDecoder(jceDecoder, jceCtx);
        }
        if (contentType == ContentType.TIMESTAMP_INFO) {
            return new TimeStampTokenDecoder(jceDecoder, jceCtx);
        }
        throw new IllegalArgumentException("Unsupported content type");
    }
}

