/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cms;

import com.rsa.certj.CertJ;
import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.attributes.X501Attribute;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.cert.extensions.X509V3Extension;
import com.rsa.certj.cms.Accuracy;
import com.rsa.certj.cms.CMSException;
import com.rsa.certj.cms.KekRecipientInfo;
import com.rsa.certj.cms.KeyAgreeRecipientInfo;
import com.rsa.certj.cms.KeyContainer;
import com.rsa.certj.cms.KeyTransRecipientInfo;
import com.rsa.certj.cms.PasswordRecipientInfo;
import com.rsa.certj.cms.RecipientInfo;
import com.rsa.certj.cms.SignerInfo;
import com.rsa.certj.internal.CertJContext;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import com.rsa.jsafe.cert.Attribute;
import com.rsa.jsafe.cert.InvalidEncodingException;
import com.rsa.jsafe.cert.X509ExtensionSpec;
import com.rsa.jsafe.crypto.FIPS140Context;
import com.rsa.jsafe.provider.JsafeJCE;
import java.io.ByteArrayInputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CMSUtils {
    private static final int DES_KEY_LENGTH = 8;

    CMSUtils() {
    }

    static JsafeJCE createJceProvider(FIPS140Context context) {
        if (context == null) {
            return new JsafeJCE();
        }
        return new JsafeJCE(context);
    }

    static FIPS140Context getJceCtx(CertJ certj) {
        return certj == null ? CertJContext.getCertJContext().fips140 : CertJInternalHelper.context((CertJ)certj).fips140;
    }

    static com.rsa.jsafe.cms.RecipientInfo[] convertToJceRecipientInfos(RecipientInfo[] recipientInfos, JsafeJCE jceProv) throws CMSException {
        if (recipientInfos == null) {
            return null;
        }
        int size = recipientInfos.length;
        com.rsa.jsafe.cms.RecipientInfo[] jceRecipientInfos = new com.rsa.jsafe.cms.RecipientInfo[size];
        for (int i = 0; i < recipientInfos.length; ++i) {
            jceRecipientInfos[i] = recipientInfos[i] == null ? null : recipientInfos[i].getJceRecipientInfo(jceProv);
        }
        return jceRecipientInfos;
    }

    static com.rsa.jsafe.cms.SignerInfo[] convertToJceSignerInfos(SignerInfo[] signerInfos, JsafeJCE jceProv) throws CMSException {
        if (signerInfos == null) {
            return null;
        }
        int size = signerInfos.length;
        com.rsa.jsafe.cms.SignerInfo[] jceSignerInfos = new com.rsa.jsafe.cms.SignerInfo[size];
        for (int i = 0; i < signerInfos.length; ++i) {
            jceSignerInfos[i] = signerInfos[i] == null ? null : signerInfos[i].getJceSignerInfo(jceProv);
        }
        return jceSignerInfos;
    }

    static com.rsa.jsafe.cms.Accuracy convertToJceAccuracy(Accuracy accuracy) {
        if (accuracy == null) {
            return null;
        }
        return new com.rsa.jsafe.cms.Accuracy(accuracy.getSeconds(), accuracy.getMillis(), accuracy.getMicros());
    }

    static Attribute[] convertToJceAttributes(X501Attributes attrs) throws CMSException {
        if (attrs == null) {
            return null;
        }
        int noOfAttrs = attrs.getAttributeCount();
        Attribute[] jceAttributes = new Attribute[noOfAttrs];
        for (int i = 0; i < noOfAttrs; ++i) {
            jceAttributes[i] = CMSUtils.convertToJceAttribute(attrs.getAttributeByIndex(i));
        }
        return jceAttributes;
    }

    private static Attribute convertToJceAttribute(X501Attribute authAttr) throws CMSException {
        int size = authAttr.getDERLen(0);
        byte[] encoding = new byte[size];
        try {
            size = authAttr.getDEREncoding(encoding, 0, 0);
        }
        catch (AttributeException e) {
            throw new CMSException(e);
        }
        byte[] finalEncoding = encoding;
        if (size != encoding.length) {
            finalEncoding = new byte[size];
            System.arraycopy(encoding, 0, finalEncoding, 0, size);
        }
        return new Attribute(finalEncoding);
    }

    static CertStore convertToJceCertStore(DatabaseService database, JsafeJCE jceProv) throws CMSException {
        if (database == null) {
            return null;
        }
        ArrayList<Certificate> storeEntries = new ArrayList<Certificate>();
        try {
            Certificate cert = database.firstCertificate();
            while (cert != null) {
                storeEntries.add(cert);
                cert = database.nextCertificate();
            }
        }
        catch (NoServiceException e) {
            throw new CMSException(e);
        }
        catch (DatabaseException e) {
            throw new CMSException(e);
        }
        Certificate[] certs = storeEntries.toArray(new Certificate[storeEntries.size()]);
        List<Object> certCrlEntries = CMSUtils.createJcpStoreEntryList(certs, jceProv);
        try {
            CRL crl = database.firstCRL();
            while (crl != null) {
                if (crl instanceof X509CRL) {
                    certCrlEntries.add(CMSUtils.convertToJceCRL((X509CRL)crl, jceProv));
                }
                crl = database.nextCRL();
            }
        }
        catch (NoServiceException e) {
            throw new CMSException(e);
        }
        catch (DatabaseException e) {
            throw new CMSException(e);
        }
        return CMSUtils.createJcpCertStore(certCrlEntries, jceProv);
    }

    static CertStore convertToJceCertStore(Certificate[] certs, JsafeJCE jceProv) throws CMSException {
        if (certs == null) {
            return null;
        }
        List<Object> storeEntries = CMSUtils.createJcpStoreEntryList(certs, jceProv);
        return CMSUtils.createJcpCertStore(storeEntries, jceProv);
    }

    private static List<Object> createJcpStoreEntryList(Certificate[] certs, JsafeJCE jceProv) throws CMSException {
        ArrayList<Object> storeEntries = new ArrayList<Object>();
        for (int i = 0; i < certs.length; ++i) {
            if (!(certs[i] instanceof X509Certificate)) continue;
            storeEntries.add(CMSUtils.convertToJceCertificate((X509Certificate)certs[i], jceProv));
        }
        return storeEntries;
    }

    private static CertStore createJcpCertStore(List<Object> storeEntries, JsafeJCE jceProv) throws CMSException {
        try {
            CollectionCertStoreParameters certStoreParams = new CollectionCertStoreParameters(storeEntries);
            return CertStore.getInstance("Collection", (CertStoreParameters)certStoreParams, (Provider)jceProv);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CMSException(e);
        }
    }

    static java.security.cert.X509Certificate convertToJceCertificate(X509Certificate certificate, JsafeJCE jceProv) throws CMSException {
        java.security.cert.X509Certificate jceCert;
        if (certificate == null) {
            return null;
        }
        int certLen = certificate.getDERLen(0);
        byte[] certData = new byte[certLen];
        try {
            certificate.getDEREncoding(certData, 0, 0);
            ByteArrayInputStream bis = new ByteArrayInputStream(certData);
            CertificateFactory cf = CertificateFactory.getInstance("X509", (Provider)jceProv);
            jceCert = (java.security.cert.X509Certificate)cf.generateCertificate(bis);
        }
        catch (CertificateException e) {
            throw new CMSException(e);
        }
        catch (java.security.cert.CertificateException e) {
            throw new CMSException(e);
        }
        return jceCert;
    }

    private static java.security.cert.X509CRL convertToJceCRL(X509CRL crl, JsafeJCE jceProv) throws CMSException {
        java.security.cert.X509CRL jceCrl;
        if (crl == null) {
            return null;
        }
        int crlLen = crl.getDERLen(0);
        byte[] crlData = new byte[crlLen];
        try {
            crl.getDEREncoding(crlData, 0, 0);
            ByteArrayInputStream bis = new ByteArrayInputStream(crlData);
            CertificateFactory cf = CertificateFactory.getInstance("X509", (Provider)jceProv);
            jceCrl = (java.security.cert.X509CRL)cf.generateCRL(bis);
        }
        catch (CertificateException e) {
            throw new CMSException(e);
        }
        catch (java.security.cert.CertificateException e) {
            throw new CMSException(e);
        }
        catch (CRLException e) {
            throw new CMSException(e);
        }
        return jceCrl;
    }

    static SecretKey convertToJceSecretKey(JSAFE_SecretKey secretKey, JsafeJCE jceProv) throws CMSException {
        if (secretKey == null) {
            return null;
        }
        String alg = secretKey.getAlgorithm();
        byte[] keyData = secretKey.getSecretKeyData();
        if (alg.indexOf("AES") >= 0) {
            alg = "AES";
        } else if (alg.equals("3DES_EDE")) {
            alg = "DESede";
            if (CertJUtils.byteArraysEqual(keyData, 0, 8, keyData, 8, 8) && keyData.length == 24 && CertJUtils.byteArraysEqual(keyData, 8, 8, keyData, 16, 8)) {
                byte[] oneKeyData = new byte[8];
                System.arraycopy(keyData, 0, oneKeyData, 0, oneKeyData.length);
                secretKey.overwrite(keyData);
                keyData = oneKeyData;
            } else if (keyData.length == 24 && CertJUtils.byteArraysEqual(keyData, 0, 8, keyData, 16, 8)) {
                byte[] twoKeyData = new byte[16];
                System.arraycopy(keyData, 0, twoKeyData, 0, twoKeyData.length);
                secretKey.overwrite(keyData);
                keyData = twoKeyData;
            }
        }
        SecretKeySpec keySpec = new SecretKeySpec(keyData, alg);
        secretKey.overwrite(keyData);
        return keySpec;
    }

    static PrivateKey convertToJcePrivateKey(JSAFE_PrivateKey privateKey, JsafeJCE jceProv) throws CMSException {
        if (privateKey == null) {
            return null;
        }
        String algName = privateKey.getAlgorithm();
        try {
            byte[] keyData = privateKey.getKeyData(algName + "PrivateKeyBER")[0];
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyData);
            KeyFactory keyFactory = KeyFactory.getInstance(algName, (Provider)jceProv);
            return keyFactory.generatePrivate(keySpec);
        }
        catch (JSAFE_UnimplementedException e) {
            throw new CMSException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new CMSException(e);
        }
    }

    static PublicKey convertToJcePublicKey(JSAFE_PublicKey publicKey, JsafeJCE jceProv) throws CMSException {
        if (publicKey == null) {
            return null;
        }
        String algName = publicKey.getAlgorithm();
        try {
            byte[] keyData = publicKey.getKeyData(algName + "PublicKeyBER")[0];
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyData);
            KeyFactory keyFactory = KeyFactory.getInstance(algName, (Provider)jceProv);
            return keyFactory.generatePublic(keySpec);
        }
        catch (JSAFE_UnimplementedException e) {
            throw new CMSException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new CMSException(e);
        }
    }

    static com.rsa.jsafe.cert.GeneralName convertToJceGeneralName(GeneralName authorityName) throws CMSException {
        if (authorityName == null) {
            return null;
        }
        try {
            int derLen = authorityName.getDERLen(0);
            byte[] encoded = new byte[derLen];
            authorityName.getDEREncoding(encoded, 0, 0);
            return new com.rsa.jsafe.cert.GeneralName(encoded);
        }
        catch (NameException e) {
            throw new CMSException(e);
        }
        catch (InvalidEncodingException e) {
            throw new CMSException(e);
        }
    }

    static com.rsa.jsafe.cms.KeyContainer convertToJceKeyContainer(KeyContainer decryptionKey, JsafeJCE jceProv) throws CMSException {
        if (decryptionKey == null) {
            return null;
        }
        JSAFE_SecretKey secretKey = decryptionKey.getSecretKey();
        char[] password = decryptionKey.getPassword();
        if (password != null) {
            return new com.rsa.jsafe.cms.KeyContainer(password);
        }
        if (secretKey != null) {
            if (secretKey.getAlgorithm().indexOf("PBKDF2") >= 0) {
                try {
                    return new com.rsa.jsafe.cms.KeyContainer(secretKey.getPassword());
                }
                catch (JSAFE_InvalidKeyException e) {
                    throw new CMSException(e);
                }
            }
            SecretKey jceSecretKey = CMSUtils.convertToJceSecretKey(secretKey, jceProv);
            return new com.rsa.jsafe.cms.KeyContainer(jceSecretKey);
        }
        PrivateKey privateKey = CMSUtils.convertToJcePrivateKey(decryptionKey.getPrivateKey(), jceProv);
        PublicKey publicKey = CMSUtils.convertToJcePublicKey(decryptionKey.getPublicKey(), jceProv);
        return new com.rsa.jsafe.cms.KeyContainer(privateKey, publicKey);
    }

    static X509ExtensionSpec convertToJceExtensionSpecs(X509V3Extensions extensions) throws CMSException {
        if (extensions == null) {
            return null;
        }
        X509ExtensionSpec spec = new X509ExtensionSpec();
        int len = extensions.getExtensionCount();
        for (int i = 0; i < len; ++i) {
            X509V3Extension extension;
            try {
                extension = extensions.getExtensionByIndex(i);
            }
            catch (CertificateException e) {
                throw new CMSException(e);
            }
            byte[] encoded = new byte[extension.getDERLen(0)];
            extension.getDEREncoding(encoded, 0, 0);
            spec.addOtherExtension(encoded);
        }
        return spec;
    }

    static String convertToJceEncryptionAlg(String encryptAlgorithm) {
        if (encryptAlgorithm == null) {
            return null;
        }
        String[] algs = encryptAlgorithm.split("/");
        if ("3DES_EDE".equals(algs[0])) {
            algs[0] = "DESede";
        } else if (algs[0].startsWith("AES")) {
            algs[0] = "AES";
        }
        StringBuilder builder = new StringBuilder(algs[0]);
        for (int i = 1; i < algs.length; ++i) {
            builder.append('/');
            builder.append(algs[i]);
        }
        return builder.toString();
    }

    static String convertToJceKDFAlg(String kdfAlgorithm) throws CMSException {
        String jceKDFAlg;
        if (kdfAlgorithm == null) {
            return null;
        }
        String[] algs = kdfAlgorithm.toUpperCase().split("/");
        if (algs.length != 3 || !algs[0].equals("PBKDF2") || !algs[2].startsWith("PKCS5V2PBE")) {
            throw new CMSException("Illegal KDF algorithm string: " + kdfAlgorithm);
        }
        if ("SHA1".equals(algs[1])) {
            jceKDFAlg = "PBKDF2withSHA1";
        } else if ("SHA256".equals(algs[1])) {
            jceKDFAlg = "PBKDF2withSHA256";
        } else if ("SHA512".equals(algs[1])) {
            jceKDFAlg = "PBKDF2withSHA512";
        } else if ("SHA384".equals(algs[1])) {
            jceKDFAlg = "PBKDF2withSHA384";
        } else if ("SHA224".equals(algs[1])) {
            jceKDFAlg = "PBKDF2withSHA224";
        } else {
            throw new CMSException("Illegal hash algorithm string: " + algs[1]);
        }
        return jceKDFAlg;
    }

    static RecipientInfo[] convertToJsafeRecipientInfo(com.rsa.jsafe.cms.RecipientInfo[] recipientInfos) {
        if (recipientInfos == null) {
            return null;
        }
        RecipientInfo[] jsafeRecInfos = new RecipientInfo[recipientInfos.length];
        for (int i = 0; i < recipientInfos.length; ++i) {
            jsafeRecInfos[i] = CMSUtils.createJsafeRecipientInfo(recipientInfos[i]);
        }
        return jsafeRecInfos;
    }

    private static RecipientInfo createJsafeRecipientInfo(com.rsa.jsafe.cms.RecipientInfo recipientInfo) {
        RecipientInfo jsafeRecipientInfo;
        if (recipientInfo instanceof com.rsa.jsafe.cms.KeyAgreeRecipientInfo) {
            jsafeRecipientInfo = new KeyAgreeRecipientInfo((com.rsa.jsafe.cms.KeyAgreeRecipientInfo)recipientInfo);
        } else if (recipientInfo instanceof com.rsa.jsafe.cms.KekRecipientInfo) {
            jsafeRecipientInfo = new KekRecipientInfo((com.rsa.jsafe.cms.KekRecipientInfo)recipientInfo);
        } else if (recipientInfo instanceof com.rsa.jsafe.cms.KeyTransRecipientInfo) {
            jsafeRecipientInfo = new KeyTransRecipientInfo((com.rsa.jsafe.cms.KeyTransRecipientInfo)recipientInfo);
        } else if (recipientInfo instanceof com.rsa.jsafe.cms.PasswordRecipientInfo) {
            jsafeRecipientInfo = new PasswordRecipientInfo((com.rsa.jsafe.cms.PasswordRecipientInfo)recipientInfo);
        } else {
            throw new IllegalArgumentException("RecipientInfo type not supported.");
        }
        return jsafeRecipientInfo;
    }

    static SignerInfo[] convertToJsafeSignerInfo(com.rsa.jsafe.cms.SignerInfo[] signerInfos) {
        if (signerInfos == null) {
            return null;
        }
        SignerInfo[] jsafeSignerInfos = new SignerInfo[signerInfos.length];
        for (int i = 0; i < signerInfos.length; ++i) {
            jsafeSignerInfos[i] = new SignerInfo(signerInfos[i]);
        }
        return jsafeSignerInfos;
    }

    static X509Certificate[] convertToJsafeCertificates(java.security.cert.X509Certificate[] certs) {
        if (certs == null) {
            return null;
        }
        X509Certificate[] jsafeCerts = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            try {
                byte[] certDer = certs[i].getEncoded();
                jsafeCerts[i] = new X509Certificate(certDer, 0, 0);
                continue;
            }
            catch (CertificateEncodingException e) {
                throw new InvalidEncodingException((Throwable)e);
            }
            catch (CertificateException e) {
                throw new InvalidEncodingException((Throwable)e);
            }
        }
        return jsafeCerts;
    }

    static X509CRL[] convertToJsafeCRLs(java.security.cert.X509CRL[] crls) {
        if (crls == null) {
            return null;
        }
        X509CRL[] jsafeCRLs = new X509CRL[crls.length];
        for (int i = 0; i < crls.length; ++i) {
            try {
                byte[] crlDer = crls[i].getEncoded();
                jsafeCRLs[i] = new X509CRL(crlDer, 0, 0);
                continue;
            }
            catch (CRLException e) {
                throw new InvalidEncodingException((Throwable)e);
            }
            catch (CertificateException e) {
                throw new InvalidEncodingException((Throwable)e);
            }
        }
        return jsafeCRLs;
    }

    static X501Attributes convertToJsafeAttributes(Attribute[] attributes) throws CMSException {
        if (attributes == null) {
            return null;
        }
        X501Attributes jsafeAttributes = new X501Attributes();
        for (int i = 0; i < attributes.length; ++i) {
            try {
                jsafeAttributes.addAttribute(X501Attribute.getInstance(attributes[i].getEncoded(), 0, 0));
                continue;
            }
            catch (AttributeException e) {
                throw new CMSException(e);
            }
        }
        return jsafeAttributes;
    }

    static JSAFE_PublicKey convertToJsafePublicKey(PublicKey publicKey) throws CMSException {
        if (publicKey == null) {
            return null;
        }
        byte[] encPublicKey = publicKey.getEncoded();
        try {
            return JSAFE_PublicKey.getInstance((byte[])encPublicKey, (int)0, (String)"Java");
        }
        catch (JSAFE_UnimplementedException e) {
            throw new CMSException(e);
        }
        catch (JSAFE_InvalidParameterException e) {
            throw new CMSException(e);
        }
    }

    static X500Name convertToJsafeIssuerName(X500Principal issuer) throws CMSException {
        if (issuer == null) {
            return null;
        }
        byte[] encoded = issuer.getEncoded();
        try {
            return new X500Name(encoded, 0, 0);
        }
        catch (NameException e) {
            throw new CMSException(e);
        }
    }

    static GeneralName convertToJsafeGeneralName(com.rsa.jsafe.cert.GeneralName authorityName) throws CMSException {
        if (authorityName == null) {
            return null;
        }
        byte[] encoded = authorityName.getEncoded();
        try {
            return new GeneralName(encoded, 0, 0);
        }
        catch (NameException e) {
            throw new CMSException(e);
        }
    }
}

