/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cms;

import com.rsa.certj.cms.CMS;
import com.rsa.certj.cms.CMSException;
import com.rsa.certj.cms.ContentType;
import com.rsa.jsafe.crypto.FIPS140Context;
import java.io.IOException;
import java.io.InputStream;

public abstract class Decoder {
    final com.rsa.jsafe.cms.Decoder jceDecoder;
    final FIPS140Context jceCtx;
    private Decoder contentDecoder;

    Decoder(com.rsa.jsafe.cms.Decoder jceDecoder, FIPS140Context jceCtx) {
        this.jceDecoder = jceDecoder;
        this.jceCtx = jceCtx;
    }

    public final ContentType getType() {
        return ContentType.getContentType(this.jceDecoder.getType().getIdentifier());
    }

    public final ContentType getContentType() {
        return ContentType.getContentType(this.jceDecoder.getContentType().getIdentifier());
    }

    public final InputStream getContentInputStream() throws IOException {
        try {
            return this.jceDecoder.getContentInputStream();
        }
        catch (IOException e) {
            throw new CMSException(e);
        }
    }

    public final void streamContent() throws IOException {
        this.jceDecoder.streamContent();
    }

    public final Decoder getContentDecoder() throws IOException {
        if (this.contentDecoder == null) {
            ContentType contentType = ContentType.getContentType(this.jceDecoder.getContentType().getIdentifier());
            this.contentDecoder = CMS.createNewDecoder(contentType, this.jceDecoder.getContentDecoder(), this.jceCtx);
        }
        return this.contentDecoder;
    }

    public final byte[] getContentBytes() throws IOException {
        return this.jceDecoder.getContentBytes();
    }

    final com.rsa.jsafe.cms.Decoder getJceDecoder() {
        return this.jceDecoder;
    }

    final FIPS140Context getFIPS140Context() {
        return this.jceCtx;
    }
}

