/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cms;

import com.rsa.certj.cms.CMSException;
import com.rsa.certj.cms.CMSUtils;
import com.rsa.certj.cms.RecipientInfo;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.cms.InfoObjectFactory;
import com.rsa.jsafe.provider.JsafeJCE;
import java.util.Date;
import javax.crypto.SecretKey;

public final class KekRecipientInfo
extends RecipientInfo {
    private com.rsa.jsafe.cms.KekRecipientInfo jceInfoObj;
    private byte[] kekId;
    private JSAFE_SecretKey secretKey;
    private Date date;
    private String otherKeyAttrOID;
    private byte[] encodedOtherKeyAttr;

    KekRecipientInfo(com.rsa.jsafe.cms.KekRecipientInfo jceInfoObj) {
        this.jceInfoObj = jceInfoObj;
    }

    KekRecipientInfo(byte[] kekId, JSAFE_SecretKey secretKey, Date date, String otherKeyAttrOID, byte[] encodedOtherKeyAttr) {
        this.kekId = kekId == null ? null : (byte[])kekId.clone();
        try {
            this.secretKey = (JSAFE_SecretKey)(secretKey == null ? null : secretKey.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException(e);
        }
        this.date = date == null ? null : new Date(date.getTime());
        this.otherKeyAttrOID = otherKeyAttrOID;
        this.encodedOtherKeyAttr = encodedOtherKeyAttr == null ? null : (byte[])encodedOtherKeyAttr.clone();
    }

    public byte[] getKekId() {
        return this.jceInfoObj.getKekId();
    }

    public Date getKekIdDate() {
        return this.jceInfoObj.getKekIdDate();
    }

    public String getKekIdOtherAttrOId() {
        return this.jceInfoObj.getKekIdOtherAttrOId();
    }

    public byte[] getKekIdOtherAttr() {
        return this.jceInfoObj.getKekIdOtherAttr();
    }

    com.rsa.jsafe.cms.RecipientInfo getJceRecipientInfo(JsafeJCE jceProv) throws CMSException {
        if (this.jceInfoObj == null) {
            SecretKey jceSecretKey = CMSUtils.convertToJceSecretKey(this.secretKey, jceProv);
            try {
                this.jceInfoObj = this.otherKeyAttrOID == null ? InfoObjectFactory.newKekRecipientInfo((byte[])this.kekId, (SecretKey)jceSecretKey, (Date)this.date) : InfoObjectFactory.newKekRecipientInfo((byte[])this.kekId, (SecretKey)jceSecretKey, (Date)this.date, (String)this.otherKeyAttrOID, (byte[])this.encodedOtherKeyAttr);
            }
            catch (com.rsa.jsafe.cms.CMSException e) {
                throw new CMSException(e);
            }
        }
        return this.jceInfoObj;
    }
}

