/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cms;

import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cms.CMSException;
import com.rsa.certj.cms.CMSUtils;
import com.rsa.certj.cms.RecipientInfo;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.cms.InfoObjectFactory;
import com.rsa.jsafe.provider.JsafeJCE;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;

public final class KeyAgreeRecipientInfo
extends RecipientInfo {
    private final com.rsa.certj.cert.X509Certificate origCertificate;
    private final JSAFE_PublicKey origPublicKey;
    private final JSAFE_PrivateKey origPrivateKey;
    private final com.rsa.certj.cert.X509Certificate recipientCertificate;
    private com.rsa.jsafe.cms.KeyAgreeRecipientInfo jceInfoObj;

    KeyAgreeRecipientInfo(com.rsa.jsafe.cms.KeyAgreeRecipientInfo jceInfoObj) {
        this.jceInfoObj = jceInfoObj;
        this.origCertificate = null;
        this.origPublicKey = null;
        this.origPrivateKey = null;
        this.recipientCertificate = null;
    }

    KeyAgreeRecipientInfo(com.rsa.certj.cert.X509Certificate origCertificate, JSAFE_PublicKey origPublicKey, JSAFE_PrivateKey origPrivateKey, com.rsa.certj.cert.X509Certificate recipientCertificate) {
        try {
            this.origCertificate = (com.rsa.certj.cert.X509Certificate)(origCertificate == null ? null : origCertificate.clone());
            this.origPublicKey = (JSAFE_PublicKey)(origPublicKey == null ? null : origPublicKey.clone());
            this.origPrivateKey = (JSAFE_PrivateKey)(origPrivateKey == null ? null : origPrivateKey.clone());
            this.recipientCertificate = (com.rsa.certj.cert.X509Certificate)(recipientCertificate == null ? null : recipientCertificate.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public X500Name getOrigIssuer() throws CMSException {
        if (this.jceInfoObj != null) {
            return CMSUtils.convertToJsafeIssuerName(this.jceInfoObj.getOrigIssuer());
        }
        return this.origCertificate == null ? null : this.origCertificate.getIssuerName();
    }

    public byte[] getOrigSerialNumber() {
        if (this.jceInfoObj != null) {
            return this.jceInfoObj.getOrigSerialNumber().toByteArray();
        }
        return this.origCertificate == null ? null : this.origCertificate.getSerialNumber();
    }

    public byte[] getOrigSubjectKeyIdentifier() {
        if (this.jceInfoObj != null) {
            return this.jceInfoObj.getOrigSubjectKeyIdentifier();
        }
        return this.origCertificate == null ? null : this.origCertificate.getSubjectUniqueID();
    }

    public JSAFE_PublicKey getOrigPublicKey() throws CMSException {
        if (this.jceInfoObj != null) {
            return CMSUtils.convertToJsafePublicKey(this.jceInfoObj.getOrigPublicKey());
        }
        if (this.origPublicKey != null) {
            try {
                return (JSAFE_PublicKey)this.origPublicKey.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (this.origCertificate != null) {
            try {
                return this.origCertificate.getSubjectPublicKey("Java");
            }
            catch (CertificateException e) {
                return null;
            }
        }
        return null;
    }

    public X500Name getRecipientIssuer() throws CMSException {
        if (this.jceInfoObj != null) {
            return CMSUtils.convertToJsafeIssuerName(this.jceInfoObj.getRecipientIssuer());
        }
        return this.recipientCertificate == null ? null : this.recipientCertificate.getIssuerName();
    }

    public byte[] getRecipientSerialNumber() {
        if (this.jceInfoObj != null) {
            return this.jceInfoObj.getRecipientSerialNumber().toByteArray();
        }
        return this.recipientCertificate == null ? null : this.recipientCertificate.getSerialNumber();
    }

    public byte[] getRecipientSubjectKeyIdentifier() {
        if (this.jceInfoObj != null) {
            return this.jceInfoObj.getRecipientSubjectKeyIdentifier();
        }
        return this.recipientCertificate == null ? null : this.recipientCertificate.getSubjectUniqueID();
    }

    com.rsa.jsafe.cms.RecipientInfo getJceRecipientInfo(JsafeJCE jceProv) throws CMSException {
        if (this.jceInfoObj == null) {
            X509Certificate jceOrigCert = CMSUtils.convertToJceCertificate(this.origCertificate, jceProv);
            X509Certificate jceRecipientCert = CMSUtils.convertToJceCertificate(this.recipientCertificate, jceProv);
            PublicKey jcePublicKey = CMSUtils.convertToJcePublicKey(this.origPublicKey, jceProv);
            PrivateKey jcePrivateKey = CMSUtils.convertToJcePrivateKey(this.origPrivateKey, jceProv);
            try {
                this.jceInfoObj = jcePublicKey == null ? InfoObjectFactory.newKeyAgreeRecipientInfo((X509Certificate)jceOrigCert, (PrivateKey)jcePrivateKey, (X509Certificate)jceRecipientCert) : InfoObjectFactory.newKeyAgreeRecipientInfo((PublicKey)jcePublicKey, (PrivateKey)jcePrivateKey, (X509Certificate)jceRecipientCert);
            }
            catch (com.rsa.jsafe.cms.CMSException e) {
                throw new CMSException(e);
            }
        }
        return this.jceInfoObj;
    }
}

