/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cms;

import com.rsa.certj.cms.CMSException;
import com.rsa.certj.cms.CMSUtils;
import com.rsa.certj.cms.RecipientInfo;
import com.rsa.jsafe.cms.InfoObjectFactory;
import com.rsa.jsafe.provider.JsafeJCE;

public final class PasswordRecipientInfo
extends RecipientInfo {
    private final char[] password;
    private final String kdfAlgorithm;
    private final int iterationCount;
    private com.rsa.jsafe.cms.PasswordRecipientInfo jceInfoObj;

    PasswordRecipientInfo(com.rsa.jsafe.cms.PasswordRecipientInfo jceInfoObj) {
        this.jceInfoObj = jceInfoObj;
        this.password = null;
        this.kdfAlgorithm = null;
        this.iterationCount = 0;
    }

    PasswordRecipientInfo(char[] password, String kdfAlgorithm, int iterationCount) {
        this.jceInfoObj = null;
        this.password = password == null ? null : (char[])password.clone();
        this.kdfAlgorithm = kdfAlgorithm;
        this.iterationCount = iterationCount;
    }

    com.rsa.jsafe.cms.RecipientInfo getJceRecipientInfo(JsafeJCE jceProv) throws CMSException {
        if (this.jceInfoObj == null) {
            try {
                if (this.kdfAlgorithm == null) {
                    this.jceInfoObj = InfoObjectFactory.newPasswordRecipientInfo((char[])this.password);
                } else {
                    String jceKDFAlg = CMSUtils.convertToJceKDFAlg(this.kdfAlgorithm);
                    this.jceInfoObj = InfoObjectFactory.newPasswordRecipientInfo((char[])this.password, (String)jceKDFAlg, (int)this.iterationCount);
                }
            }
            catch (com.rsa.jsafe.cms.CMSException e) {
                throw new CMSException(e);
            }
        }
        return this.jceInfoObj;
    }
}

