/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cms;

import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.cms.Accuracy;
import com.rsa.certj.cms.CMSException;
import com.rsa.certj.cms.CMSUtils;
import java.math.BigInteger;
import java.util.Date;

public final class TimeStampInfo {
    private com.rsa.jsafe.cms.TimeStampInfo jceTimeStampInfo;

    TimeStampInfo(com.rsa.jsafe.cms.TimeStampInfo jceTimeStampInfo) {
        this.jceTimeStampInfo = jceTimeStampInfo;
    }

    public String getPolicyId() {
        return this.jceTimeStampInfo.getPolicyId();
    }

    public byte[] getSerialNumber() {
        return this.jceTimeStampInfo.getSerialNumber().toByteArray();
    }

    public Date getGenerationTime() {
        return this.jceTimeStampInfo.getGenerationTime();
    }

    public Accuracy getAccuracy() {
        com.rsa.jsafe.cms.Accuracy jceAcc = this.jceTimeStampInfo.getAccuracy();
        if (jceAcc == null) {
            return null;
        }
        return new Accuracy(jceAcc.getSeconds(), jceAcc.getMillis(), jceAcc.getMicros());
    }

    public boolean getOrdering() {
        return this.jceTimeStampInfo.getOrdering();
    }

    public GeneralName getAuthorityName() throws CMSException {
        return CMSUtils.convertToJsafeGeneralName(this.jceTimeStampInfo.getAuthorityName());
    }

    public String getDigestAlgorithm() {
        return this.jceTimeStampInfo.getDigestAlgorithm();
    }

    public byte[] getDigestValue() {
        return this.jceTimeStampInfo.getDigestValue();
    }

    public byte[] getNonce() {
        BigInteger nonce = this.jceTimeStampInfo.getNonce();
        return nonce == null ? null : nonce.toByteArray();
    }

    public byte[] getExtensionValue(String oid) throws CMSException {
        return this.jceTimeStampInfo.getExtensionValue(oid);
    }
}

