/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.core.config;

import com.rsa.certj.core.CertJRuntimeException;
import com.rsa.certj.core.util.EvalVersion;
import com.rsa.jsafe.CryptoJVersion;
import com.rsa.jsafe.crypto.CryptoJ;
import java.security.Security;

public final class CertJConfiguration {
    private static final String FIPS140_PROPERTY = "cryptoj.prod.common.fips140.configuration";
    private static boolean errorFound;
    private static String errorMsg;
    private static final boolean FIPS140_COMPLIANT;
    private static final boolean CERTJ_EVAL;
    private static final String PROPERTY_AUTO_GENERATE_SUBJECT_NAME_SERIAL_NUM = "com.rsa.cryptoj.autogenserialnum";
    private static final boolean AUTO_GEN_SERIAL_NUM;

    private static boolean determineFips140Compliant() {
        return CryptoJ.isFIPS140Compliant();
    }

    private CertJConfiguration() {
    }

    public static boolean isEval() {
        if (!errorFound) {
            return CERTJ_EVAL;
        }
        throw new CertJRuntimeException(errorMsg);
    }

    public static boolean isFIPSCompliant() {
        if (!errorFound) {
            return FIPS140_COMPLIANT;
        }
        throw new CertJRuntimeException(errorMsg);
    }

    public static boolean isAutoGenSerialNumEnabled() {
        return AUTO_GEN_SERIAL_NUM;
    }

    public static boolean wasCertjPKCS11LoadSuccessful() {
        if (!errorFound) {
            return false;
        }
        throw new CertJRuntimeException(errorMsg);
    }

    public static boolean wasJsafeLoadSuccessful() {
        if (!errorFound) {
            return false;
        }
        throw new CertJRuntimeException(errorMsg);
    }

    public static boolean wasJsafePKCS11LoadSuccessful() {
        if (!errorFound) {
            return false;
        }
        throw new CertJRuntimeException(errorMsg);
    }

    static String readProperty(String property) {
        String value = Security.getProperty(property);
        if (value != null) {
            return value;
        }
        value = System.getProperty(property);
        return value;
    }

    static {
        String jsafeJCEVersion;
        errorMsg = "";
        FIPS140_COMPLIANT = CertJConfiguration.determineFips140Compliant();
        CERTJ_EVAL = EvalVersion.isEvalVersion();
        String fips140Required = Security.getProperty(FIPS140_PROPERTY);
        if (fips140Required != null) {
            if (fips140Required.equalsIgnoreCase("true") && !FIPS140_COMPLIANT) {
                errorMsg = errorMsg + "FIPS 140 mode is required but FIPS 140 compliant jar file not present\n";
                errorFound = true;
            } else if (fips140Required.equalsIgnoreCase("false") && FIPS140_COMPLIANT) {
                errorMsg = errorMsg + "FIPS 140 mode is not expected, but the jar file is FIPS 140 compliant\n";
                errorFound = true;
            }
        }
        AUTO_GEN_SERIAL_NUM = Boolean.parseBoolean(CertJConfiguration.readProperty(PROPERTY_AUTO_GENERATE_SUBJECT_NAME_SERIAL_NUM));
        String jsafeVersion = CryptoJVersion.getVersionString();
        if (!jsafeVersion.equals(jsafeJCEVersion = com.rsa.jsafe.crypto.CryptoJVersion.getVersionString())) {
            errorMsg = errorMsg + "Detected differing JSAFE API and JCE API versions.\n JSAFE: " + jsafeVersion + "\n" + " JCE: " + jsafeJCEVersion + "\n";
            errorFound = true;
        }
        boolean jsafeEval = CryptoJVersion.isEval();
        boolean jsafeJCEEval = com.rsa.jsafe.crypto.CryptoJVersion.isEval();
        if (!(CERTJ_EVAL && jsafeEval && jsafeJCEEval || !CERTJ_EVAL && !jsafeEval && !jsafeJCEEval)) {
            errorMsg = errorMsg + "Mixture of evaluation and production jars files detected.\n JSAFE API jar eval: " + jsafeEval + "\n" + " JCE API jar eval: " + jsafeJCEEval + "\n" + " certj jar eval: " + CERTJ_EVAL + "\n";
            errorFound = true;
        }
    }
}

