/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.CertRequest;
import com.rsa.certj.crmf.CertTemplate;
import com.rsa.certj.crmf.ProofOfPossession;
import com.rsa.certj.crmf.RegInfo;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertReqMessages
implements Cloneable,
Serializable {
    private Vector<Object>[] messages = this.createVectorArray(3);
    private int special;
    private ASN1Template asn1Template;
    private CertPathCtx theCertPathCtx;
    private CertJ theCertJ;
    private JSAFE_PublicKey pubKey;
    private JSAFE_PrivateKey privKey;

    public CertReqMessages() {
    }

    public CertReqMessages(CertRequest certRequest, ProofOfPossession pop, RegInfo regInfo) throws CRMFException {
        this.addCertReqMsg(certRequest, pop, regInfo);
    }

    public void addCertReqMsg(CertRequest certRequest, ProofOfPossession pop, RegInfo regInfo) throws CRMFException {
        if (certRequest == null) {
            throw new CRMFException("Cert Request is NULL.");
        }
        this.messages[0].addElement(certRequest);
        if (pop != null) {
            this.messages[1].addElement(pop);
        } else {
            this.messages[1].addElement(null);
        }
        if (regInfo != null) {
            this.messages[2].addElement(regInfo);
        } else {
            this.messages[2].addElement(null);
        }
    }

    public void decodeCertReqMessages(byte[] certBER, int offset, int special) throws CRMFException {
        if (certBER == null) {
            throw new CRMFException("CertReqMessages Encoding is null.");
        }
        this.special = special;
        try {
            OfContainer seqOf = new OfContainer(special, 12288, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] certDef = new ASN1Container[]{seqOf};
            ASN1.berDecode((byte[])certBER, (int)offset, (ASN1Container[])certDef);
            int count = seqOf.getContainerCount();
            for (int index = 0; index < count; ++index) {
                ProofOfPossession pop;
                ASN1Container encodedInfoContainer = seqOf.containerAt(index);
                SequenceContainer aSeq = new SequenceContainer(0);
                EndContainer anEnd = new EndContainer();
                EncodedContainer reqContainer = new EncodedContainer(12288);
                ChoiceContainer popContainer = new ChoiceContainer(65536);
                EncodedContainer nullContainer = new EncodedContainer(8455424);
                EncodedContainer signContainer = new EncodedContainer(8466433);
                EncodedContainer encContainer = new EncodedContainer(10616578);
                EncodedContainer agreeContainer = new EncodedContainer(10616579);
                EncodedContainer regInfoContainer = new EncodedContainer(77824);
                ASN1Container[] asn1Def = new ASN1Container[]{aSeq, reqContainer, popContainer, nullContainer, signContainer, encContainer, agreeContainer, anEnd, regInfoContainer, anEnd};
                ASN1.berDecode((byte[])encodedInfoContainer.data, (int)encodedInfoContainer.dataOffset, (ASN1Container[])asn1Def);
                CertRequest request = new CertRequest();
                request.setEnvironment(this.theCertJ, this.theCertPathCtx, this.pubKey, this.privKey);
                request.decodeCertRequest(reqContainer.data, reqContainer.dataOffset, 0);
                this.messages[0].addElement(request);
                if (nullContainer.dataPresent) {
                    pop = new ProofOfPossession(0);
                    pop.decodeProofOfPossession(nullContainer.data, nullContainer.dataOffset, 65536);
                    this.messages[1].addElement(pop);
                } else if (signContainer.dataPresent) {
                    pop = new ProofOfPossession(1);
                    CertTemplate template = request.getCertTemplate();
                    if (template == null) {
                        throw new CRMFException("Invalid CertRequest: CertTemplate is missing.");
                    }
                    if (template.getSubjectName() != null && template.getSubjectPublicKey() != null) {
                        pop.setCertRequest(request);
                    }
                    pop.decodeProofOfPossession(signContainer.data, signContainer.dataOffset, 65536);
                    this.messages[1].addElement(pop);
                } else if (encContainer.dataPresent) {
                    pop = new ProofOfPossession(2);
                    pop.setEnvironment(this.theCertJ, this.pubKey, this.privKey);
                    pop.decodeProofOfPossession(encContainer.data, encContainer.dataOffset, 65536);
                    this.messages[1].addElement(pop);
                } else if (agreeContainer.dataPresent) {
                    pop = new ProofOfPossession();
                    pop.setEnvironment(this.theCertJ, this.pubKey, this.privKey);
                    pop.decodeProofOfPossession(agreeContainer.data, agreeContainer.dataOffset, 65536);
                    this.messages[1].addElement(pop);
                } else {
                    this.messages[1].addElement(null);
                }
                if (regInfoContainer.dataPresent) {
                    this.messages[2].addElement(new RegInfo(regInfoContainer.data, regInfoContainer.dataOffset, 0));
                    continue;
                }
                this.messages[2].addElement(null);
            }
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Could not BER decode the cert request messages. ", (Exception)((Object)asnException));
        }
    }

    private Vector<Object>[] createVectorArray(int size) {
        Vector[] vectorArray = new Vector[size];
        for (int index = 0; index < size; ++index) {
            vectorArray[index] = new Vector();
        }
        return vectorArray;
    }

    public void setEnvironment(CertJ certJ, CertPathCtx pathCtx, JSAFE_PublicKey pubKey, JSAFE_PrivateKey privKey) {
        this.theCertJ = certJ;
        this.theCertPathCtx = pathCtx;
        if (pubKey != null) {
            this.pubKey = pubKey;
        }
        if (privKey != null) {
            this.privKey = privKey;
        }
    }

    public CertRequest getCertRequest(int index) throws CRMFException {
        if (index >= 0 && index < this.messages[0].size()) {
            if (this.messages[0].elementAt(index) == null) {
                return null;
            }
            return (CertRequest)this.messages[0].elementAt(index);
        }
        throw new CRMFException("Invalid index for CertRequest.");
    }

    public ProofOfPossession getPOP(int index) throws CRMFException {
        if (index >= 0 && index < this.messages[1].size()) {
            if (this.messages[1].elementAt(index) == null) {
                return null;
            }
            return (ProofOfPossession)this.messages[1].elementAt(index);
        }
        throw new CRMFException("Invalid index for ProofOfPossession.");
    }

    public RegInfo getRegInfo(int index) throws CRMFException {
        if (index >= 0 && index < this.messages[2].size()) {
            if (this.messages[2].elementAt(index) == null) {
                return null;
            }
            return (RegInfo)this.messages[2].elementAt(index);
        }
        throw new CRMFException("Invalid index for RegInfo.");
    }

    public int getCertReqMsgCount() {
        return this.messages[0].size();
    }

    public static int getNextBEROffset(byte[] certBER, int offset) throws CRMFException {
        if (certBER == null || certBER.length <= offset) {
            throw new CRMFException("Illegal CertReqMessages encoding values.");
        }
        if (certBER[offset] == 0 && certBER[offset + 1] == 0) {
            return offset + 2;
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])certBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])certBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Unable to determine length of the BER", (Exception)((Object)asnException));
        }
    }

    public int getDERLen(int special) throws CRMFException {
        return this.encodeInit(special);
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws CRMFException {
        int returnValue;
        if (encoding == null) {
            throw new CRMFException("Specified CertReqMessages array is null.");
        }
        try {
            if (this.asn1Template == null || this.special != special) {
                this.getDERLen(special);
            }
            returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new CRMFException("Unable to encode CertReqMessages.", (Exception)((Object)asnException));
        }
        return returnValue;
    }

    private int encodeInit(int special) throws CRMFException {
        this.special = special;
        Vector<OfContainer> asn1Def = new Vector<OfContainer>();
        try {
            OfContainer seqOf = new OfContainer(special, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
            asn1Def.addElement(seqOf);
            int infoCount = this.messages[0].size();
            for (int index = 0; index < infoCount; ++index) {
                int reqLen = ((CertRequest)this.messages[0].elementAt(index)).getDERLen(0);
                byte[] reqEncoding = new byte[reqLen];
                reqLen = ((CertRequest)this.messages[0].elementAt(index)).getDEREncoding(reqEncoding, 0, 0);
                boolean popPresent = false;
                int popLen = 0;
                byte[] popEncoding = null;
                int type = -1;
                if (this.messages[1].elementAt(index) != null) {
                    popPresent = true;
                    ProofOfPossession pop = (ProofOfPossession)this.messages[1].elementAt(index);
                    popLen = pop.getDERLen(65536);
                    popEncoding = new byte[popLen];
                    popLen = pop.getDEREncoding(popEncoding, 0, 65536);
                    type = pop.getPOPType();
                }
                boolean regPresent = false;
                int regLen = 0;
                byte[] regEncoding = null;
                if (this.messages[2].elementAt(index) != null) {
                    regPresent = true;
                    RegInfo reg = (RegInfo)this.messages[2].elementAt(index);
                    regLen = reg.getDERLen(0);
                    regEncoding = new byte[regLen];
                    regLen = reg.getDEREncoding(regEncoding, 0, 0);
                }
                SequenceContainer aSeq = new SequenceContainer(0, true, 0);
                EndContainer anEnd = new EndContainer();
                EncodedContainer reqContainer = new EncodedContainer(12288, true, 0, reqEncoding, 0, reqLen);
                EncodedContainer popContainer = type == 0 ? new EncodedContainer(0x800500, popPresent, 0, popEncoding, 0, popLen) : (type == 1 ? new EncodedContainer(8400897, popPresent, 0, popEncoding, 0, popLen) : (type == 2 ? new EncodedContainer(10498050, popPresent, 0, popEncoding, 0, popLen) : (type == 3 ? new EncodedContainer(0xA03003, popPresent, 0, popEncoding, 0, popLen) : new EncodedContainer(65536, false, 0, null, 0, 0))));
                EncodedContainer regInfoContainer = new EncodedContainer(77824, regPresent, 0, regEncoding, 0, regLen);
                ASN1Container[] asnDef = new ASN1Container[]{aSeq, reqContainer, popContainer, regInfoContainer, anEnd};
                this.asn1Template = new ASN1Template(asnDef);
                int encodingLen = this.asn1Template.derEncodeInit();
                byte[] encoding = new byte[encodingLen];
                encodingLen = this.asn1Template.derEncode(encoding, 0);
                EncodedContainer info = new EncodedContainer(0, true, 0, encoding, 0, encodingLen);
                seqOf.addContainer((ASN1Container)info);
            }
            Object[] asn1DefArray = new ASN1Container[asn1Def.size()];
            asn1Def.copyInto(asn1DefArray);
            this.asn1Template = new ASN1Template((ASN1Container[])asn1DefArray);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException((Exception)((Object)asnException));
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CertReqMessages)) {
            return false;
        }
        CertReqMessages other = (CertReqMessages)obj;
        int thisVectorLen = this.messages.length;
        int otherVectorLen = other.messages.length;
        if (thisVectorLen != otherVectorLen) {
            return false;
        }
        for (int index = 0; index < thisVectorLen; ++index) {
            int otherVectorSize;
            int thisVectorSize = this.messages[index].size();
            if (thisVectorSize != (otherVectorSize = other.messages[index].size())) {
                return false;
            }
            for (int vectorIndex = 0; vectorIndex < thisVectorSize; ++vectorIndex) {
                if (this.messages[index].elementAt(vectorIndex) == null) {
                    if (other.messages[index].elementAt(vectorIndex) == null) continue;
                    return false;
                }
                if (other.messages[index].elementAt(vectorIndex) == null) {
                    return false;
                }
                if (this.messages[index].elementAt(vectorIndex).equals(other.messages[index].elementAt(vectorIndex))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 31 + Arrays.hashCode(this.messages);
    }

    public Object clone() throws CloneNotSupportedException {
        CertReqMessages otherSelf = new CertReqMessages();
        otherSelf.setEnvironment(this.theCertJ, this.theCertPathCtx, this.pubKey, this.privKey);
        for (int index = 0; index < this.messages.length; ++index) {
            for (int msgIndex = 0; msgIndex < this.messages[index].size(); ++msgIndex) {
                otherSelf.messages[index].addElement(this.messages[index].elementAt(msgIndex));
            }
        }
        otherSelf.special = this.special;
        try {
            if (this.asn1Template != null) {
                otherSelf.encodeInit(this.special);
            }
        }
        catch (CRMFException crmf) {
            throw new CloneNotSupportedException(crmf.getMessage());
        }
        return otherSelf;
    }
}

