/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.CertTemplate;
import com.rsa.certj.crmf.Controls;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.Serializable;

public class CertRequest
implements Cloneable,
Serializable {
    private int reqId;
    private CertTemplate template;
    private Controls controls;
    protected int special;
    private ASN1Template asn1Template;
    private CertPathCtx theCertPathCtx;
    private CertJ theCertJ;
    private JSAFE_PublicKey pubKey;
    private JSAFE_PrivateKey privKey;

    public CertRequest() {
    }

    public void decodeCertRequest(byte[] certBER, int offset, int special) throws CRMFException {
        if (certBER == null) {
            throw new CRMFException("CertRequest Encoding is null.");
        }
        this.special = special;
        SequenceContainer aSeq = new SequenceContainer(special);
        EndContainer anEnd = new EndContainer();
        IntegerContainer id = new IntegerContainer(0);
        EncodedContainer templ = new EncodedContainer(12288);
        EncodedContainer control = new EncodedContainer(77824);
        ASN1Container[] asn1Def = new ASN1Container[]{aSeq, id, templ, control, anEnd};
        try {
            ASN1.berDecode((byte[])certBER, (int)offset, (ASN1Container[])asn1Def);
            this.reqId = id.getValueAsInt();
            this.template = new CertTemplate(templ.data, templ.dataOffset, 0);
            if (control.dataPresent) {
                this.controls = new Controls();
                this.controls.setEnvironment(this.theCertJ, this.theCertPathCtx, this.pubKey, this.privKey);
                this.controls.decodeControls(control.data, control.dataOffset, 0);
            }
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Could not BER decode the cert request info.", (Exception)((Object)asnException));
        }
    }

    public CertRequest(int id, CertTemplate template, Controls controls) throws CRMFException {
        this.reqId = id;
        if (template == null) {
            throw new CRMFException("Cert Template is null.");
        }
        try {
            this.template = (CertTemplate)template.clone();
            if (controls != null) {
                this.controls = (Controls)controls.clone();
            }
        }
        catch (CloneNotSupportedException cloneException) {
            throw new CRMFException("Unable to create CertRequest object", cloneException);
        }
    }

    public static int getNextBEROffset(byte[] certBER, int offset) throws CRMFException {
        if (certBER == null) {
            throw new CRMFException("Encoding is null.");
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])certBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])certBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Could not read the BER encoding.", (Exception)((Object)asnException));
        }
    }

    public void setRequestID(int id) {
        this.reqId = id;
    }

    public int getRequestID() {
        return this.reqId;
    }

    public void setCertTemplate(CertTemplate template) throws CRMFException {
        if (template == null) {
            throw new CRMFException("Cert Template is NULL.");
        }
        try {
            this.template = (CertTemplate)template.clone();
        }
        catch (CloneNotSupportedException cloneException) {
            throw new CRMFException("Unable to set CertTemplate", cloneException);
        }
    }

    public CertTemplate getCertTemplate() throws CRMFException {
        if (this.template == null) {
            return null;
        }
        try {
            return (CertTemplate)this.template.clone();
        }
        catch (CloneNotSupportedException cloneException) {
            throw new CRMFException("Unable to get CertTemplate", cloneException);
        }
    }

    public void setControls(Controls controls) throws CRMFException {
        try {
            if (controls != null) {
                this.controls = (Controls)controls.clone();
            }
        }
        catch (CloneNotSupportedException cloneException) {
            throw new CRMFException("Unable to set Controls", cloneException);
        }
    }

    public Controls getControls() throws CRMFException {
        if (this.controls == null) {
            return null;
        }
        try {
            return (Controls)this.controls.clone();
        }
        catch (CloneNotSupportedException cloneException) {
            throw new CRMFException("Unable to get Controls", cloneException);
        }
    }

    public int getDERLen(int special) throws CRMFException {
        return this.encodeInit(special);
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws CRMFException {
        int returnValue;
        if (encoding == null) {
            throw new CRMFException("Specified array is null.");
        }
        try {
            if (this.asn1Template == null || this.special != special) {
                this.getDERLen(special);
            }
            returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new CRMFException("Unable to encode CertRequest.", (Exception)((Object)asnException));
        }
        return returnValue;
    }

    private int encodeInit(int special) throws CRMFException {
        try {
            this.special = special;
            SequenceContainer aSeq = new SequenceContainer(special, true, 0);
            EndContainer anEnd = new EndContainer();
            IntegerContainer id = new IntegerContainer(0, true, 0, this.reqId);
            if (this.template == null) {
                throw new CRMFException("Cert Template is not set.");
            }
            int templLen = this.template.getDERLen(0);
            byte[] templEncoding = new byte[templLen];
            templLen = this.template.getDEREncoding(templEncoding, 0, 0);
            EncodedContainer templ = new EncodedContainer(0, true, 0, templEncoding, 0, templLen);
            boolean dataPresent = false;
            int controlLen = 0;
            byte[] controlEncoding = null;
            if (this.controls != null) {
                dataPresent = true;
                controlLen = this.controls.getDERLen(65536);
                controlEncoding = new byte[controlLen];
                controlLen = this.controls.getDEREncoding(controlEncoding, 0, 0);
            }
            EncodedContainer control = new EncodedContainer(65536, dataPresent, 0, controlEncoding, 0, controlLen);
            ASN1Container[] asn1Def = new ASN1Container[]{aSeq, id, templ, control, anEnd};
            this.asn1Template = new ASN1Template(asn1Def);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException((Exception)((Object)asnException));
        }
    }

    public void setEnvironment(CertJ certJ, CertPathCtx pathCtx, JSAFE_PublicKey pubKey, JSAFE_PrivateKey privKey) {
        this.theCertJ = certJ;
        this.theCertPathCtx = pathCtx;
        if (pubKey != null) {
            this.pubKey = pubKey;
        }
        if (privKey != null) {
            this.privKey = privKey;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CertRequest)) {
            return false;
        }
        CertRequest other = (CertRequest)obj;
        if (this.special != other.special) {
            return false;
        }
        if (this.reqId != other.reqId) {
            return false;
        }
        if (this.template != null ? !this.template.equals(other.template) : other.template != null) {
            return false;
        }
        return !(this.controls != null ? !this.controls.equals(other.controls) : other.controls != null);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + CertJInternalHelper.hashCodeValue(this.controls);
        result = prime * result + this.reqId;
        result = prime * result + this.special;
        result = prime * result + CertJInternalHelper.hashCodeValue(this.template);
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        CertRequest otherSelf = new CertRequest();
        otherSelf.setEnvironment(this.theCertJ, this.theCertPathCtx, this.pubKey, this.privKey);
        otherSelf.special = this.special;
        otherSelf.reqId = this.reqId;
        if (this.template != null) {
            otherSelf.template = (CertTemplate)this.template.clone();
        }
        if (this.controls != null) {
            otherSelf.controls = (Controls)this.controls.clone();
        }
        try {
            if (this.asn1Template != null) {
                otherSelf.encodeInit(this.special);
            }
        }
        catch (CRMFException crmf) {
            throw new CloneNotSupportedException(crmf.getMessage());
        }
        return otherSelf;
    }
}

