/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.GenTimeContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.UTCTimeContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.core.config.CertJConfiguration;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.internal.CertificateUtil;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;

public class CertTemplate
implements Cloneable,
Serializable {
    private int theVersion = -1;
    private X500Name subjectName;
    private X500Name issuerName;
    private byte[] serialNumber;
    protected byte[] subjectPublicKeyInfo;
    protected byte[] signatureAlgorithmBER;
    private byte[] issuerUniqueID;
    private byte[] subjectUniqueID;
    private boolean timeType;
    private Date notBefore;
    private Date notAfter;
    private X509V3Extensions theExtensions;
    protected int special;
    private ASN1Template asn1Template;
    private ASN1Template asn1TemplateValidity;
    public static final int RSA_WITH_SHA1_PKCS = 0;
    public static final int RSA_WITH_SHA1_ISO_OIW = 1;
    public static final int DSA_WITH_SHA1_X930 = 2;
    public static final int DSA_WITH_SHA1_X957 = 3;
    protected int signatureAlgorithmFormat = -1;

    public CertTemplate() {
    }

    public CertTemplate(byte[] certBER, int offset, int special) throws CRMFException {
        if (certBER == null) {
            throw new CRMFException("CertTemplate Encoding is null.");
        }
        this.setCertTemplateBER(certBER, offset, special);
    }

    public static int getNextBEROffset(byte[] certBER, int offset) throws CRMFException {
        if (certBER == null) {
            throw new CRMFException("CertTemplate Encoding is null.");
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])certBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])certBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Could not read the BER encoding.", (Exception)((Object)asnException));
        }
    }

    public void setCertTemplateBER(byte[] certTemplateBER, int offset, int special) throws CRMFException {
        if (certTemplateBER == null) {
            throw new CRMFException("CertTemplate Encoding is null.");
        }
        SequenceContainer aSeq = new SequenceContainer(special);
        EndContainer anEnd = new EndContainer();
        IntegerContainer vers = new IntegerContainer(0x810000);
        IntegerContainer serial = new IntegerContainer(0x810001);
        EncodedContainer algID = new EncodedContainer(8466434);
        EncodedContainer issuer = new EncodedContainer(10563587);
        EncodedContainer validity = new EncodedContainer(8466436);
        EncodedContainer subject = new EncodedContainer(10563589);
        EncodedContainer key = new EncodedContainer(8466438);
        EncodedContainer issuerID = new EncodedContainer(8454919);
        EncodedContainer subjectID = new EncodedContainer(8454920);
        EncodedContainer exten = new EncodedContainer(8466441);
        ASN1Container[] asn1Def = new ASN1Container[]{aSeq, vers, serial, algID, issuer, validity, subject, key, issuerID, subjectID, exten, anEnd};
        try {
            ASN1.berDecode((byte[])certTemplateBER, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Could not BER decode the cert template info. ", (Exception)((Object)asnException));
        }
        if (vers.dataPresent) {
            this.setVersionNumber(vers.data, vers.dataOffset, vers.dataLen);
        }
        if (serial.dataPresent) {
            this.setSerialNumber(serial.data, serial.dataOffset, serial.dataLen);
        }
        if (algID.dataPresent) {
            this.setSignatureAlgorithm(algID.data, algID.dataOffset, algID.dataLen);
        }
        if (issuer.dataPresent) {
            try {
                X500Name localIssuerName = new X500Name(issuer.data, issuer.dataOffset, 10551299);
                this.setIssuerName(localIssuerName);
            }
            catch (NameException nameException) {
                throw new CRMFException("Invalid issuer name: ", nameException);
            }
        }
        if (validity.dataPresent) {
            this.setValidityBER(validity.data, validity.dataOffset);
        }
        if (subject.dataPresent) {
            try {
                X500Name localSubjectName = new X500Name(subject.data, subject.dataOffset, 10551301);
                this.setSubjectName(localSubjectName);
            }
            catch (NameException nameException) {
                throw new CRMFException("Invalid subject name: ", nameException);
            }
        }
        if (key.dataPresent) {
            this.setSubjectPublicKey(key.data, key.dataOffset);
        }
        if (issuerID.dataPresent) {
            this.issuerUniqueID = new byte[issuerID.dataLen];
            System.arraycopy(issuerID.data, issuerID.dataOffset, this.issuerUniqueID, 0, issuerID.dataLen);
        }
        if (subjectID.dataPresent) {
            this.subjectUniqueID = new byte[subjectID.dataLen];
            System.arraycopy(subjectID.data, subjectID.dataOffset, this.subjectUniqueID, 0, subjectID.dataLen);
        }
        try {
            if (exten.dataPresent) {
                X509V3Extensions extensions = new X509V3Extensions(exten.data, exten.dataOffset, 0x800009, 1);
                this.setExtensions(extensions);
            }
        }
        catch (CertificateException certException) {
            throw new CRMFException("Cannot decode extensions. ", certException);
        }
    }

    protected void setVersionNumber(byte[] version, int offset, int len) throws CRMFException {
        if (version == null || len > 4) {
            throw new CRMFException("Invalid Certificate version.");
        }
        int versionInt = 0;
        for (int index = offset; index < offset + len; ++index) {
            versionInt = versionInt << 8 | version[offset] & 0xFF;
        }
        this.theVersion = versionInt;
    }

    public void setVersion(int version) {
        this.theVersion = version;
    }

    public int getVersion() {
        return this.theVersion;
    }

    public void setSignatureAlgorithm(String algName) throws CRMFException {
        if (algName == null) {
            throw new CRMFException("Specified SignatureAlgorithm value is null.");
        }
        try {
            String algFormat = this.getSignatureFormat(algName);
            this.signatureAlgorithmBER = algFormat == null ? AlgorithmID.derEncodeAlgID((String)algName, (int)1, null, (int)0, (int)0) : AlgorithmID.derEncodeAlgID((String)algFormat, (int)1, null, (int)0, (int)0);
        }
        catch (ASN_Exception e) {
            throw new CRMFException("Cannot set, unknown algorithm.", (Exception)((Object)e));
        }
    }

    public void setSignatureAlgorithm(byte[] algID, int offset, int len) throws CRMFException {
        if (algID == null || len == 0) {
            throw new CRMFException("Signature Algorithm is null.");
        }
        try {
            this.signatureAlgorithmBER = new byte[len];
            algID[offset] = 48;
            System.arraycopy(algID, offset, this.signatureAlgorithmBER, 0, len);
            String trans = AlgorithmID.berDecodeAlgID((byte[])algID, (int)offset, (int)1, null);
            if (trans == null) {
                throw new CRMFException("Cannot recognize the signature algorithm.");
            }
        }
        catch (ASN_Exception e) {
            throw new CRMFException((Exception)((Object)e));
        }
    }

    public void setSignatureStandard(int standardFlag) {
        this.signatureAlgorithmFormat = standardFlag;
    }

    public int getSignatureStandard() {
        return this.signatureAlgorithmFormat;
    }

    public String getSignatureFormat(String transformation) {
        if (transformation == null) {
            return null;
        }
        switch (this.signatureAlgorithmFormat) {
            case 0: {
                if (transformation.equals("SHA1/RSA/PKCS1Block01Pad")) {
                    return "RSAWithSHA1PKCS";
                }
                return null;
            }
            case 1: {
                if (transformation.equals("SHA1/RSA/PKCS1Block01Pad")) {
                    return "RSAWithSHA1ISO_OIW";
                }
                return null;
            }
            case 2: {
                if (transformation.equals("SHA1/DSA") || transformation.equals("SHA1/DSA/NoPad")) {
                    return "DSAWithSHA1X930";
                }
                return null;
            }
            case 3: {
                if (transformation.equals("SHA1/DSA") || transformation.equals("SHA1/DSA/NoPad")) {
                    return "DSAWithSHA1X957";
                }
                return null;
            }
        }
        if (transformation.equals("SHA1/DSA")) {
            return "SHA1/DSA/NoPad";
        }
        return null;
    }

    public int getDERLen(int special) throws CRMFException {
        return this.encodeInit(special);
    }

    private int encodeInit(int special) throws CRMFException {
        this.special = special;
        byte[] encoding = null;
        try {
            int dataLen;
            SequenceContainer aSeq = new SequenceContainer(special, true, 0);
            EndContainer anEnd = new EndContainer();
            boolean dataPresent = false;
            if (this.theVersion != -1) {
                dataPresent = true;
            }
            IntegerContainer vers = new IntegerContainer(0x810000, dataPresent, 0, this.theVersion);
            IntegerContainer serial = this.serialNumber == null ? new IntegerContainer(0x810001, false, 0, 0) : ((this.serialNumber[0] & 0x80) >> 7 == 0 ? new IntegerContainer(0x810001, true, 0, this.serialNumber, 0, this.serialNumber.length, true) : new IntegerContainer(0x810001, true, 0, this.serialNumber, 0, this.serialNumber.length, false));
            if (this.signatureAlgorithmBER == null) {
                dataPresent = false;
                dataLen = 0;
            } else {
                dataPresent = true;
                dataLen = this.signatureAlgorithmBER.length;
                this.signatureAlgorithmBER[0] = -94;
            }
            EncodedContainer algID = new EncodedContainer(8466434, dataPresent, 0, this.signatureAlgorithmBER, 0, dataLen);
            if (this.notBefore == null && this.notAfter == null) {
                dataPresent = false;
                dataLen = 0;
            } else {
                dataLen = this.getValidityDERLen(8454148);
                dataPresent = true;
                encoding = new byte[dataLen];
                dataLen = this.getValidityDEREncoding(encoding, 0, 8454148);
            }
            EncodedContainer validity = new EncodedContainer(8466436, dataPresent, 0, encoding, 0, dataLen);
            if (this.subjectPublicKeyInfo != null) {
                dataPresent = true;
                this.subjectPublicKeyInfo[0] = -90;
                dataLen = this.subjectPublicKeyInfo.length;
            } else {
                dataPresent = false;
                dataLen = 0;
            }
            EncodedContainer key = new EncodedContainer(8466438, dataPresent, 0, this.subjectPublicKeyInfo, 0, dataLen);
            try {
                if (this.issuerName != null) {
                    dataLen = this.issuerName.getDERLen(10551299);
                    encoding = new byte[dataLen];
                    dataLen = this.issuerName.getDEREncoding(encoding, 0, 10551299);
                    dataPresent = true;
                } else {
                    dataPresent = false;
                    dataLen = 0;
                }
            }
            catch (NameException nameException) {
                throw new CRMFException(nameException);
            }
            EncodedContainer issuer = new EncodedContainer(10563587, dataPresent, 0, encoding, 0, dataLen);
            try {
                if (this.subjectName != null) {
                    dataLen = this.subjectName.getDERLen(10551301);
                    encoding = new byte[dataLen];
                    dataLen = this.subjectName.getDEREncoding(encoding, 0, 10551301);
                    dataPresent = true;
                } else {
                    dataPresent = false;
                    dataLen = 0;
                }
            }
            catch (NameException nameException) {
                throw new CRMFException(nameException);
            }
            EncodedContainer subject = new EncodedContainer(10563589, dataPresent, 0, encoding, 0, dataLen);
            if (this.issuerUniqueID != null) {
                dataPresent = true;
                dataLen = this.issuerUniqueID.length;
            } else {
                dataPresent = false;
                dataLen = 0;
            }
            EncodedContainer issuerID = new EncodedContainer(8454919, dataPresent, 0, this.issuerUniqueID, 0, dataLen);
            if (this.subjectUniqueID != null) {
                dataPresent = true;
                dataLen = this.subjectUniqueID.length;
            } else {
                dataPresent = false;
                dataLen = 0;
            }
            EncodedContainer subjectID = new EncodedContainer(8454920, dataPresent, 0, this.subjectUniqueID, 0, dataLen);
            if (this.theExtensions != null) {
                dataLen = this.theExtensions.getDERLen(8466441);
                dataPresent = true;
                encoding = new byte[dataLen];
                dataLen = this.theExtensions.getDEREncoding(encoding, 0, 8466441);
            } else {
                dataPresent = false;
                dataLen = 0;
            }
            EncodedContainer exten = new EncodedContainer(8466441, dataPresent, 0, encoding, 0, dataLen);
            ASN1Container[] asn1Def = new ASN1Container[]{aSeq, vers, serial, algID, issuer, validity, subject, key, issuerID, subjectID, exten, anEnd};
            this.asn1Template = new ASN1Template(asn1Def);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException((Exception)((Object)asnException));
        }
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws CRMFException {
        int dataLen;
        if (encoding == null) {
            throw new CRMFException("Passed array is null in the cert template ");
        }
        try {
            if (this.asn1Template == null && (dataLen = this.encodeInit(special)) == 0) {
                throw new CRMFException("Cannot encode cert template, information missing.");
            }
            dataLen = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new CRMFException("Could not encode the cert template: ", (Exception)((Object)asnException));
        }
        return dataLen;
    }

    private int getValidityDERLen(int special) throws CRMFException {
        GenTimeContainer gen2;
        GenTimeContainer gen1;
        SequenceContainer aSeq = new SequenceContainer(special, true, 0);
        EndContainer anEnd = new EndContainer();
        if (this.notBefore == null && this.notAfter == null) {
            throw new CRMFException("Validity dates are not set.");
        }
        boolean dataPresent1 = false;
        boolean dataPresent2 = false;
        if (this.notBefore != null) {
            dataPresent1 = true;
        }
        if (this.notAfter != null) {
            dataPresent2 = true;
        }
        if (this.timeType) {
            gen1 = new GenTimeContainer(0xA10000, dataPresent1, 0, this.notBefore);
            gen2 = new GenTimeContainer(0xA10001, dataPresent2, 0, this.notAfter);
        } else {
            gen1 = new UTCTimeContainer(0xA10000, dataPresent1, 0, this.notBefore);
            gen2 = new UTCTimeContainer(0xA10001, dataPresent2, 0, this.notAfter);
        }
        ASN1Container[] asn1Def = new ASN1Container[]{aSeq, gen1, gen2, anEnd};
        this.asn1TemplateValidity = new ASN1Template(asn1Def);
        try {
            return this.asn1TemplateValidity.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException((Exception)((Object)asnException));
        }
    }

    public Date getStartDate() {
        if (this.notBefore == null) {
            return null;
        }
        return new Date(this.notBefore.getTime());
    }

    public Date getEndDate() {
        if (this.notAfter == null) {
            return null;
        }
        return new Date(this.notAfter.getTime());
    }

    public void setTimeType(boolean flag) {
        this.timeType = flag;
    }

    private int getValidityDEREncoding(byte[] encoding, int offset, int special) throws CRMFException {
        if (this.asn1TemplateValidity == null && this.getValidityDERLen(special) == 0) {
            return 0;
        }
        try {
            int returnValue = this.asn1TemplateValidity.derEncode(encoding, offset);
            this.asn1TemplateValidity = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.asn1TemplateValidity = null;
            throw new CRMFException((Exception)((Object)asnException));
        }
    }

    private void setValidityBER(byte[] validityBER, int offset) throws CRMFException {
        if (validityBER == null) {
            throw new CRMFException("The cert template encoding is null.");
        }
        SequenceContainer aSeq = new SequenceContainer(8454148);
        EndContainer anEnd = new EndContainer();
        ChoiceContainer choice1 = new ChoiceContainer(0xA10000);
        ChoiceContainer choice2 = new ChoiceContainer(0xA10001);
        UTCTimeContainer utc1 = new UTCTimeContainer(0);
        UTCTimeContainer utc2 = new UTCTimeContainer(0);
        GenTimeContainer gen1 = new GenTimeContainer(0);
        GenTimeContainer gen2 = new GenTimeContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{aSeq, choice1, utc1, gen1, anEnd, choice2, utc2, gen2, anEnd, anEnd};
        try {
            ASN1.berDecode((byte[])validityBER, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Cannot extract Validity. ", (Exception)((Object)asnException));
        }
        Date start = gen1.theTime;
        if (!gen1.dataPresent) {
            start = utc1.theTime;
        } else {
            this.timeType = true;
        }
        Date end = gen2.theTime;
        if (!gen2.dataPresent) {
            end = utc2.theTime;
        } else {
            this.timeType = true;
        }
        this.setValidity(start, end);
    }

    public void setValidity(Date start, Date end) throws CRMFException {
        if (start == null && end == null) {
            throw new CRMFException("Cannot set the validity with the NULL dates.");
        }
        if (start != null) {
            this.notBefore = new Date(start.getTime());
        }
        if (end != null) {
            this.notAfter = new Date(end.getTime());
        }
        if (this.notAfter != null && this.notBefore != null && !this.notAfter.after(this.notBefore)) {
            throw new CRMFException("Cannot set the validity with the given dates.");
        }
    }

    public void setSerialNumber(byte[] serialNumber, int offset, int len) throws CRMFException {
        if (serialNumber == null || len == 0) {
            throw new CRMFException("Passed in SerialNumber value is null.");
        }
        this.serialNumber = new byte[len];
        System.arraycopy(serialNumber, offset, this.serialNumber, 0, len);
    }

    public byte[] getSerialNumber() {
        if (this.serialNumber == null) {
            return null;
        }
        return (byte[])this.serialNumber.clone();
    }

    public void setIssuerName(X500Name issuerName) throws CRMFException {
        if (issuerName == null) {
            throw new CRMFException("Passed in IssuerName value is null.");
        }
        try {
            this.issuerName = (X500Name)issuerName.clone();
        }
        catch (CloneNotSupportedException cloneException) {
            throw new CRMFException("Cannot set the cert template with the given issuerName.", cloneException);
        }
    }

    public X500Name getIssuerName() {
        if (this.issuerName == null) {
            return null;
        }
        try {
            return (X500Name)this.issuerName.clone();
        }
        catch (CloneNotSupportedException cloneException) {
            return null;
        }
    }

    public void setSubjectName(X500Name subjectName) throws CRMFException {
        this.setSubjectName(subjectName, CertJConfiguration.isAutoGenSerialNumEnabled());
    }

    public void setSubjectName(X500Name subjectName, boolean autoGenerateSerialNumber) throws CRMFException {
        if (subjectName == null) {
            throw new CRMFException("Passed in SubjectName value is null.");
        }
        try {
            this.subjectName = (X500Name)subjectName.clone();
            if (autoGenerateSerialNumber) {
                CertificateUtil.checkSerialNumber(this.subjectName);
            }
        }
        catch (CloneNotSupportedException cloneException) {
            throw new CRMFException("Cannot set the cert template with the given subjectName.", cloneException);
        }
    }

    public X500Name getSubjectName() {
        if (this.subjectName == null) {
            return null;
        }
        try {
            return (X500Name)this.subjectName.clone();
        }
        catch (CloneNotSupportedException cloneException) {
            return null;
        }
    }

    public void setIssuerUniqueID(byte[] issuerUniqueID, int offset, int len) throws CRMFException {
        if (issuerUniqueID == null || len == 0) {
            throw new CRMFException("Passed in IssuerUniqueID value is null.");
        }
        try {
            BitStringContainer id = new BitStringContainer(0x800007, true, 0, issuerUniqueID, offset, len, len * 8, false);
            ASN1Container[] asn1Def = new ASN1Container[]{id};
            this.issuerUniqueID = ASN1.derEncode((ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Cannot set issuerUniqueID: ", (Exception)((Object)asnException));
        }
    }

    public byte[] getIssuerUniqueID() {
        int offset;
        if (this.issuerUniqueID == null) {
            return null;
        }
        try {
            offset = 2 + ASN1Lengths.determineLengthLen((byte[])this.issuerUniqueID, (int)1);
        }
        catch (ASN_Exception e) {
            return null;
        }
        byte[] returnValue = new byte[this.issuerUniqueID.length - offset];
        System.arraycopy(this.issuerUniqueID, offset, returnValue, 0, returnValue.length);
        return returnValue;
    }

    public void setSubjectUniqueID(byte[] subjectUniqueID, int offset, int len) throws CRMFException {
        if (subjectUniqueID == null || len == 0) {
            throw new CRMFException("Passed in SubjectUniqueID value is null.");
        }
        try {
            BitStringContainer id = new BitStringContainer(0x800008, true, 0, subjectUniqueID, offset, len, len * 8, false);
            ASN1Container[] asn1Def = new ASN1Container[]{id};
            this.subjectUniqueID = ASN1.derEncode((ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Cannot set subjectUniqueID: ", (Exception)((Object)asnException));
        }
    }

    public byte[] getSubjectUniqueID() {
        int offset;
        if (this.subjectUniqueID == null) {
            return null;
        }
        try {
            offset = 2 + ASN1Lengths.determineLengthLen((byte[])this.subjectUniqueID, (int)1);
        }
        catch (ASN_Exception e) {
            return null;
        }
        byte[] returnValue = new byte[this.subjectUniqueID.length - offset];
        System.arraycopy(this.subjectUniqueID, offset, returnValue, 0, returnValue.length);
        return returnValue;
    }

    public String getSignatureAlgorithm() throws CRMFException {
        try {
            if (this.signatureAlgorithmBER == null) {
                throw new CRMFException("Object not set with signature algorithm.");
            }
            this.signatureAlgorithmBER[0] = 48;
            return AlgorithmID.berDecodeAlgID((byte[])this.signatureAlgorithmBER, (int)0, (int)1, null);
        }
        catch (ASN_Exception asnExc) {
            throw new CRMFException("Invalid Signature Algorithm.", (Exception)((Object)asnExc));
        }
    }

    public byte[] getSignatureAlgorithmDER() throws CRMFException {
        if (this.signatureAlgorithmBER == null) {
            throw new CRMFException("Object not set with signature algorithm.");
        }
        this.signatureAlgorithmBER[0] = 48;
        return (byte[])this.signatureAlgorithmBER.clone();
    }

    public void setSubjectPublicKey(JSAFE_PublicKey publicKey) throws CRMFException {
        if (publicKey == null) {
            throw new CRMFException("Public key is null.");
        }
        try {
            String format = publicKey.getAlgorithm().compareTo("DSA") == 0 ? "DSAPublicKeyX957BER" : publicKey.getAlgorithm() + "PublicKeyBER";
            byte[][] keyData = publicKey.getKeyData(format);
            this.subjectPublicKeyInfo = keyData[0];
        }
        catch (JSAFE_Exception jsafeException) {
            throw new CRMFException("Could not read the public key. ", (Exception)((Object)jsafeException));
        }
    }

    public void setSubjectPublicKey(byte[] publicKeyBER, int offset) throws CRMFException {
        if (publicKeyBER == null) {
            throw new CRMFException("Public key encoding is null.");
        }
        JSAFE_PublicKey publicKey = null;
        try {
            publicKeyBER[offset] = 48;
            publicKey = JSAFEFactory.getPublicKey(publicKeyBER, offset, "Java", (CertJ)null);
            this.setSubjectPublicKey(publicKey);
        }
        catch (JSAFE_Exception jsafeException) {
            throw new CRMFException("Could not read the public key. ", (Exception)((Object)jsafeException));
        }
        finally {
            if (publicKey != null) {
                publicKey.clearSensitiveData();
            }
        }
    }

    public JSAFE_PublicKey getSubjectPublicKey() throws CRMFException {
        if (this.subjectPublicKeyInfo == null) {
            return null;
        }
        try {
            this.subjectPublicKeyInfo[0] = 48;
            return JSAFEFactory.getPublicKey(this.subjectPublicKeyInfo, 0, "Java", (CertJ)null);
        }
        catch (JSAFE_Exception jsafeException) {
            throw new CRMFException("Cannot retrieve the public key: ", (Exception)((Object)jsafeException));
        }
    }

    public byte[] getSubjectPublicKeyBER() {
        if (this.subjectPublicKeyInfo == null) {
            return null;
        }
        this.subjectPublicKeyInfo[0] = 48;
        return (byte[])this.subjectPublicKeyInfo.clone();
    }

    public void setExtensions(X509V3Extensions extensions) throws CRMFException {
        try {
            if (extensions == null) {
                throw new CRMFException("Extensions are null.");
            }
            if (extensions.getExtensionsType() != 1) {
                throw new CRMFException("Wrong extensions type: should be Cert extensions.");
            }
            this.theExtensions = (X509V3Extensions)extensions.clone();
        }
        catch (CloneNotSupportedException cloneException) {
            throw new CRMFException("Cannot set the cert with the given extensions.", cloneException);
        }
    }

    public X509V3Extensions getExtensions() {
        if (this.theExtensions == null) {
            return null;
        }
        try {
            return (X509V3Extensions)this.theExtensions.clone();
        }
        catch (CloneNotSupportedException cloneException) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CertTemplate)) {
            return false;
        }
        CertTemplate other = (CertTemplate)obj;
        try {
            int thisLen = this.getDERLen(0);
            int otherLen = other.getDERLen(0);
            if (thisLen != otherLen) {
                return false;
            }
            byte[] thisEncoding = new byte[thisLen];
            byte[] otherEncoding = new byte[otherLen];
            thisLen = this.getDEREncoding(thisEncoding, 0, 0);
            if (thisLen != (otherLen = other.getDEREncoding(otherEncoding, 0, 0))) {
                return false;
            }
            for (int index = 0; index < thisLen; ++index) {
                if (thisEncoding[index] == otherEncoding[index]) continue;
                return false;
            }
        }
        catch (CRMFException certException) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        try {
            int len = this.getDERLen(0);
            byte[] encoding = new byte[len];
            len = this.getDEREncoding(encoding, 0, 0);
            result = 31 * result + Arrays.hashCode(encoding);
        }
        catch (CRMFException certException) {
            return 0;
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        CertTemplate otherSelf = (CertTemplate)super.clone();
        if (this.subjectPublicKeyInfo != null) {
            otherSelf.subjectPublicKeyInfo = (byte[])this.subjectPublicKeyInfo.clone();
        }
        if (this.signatureAlgorithmBER != null) {
            otherSelf.signatureAlgorithmBER = (byte[])this.signatureAlgorithmBER.clone();
        }
        otherSelf.theVersion = this.theVersion;
        otherSelf.signatureAlgorithmFormat = this.signatureAlgorithmFormat;
        if (this.subjectName != null) {
            otherSelf.subjectName = (X500Name)this.subjectName.clone();
        }
        if (this.issuerName != null) {
            otherSelf.issuerName = (X500Name)this.issuerName.clone();
        }
        if (this.serialNumber != null) {
            otherSelf.serialNumber = (byte[])this.serialNumber.clone();
        }
        if (this.issuerUniqueID != null) {
            otherSelf.issuerUniqueID = (byte[])this.issuerUniqueID.clone();
        }
        if (this.subjectUniqueID != null) {
            otherSelf.subjectUniqueID = (byte[])this.subjectUniqueID.clone();
        }
        otherSelf.timeType = this.timeType;
        if (this.notBefore != null) {
            otherSelf.notBefore = new Date(this.notBefore.getTime());
        }
        if (this.notAfter != null) {
            otherSelf.notAfter = new Date(this.notAfter.getTime());
        }
        if (this.theExtensions != null) {
            otherSelf.theExtensions = (X509V3Extensions)this.theExtensions.clone();
        }
        otherSelf.special = this.special;
        try {
            if (this.asn1Template != null) {
                otherSelf.encodeInit(this.special);
            }
        }
        catch (CRMFException crmf) {
            throw new CloneNotSupportedException(crmf.getMessage());
        }
        return otherSelf;
    }
}

