/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.crmf.Authenticator;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.NonStandardControl;
import com.rsa.certj.crmf.OldCertID;
import com.rsa.certj.crmf.PKIArchiveOptions;
import com.rsa.certj.crmf.PKIPublicationInfo;
import com.rsa.certj.crmf.ProtocolEncryptionKey;
import com.rsa.certj.crmf.RegistrationToken;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.Serializable;

public abstract class Control
implements Cloneable,
Serializable {
    public static final int REG_TOKEN = 0;
    public static final int AUTHENTICATOR = 1;
    public static final int PKI_PUBLICATION_INFO = 2;
    public static final int PKI_ARCHIVE_OPTIONS = 3;
    public static final int OLD_CERT_ID = 4;
    public static final int PROTOCOL_ENCR_KEY = 5;
    public static final int NON_STANDARD = 6;
    protected static final byte[][] OID_LIST = new byte[][]{{43, 6, 1, 5, 5, 7, 5, 1, 1}, {43, 6, 1, 5, 5, 7, 5, 1, 2}, {43, 6, 1, 5, 5, 7, 5, 1, 3}, {43, 6, 1, 5, 5, 7, 5, 1, 4}, {43, 6, 1, 5, 5, 7, 5, 1, 5}, {43, 6, 1, 5, 5, 7, 5, 1, 6}};
    protected int controlTypeFlag;
    byte[] theOID;
    protected int special;
    protected ASN1Template asn1Template;
    protected String controlTypeString;
    protected static CertPathCtx theCertPathCtx;
    protected static CertJ theCertJ;
    protected JSAFE_PublicKey pubKey;
    protected JSAFE_PrivateKey privKey;

    public static Control getInstance(byte[] controlBER, int offset, int special, CertJ certJ, CertPathCtx pathCtx, JSAFE_PublicKey pubKey, JSAFE_PrivateKey privKey) throws CRMFException {
        Control returnValue;
        if (controlBER == null || offset < 0) {
            throw new CRMFException("Control encoding is null.");
        }
        ASN1Container[] asn1Def = Control.decodeControl(controlBER, offset, special);
        int controlType = Control.findOID(asn1Def[1].data, asn1Def[1].dataOffset, asn1Def[1].dataLen);
        switch (controlType) {
            case 0: {
                returnValue = new RegistrationToken();
                break;
            }
            case 1: {
                returnValue = new Authenticator();
                break;
            }
            case 2: {
                returnValue = new PKIPublicationInfo();
                break;
            }
            case 3: {
                returnValue = new PKIArchiveOptions();
                returnValue.setEnvironment(certJ, pathCtx, pubKey, privKey);
                break;
            }
            case 4: {
                returnValue = new OldCertID();
                break;
            }
            case 5: {
                returnValue = new ProtocolEncryptionKey();
                break;
            }
            case 6: {
                returnValue = new NonStandardControl();
                returnValue.theOID = new byte[asn1Def[1].dataLen];
                System.arraycopy(asn1Def[1].data, asn1Def[1].dataOffset, returnValue.theOID, 0, asn1Def[1].dataLen);
                break;
            }
            default: {
                return null;
            }
        }
        returnValue.decodeValue(asn1Def[2].data, asn1Def[2].dataOffset);
        for (int index = 0; index < asn1Def.length; ++index) {
            asn1Def[index].clearSensitiveData();
        }
        return returnValue;
    }

    public static Control getInstance(byte[] controlBER, int offset, int special) throws CRMFException {
        return Control.getInstance(controlBER, offset, special, null, null, null, null);
    }

    protected static ASN1Container[] decodeControl(byte[] controlBER, int offset, int special) throws CRMFException {
        if (controlBER == null || offset < 0) {
            throw new CRMFException("Control encoding is null.");
        }
        SequenceContainer seq1 = new SequenceContainer(special);
        EndContainer anEnd = new EndContainer();
        OIDContainer oid = new OIDContainer(0x1000000);
        EncodedContainer value = new EncodedContainer(65280);
        ASN1Container[] asn1Def = new ASN1Container[]{seq1, oid, value, anEnd};
        try {
            ASN1.berDecode((byte[])controlBER, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Cannot read the BER of the control.", (Exception)((Object)asnException));
        }
        return asn1Def;
    }

    private static int findOID(byte[] compareOID, int offset, int len) {
        if (compareOID == null) {
            return 6;
        }
        for (int index = 0; index < 6; ++index) {
            int oidIndex;
            if (len != OID_LIST[index].length) continue;
            for (oidIndex = 0; oidIndex < len && (compareOID[oidIndex + offset] & 0xFF) == (OID_LIST[index][oidIndex] & 0xFF); ++oidIndex) {
            }
            if (oidIndex < len) continue;
            return index;
        }
        return 6;
    }

    public String getControlTypeString() {
        return this.controlTypeString;
    }

    protected abstract void decodeValue(byte[] var1, int var2) throws CRMFException;

    public byte[] getOID() {
        if (this.theOID == null) {
            return null;
        }
        return (byte[])this.theOID.clone();
    }

    public boolean compareOID(byte[] oid) {
        if (oid == null || this.theOID == null) {
            return false;
        }
        if (oid.length != this.theOID.length) {
            return false;
        }
        for (int index = 0; index < oid.length; ++index) {
            if (oid[index] == this.theOID[index]) continue;
            return false;
        }
        return true;
    }

    public int getControlType() {
        return this.controlTypeFlag;
    }

    public int getDERLen(int special) throws CRMFException {
        return this.derEncodeControlLen(special, this.derEncodeValueInit());
    }

    protected abstract int derEncodeValueInit() throws CRMFException;

    public static int getNextBEROffset(byte[] controlBER, int offset) throws CRMFException {
        if (controlBER == null || offset < 0) {
            throw new CRMFException("Control encoding is null.");
        }
        try {
            return offset + ASN1Lengths.determineLength((byte[])controlBER, (int)offset);
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Could not read the BER encoding.", (Exception)((Object)asnException));
        }
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws CRMFException {
        if (encoding == null || offset < 0) {
            throw new CRMFException("Passed control array is null.");
        }
        return this.derEncodeControl(encoding, offset, special);
    }

    public boolean isControlType(int type) {
        return type == this.controlTypeFlag;
    }

    public int derEncodeControlLen(int special, int valueLen) throws CRMFException {
        this.special = special;
        try {
            SequenceContainer seq1 = new SequenceContainer(0, true, 0);
            EndContainer anEnd = new EndContainer();
            OIDContainer oid = new OIDContainer(0x1000000, true, 0, this.theOID, 0, this.theOID.length);
            EncodedContainer value = new EncodedContainer(65280, true, 0, null, 0, valueLen);
            ASN1Container[] asn1Def = new ASN1Container[]{seq1, oid, value, anEnd};
            this.asn1Template = new ASN1Template(asn1Def);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Cannot encode control. ", (Exception)((Object)asnException));
        }
    }

    protected int derEncodeControl(byte[] encoding, int offset, int special) throws CRMFException {
        int totalLen;
        if (encoding == null) {
            throw new CRMFException("Passed control array is null.");
        }
        if ((this.asn1Template == null || this.special != special) && this.getDERLen(special) == 0) {
            throw new CRMFException("Could not encode, missing data");
        }
        try {
            totalLen = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Cannot encode control. ", (Exception)((Object)asnException));
        }
        totalLen += this.derEncodeValue(encoding, offset + totalLen);
        return totalLen;
    }

    protected abstract int derEncodeValue(byte[] var1, int var2) throws CRMFException;

    protected void copyValues(Control otherSelf) throws CloneNotSupportedException {
        otherSelf.special = this.special;
        if (this.asn1Template == null) {
            return;
        }
        try {
            otherSelf.getDERLen(this.special);
        }
        catch (CRMFException crmfExc) {
            throw new CloneNotSupportedException(crmfExc.getMessage());
        }
    }

    public void setEnvironment(CertJ certJ, CertPathCtx pathCtx, JSAFE_PublicKey pubKey, JSAFE_PrivateKey privKey) throws CRMFException {
        theCertJ = certJ;
        theCertPathCtx = pathCtx;
        if (pubKey != null) {
            this.pubKey = pubKey;
        }
        if (privKey != null) {
            this.privKey = privKey;
        }
    }

    public abstract boolean equals(Object var1);

    public abstract Object clone() throws CloneNotSupportedException;
}

