/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.certj.spi.random.RandomException;
import com.rsa.jsafe.JSAFE_AsymmetricCipher;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Arrays;

public class EncryptedValue
implements Cloneable,
Serializable {
    private CertJ theCertJ;
    private JSAFE_PublicKey pubKey;
    private JSAFE_PrivateKey privKey;
    private byte[] intendedAlgId;
    private byte[] symmAlgId;
    private byte[] keyAlgId;
    private byte[] hintValue;
    private byte[] encryptedKeyValue;
    private byte[] symmKeyValue;
    private JSAFE_SecretKey theKey;
    private JSAFE_PrivateKey thePrivateKey;
    private ASN1Template asn1Template;
    private int special;
    private byte[] theDecryptedValue;

    public EncryptedValue(CertJ certJ, JSAFE_PublicKey pubKey, JSAFE_PrivateKey privKey) throws CRMFException {
        if (certJ == null) {
            throw new CRMFException("The specified CertJ value is NULL in EncryptedValue.");
        }
        if (pubKey != null) {
            this.pubKey = pubKey;
        }
        if (privKey != null) {
            this.privKey = privKey;
        }
        this.theCertJ = certJ;
    }

    public void decodeEncryptedValue(byte[] valueBER, int offset, int special) throws CRMFException {
        this.special = special;
        if (valueBER == null) {
            throw new CRMFException("EncryptedValue Encoding is null.");
        }
        try {
            SequenceContainer seq = new SequenceContainer(special);
            EndContainer endContainer = new EndContainer();
            EncodedContainer intendedAlg = new EncodedContainer(8466432);
            EncodedContainer symmAlg = new EncodedContainer(8466433);
            BitStringContainer encSymmKey = new BitStringContainer(8454146);
            EncodedContainer keyAlg = new EncodedContainer(8466435);
            OctetStringContainer valueHint = new OctetStringContainer(8466436);
            BitStringContainer encValue = new BitStringContainer(0);
            ASN1Container[] asn1Def = new ASN1Container[]{seq, intendedAlg, symmAlg, encSymmKey, keyAlg, valueHint, encValue, endContainer};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            if (intendedAlg.dataPresent && intendedAlg.data != null && intendedAlg.dataLen != 0) {
                this.intendedAlgId = new byte[intendedAlg.dataLen];
                this.intendedAlgId[0] = 48;
                System.arraycopy(intendedAlg.data, intendedAlg.dataOffset + 1, this.intendedAlgId, 1, intendedAlg.dataLen - 1);
            }
            if (symmAlg.dataPresent && symmAlg.data != null && symmAlg.dataLen != 0) {
                this.symmAlgId = new byte[symmAlg.dataLen];
                this.symmAlgId[0] = 48;
                System.arraycopy(symmAlg.data, symmAlg.dataOffset + 1, this.symmAlgId, 1, symmAlg.dataLen - 1);
            }
            if (keyAlg.dataPresent && keyAlg.data != null && keyAlg.dataLen != 0) {
                this.keyAlgId = new byte[keyAlg.dataLen];
                this.keyAlgId[0] = 48;
                System.arraycopy(keyAlg.data, keyAlg.dataOffset + 1, this.keyAlgId, 1, keyAlg.dataLen - 1);
            }
            if (encValue.data == null || encValue.dataLen == 0) {
                throw new CRMFException("Encrypted Private Key value is missing.");
            }
            this.encryptedKeyValue = new byte[encValue.dataLen];
            System.arraycopy(encValue.data, encValue.dataOffset, this.encryptedKeyValue, 0, encValue.dataLen);
            if (encSymmKey.data != null && encSymmKey.dataLen != 0) {
                this.symmKeyValue = new byte[encSymmKey.dataLen];
                System.arraycopy(encSymmKey.data, encSymmKey.dataOffset, this.symmKeyValue, 0, encSymmKey.dataLen);
            }
            if (valueHint.data != null && valueHint.dataLen != 0) {
                this.hintValue = new byte[valueHint.dataLen];
                System.arraycopy(valueHint.data, valueHint.dataOffset, this.hintValue, 0, valueHint.dataLen);
            }
            if (this.symmAlgId != null && this.keyAlgId != null && this.encryptedKeyValue != null && this.symmKeyValue != null) {
                this.decryptPrivateKey();
            }
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Cannot decode the BER of the Encrypted Value.");
        }
    }

    public void decryptPrivateKey() throws CRMFException {
        try {
            if (this.privKey == null) {
                throw new CRMFException("Private Key is not set in EncryptedValue");
            }
            if (this.symmAlgId == null || this.symmKeyValue == null || this.encryptedKeyValue == null) {
                throw new CRMFException("Values are not set.");
            }
            String name = AlgorithmID.berDecodeAlgID((byte[])this.symmAlgId, (int)0, (int)7, null);
            if (name == null) {
                throw new CRMFException("Invalid Symmetric Algorithm OID.");
            }
            int index = name.indexOf("/");
            String algName = name.substring(0, index);
            String device = this.theCertJ.getDevice();
            JSAFE_AsymmetricCipher jsafeCipher = JSAFEFactory.getAsymmetricCipher(this.keyAlgId, 0, device, this.theCertJ);
            jsafeCipher.decryptInit(this.privKey, this.theCertJ.getPKCS11Sessions());
            this.theKey = jsafeCipher.unwrapSecretKey(this.symmKeyValue, 0, this.symmKeyValue.length, false, algName);
            jsafeCipher.clearSensitiveData();
            JSAFE_SymmetricCipher cipher = JSAFEFactory.getSymmetricCipher(this.symmAlgId, 0, device, this.theCertJ);
            JSAFE_SecureRandom random = this.theCertJ.getRandomObject();
            cipher.decryptInit(this.theKey, (SecureRandom)random);
            try {
                this.thePrivateKey = cipher.unwrapPrivateKey(this.encryptedKeyValue, 0, this.encryptedKeyValue.length, false);
            }
            catch (JSAFE_Exception jsafeException) {
                try {
                    cipher.decryptReInit();
                    int outLen = cipher.getOutputBufferSize(this.encryptedKeyValue.length);
                    this.theDecryptedValue = new byte[outLen];
                    int offset = cipher.decryptUpdate(this.encryptedKeyValue, 0, this.encryptedKeyValue.length, this.theDecryptedValue, 0);
                    cipher.decryptFinal(this.theDecryptedValue, offset);
                }
                catch (JSAFE_Exception cipherException) {
                    throw new CRMFException("Could not decode encrypted value", (Exception)((Object)cipherException));
                }
                finally {
                    cipher.clearSensitiveData();
                }
            }
        }
        catch (NoServiceException noServiceException) {
            throw new CRMFException("Cannot get random object from CertJ.", noServiceException);
        }
        catch (RandomException randomException) {
            throw new CRMFException("Cannot get random object from CertJ.", randomException);
        }
        catch (JSAFE_Exception jsafeException) {
            throw new CRMFException("Could not decode encrypted key", (Exception)((Object)jsafeException));
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException((Exception)((Object)asnException));
        }
    }

    public void setPrivateKey(JSAFE_PrivateKey privateKey) throws CRMFException {
        if (privateKey == null) {
            throw new CRMFException("The private key is NULL.");
        }
        try {
            this.thePrivateKey = (JSAFE_PrivateKey)privateKey.clone();
        }
        catch (CloneNotSupportedException cloneExc) {
            throw new CRMFException("Invalid Private Key.", cloneExc);
        }
    }

    public JSAFE_PrivateKey getPrivateKey() throws CRMFException {
        if (this.thePrivateKey == null) {
            return null;
        }
        try {
            return (JSAFE_PrivateKey)this.thePrivateKey.clone();
        }
        catch (CloneNotSupportedException cloneExc) {
            throw new CRMFException("Invalid Private Key.", cloneExc);
        }
    }

    public byte[] getDecryptedValue() {
        if (this.theDecryptedValue == null) {
            return null;
        }
        byte[] copy = new byte[this.theDecryptedValue.length];
        System.arraycopy(this.theDecryptedValue, 0, copy, 0, this.theDecryptedValue.length);
        return copy;
    }

    public void setSymmetricKey(JSAFE_SecretKey symmKey) throws CRMFException {
        if (symmKey == null) {
            throw new CRMFException("The secret key is NULL.");
        }
        try {
            this.theKey = (JSAFE_SecretKey)symmKey.clone();
        }
        catch (CloneNotSupportedException cloneExc) {
            throw new CRMFException("Invalid Symmetric Key.", cloneExc);
        }
    }

    public JSAFE_SecretKey getSecretKey() throws CRMFException {
        if (this.theKey == null) {
            return null;
        }
        try {
            return (JSAFE_SecretKey)this.theKey.clone();
        }
        catch (CloneNotSupportedException cloneExc) {
            throw new CRMFException("Invalid Symmetric Key.", cloneExc);
        }
    }

    public void setEncryptedSecretKey(byte[] encSecretKey, int offset, int len) throws CRMFException {
        if (encSecretKey == null || len == 0) {
            throw new CRMFException("The specified EncryptedSecretKey values are null.");
        }
        this.symmKeyValue = new byte[len];
        System.arraycopy(encSecretKey, offset, this.symmKeyValue, 0, len);
    }

    public byte[] getEncryptedSecretKey() {
        if (this.symmKeyValue == null) {
            return null;
        }
        byte[] value = new byte[this.symmKeyValue.length];
        System.arraycopy(this.symmKeyValue, 0, value, 0, this.symmKeyValue.length);
        return value;
    }

    public void setEncryptedPrivateKey(byte[] encPrivateKey, int offset, int len) throws CRMFException {
        if (encPrivateKey == null || len == 0) {
            throw new CRMFException("The specified EncryptedPrivateKey values are null.");
        }
        this.encryptedKeyValue = new byte[len];
        System.arraycopy(encPrivateKey, offset, this.encryptedKeyValue, 0, len);
    }

    public byte[] getEncryptedPrivateKey() {
        if (this.encryptedKeyValue == null) {
            return null;
        }
        byte[] value = new byte[this.encryptedKeyValue.length];
        System.arraycopy(this.encryptedKeyValue, 0, value, 0, this.encryptedKeyValue.length);
        return value;
    }

    public void setValueHint(byte[] hint, int offset, int len) throws CRMFException {
        if (hint == null || len == 0) {
            throw new CRMFException("Value hint is null.");
        }
        this.hintValue = new byte[len];
        System.arraycopy(hint, offset, this.hintValue, 0, len);
    }

    public byte[] getValueHint() {
        if (this.hintValue == null) {
            return null;
        }
        byte[] returnValue = new byte[this.hintValue.length];
        System.arraycopy(this.hintValue, 0, returnValue, 0, this.hintValue.length);
        return returnValue;
    }

    public void setKeyEncryptionAlgorithm(byte[] oid, int offset, int len) throws CRMFException {
        if (oid == null || len == 0) {
            throw new CRMFException("The specified KeyEncryptionAlgorithm OID is null.");
        }
        this.keyAlgId = new byte[len];
        System.arraycopy(oid, offset, this.keyAlgId, 0, len);
    }

    public byte[] getKeyEncryptionAlgorithm() {
        if (this.keyAlgId == null) {
            return null;
        }
        byte[] returnValue = new byte[this.keyAlgId.length];
        System.arraycopy(this.keyAlgId, 0, returnValue, 0, this.keyAlgId.length);
        return returnValue;
    }

    public void setValueEncryptionAlgorithm(byte[] oid, int offset, int len) throws CRMFException {
        if (oid == null || len == 0) {
            throw new CRMFException("The specified ValueEncryptionAlgorithm OID is null.");
        }
        this.symmAlgId = new byte[len];
        System.arraycopy(oid, offset, this.symmAlgId, 0, len);
    }

    public byte[] getValueEncryptionAlgorithm() {
        if (this.symmAlgId == null) {
            return null;
        }
        byte[] returnValue = new byte[this.symmAlgId.length];
        System.arraycopy(this.symmAlgId, 0, returnValue, 0, this.symmAlgId.length);
        return returnValue;
    }

    public void setIntendedAlgorithm(byte[] oid, int offset, int len) throws CRMFException {
        if (oid == null || len == 0) {
            throw new CRMFException("The specified IntendedAlgorithm OID is null.");
        }
        this.intendedAlgId = new byte[len];
        System.arraycopy(oid, offset, this.intendedAlgId, 0, len);
    }

    public byte[] getIntendedAlgorithm() {
        if (this.intendedAlgId == null) {
            return null;
        }
        byte[] returnValue = new byte[this.intendedAlgId.length];
        System.arraycopy(this.intendedAlgId, 0, returnValue, 0, this.intendedAlgId.length);
        return returnValue;
    }

    public byte[] encryptPrivateKey() throws CRMFException {
        if (this.theKey == null || this.thePrivateKey == null || this.symmAlgId == null) {
            return null;
        }
        try {
            JSAFE_SymmetricCipher encryptor = JSAFEFactory.getSymmetricCipher(this.symmAlgId, 0, this.theCertJ.getDevice(), this.theCertJ);
            encryptor.encryptInit(this.theKey);
            byte[] value = encryptor.wrapPrivateKey(this.thePrivateKey, false);
            encryptor.clearSensitiveData();
            return value;
        }
        catch (JSAFE_Exception jsafeException) {
            throw new CRMFException("Cannot encrypt the PrivateKey. ", (Exception)((Object)jsafeException));
        }
    }

    public byte[] encryptSecretKey() throws CRMFException {
        if (this.theKey == null || this.keyAlgId == null || this.pubKey == null) {
            return null;
        }
        try {
            JSAFE_SecureRandom random = this.theCertJ.getRandomObject();
            JSAFE_AsymmetricCipher jsafeCipher = JSAFEFactory.getAsymmetricCipher(this.keyAlgId, 0, this.theCertJ.getDevice(), this.theCertJ);
            jsafeCipher.encryptInit(this.pubKey, (SecureRandom)random, this.theCertJ.getPKCS11Sessions());
            byte[] encryptedKey = jsafeCipher.wrapSecretKey(this.theKey, false);
            jsafeCipher.clearSensitiveData();
            return encryptedKey;
        }
        catch (NoServiceException noServiceException) {
            throw new CRMFException("Cannot get random object from CertJ.", noServiceException);
        }
        catch (JSAFE_Exception jsafeException) {
            throw new CRMFException("Could not encrypt the secret key. ", (Exception)((Object)jsafeException));
        }
        catch (RandomException randomException) {
            throw new CRMFException("Could not encrypt the secret key. ", randomException);
        }
    }

    public static int getNextBEROffset(byte[] valueBER, int offset) throws CRMFException {
        if (valueBER == null) {
            throw new CRMFException("EncryptedValue Encoding is null.");
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])valueBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])valueBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Could not read the BER encoding.", (Exception)((Object)asnException));
        }
    }

    public int getDERLen(int special) throws CRMFException {
        this.special = special;
        return this.encodeInit();
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws CRMFException {
        int returnValue;
        if (encoding == null) {
            throw new CRMFException("Specified array is null in EncryptedValue.");
        }
        this.special = special;
        try {
            if (this.asn1Template == null) {
                this.getDERLen(special);
            }
            returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new CRMFException("Unable to encode EncryptedValue.", (Exception)((Object)asnException));
        }
        return returnValue;
    }

    private int encodeInit() throws CRMFException {
        try {
            if (this.encryptedKeyValue == null) {
                this.encryptedKeyValue = this.encryptPrivateKey();
            }
            if (this.symmKeyValue == null) {
                this.symmKeyValue = this.encryptSecretKey();
            }
            boolean dataPresent = false;
            int dataLen = 0;
            byte[] encoding = null;
            if (this.intendedAlgId != null) {
                dataPresent = true;
                dataLen = this.intendedAlgId.length;
                encoding = new byte[dataLen];
                encoding[0] = -96;
                System.arraycopy(this.intendedAlgId, 1, encoding, 1, dataLen - 1);
            }
            EncodedContainer intendedAlg = new EncodedContainer(8466432, dataPresent, 0, encoding, 0, dataLen);
            dataPresent = false;
            dataLen = 0;
            if (this.hintValue != null) {
                dataPresent = true;
                dataLen = this.hintValue.length;
            }
            OctetStringContainer valueHint = new OctetStringContainer(8466436, dataPresent, 0, this.hintValue, 0, dataLen);
            dataPresent = false;
            dataLen = 0;
            if (this.symmAlgId != null) {
                dataPresent = true;
                dataLen = this.symmAlgId.length;
                encoding = new byte[dataLen];
                encoding[0] = -95;
                System.arraycopy(this.symmAlgId, 1, encoding, 1, dataLen - 1);
            }
            EncodedContainer symmAlg = new EncodedContainer(8466433, dataPresent, 0, encoding, 0, dataLen);
            dataPresent = false;
            dataLen = 0;
            if (this.keyAlgId != null) {
                dataPresent = true;
                dataLen = this.keyAlgId.length;
                encoding = new byte[dataLen];
                encoding[0] = -93;
                System.arraycopy(this.keyAlgId, 1, encoding, 1, dataLen - 1);
            }
            EncodedContainer keyAlg = new EncodedContainer(8466435, dataPresent, 0, encoding, 0, dataLen);
            dataPresent = false;
            dataLen = 0;
            SequenceContainer seq = new SequenceContainer(this.special, true, 0);
            EndContainer endContainer = new EndContainer();
            if (this.symmKeyValue != null) {
                dataPresent = true;
                dataLen = this.symmKeyValue.length;
            }
            BitStringContainer encSymmKey = new BitStringContainer(8454146, dataPresent, 0, this.symmKeyValue, 0, dataLen);
            if (this.encryptedKeyValue == null) {
                throw new CRMFException("The encrypted private key value is missing.");
            }
            BitStringContainer encValue = new BitStringContainer(0, true, 0, this.encryptedKeyValue, 0, this.encryptedKeyValue.length);
            ASN1Container[] asn1Def = new ASN1Container[]{seq, intendedAlg, symmAlg, encSymmKey, keyAlg, valueHint, encValue, endContainer};
            this.asn1Template = new ASN1Template(asn1Def);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException((Exception)((Object)asnException));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            EncryptedValue otherSelf = new EncryptedValue(this.theCertJ, this.pubKey, this.privKey);
            if (this.intendedAlgId != null) {
                otherSelf.intendedAlgId = new byte[this.intendedAlgId.length];
                System.arraycopy(this.intendedAlgId, 0, otherSelf.intendedAlgId, 0, this.intendedAlgId.length);
            }
            if (this.symmAlgId != null) {
                otherSelf.symmAlgId = new byte[this.symmAlgId.length];
                System.arraycopy(this.symmAlgId, 0, otherSelf.symmAlgId, 0, this.symmAlgId.length);
            }
            if (this.keyAlgId != null) {
                otherSelf.keyAlgId = new byte[this.keyAlgId.length];
                System.arraycopy(this.keyAlgId, 0, otherSelf.keyAlgId, 0, this.keyAlgId.length);
            }
            if (this.hintValue != null) {
                otherSelf.hintValue = new byte[this.hintValue.length];
                System.arraycopy(this.hintValue, 0, otherSelf.hintValue, 0, this.hintValue.length);
            }
            if (this.encryptedKeyValue != null) {
                otherSelf.encryptedKeyValue = new byte[this.encryptedKeyValue.length];
                System.arraycopy(this.encryptedKeyValue, 0, otherSelf.encryptedKeyValue, 0, this.encryptedKeyValue.length);
            }
            if (this.symmKeyValue != null) {
                otherSelf.symmKeyValue = new byte[this.symmKeyValue.length];
                System.arraycopy(this.symmKeyValue, 0, otherSelf.symmKeyValue, 0, this.symmKeyValue.length);
            }
            if (this.theKey != null) {
                otherSelf.theKey = (JSAFE_SecretKey)this.theKey.clone();
            }
            if (this.thePrivateKey != null) {
                otherSelf.thePrivateKey = (JSAFE_PrivateKey)this.thePrivateKey.clone();
            }
            if (this.asn1Template != null) {
                otherSelf.encodeInit();
            }
            otherSelf.special = this.special;
            return otherSelf;
        }
        catch (CRMFException crmfException) {
            throw new CloneNotSupportedException(crmfException.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof EncryptedValue)) {
            return false;
        }
        EncryptedValue other = (EncryptedValue)obj;
        if (!CertJUtils.byteArraysEqual(this.intendedAlgId, other.intendedAlgId)) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.symmAlgId, other.symmAlgId)) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.keyAlgId, other.keyAlgId)) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.hintValue, other.hintValue)) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.encryptedKeyValue, other.encryptedKeyValue)) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.symmKeyValue, other.symmKeyValue)) {
            return false;
        }
        if (this.theKey != null) {
            byte[][] data2;
            if (other.theKey == null) {
                return false;
            }
            byte[][] data1 = this.theKey.getKeyData();
            if (!CertJUtils.byteArraysEqual(data1[0], (data2 = other.theKey.getKeyData())[0])) {
                return false;
            }
        } else if (other.theKey != null) {
            return false;
        }
        return !(this.thePrivateKey != null ? !this.thePrivateKey.equals((Object)other.thePrivateKey) : other.thePrivateKey != null);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(this.encryptedKeyValue);
        result = prime * result + Arrays.hashCode(this.hintValue);
        result = prime * result + Arrays.hashCode(this.intendedAlgId);
        result = prime * result + Arrays.hashCode(this.keyAlgId);
        result = prime * result + Arrays.hashCode(this.symmAlgId);
        result = prime * result + Arrays.hashCode(this.symmKeyValue);
        if (this.theKey != null) {
            byte[] data = this.theKey.getSecretKeyData();
            result = prime * result + Arrays.hashCode(data);
        }
        result = prime * result + CertJInternalHelper.hashCodeValue(this.thePrivateKey);
        return result;
    }
}

