/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BooleanContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.Control;
import com.rsa.certj.crmf.EncryptedKey;
import java.util.Arrays;

public class PKIArchiveOptions
extends Control {
    private EncryptedKey privEncKey;
    private byte[] parameters;
    private boolean archiveKey;
    ASN1Template asn1TemplateValue;
    private int special = 0;

    public PKIArchiveOptions() {
        this.controlTypeFlag = 3;
        this.theOID = new byte[OID_LIST[3].length];
        System.arraycopy(OID_LIST[3], 0, this.theOID, 0, this.theOID.length);
        this.controlTypeString = "PKIArchiveOptions";
    }

    protected void decodeValue(byte[] valueBER, int offset) throws CRMFException {
        if (valueBER == null) {
            throw new CRMFException("PKIArchiveOptions Encoding is null.");
        }
        try {
            ChoiceContainer optionsContainer = new ChoiceContainer(0);
            EndContainer anEnd = new EndContainer();
            EncodedContainer keyContainer = new EncodedContainer(0xA0FF00);
            OctetStringContainer paramContainer = new OctetStringContainer(0x800001);
            BooleanContainer archiveContainer = new BooleanContainer(0x800002);
            ASN1Container[] asn1Def = new ASN1Container[]{optionsContainer, keyContainer, paramContainer, archiveContainer, anEnd};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            if (keyContainer.dataPresent) {
                this.privEncKey = new EncryptedKey(theCertJ, theCertPathCtx, this.pubKey, this.privKey);
                this.privEncKey.decodeEncryptedKey(keyContainer.data, keyContainer.dataOffset, 0xA00000);
            } else if (paramContainer.dataPresent) {
                this.parameters = new byte[paramContainer.dataLen];
                System.arraycopy(paramContainer.data, paramContainer.dataOffset, this.parameters, 0, paramContainer.dataLen);
            } else if (archiveContainer.dataPresent) {
                this.archiveKey = archiveContainer.value;
            }
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Could not BER decode PKIArchiveOptions.", (Exception)((Object)asnException));
        }
    }

    public void setEncryptedKey(EncryptedKey encKey) throws CRMFException {
        if (encKey == null) {
            throw new CRMFException("Specified EncryptedKey is null.");
        }
        try {
            this.privEncKey = (EncryptedKey)encKey.clone();
        }
        catch (CloneNotSupportedException cloneExc) {
            throw new CRMFException(cloneExc);
        }
    }

    public EncryptedKey getEncryptedKey() {
        if (this.privEncKey == null) {
            return null;
        }
        try {
            return (EncryptedKey)this.privEncKey.clone();
        }
        catch (CloneNotSupportedException cloneExc) {
            return null;
        }
    }

    public void setParameters(byte[] param, int offset, int len) throws CRMFException {
        if (param == null || len <= 0 || offset < 0) {
            throw new CRMFException("Specified parameters are null.");
        }
        this.parameters = new byte[len];
        System.arraycopy(param, offset, this.parameters, 0, len);
    }

    public byte[] getParameters() {
        if (this.parameters == null) {
            return null;
        }
        byte[] returnValue = new byte[this.parameters.length];
        System.arraycopy(this.parameters, 0, returnValue, 0, this.parameters.length);
        return returnValue;
    }

    public void setArchivePrivateKey(boolean flag) {
        this.archiveKey = flag;
    }

    public boolean getArchivePrivateKey() {
        return this.archiveKey;
    }

    protected int derEncodeValueInit() throws CRMFException {
        this.asn1TemplateValue = null;
        try {
            boolean keyPresent = false;
            boolean paramPresent = false;
            boolean flagPresent = false;
            byte[] encoding = null;
            int len = 0;
            int paramLen = 0;
            if (this.privEncKey != null) {
                len = this.privEncKey.getDERLen(0xA00000);
                encoding = new byte[len];
                len = this.privEncKey.getDEREncoding(encoding, 0, 0xA00000);
                keyPresent = true;
            } else if (this.parameters != null) {
                paramPresent = true;
                paramLen = this.parameters.length;
            } else {
                flagPresent = true;
            }
            ChoiceContainer optionsContainer = new ChoiceContainer(0, 0);
            EndContainer anEnd = new EndContainer();
            EncodedContainer keyContainer = new EncodedContainer(0xA00000, keyPresent, 0, encoding, 0, len);
            OctetStringContainer paramContainer = new OctetStringContainer(0x800001, paramPresent, 0, this.parameters, 0, paramLen);
            BooleanContainer archiveContainer = new BooleanContainer(0x800002, flagPresent, 0, this.archiveKey);
            ASN1Container[] asn1Def = new ASN1Container[]{optionsContainer, keyContainer, paramContainer, archiveContainer, anEnd};
            this.asn1TemplateValue = new ASN1Template(asn1Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Cannot encode PKIArchiveOptions control. ", (Exception)((Object)asnException));
        }
    }

    protected int derEncodeValue(byte[] encoding, int offset) throws CRMFException {
        if (encoding == null) {
            throw new CRMFException("Passed in array is null in PKIArchiveOptions control.");
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            throw new CRMFException("Cannot encode PKIArchiveOptions control.");
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Cannot encode PKIArchiveOptions control.", (Exception)((Object)asnException));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        PKIArchiveOptions otherSelf = new PKIArchiveOptions();
        try {
            if (Control.theCertJ != null) {
                otherSelf.setEnvironment(Control.theCertJ, Control.theCertPathCtx, this.pubKey, this.privKey);
            }
        }
        catch (CRMFException crmfException) {
            throw new CloneNotSupportedException(crmfException.getMessage());
        }
        if (this.privEncKey != null) {
            otherSelf.privEncKey = (EncryptedKey)this.privEncKey.clone();
        }
        if (this.parameters != null) {
            otherSelf.parameters = new byte[this.parameters.length];
            System.arraycopy(this.parameters, 0, otherSelf.parameters, 0, this.parameters.length);
        }
        otherSelf.archiveKey = this.archiveKey;
        otherSelf.special = this.special;
        super.copyValues(otherSelf);
        return otherSelf;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PKIArchiveOptions)) {
            return false;
        }
        PKIArchiveOptions other = (PKIArchiveOptions)obj;
        if (other.archiveKey != this.archiveKey) {
            return false;
        }
        if (this.privEncKey != null ? !this.privEncKey.equals(other.privEncKey) : other.privEncKey != null) {
            return false;
        }
        return CertJUtils.byteArraysEqual(this.parameters, other.parameters);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.archiveKey ? 1231 : 1237);
        result = prime * result + Arrays.hashCode(this.parameters);
        result = prime * result + CertJInternalHelper.hashCodeValue(this.privEncKey);
        return result;
    }
}

