/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.Control;
import java.util.Arrays;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PKIPublicationInfo
extends Control {
    public static final int DONT_PUBLISH = 0;
    public static final int PLEASE_PUBLISH = 1;
    public static final int DONT_CARE = 0;
    public static final int X500 = 1;
    public static final int WEB = 2;
    public static final int LDAP = 3;
    private int action;
    private Vector<Object>[] pubInfos = this.createVectorArray(2);
    ASN1Template asn1TemplateValue;
    private int special = 0;

    public PKIPublicationInfo() {
        this.controlTypeFlag = 2;
        this.theOID = new byte[OID_LIST[2].length];
        System.arraycopy(OID_LIST[2], 0, this.theOID, 0, this.theOID.length);
        this.controlTypeString = "PKIPublicationInfo";
    }

    @Override
    protected void decodeValue(byte[] valueBER, int offset) throws CRMFException {
        if (valueBER == null) {
            throw new CRMFException("PKIPublicationInfo Encoding is null.");
        }
        try {
            SequenceContainer aSeq = new SequenceContainer(this.special);
            EndContainer anEnd = new EndContainer();
            EncodedContainer pubContainer = new EncodedContainer(77824);
            IntegerContainer actContainer = new IntegerContainer(0);
            ASN1Container[] asn1Def = new ASN1Container[]{aSeq, actContainer, pubContainer, anEnd};
            ASN1.berDecode((byte[])valueBER, (int)offset, (ASN1Container[])asn1Def);
            this.action = actContainer.getValueAsInt();
            if (this.action != 0 && this.action != 1) {
                throw new CRMFException("Invalid action option.");
            }
            if (pubContainer.dataPresent) {
                OfContainer seqOf = new OfContainer(65536, 12288, (ASN1Container)new EncodedContainer(12288));
                ASN1Container[] asnDef = new ASN1Container[]{seqOf};
                ASN1.berDecode((byte[])pubContainer.data, (int)pubContainer.dataOffset, (ASN1Container[])asnDef);
                int count = seqOf.getContainerCount();
                for (int index = 0; index < count; ++index) {
                    ASN1Container encodedInfoContainer = seqOf.containerAt(index);
                    EncodedContainer nameContainer = new EncodedContainer(130816);
                    IntegerContainer methodContainer = new IntegerContainer(0);
                    ASN1Container[] asn2Def = new ASN1Container[]{aSeq, methodContainer, nameContainer, anEnd};
                    ASN1.berDecode((byte[])encodedInfoContainer.data, (int)encodedInfoContainer.dataOffset, (ASN1Container[])asn2Def);
                    if (nameContainer.dataPresent) {
                        GeneralName pubLocation = new GeneralName(nameContainer.data, nameContainer.dataOffset, 65536);
                        this.pubInfos[1].addElement(pubLocation);
                    } else {
                        this.pubInfos[1].addElement(null);
                    }
                    int pubMethod = methodContainer.getValueAsInt();
                    if (pubMethod != 0 && pubMethod != 1 && pubMethod != 2 && pubMethod != 3) {
                        throw new CRMFException("Invalid pubMethod option");
                    }
                    this.pubInfos[0].addElement(new Integer(pubMethod));
                }
            }
        }
        catch (Exception anyExc) {
            throw new CRMFException("Cannot decode PKIPublicationInfo control.", anyExc);
        }
    }

    private Vector<Object>[] createVectorArray(int size) {
        Vector[] vectorArray = new Vector[size];
        for (int index = 0; index < size; ++index) {
            vectorArray[index] = new Vector();
        }
        return vectorArray;
    }

    public void setAction(int action) throws CRMFException {
        if (action != 0 && action != 1) {
            throw new CRMFException("Invalid action option.");
        }
        this.action = action;
    }

    public int getAction() {
        return this.action;
    }

    public void addSinglePubInfo(int pubMethod, GeneralName pubLocation) throws CRMFException {
        if (pubMethod != 0 && pubMethod != 1 && pubMethod != 2 && pubMethod != 3) {
            throw new CRMFException("Invalid pubMethod option");
        }
        this.pubInfos[0].addElement(new Integer(pubMethod));
        if (pubLocation != null) {
            try {
                this.pubInfos[1].addElement(pubLocation.clone());
            }
            catch (CloneNotSupportedException cloneExc) {
                throw new CRMFException("Invalid value.", cloneExc);
            }
        } else {
            this.pubInfos[1].addElement(null);
        }
    }

    public int getSinglePubInfoCount() {
        return this.pubInfos[0].size();
    }

    public int getPubMethod(int index) throws CRMFException {
        if (index < this.pubInfos[0].size()) {
            return (Integer)this.pubInfos[0].elementAt(index);
        }
        throw new CRMFException("Invalid index.");
    }

    public GeneralName getPubLocation(int index) throws CRMFException {
        if (index < this.pubInfos[1].size()) {
            return (GeneralName)this.pubInfos[1].elementAt(index);
        }
        throw new CRMFException("Invalid index.");
    }

    @Override
    protected int derEncodeValue(byte[] encoding, int offset) throws CRMFException {
        if (encoding == null) {
            throw new CRMFException("Passed in array is null in PKIPublicationInfo control.");
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            throw new CRMFException("Cannot encode PKIPublicationInfo control.");
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Cannot encode PKIPublicationInfo control.", (Exception)((Object)asnException));
        }
    }

    @Override
    protected int derEncodeValueInit() throws CRMFException {
        this.asn1TemplateValue = null;
        Vector<OfContainer> asn1Def = new Vector<OfContainer>();
        try {
            boolean dataPresent = false;
            int encLen = 0;
            byte[] encoding = null;
            EndContainer anEnd = new EndContainer();
            int infoCount = this.pubInfos[0].size();
            if (infoCount > 0) {
                dataPresent = true;
                OfContainer seqOf = new OfContainer(this.special, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
                asn1Def.addElement(seqOf);
                for (int index = 0; index < infoCount; ++index) {
                    boolean namePresent = false;
                    if (this.pubInfos[1].elementAt(index) != null) {
                        GeneralName name = (GeneralName)this.pubInfos[1].elementAt(index);
                        encLen = name.getDERLen(0);
                        encoding = new byte[encLen];
                        encLen = name.getDEREncoding(encoding, 0, 0);
                        namePresent = true;
                    }
                    SequenceContainer aSeq = new SequenceContainer(0, true, 0);
                    EncodedContainer locContainer = new EncodedContainer(130816, namePresent, 0, encoding, 0, encLen);
                    IntegerContainer methodContainer = new IntegerContainer(0, true, 0, ((Integer)this.pubInfos[0].elementAt(index)).intValue());
                    ASN1Container[] asnDef = new ASN1Container[]{aSeq, methodContainer, locContainer, anEnd};
                    ASN1Template asnTemplate = new ASN1Template(asnDef);
                    int encodingLen = asnTemplate.derEncodeInit();
                    byte[] encod = new byte[encodingLen];
                    encodingLen = asnTemplate.derEncode(encod, 0);
                    EncodedContainer info = new EncodedContainer(12288, true, 0, encod, 0, encodingLen);
                    seqOf.addContainer((ASN1Container)info);
                }
                Object[] asn1DefArray = new ASN1Container[asn1Def.size()];
                asn1Def.copyInto(asn1DefArray);
                ASN1Template asnTemplate = new ASN1Template((ASN1Container[])asn1DefArray);
                encLen = asnTemplate.derEncodeInit();
                encoding = new byte[encLen];
                encLen = asnTemplate.derEncode(encoding, 0);
            }
            EncodedContainer pubContainer = new EncodedContainer(77824, dataPresent, 0, encoding, 0, encLen);
            IntegerContainer actContainer = new IntegerContainer(0, true, 0, this.action);
            SequenceContainer aSeq = new SequenceContainer(this.special, true, 0);
            ASN1Container[] asn2Def = new ASN1Container[]{aSeq, actContainer, pubContainer, anEnd};
            this.asn1TemplateValue = new ASN1Template(asn2Def);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Cannot encode PKIPublicationInfo control.", (Exception)((Object)asnException));
        }
        catch (NameException nameException) {
            throw new CRMFException("Cannot encode PKIPublicationInfo control.", nameException);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PKIPublicationInfo otherSelf = new PKIPublicationInfo();
        otherSelf.action = this.action;
        for (int index = 0; index < this.pubInfos.length; ++index) {
            for (int pubIndex = 0; pubIndex < this.pubInfos[index].size(); ++pubIndex) {
                otherSelf.pubInfos[index].addElement(this.pubInfos[index].elementAt(pubIndex));
            }
        }
        otherSelf.special = this.special;
        super.copyValues(otherSelf);
        return otherSelf;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PKIPublicationInfo)) {
            return false;
        }
        PKIPublicationInfo other = (PKIPublicationInfo)obj;
        if (this.action != other.action) {
            return false;
        }
        int thisVectorLen = this.pubInfos.length;
        int otherVectorLen = other.pubInfos.length;
        if (thisVectorLen != otherVectorLen) {
            return false;
        }
        for (int index = 0; index < thisVectorLen; ++index) {
            int otherVectorSize;
            int thisVectorSize = this.pubInfos[index].size();
            if (thisVectorSize != (otherVectorSize = other.pubInfos[index].size())) {
                return false;
            }
            for (int vectorIndex = 0; vectorIndex < thisVectorSize; ++vectorIndex) {
                if (this.pubInfos[index].elementAt(vectorIndex) == null) {
                    if (other.pubInfos[index].elementAt(vectorIndex) == null) continue;
                    return false;
                }
                if (other.pubInfos[index].elementAt(vectorIndex) == null) {
                    return false;
                }
                if (this.pubInfos[index].elementAt(vectorIndex).equals(other.pubInfos[index].elementAt(vectorIndex))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.action;
        result = prime * result + Arrays.hashCode(this.pubInfos);
        return result;
    }
}

