/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.EncryptedValue;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.Serializable;

public class POPOPrivKey
implements Cloneable,
Serializable {
    public static final int THIS_MESSAGE = 0;
    public static final int SUBSEQUENT_MESSAGE = 1;
    public static final int ENCRYPTED_CERT = 0;
    public static final int CHALLENGE_RESPONSE = 1;
    private ASN1Template asn1Template;
    private EncryptedValue encValue;
    private int subsequentMessage = -1;
    private int special;
    private int type = -1;
    private CertJ theCertJ;
    private JSAFE_PublicKey pubKey;
    private JSAFE_PrivateKey privKey;

    public void setType(int type) throws CRMFException {
        if (type != 0 && type != 1) {
            throw new CRMFException("Invalid type.");
        }
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setEnvironment(CertJ certJ, JSAFE_PublicKey pubKey, JSAFE_PrivateKey privKey) {
        if (certJ != null) {
            this.theCertJ = certJ;
        }
        if (pubKey != null) {
            this.pubKey = pubKey;
        }
        if (privKey != null) {
            this.privKey = privKey;
        }
    }

    public void setEncryptedValue(EncryptedValue value) throws CRMFException {
        if (this.type == 1) {
            throw new CRMFException("Wrong type: this object is of SUBSEQUENT_MESSAGE type");
        }
        if (value == null) {
            throw new CRMFException("specified EncryptedValue is null");
        }
        try {
            this.encValue = (EncryptedValue)value.clone();
        }
        catch (CloneNotSupportedException cloneExc) {
            throw new CRMFException("Invalid Encrypted Value.", cloneExc);
        }
    }

    public EncryptedValue getEncryptedValue() throws CRMFException {
        if (this.type == 1) {
            throw new CRMFException("Wrong type: this object is of SUBSEQUENT_MESSAGE type");
        }
        if (this.encValue == null) {
            return null;
        }
        try {
            return (EncryptedValue)this.encValue.clone();
        }
        catch (CloneNotSupportedException cloneExc) {
            throw new CRMFException("Invalid Encrypted Value.", cloneExc);
        }
    }

    public void setSubsequentMessage(int value) throws CRMFException {
        if (value != 0 && value != 1) {
            throw new CRMFException("Invalid value for Subsequent Message.");
        }
        this.subsequentMessage = value;
    }

    public int getSubsequentMessage() {
        return this.subsequentMessage;
    }

    public void decodePOPOPrivKey(byte[] keyBER, int offset, int special) throws CRMFException {
        if (keyBER == null) {
            throw new CRMFException("POPOPrivKey Encoding is null.");
        }
        this.special = special;
        try {
            ChoiceContainer keyContainer = new ChoiceContainer(special);
            BitStringContainer encryptedValue = new BitStringContainer(0x800000);
            IntegerContainer message = new IntegerContainer(0x800001);
            EndContainer anEnd = new EndContainer();
            ASN1Container[] asnDef = new ASN1Container[]{keyContainer, encryptedValue, message, anEnd};
            ASN1.berDecode((byte[])keyBER, (int)offset, (ASN1Container[])asnDef);
            if (encryptedValue.dataPresent) {
                this.encValue = new EncryptedValue(this.theCertJ, this.pubKey, this.privKey);
                this.encValue.decodeEncryptedValue(encryptedValue.data, encryptedValue.dataOffset, 0);
                this.type = 0;
            } else if (message.dataPresent) {
                this.subsequentMessage = message.getValueAsInt();
                if (this.subsequentMessage != 0 && this.subsequentMessage != 1) {
                    throw new CRMFException("Invalid value of Subsequent Message.");
                }
                this.type = 1;
            }
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Invalid POPOPrivKey encoding: ", (Exception)((Object)asnException));
        }
    }

    public static int getNextBEROffset(byte[] valueBER, int offset) throws CRMFException {
        if (valueBER == null) {
            throw new CRMFException("POPOPrivKey Encoding is null.");
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])valueBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])valueBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Could not read the BER encoding.", (Exception)((Object)asnException));
        }
    }

    public int getDERLen(int special) throws CRMFException {
        this.special = special;
        return this.encodeInit();
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws CRMFException {
        int returnValue;
        if (encoding == null) {
            throw new CRMFException("Specified POPOPrivKey array is null.");
        }
        this.special = special;
        try {
            if (this.asn1Template == null) {
                this.getDERLen(special);
            }
            returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new CRMFException("Unable to encode POPOPrivKey.", (Exception)((Object)asnException));
        }
        return returnValue;
    }

    private int encodeInit() throws CRMFException {
        try {
            byte[] encoding = null;
            int dataLen = 0;
            boolean thisPresent = false;
            boolean subseqPresent = false;
            if (this.encValue != null) {
                dataLen = this.encValue.getDERLen(0);
                encoding = new byte[dataLen];
                dataLen = this.encValue.getDEREncoding(encoding, 0, 0x800000);
                thisPresent = true;
            } else if (this.subsequentMessage != -1) {
                subseqPresent = true;
            } else {
                throw new CRMFException("POPOPrivKey Data is not set.");
            }
            ChoiceContainer keyContainer = new ChoiceContainer(this.special, 0);
            BitStringContainer encryptedValue = new BitStringContainer(0x800000, thisPresent, 0, encoding, 0, dataLen);
            IntegerContainer message = new IntegerContainer(0x800001, subseqPresent, 0, this.subsequentMessage);
            EndContainer anEnd = new EndContainer();
            ASN1Container[] asn1Def = new ASN1Container[]{keyContainer, encryptedValue, message, anEnd};
            this.asn1Template = new ASN1Template(asn1Def);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException((Exception)((Object)asnException));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            POPOPrivKey otherSelf = new POPOPrivKey();
            otherSelf.type = this.type;
            otherSelf.subsequentMessage = this.subsequentMessage;
            if (this.encValue != null) {
                otherSelf.encValue = (EncryptedValue)this.encValue.clone();
            }
            if (this.theCertJ != null) {
                otherSelf.setEnvironment(this.theCertJ, this.pubKey, this.privKey);
            }
            if (this.asn1Template != null) {
                otherSelf.encodeInit();
            }
            otherSelf.special = this.special;
            return otherSelf;
        }
        catch (CRMFException crmfException) {
            throw new CloneNotSupportedException(crmfException.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof POPOPrivKey)) {
            return false;
        }
        POPOPrivKey other = (POPOPrivKey)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.encValue != null ? !this.encValue.equals(other.encValue) : other.encValue != null) {
            return false;
        }
        return other.subsequentMessage == this.subsequentMessage;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + CertJInternalHelper.hashCodeValue(this.encValue);
        result = prime * result + this.subsequentMessage;
        result = prime * result + this.type;
        return result;
    }
}

