/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.CertRequest;
import com.rsa.certj.crmf.CertTemplate;
import com.rsa.certj.crmf.POPOPrivKey;
import com.rsa.certj.crmf.POPOSigningKeyInput;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_Signature;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Arrays;

public class ProofOfPossession
implements Cloneable,
Serializable {
    public static final int RA_VERIFIED_POP = 0;
    public static final int SIGNATURE_POP = 1;
    public static final int ENCIPHERMENT_POP = 2;
    public static final int AGREEMENT_POP = 3;
    private static final int RA_VERIFIED_SPECIAL = 0x800500;
    private static final int SIGNATURE_SPECIAL = 8400897;
    private int type;
    private POPOSigningKeyInput poposkInput;
    private POPOPrivKey privPOPKey = new POPOPrivKey();
    private byte[] signature;
    private byte[] signatureAlgorithmBER;
    String transformation = "";
    CertRequest certRequest;
    private CertJ theCertJ;
    protected JSAFE_PublicKey pubKey;
    protected JSAFE_PrivateKey privKey;
    private ASN1Template asn1Template;
    private int special;

    public ProofOfPossession() {
    }

    public ProofOfPossession(CertJ certJContext) {
        this.theCertJ = certJContext;
    }

    public ProofOfPossession(int type) throws CRMFException {
        this(type, null);
    }

    public ProofOfPossession(int type, CertJ certJContext) throws CRMFException {
        if (type != 0 && type != 1 && type != 2 && type != 3) {
            throw new CRMFException("This POP is not supported.");
        }
        this.type = type;
        this.theCertJ = certJContext;
    }

    public void decodeProofOfPossession(byte[] dataBER, int offset, int special) throws CRMFException {
        if (dataBER == null) {
            throw new CRMFException("ProofOfPossession Encoding is null.");
        }
        ChoiceContainer popContainer = new ChoiceContainer(special);
        EndContainer anEnd = new EndContainer();
        EncodedContainer nullContainer = new EncodedContainer(0x800500);
        EncodedContainer signContainer = new EncodedContainer(8400897);
        EncodedContainer encContainer = new EncodedContainer(10551042);
        EncodedContainer agreeContainer = new EncodedContainer(10551043);
        ASN1Container[] asn1Def = new ASN1Container[]{popContainer, nullContainer, signContainer, encContainer, agreeContainer, anEnd};
        try {
            ASN1.berDecode((byte[])dataBER, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException((Exception)((Object)asnException));
        }
        if (nullContainer.dataPresent) {
            this.type = 0;
        } else if (signContainer.dataPresent) {
            this.type = 1;
            this.decodeSignature(signContainer.data, signContainer.dataOffset);
        } else if (encContainer.dataPresent) {
            this.type = 2;
            this.privPOPKey.setEnvironment(this.theCertJ, this.pubKey, this.privKey);
            this.privPOPKey.decodePOPOPrivKey(encContainer.data, encContainer.dataOffset, 0xA00002);
        } else if (agreeContainer.dataPresent) {
            this.type = 3;
            this.privPOPKey.setEnvironment(this.theCertJ, this.pubKey, this.privKey);
            this.privPOPKey.decodePOPOPrivKey(agreeContainer.data, agreeContainer.dataOffset, 0xA00003);
        }
    }

    private void decodeSignature(byte[] data, int offset) throws CRMFException {
        if (data == null) {
            throw new CRMFException("Signature Proof Of Possession is NULL.");
        }
        SequenceContainer aSeq = new SequenceContainer(8400897);
        EndContainer anEnd = new EndContainer();
        EncodedContainer input = new EncodedContainer(8466432);
        EncodedContainer algID = new EncodedContainer(12288);
        BitStringContainer sig = new BitStringContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{aSeq, input, algID, sig, anEnd};
        try {
            ASN1.berDecode((byte[])data, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Could not BER decode the POP.", (Exception)((Object)asnException));
        }
        if (input.dataPresent) {
            this.poposkInput = new POPOSigningKeyInput(input.data, input.dataOffset);
        }
        this.signature = new byte[sig.dataLen];
        System.arraycopy(sig.data, sig.dataOffset, this.signature, 0, sig.dataLen);
        this.setSignatureAlgorithm(algID.data, algID.dataOffset, algID.dataLen);
    }

    public boolean verifySignature(String device, SecureRandom random) throws CRMFException {
        JSAFE_PublicKey publicKey;
        byte[] encoding;
        JSAFE_Signature verifier = null;
        if (this.signature == null) {
            throw new CRMFException("Signature is null, cannot verify it.");
        }
        if (this.poposkInput != null) {
            int len = this.poposkInput.getDERLen();
            if (len == 0) {
                throw new CRMFException("Cannot DER-encode poposkInput.");
            }
            encoding = new byte[len];
            this.poposkInput.getDEREncoding(encoding, 0);
            encoding[0] = 48;
            publicKey = this.poposkInput.getSubjectPublicKey();
        } else {
            if (this.certRequest == null) {
                throw new CRMFException("CertRequest is not set.");
            }
            CertTemplate template = this.certRequest.getCertTemplate();
            publicKey = template.getSubjectPublicKey();
            if (publicKey == null) {
                throw new CRMFException("Public key is not set in CertRequest; Cannot verify the signature.");
            }
            int len = this.certRequest.getDERLen(0);
            if (len == 0) {
                throw new CRMFException("Cannot DER-encode CertRequest.");
            }
            encoding = new byte[len];
            this.certRequest.getDEREncoding(encoding, 0, 0);
        }
        try {
            verifier = JSAFEFactory.getSignature(this.transformation, device, this.theCertJ);
            if (this.theCertJ == null) {
                verifier.verifyInit(publicKey, random);
            } else {
                verifier.verifyInit(publicKey, null, random, this.theCertJ.getPKCS11Sessions());
            }
            verifier.verifyUpdate(encoding, 0, encoding.length);
            boolean template = verifier.verifyFinal(this.signature, 0, this.signature.length);
            return template;
        }
        catch (JSAFE_Exception jsafeException) {
            throw new CRMFException("Could not verify the POP's signature: ", (Exception)((Object)jsafeException));
        }
        finally {
            if (verifier != null) {
                verifier.clearSensitiveData();
            }
        }
    }

    public int getPOPType() {
        return this.type;
    }

    public POPOSigningKeyInput getPOPOSigningKeyInput() {
        if (this.type != 1) {
            return null;
        }
        return this.poposkInput;
    }

    public void setPOPOSigningKeyInput(POPOSigningKeyInput input) throws CRMFException {
        if (this.type != 1) {
            throw new CRMFException("This POP is NOT POPOSigningKey type.");
        }
        if (input == null) {
            throw new CRMFException("POPOSigningKeyInput object is null.");
        }
        this.poposkInput = input;
    }

    public String getAlgTransformation() {
        if (this.type != 1) {
            return null;
        }
        return this.transformation;
    }

    public byte[] getAlgBER() {
        if (this.type != 1 || this.signatureAlgorithmBER == null) {
            return null;
        }
        byte[] returnValue = new byte[this.signatureAlgorithmBER.length];
        System.arraycopy(this.signatureAlgorithmBER, 0, returnValue, 0, this.signatureAlgorithmBER.length);
        return returnValue;
    }

    public void setSignatureAlgorithm(String trans) throws CRMFException {
        if (this.type != 1) {
            throw new CRMFException("This POP is NOT POPOSigningKey type.");
        }
        if (trans == null) {
            throw new CRMFException("POP Transformation is null.");
        }
        this.transformation = trans;
        try {
            this.signatureAlgorithmBER = AlgorithmID.derEncodeAlgID((String)trans, (int)1, null, (int)0, (int)0);
        }
        catch (ASN_Exception e) {
            throw new CRMFException("POP Transformation is invalid. ", (Exception)((Object)e));
        }
    }

    public void setSignatureAlgorithm(byte[] algID, int offset, int len) throws CRMFException {
        if (this.type != 1) {
            throw new CRMFException("This POP is NOT POPOSigningKey type.");
        }
        if (algID == null || len == 0) {
            throw new CRMFException("POP Algorithm ID is null.");
        }
        try {
            this.signatureAlgorithmBER = new byte[len];
            System.arraycopy(algID, offset, this.signatureAlgorithmBER, 0, len);
            this.transformation = AlgorithmID.berDecodeAlgID((byte[])algID, (int)offset, (int)1, null);
            if (this.transformation == null) {
                throw new CRMFException("Unknown Signature Algorithm in POP.");
            }
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Cannot set Signature Algorithm in POP.", (Exception)((Object)asnException));
        }
    }

    public byte[] getSignature() {
        if (this.type != 1 || this.signature == null) {
            return null;
        }
        byte[] returnValue = new byte[this.signature.length];
        System.arraycopy(this.signature, 0, returnValue, 0, this.signature.length);
        return returnValue;
    }

    public void setCertRequest(CertRequest request) throws CRMFException {
        if (this.type != 1) {
            throw new CRMFException("This POP is NOT POPOSigningKey type.");
        }
        if (request == null) {
            throw new CRMFException("The request in POP is NULL.");
        }
        CertTemplate template = request.getCertTemplate();
        if (template == null) {
            throw new CRMFException("Invalid CertRequest: CertTemplate is missing.");
        }
        if (template.getSubjectName() == null || template.getSubjectPublicKey() == null) {
            throw new CRMFException("Subject Name and / or Public Key values are missing.");
        }
        this.certRequest = request;
    }

    public void signPOP(String device, JSAFE_PrivateKey signingKey, SecureRandom random) throws CRMFException {
        byte[] encoding;
        if (this.type != 1) {
            throw new CRMFException("This POP is NOT POPOSigningKey type.");
        }
        if (this.certRequest != null) {
            this.poposkInput = null;
            int len = this.certRequest.getDERLen(0);
            if (len == 0) {
                throw new CRMFException("Cannot DER-encode CertRequest in POP.");
            }
            encoding = new byte[len];
            this.certRequest.getDEREncoding(encoding, 0, 0);
        } else {
            if (this.poposkInput == null) {
                throw new CRMFException("Data is not set in poposkInput.");
            }
            int len = this.poposkInput.getDERLen();
            if (len == 0) {
                throw new CRMFException("Cannot DER-encode poposkInput.");
            }
            encoding = new byte[len];
            this.poposkInput.getDEREncoding(encoding, 0);
            encoding[0] = 48;
        }
        JSAFE_Signature signer = null;
        try {
            signer = JSAFEFactory.getSignature(this.transformation, device, this.theCertJ);
            if (this.theCertJ == null) {
                signer.signInit(signingKey, random);
            } else {
                signer.signInit(signingKey, null, random, this.theCertJ.getPKCS11Sessions());
            }
            signer.signUpdate(encoding, 0, encoding.length);
            this.signature = signer.signFinal();
        }
        catch (JSAFE_Exception jsafeException) {
            throw new CRMFException("Could not sign the POP: ", (Exception)((Object)jsafeException));
        }
        finally {
            if (signer != null) {
                signer.clearSensitiveData();
            }
        }
    }

    public void setEnvironment(CertJ certJ, JSAFE_PublicKey pubKey, JSAFE_PrivateKey privKey) {
        this.theCertJ = certJ;
        if (pubKey != null) {
            this.pubKey = pubKey;
        }
        if (privKey != null) {
            this.privKey = privKey;
        }
    }

    public void setCertJ(CertJ certJContext) {
        this.theCertJ = certJContext;
    }

    public CertJ getCertJ() {
        return this.theCertJ;
    }

    public void setKeys(JSAFE_PublicKey pubKey, JSAFE_PrivateKey privKey) {
        if (pubKey != null) {
            this.pubKey = pubKey;
        }
        if (privKey != null) {
            this.privKey = privKey;
        }
    }

    public void setPOPOPrivKey(POPOPrivKey privateKey) throws CRMFException {
        if (this.type != 2 && this.type != 3) {
            throw new CRMFException("Wrong POP type.");
        }
        if (privateKey == null) {
            throw new CRMFException("POPOPrivateKey object is null.");
        }
        this.privPOPKey = privateKey;
    }

    public POPOPrivKey getPOPOPrivKey() throws CRMFException {
        return this.privPOPKey;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            ProofOfPossession otherself = new ProofOfPossession(this.type);
            if (this.poposkInput != null) {
                otherself.poposkInput = (POPOSigningKeyInput)this.poposkInput.clone();
            }
            if (this.signature != null) {
                otherself.signature = new byte[this.signature.length];
                System.arraycopy(this.signature, 0, otherself.signature, 0, this.signature.length);
            }
            if (this.signatureAlgorithmBER != null) {
                otherself.signatureAlgorithmBER = new byte[this.signatureAlgorithmBER.length];
                System.arraycopy(this.signatureAlgorithmBER, 0, otherself.signatureAlgorithmBER, 0, this.signatureAlgorithmBER.length);
            }
            otherself.transformation = this.transformation;
            if (this.certRequest != null) {
                otherself.certRequest = (CertRequest)this.certRequest.clone();
            }
            if (this.privPOPKey != null) {
                otherself.privPOPKey = (POPOPrivKey)this.privPOPKey.clone();
            }
            otherself.setEnvironment(this.theCertJ, this.pubKey, this.privKey);
            return otherself;
        }
        catch (CRMFException crmf) {
            throw new CloneNotSupportedException(crmf.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ProofOfPossession)) {
            return false;
        }
        ProofOfPossession other = (ProofOfPossession)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.certRequest != null ? !this.certRequest.equals(other.certRequest) : other.certRequest != null) {
            return false;
        }
        if (this.poposkInput != null ? !this.poposkInput.equals(other.poposkInput) : other.poposkInput != null) {
            return false;
        }
        if (this.transformation != null ? !this.transformation.equals(other.transformation) : other.transformation != null) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.signatureAlgorithmBER, other.signatureAlgorithmBER)) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.signature, other.signature)) {
            return false;
        }
        return !(this.privPOPKey != null ? !this.privPOPKey.equals(other.privPOPKey) : other.privPOPKey != null);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.type;
        result = prime * result + CertJInternalHelper.hashCodeValue(this.certRequest);
        result = prime * result + CertJInternalHelper.hashCodeValue(this.poposkInput);
        result = prime * result + CertJInternalHelper.hashCodeValue(this.privPOPKey);
        result = prime * result + Arrays.hashCode(this.signature);
        result = prime * result + Arrays.hashCode(this.signatureAlgorithmBER);
        result = prime * result + CertJInternalHelper.hashCodeValue(this.transformation);
        return result;
    }

    public static int getNextBEROffset(byte[] popBER, int offset) throws CRMFException {
        if (popBER == null) {
            throw new CRMFException("Encoding is null.");
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])popBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])popBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Could not read the BER encoding of ProofOfPossession.", (Exception)((Object)asnException));
        }
    }

    public int getDERLen(int special) throws CRMFException {
        this.special = special;
        return this.encodeInit();
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws CRMFException {
        int returnValue;
        this.special = special;
        if (encoding == null) {
            throw new CRMFException("Specified array in ProofOfPossession is null.");
        }
        if (this.type == 0) {
            encoding[0] = -128;
            encoding[1] = 0;
            return 2;
        }
        try {
            if (this.asn1Template == null) {
                this.getDERLen(special);
            }
            returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new CRMFException("Unable to encode ProofOfPossession.", (Exception)((Object)asnException));
        }
        return returnValue;
    }

    private int encodeInit() throws CRMFException {
        if (this.type == 0) {
            return 2;
        }
        try {
            boolean signPresent = false;
            boolean encPresent = false;
            boolean agreePresent = false;
            int len = 0;
            byte[] encoding = null;
            EndContainer anEnd = new EndContainer();
            if (this.type == 1) {
                signPresent = true;
                SequenceContainer aSeq = new SequenceContainer(8400897, true, 0);
                boolean dataPresent = true;
                int inputLen = 0;
                byte[] inputEncoding = null;
                if (this.poposkInput == null) {
                    dataPresent = false;
                } else {
                    inputLen = this.poposkInput.getDERLen();
                    inputEncoding = new byte[inputLen];
                    inputLen = this.poposkInput.getDEREncoding(inputEncoding, 0);
                }
                EncodedContainer input = new EncodedContainer(8466432, dataPresent, 0, inputEncoding, 0, inputLen);
                if (this.signatureAlgorithmBER == null) {
                    throw new CRMFException("Signature Algorithm ID is not set.");
                }
                EncodedContainer algID = new EncodedContainer(12288, true, 0, this.signatureAlgorithmBER, 0, this.signatureAlgorithmBER.length);
                if (this.signature == null) {
                    throw new CRMFException("Signature is not set.");
                }
                BitStringContainer sig = new BitStringContainer(0, true, 0, this.signature, 0, this.signature.length);
                ASN1Container[] asn1Def = new ASN1Container[]{aSeq, input, algID, sig, anEnd};
                ASN1Template popTemplate = new ASN1Template(asn1Def);
                len = popTemplate.derEncodeInit();
                encoding = new byte[len];
                len = popTemplate.derEncode(encoding, 0);
            } else if (this.type == 2) {
                if (this.privPOPKey == null) {
                    throw new CRMFException("POPOPrivKey is not set.");
                }
                encPresent = true;
                len = this.privPOPKey.getDERLen(0xA00002);
                encoding = new byte[len];
                len = this.privPOPKey.getDEREncoding(encoding, 0, 0xA00002);
            } else if (this.type == 3) {
                if (this.privPOPKey == null) {
                    throw new CRMFException("POPOPrivKey is not set.");
                }
                agreePresent = true;
                len = this.privPOPKey.getDERLen(0xA00003);
                encoding = new byte[len];
                len = this.privPOPKey.getDEREncoding(encoding, 0, 0xA00003);
            }
            ChoiceContainer popContainer = new ChoiceContainer(this.special, 0);
            EncodedContainer keyContainer = new EncodedContainer(8400897, signPresent, 0, encoding, 0, len);
            EncodedContainer encContainer = new EncodedContainer(10551042, encPresent, 0, encoding, 0, len);
            EncodedContainer agreeContainer = new EncodedContainer(10551043, agreePresent, 0, encoding, 0, len);
            ASN1Container[] asn2Def = new ASN1Container[]{popContainer, keyContainer, encContainer, agreeContainer, anEnd};
            this.asn1Template = new ASN1Template(asn2Def);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException((Exception)((Object)asnException));
        }
    }
}

