/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.Control;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.util.Arrays;

public class ProtocolEncryptionKey
extends Control {
    private byte[] subjectPublicKeyInfo;
    ASN1Template asn1TemplateValue;
    private int special = 0;

    public ProtocolEncryptionKey() {
        this.controlTypeFlag = 5;
        this.theOID = new byte[OID_LIST[5].length];
        System.arraycopy(OID_LIST[5], 0, this.theOID, 0, this.theOID.length);
        this.controlTypeString = "ProtocolEncryptionKey";
    }

    protected void decodeValue(byte[] valueBER, int offset) throws CRMFException {
        if (valueBER == null) {
            throw new CRMFException("ProtocolEncryptionKey Encoding is null.");
        }
        this.setSubjectPublicKey(valueBER, offset);
    }

    public void setSubjectPublicKey(JSAFE_PublicKey publicKey) throws CRMFException {
        if (publicKey == null) {
            throw new CRMFException("Public key is null.");
        }
        try {
            String format = publicKey.getAlgorithm().compareTo("DSA") == 0 ? "DSAPublicKeyX957BER" : publicKey.getAlgorithm() + "PublicKeyBER";
            byte[][] keyData = publicKey.getKeyData(format);
            this.subjectPublicKeyInfo = keyData[0];
        }
        catch (JSAFE_Exception jsafeException) {
            throw new CRMFException("Could not read the public key. ", (Exception)((Object)jsafeException));
        }
    }

    public void setSubjectPublicKey(byte[] publicKeyBER, int offset) throws CRMFException {
        if (publicKeyBER == null || offset < 0) {
            throw new CRMFException("Public key encoding is null.");
        }
        JSAFE_PublicKey publicKey = null;
        try {
            publicKeyBER[offset] = 48;
            publicKey = JSAFEFactory.getPublicKey(publicKeyBER, offset, "Java", theCertJ);
            this.setSubjectPublicKey(publicKey);
        }
        catch (JSAFE_Exception jsafeException) {
            throw new CRMFException("Could not read the public key. ", (Exception)((Object)jsafeException));
        }
        finally {
            if (publicKey != null) {
                publicKey.clearSensitiveData();
            }
        }
    }

    public JSAFE_PublicKey getSubjectPublicKey() throws CRMFException {
        if (this.subjectPublicKeyInfo == null) {
            return null;
        }
        try {
            return JSAFEFactory.getPublicKey(this.subjectPublicKeyInfo, 0, "Java", theCertJ);
        }
        catch (JSAFE_Exception jsafeException) {
            throw new CRMFException("Cannot retrieve the public key: ", (Exception)((Object)jsafeException));
        }
    }

    public byte[] getSubjectPublicKeyBER() {
        if (this.subjectPublicKeyInfo == null) {
            return null;
        }
        return (byte[])this.subjectPublicKeyInfo.clone();
    }

    protected int derEncodeValue(byte[] encoding, int offset) throws CRMFException {
        if (encoding == null) {
            throw new CRMFException("Passed in array is null in PKIPublicationInfo control.");
        }
        if (this.asn1TemplateValue == null && this.derEncodeValueInit() == 0) {
            throw new CRMFException("Cannot encode PKIPublicationInfo control.");
        }
        try {
            int totalLen = this.asn1TemplateValue.derEncode(encoding, offset);
            this.asn1Template = null;
            return totalLen;
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Cannot encode PKIPublicationInfo control.", (Exception)((Object)asnException));
        }
    }

    protected int derEncodeValueInit() throws CRMFException {
        try {
            this.asn1TemplateValue = null;
            if (this.subjectPublicKeyInfo == null) {
                throw new CRMFException("Protocol Encryption Key value is not set.");
            }
            EncodedContainer key = new EncodedContainer(77824, true, 0, this.subjectPublicKeyInfo, 0, this.subjectPublicKeyInfo.length);
            ASN1Container[] asnDef = new ASN1Container[]{key};
            this.asn1TemplateValue = new ASN1Template(asnDef);
            return this.asn1TemplateValue.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new CRMFException("Cannot encode ProtocolEncryptionKey control.", (Exception)((Object)asnException));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ProtocolEncryptionKey otherSelf = new ProtocolEncryptionKey();
        if (this.subjectPublicKeyInfo != null) {
            otherSelf.subjectPublicKeyInfo = new byte[this.subjectPublicKeyInfo.length];
            System.arraycopy(this.subjectPublicKeyInfo, 0, otherSelf.subjectPublicKeyInfo, 0, this.subjectPublicKeyInfo.length);
        }
        otherSelf.special = this.special;
        super.copyValues(otherSelf);
        return otherSelf;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ProtocolEncryptionKey)) {
            return false;
        }
        ProtocolEncryptionKey other = (ProtocolEncryptionKey)obj;
        return CertJUtils.byteArraysEqual(this.subjectPublicKeyInfo, other.subjectPublicKeyInfo);
    }

    public int hashCode() {
        return 31 + Arrays.hashCode(this.subjectPublicKeyInfo);
    }
}

