/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.pkcs12;

import com.rsa.certj.CertJ;
import com.rsa.certj.CertJException;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.attributes.FriendlyName;
import com.rsa.certj.cert.attributes.LocalKeyID;
import com.rsa.certj.pkcs12.PFX;
import com.rsa.certj.pkcs12.PKCS12Exception;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Vector;

public class PKCS12
implements Serializable {
    public static final int USE_MS_FORMAT = 1;
    public static final int USE_NS_FORMAT = 2;
    public static final String[] POSSIBLE_ENCRYPTION_ALGORITHMS = new String[]{"PBE/SHA1/3DES_EDE/CBC/PKCS12V1PBE-1-3", "PBE/SHA1/RC4/PKCS12V1PBE-1-128", "PBE/SHA1/RC4/PKCS12V1PBE-1-40", "PBE/SHA1/3DES_EDE/CBC/PKCS12V1PBE-1-2", "PBE/SHA1/RC2/CBC/PKCS12V1PBE-1-128", "PBE/SHA1/RC2/CBC/PKCS12V1PBE-1-40"};
    public static final String[] POSSIBLE_DIGEST_ALGORITHMS = new String[]{"SHA1"};
    public static final int DEFAULT_ITERATIONS = 1;
    public static final int[] POSSIBLE_OPTIONS = new int[]{1, 2};
    private static final int READ_BUFFER_SIZE = 1024;
    private PFX pfx;
    private byte[] ber;
    private CertJ certJ;

    protected PKCS12(CertJ certJ) {
        this.certJ = certJ;
    }

    public PKCS12(CertJ certJ, DatabaseService database, char[] password, InputStream pkcs12Stream, int length) throws PKCS12Exception {
        this(certJ);
        this.importPKCS12(database, password, null, pkcs12Stream, length);
    }

    public PKCS12(CertJ certJ, DatabaseService database, char[] password, char[] encPassword, InputStream pkcs12Stream, int length) throws PKCS12Exception {
        this(certJ);
        this.importPKCS12(database, password, encPassword, pkcs12Stream, length);
    }

    public PKCS12(CertJ certJ, DatabaseService database, char[] password, InputStream pkcs12Stream) throws PKCS12Exception {
        this(certJ, database, password, pkcs12Stream, -1);
    }

    public PKCS12(CertJ certJ, DatabaseService database, char[] password, char[] encPassword, InputStream pkcs12Stream) throws PKCS12Exception {
        this(certJ, database, password, encPassword, pkcs12Stream, -1);
    }

    public PKCS12(CertJ certJ, DatabaseService database, char[] password, String pkcs12File) throws PKCS12Exception {
        this(certJ);
        if (pkcs12File == null) {
            throw new PKCS12Exception("PKCS12.PKCS12: pkcs12File should not be null.");
        }
        this.importPKCS12(database, password, null, new File(pkcs12File));
    }

    public PKCS12(CertJ certJ, DatabaseService database, char[] password, char[] encPassword, String pkcs12File) throws PKCS12Exception {
        this(certJ);
        if (pkcs12File == null) {
            throw new PKCS12Exception("PKCS12.PKCS12: pkcs12File should not be null.");
        }
        this.importPKCS12(database, password, encPassword, new File(pkcs12File));
    }

    public PKCS12(CertJ certJ, DatabaseService database, char[] password, File pkcs12File) throws PKCS12Exception {
        this(certJ);
        this.importPKCS12(database, password, null, pkcs12File);
    }

    public PKCS12(CertJ certJ, DatabaseService database, char[] password, char[] encPassword, File pkcs12File) throws PKCS12Exception {
        this(certJ);
        this.importPKCS12(database, password, encPassword, pkcs12File);
    }

    private void importPKCS12(DatabaseService database, char[] password, char[] encPassword, InputStream inputStream, int length) throws PKCS12Exception {
        if (password == null) {
            throw new PKCS12Exception("PKCS12.importPKCS12: password should not be null.");
        }
        if (inputStream == null) {
            throw new PKCS12Exception("PKCS12.importPKCS12: inputStream should not be null.");
        }
        this.readBER(inputStream, length);
        this.pfx = new PFX(this.certJ, database, password, encPassword, this.ber, 0, 0);
    }

    private void importPKCS12(DatabaseService database, char[] password, char[] encPassword, File pkcs12File) throws PKCS12Exception {
        if (pkcs12File == null) {
            throw new PKCS12Exception("PKCS12.import: pkcs12File should not be null.");
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(pkcs12File);
            this.importPKCS12(database, password, encPassword, stream, (int)pkcs12File.length());
        }
        catch (FileNotFoundException e) {
            throw new PKCS12Exception("PKCS12.import: Could not find file " + pkcs12File.toString() + ".", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new PKCS12Exception("PKCS12.import: Could not close file " + pkcs12File.toString() + ".", e);
                }
            }
        }
    }

    private void readBER(InputStream stream, int length) throws PKCS12Exception {
        try {
            if (length > 0) {
                this.ber = new byte[length];
                int bytesRead = stream.read(this.ber);
                if (length != bytesRead) {
                    throw new PKCS12Exception("PKCS12.readBER: Not enough bytes read. " + length + " bytes expected, " + bytesRead + " read.");
                }
            } else {
                int bytesRead;
                int bytesReadSoFar = 0;
                byte[] berCollected = new byte[]{};
                byte[] buffer = new byte[1024];
                while ((bytesRead = stream.read(buffer)) != -1) {
                    byte[] newBerCollected = new byte[bytesReadSoFar + bytesRead];
                    System.arraycopy(berCollected, 0, newBerCollected, 0, bytesReadSoFar);
                    System.arraycopy(buffer, 0, newBerCollected, bytesReadSoFar, bytesRead);
                    bytesReadSoFar += bytesRead;
                    berCollected = newBerCollected;
                }
                this.ber = berCollected;
            }
        }
        catch (Exception e) {
            throw new PKCS12Exception("PKCS12.readBER: error occurred while reading from stream " + stream.toString() + ".", e);
        }
    }

    public PKCS12(CertJ certJ, Certificate[] certs, CRL[] crls, JSAFE_PrivateKey[] keys, X501Attributes[] certAttrs, X501Attributes[] crlAttrs, X501Attributes[] keyAttrs) throws InvalidParameterException {
        this(certJ, certs, crls, keys, certAttrs, crlAttrs, keyAttrs, null);
    }

    public PKCS12(CertJ certJ, Certificate[] certs, CRL[] crls, JSAFE_PrivateKey[] keys, X501Attributes[] certAttrs, X501Attributes[] crlAttrs, X501Attributes[] keyAttrs, String[] keyFormats) throws InvalidParameterException {
        this(certJ);
        if (certs == null && crls == null && keys == null) {
            throw new InvalidParameterException("PKCS12.PKCS12: At least one of certs, crls and keys should not be null.");
        }
        if (keys != null && certs != null && (certAttrs == null || keyAttrs == null)) {
            Certificate[] certArray = this.orderCerts(certs, keys);
            certAttrs = certAttrs == null ? new X501Attributes[certArray.length] : PKCS12.reorderCertAttr(certArray, certs, certAttrs);
            if (keyAttrs == null) {
                keyAttrs = new X501Attributes[keys.length];
            }
            this.fixAttributes(certArray, keys, certAttrs, keyAttrs);
            this.pfx = new PFX(certArray, crls, keys, certAttrs, crlAttrs, keyAttrs, keyFormats);
            return;
        }
        this.pfx = new PFX(certs, crls, keys, certAttrs, crlAttrs, keyAttrs, keyFormats);
    }

    private static X501Attributes[] reorderCertAttr(Certificate[] certArray, Certificate[] certs, X501Attributes[] certAttrs) {
        int arrayLen = certAttrs.length;
        X501Attributes[] newCertAttrs = new X501Attributes[arrayLen];
        block0: for (int i = 0; i < arrayLen; ++i) {
            for (int j = 0; j < arrayLen; ++j) {
                if (certArray[i].hashCode() != certs[j].hashCode()) continue;
                newCertAttrs[i] = certAttrs[j];
                continue block0;
            }
        }
        return newCertAttrs;
    }

    private Certificate[] orderCerts(Certificate[] certs, JSAFE_PrivateKey[] keys) throws InvalidParameterException {
        int certLen;
        int i;
        Certificate[] resultCerts = new Certificate[certs.length];
        Vector<Certificate> newCerts = new Vector<Certificate>();
        for (i = 0; i < certs.length; ++i) {
            newCerts.addElement(certs[i]);
        }
        try {
            for (i = 0; i < keys.length; ++i) {
                byte[][] pubKeyData;
                JSAFE_PublicKey pubKey;
                int j;
                byte[][] privKeyData;
                String algName = keys[i].getAlgorithm();
                certLen = newCerts.size();
                if (algName.equals("RSA")) {
                    privKeyData = keys[i].getKeyData("RSAPrivateKeyCRT");
                    for (j = 0; j < certLen; ++j) {
                        pubKey = ((Certificate)newCerts.elementAt(j)).getSubjectPublicKey("Java");
                        if (!pubKey.getAlgorithm().equals("RSA")) continue;
                        pubKeyData = pubKey.getKeyData("RSAPublicKey");
                        if (privKeyData == null || pubKeyData == null) {
                            throw new InvalidParameterException("Invalid RSA key.");
                        }
                        if (!CertJUtils.byteArraysEqual(pubKeyData[0], privKeyData[0]) || !CertJUtils.byteArraysEqual(pubKeyData[1], privKeyData[1])) continue;
                        resultCerts[i] = (Certificate)newCerts.elementAt(j);
                        newCerts.removeElementAt(j);
                        break;
                    }
                    if (j != certLen) continue;
                    throw new InvalidParameterException("No corresponding cert found.");
                }
                if (!algName.equals("DSA")) continue;
                privKeyData = keys[i].getKeyData("DSAPrivateKey");
                if (privKeyData == null || privKeyData[0] == null || privKeyData[2] == null || privKeyData[3] == null) {
                    throw new InvalidParameterException("Invalid DSA private key.");
                }
                BigInteger prime = new BigInteger(1, privKeyData[0]);
                BigInteger base = new BigInteger(1, privKeyData[2]);
                BigInteger priValue = new BigInteger(1, privKeyData[3]);
                BigInteger pubValue = base.modPow(priValue, prime);
                for (j = 0; j < certLen; ++j) {
                    pubKey = ((Certificate)newCerts.elementAt(j)).getSubjectPublicKey("Java");
                    if (!pubKey.getAlgorithm().equals("DSA")) continue;
                    pubKeyData = pubKey.getKeyData("DSAPublicKey");
                    if (pubKeyData == null || pubKeyData[3] == null) {
                        throw new InvalidParameterException("Invalid DSA public key.");
                    }
                    BigInteger pubValueNew = new BigInteger(1, pubKeyData[3]);
                    if (!pubValueNew.equals(pubValue)) continue;
                    resultCerts[i] = (Certificate)newCerts.elementAt(j);
                    newCerts.removeElementAt(j);
                    break;
                }
                if (j != certLen) continue;
                throw new InvalidParameterException("No corresponding cert found.");
            }
        }
        catch (JSAFE_Exception jsafeException) {
            throw new InvalidParameterException("Invalid key.", (Exception)((Object)jsafeException));
        }
        catch (CertificateException certException) {
            throw new InvalidParameterException("Invalid certificate.", certException);
        }
        certLen = newCerts.size();
        int index = i;
        for (int j = 0; j < certLen; ++j) {
            resultCerts[index] = (Certificate)newCerts.elementAt(j);
            ++index;
        }
        return resultCerts;
    }

    public PKCS12(CertJ certJ, X500Name subjectName, CertPathCtx pathCtx) throws InvalidParameterException, PKCS12Exception {
        this(certJ, subjectName, pathCtx, null);
    }

    public PKCS12(CertJ certJ, X500Name subjectName, CertPathCtx pathCtx, String keyFormat) throws InvalidParameterException, PKCS12Exception {
        this(certJ);
        int i;
        int count;
        if (certJ == null) {
            throw new InvalidParameterException("PKCS12.PKCS12: certJ should not be null.");
        }
        if (subjectName == null) {
            throw new InvalidParameterException("PKCS12.PKCS12: subjectName should not be null.");
        }
        if (pathCtx == null) {
            throw new InvalidParameterException("PKCS12.PKCS12: pathCtx should not be null.");
        }
        DatabaseService db = pathCtx.getDatabase();
        Vector<Certificate> candidates = new Vector<Certificate>();
        try {
            count = db.selectCertificateBySubject(subjectName, candidates);
        }
        catch (Exception e) {
            throw new PKCS12Exception("PKCS12.PKCS12: Finding certificates for the subjectName failed.", e);
        }
        if (count == 0) {
            throw new PKCS12Exception("PKCS12.PKCS12: No certificate found for the subjectName(" + subjectName.toString() + ").");
        }
        Vector<Certificate> allCerts = new Vector<Certificate>();
        Vector<JSAFE_PrivateKey> keys = new Vector<JSAFE_PrivateKey>();
        for (int i2 = 0; i2 < count; ++i2) {
            try {
                JSAFE_PrivateKey key = db.selectPrivateKeyByCertificate(candidates.elementAt(i2));
                if (key == null) continue;
                keys.addElement(key);
                allCerts.addElement(candidates.elementAt(i2));
                continue;
            }
            catch (Exception e) {
                throw new PKCS12Exception("PKCS12.PKCS12: Retrieving private key certificate failed.", e);
            }
        }
        Vector<Certificate> crlCerts = new Vector<Certificate>();
        Vector<CRL> crls = new Vector<CRL>();
        for (i = 0; i < count; ++i) {
            try {
                certJ.buildCertPath(pathCtx, allCerts.elementAt(i), allCerts, crls, crlCerts, null);
                continue;
            }
            catch (Exception e) {
                throw new PKCS12Exception("PKCS12.PKCS12: Building certification path failed.", e);
            }
        }
        for (i = 0; i < crlCerts.size(); ++i) {
            allCerts.addElement((Certificate)crlCerts.elementAt(i));
        }
        count = allCerts.size();
        X501Attributes[] certAttrs = new X501Attributes[count];
        Certificate[] certArray = new Certificate[count];
        for (int i3 = 0; i3 < count; ++i3) {
            certArray[i3] = allCerts.elementAt(i3);
        }
        count = crls.size();
        CRL[] crlArray = null;
        if (count != 0) {
            crlArray = new CRL[count];
            for (int i4 = 0; i4 < count; ++i4) {
                crlArray[i4] = crls.elementAt(i4);
            }
        }
        count = keys.size();
        X501Attributes[] keyAttrs = new X501Attributes[count];
        JSAFE_PrivateKey[] keyArray = new JSAFE_PrivateKey[count];
        String[] keyFormats = new String[count];
        for (int i5 = 0; i5 < count; ++i5) {
            keyArray[i5] = (JSAFE_PrivateKey)keys.elementAt(i5);
            keyFormats[i5] = keyFormat;
        }
        this.fixAttributes(certArray, keyArray, certAttrs, keyAttrs);
        this.pfx = new PFX(certArray, crlArray, keyArray, certAttrs, null, keyAttrs, keyFormats);
    }

    public PKCS12(CertJ certJ, Certificate cert, CertPathCtx pathCtx) throws InvalidParameterException, PKCS12Exception {
        this(certJ, cert, pathCtx, null);
    }

    public PKCS12(CertJ certJ, Certificate cert, CertPathCtx pathCtx, String keyFormat) throws InvalidParameterException, PKCS12Exception {
        this(certJ);
        JSAFE_PrivateKey key;
        if (certJ == null) {
            throw new InvalidParameterException("PKCS12.PKCS12: cert should not be null.");
        }
        if (cert == null) {
            throw new InvalidParameterException("PKCS12.PKCS12: certJ should not be null.");
        }
        if (pathCtx == null) {
            throw new InvalidParameterException("PKCS12.PKCS12: pathCtx should not be null.");
        }
        DatabaseService db = pathCtx.getDatabase();
        Vector<Certificate> allCerts = new Vector<Certificate>();
        allCerts.addElement(cert);
        Vector<CRL> crls = new Vector<CRL>();
        try {
            key = db.selectPrivateKeyByCertificate(cert);
        }
        catch (CertJException e) {
            throw new PKCS12Exception("PKCS12.PKCS12: Finding private key for given certificate failed.", e);
        }
        if (key == null) {
            throw new PKCS12Exception("PKCS12.PKCS12: Matching private key not found.");
        }
        Vector<Certificate> crlCerts = new Vector<Certificate>();
        try {
            certJ.buildCertPath(pathCtx, cert, allCerts, crls, crlCerts, null);
        }
        catch (CertJException e) {
            throw new PKCS12Exception("PKCS12.PKCS12: Building certification path failed.", e);
        }
        for (int i = 0; i < crlCerts.size(); ++i) {
            allCerts.addElement(crlCerts.elementAt(i));
        }
        int count = allCerts.size();
        X501Attributes[] certAttrs = new X501Attributes[count];
        Certificate[] certArray = new Certificate[count];
        for (int i = 0; i < count; ++i) {
            certArray[i] = allCerts.elementAt(i);
        }
        count = crls.size();
        CRL[] crlArray = null;
        if (count != 0) {
            crlArray = new CRL[count];
            for (int i = 0; i < count; ++i) {
                crlArray[i] = crls.elementAt(i);
            }
        }
        X501Attributes[] keyAttrs = new X501Attributes[1];
        JSAFE_PrivateKey[] keyArray = new JSAFE_PrivateKey[]{key};
        String[] keyFormats = new String[]{keyFormat};
        this.fixAttributes(certArray, keyArray, certAttrs, keyAttrs);
        this.pfx = new PFX(certArray, crlArray, keyArray, certAttrs, null, keyAttrs, keyFormats);
    }

    public void export(String filename, char[] password, String encAlg, String digestAlg, int iterations, int option) throws InvalidParameterException, PKCS12Exception {
        if (filename == null) {
            throw new InvalidParameterException("PKCS12.export: filename should not be null.");
        }
        this.export(new File(filename), password, encAlg, digestAlg, iterations, option);
    }

    public void export(File file, char[] password, String encAlg, String digestAlg, int iterations, int option) throws InvalidParameterException, PKCS12Exception {
        if (file == null) {
            throw new InvalidParameterException("PKCS12.export: file should not be null.");
        }
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(file);
            this.export(stream, password, encAlg, digestAlg, iterations, option);
        }
        catch (IOException e) {
            throw new PKCS12Exception("PKCS12.export: Creation of stream failed.", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new PKCS12Exception("PKCS12.export: Could not close file.", e);
                }
            }
        }
    }

    public void export(String filename, char[] password, char[] encPassword, String encAlg, String digestAlg, int iterations, int option) throws InvalidParameterException, PKCS12Exception {
        if (filename == null) {
            throw new InvalidParameterException("PKCS12.export: filename should not be null.");
        }
        this.export(new File(filename), password, encPassword, encAlg, digestAlg, iterations, option);
    }

    public void export(File file, char[] password, char[] encPassword, String encAlg, String digestAlg, int iterations, int option) throws InvalidParameterException, PKCS12Exception {
        if (file == null) {
            throw new InvalidParameterException("PKCS12.export: file should not be null.");
        }
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(file);
            this.export(stream, password, encPassword, encAlg, digestAlg, iterations, option);
        }
        catch (IOException e) {
            throw new PKCS12Exception("PKCS12.export: stream IO failed.", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new PKCS12Exception("PKCS12.export: Could not close file.", e);
                }
            }
        }
    }

    public void export(OutputStream stream, char[] password, String encAlg, String digestAlg, int iterations, int option) throws InvalidParameterException, PKCS12Exception {
        this.export(stream, password, null, encAlg, digestAlg, iterations, option);
    }

    public void export(OutputStream stream, char[] password, char[] encPassword, String encAlg, String digestAlg, int iterations, int option) throws InvalidParameterException, PKCS12Exception {
        if (stream == null) {
            throw new InvalidParameterException("PKCS12.export: stream should not be null.");
        }
        if (this.certJ == null) {
            throw new PKCS12Exception("PKCS12.export: Object not initialized with certJ.");
        }
        if (this.pfx == null) {
            throw new PKCS12Exception("PKCS12.export: Object not initialized with pfx.");
        }
        if (password == null) {
            throw new InvalidParameterException("PKCS12.export: password can not be null.");
        }
        if (encAlg == null) {
            encAlg = POSSIBLE_ENCRYPTION_ALGORITHMS[0];
        }
        if (digestAlg == null) {
            digestAlg = POSSIBLE_DIGEST_ALGORITHMS[0];
        }
        if (iterations <= 0) {
            iterations = 1;
        }
        if (option == 0) {
            option = POSSIBLE_OPTIONS[0];
        } else if (!this.validOption(option)) {
            throw new InvalidParameterException("PKCS12.export: option is invalid.");
        }
        this.ber = this.pfx.derEncode(this.certJ, password, encPassword, encAlg, digestAlg, iterations, option);
        try {
            stream.write(this.ber);
            stream.close();
        }
        catch (IOException e) {
            throw new PKCS12Exception("PKCS12.export: Writing to stream failed.", e);
        }
    }

    public Certificate[] getCertificates() {
        if (this.pfx == null || this.pfx.getSafeObjects() == null) {
            return null;
        }
        Vector<Certificate> certVector = this.pfx.getSafeObjects().getCertificates();
        return certVector.toArray(new Certificate[certVector.size()]);
    }

    public CRL[] getCrls() {
        if (this.pfx == null || this.pfx.getSafeObjects() == null) {
            return null;
        }
        Vector<CRL> crlVector = this.pfx.getSafeObjects().getCrls();
        return crlVector.toArray(new CRL[crlVector.size()]);
    }

    public JSAFE_PrivateKey[] getKeys() {
        if (this.pfx == null || this.pfx.getSafeObjects() == null) {
            return null;
        }
        Vector<JSAFE_PrivateKey> keyVector = this.pfx.getSafeObjects().getKeys();
        return keyVector.toArray(new JSAFE_PrivateKey[keyVector.size()]);
    }

    public X501Attributes[] getKeysAttributes() {
        if (this.pfx == null || this.pfx.getSafeObjects() == null) {
            return null;
        }
        Vector<X501Attributes> attrVector = this.pfx.getSafeObjects().getKeysAttributes();
        return attrVector.toArray(new X501Attributes[attrVector.size()]);
    }

    public X501Attributes[] getCertsAttributes() {
        if (this.pfx == null || this.pfx.getSafeObjects() == null) {
            return null;
        }
        Vector<X501Attributes> attrVector = this.pfx.getSafeObjects().getCertsAttributes();
        return attrVector.toArray(new X501Attributes[attrVector.size()]);
    }

    public X501Attributes[] getCRLsAttributes() {
        if (this.pfx == null || this.pfx.getSafeObjects() == null) {
            return null;
        }
        Vector<X501Attributes> attrVector = this.pfx.getSafeObjects().getCrlsAttributes();
        return attrVector.toArray(new X501Attributes[attrVector.size()]);
    }

    private void fixAttributes(Certificate[] certs, JSAFE_PrivateKey[] keys, X501Attributes[] certAttrs, X501Attributes[] keyAttrs) {
        int i;
        for (i = 0; i < keys.length; ++i) {
            if (certAttrs[i] == null) {
                certAttrs[i] = new X501Attributes();
            }
            if (keyAttrs[i] == null) {
                keyAttrs[i] = new X501Attributes();
            }
            byte[] id = this.createLocalId(i + 1);
            LocalKeyID keyId = new LocalKeyID(id, 0, id.length);
            FriendlyName friendlyName = new FriendlyName(((X509Certificate)certs[i]).getSubjectName().toString());
            if (certAttrs[i].getAttributeByType(3) == null) {
                certAttrs[i].addAttribute(friendlyName);
            }
            if (certAttrs[i].getAttributeByType(4) == null) {
                certAttrs[i].addAttribute(keyId);
            }
            if (keyAttrs[i].getAttributeByType(3) == null) {
                keyAttrs[i].addAttribute(friendlyName);
            }
            if (keyAttrs[i].getAttributeByType(4) != null) continue;
            keyAttrs[i].addAttribute(keyId);
        }
        for (i = keys.length; i < certs.length; ++i) {
            FriendlyName friendlyName = new FriendlyName(((X509Certificate)certs[i]).getSubjectName().toString());
            if (certAttrs[i] == null) {
                certAttrs[i] = new X501Attributes();
            }
            if (certAttrs[i].getAttributeByType(3) != null) continue;
            certAttrs[i].addAttribute(friendlyName);
        }
    }

    private byte[] createLocalId(int i) {
        return BigInteger.valueOf(i).toByteArray();
    }

    private boolean validOption(int option) {
        for (int i = 0; i < POSSIBLE_OPTIONS.length; ++i) {
            if (option != POSSIBLE_OPTIONS[i]) continue;
            return true;
        }
        return false;
    }
}

