/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.pkcs12;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.certj.pkcs12.PKCS12Exception;
import com.rsa.certj.pkcs12.SafeObjects;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.random.RandomException;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_IVException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.Serializable;
import java.util.Vector;

final class SafeContents
implements Cloneable,
Serializable {
    private SafeObjects safeObjects;
    private DatabaseService theDatabase;
    private static final int TYPE_KEY_BAG = 1;
    private static final int TYPE_PKCS8SHROUDEDKEY_BAG = 2;
    private static final int TYPE_CERT_BAG = 3;
    private static final int TYPE_CRL_BAG = 4;
    private static final int TYPE_SECRET_BAG = 5;
    private static final int TYPE_SAFECONTENTS_BAG = 6;
    private static final byte[] KEY_BAG_OID = new byte[]{42, -122, 72, -122, -9, 13, 1, 12, 10, 1, 1};
    private static final byte[] SHROUDED_KEY_BAG_OID = new byte[]{42, -122, 72, -122, -9, 13, 1, 12, 10, 1, 2};
    private static final byte[] CERT_BAG_OID = new byte[]{42, -122, 72, -122, -9, 13, 1, 12, 10, 1, 3};
    private static final byte[] CRL_BAG_OID = new byte[]{42, -122, 72, -122, -9, 13, 1, 12, 10, 1, 4};
    private static final byte[] X509_CERT_TYPE_OID = new byte[]{42, -122, 72, -122, -9, 13, 1, 9, 22, 1};
    private static final byte[] X509_CRL_TYPE_OID = new byte[]{42, -122, 72, -122, -9, 13, 1, 9, 23, 1};
    private static final byte[] EMPTY_SET = new byte[]{49, 0};
    private static final int SALT_LEN = 8;

    SafeContents() {
    }

    SafeContents(CertJ certJ, DatabaseService database, SafeObjects objects, char[] password, byte[] safeContentsBer, int offset, int special) throws PKCS12Exception {
        this.safeObjects = objects;
        this.theDatabase = database;
        this.decodeSafeContents(certJ, password, safeContentsBer, special);
    }

    SafeContents(SafeObjects objects) throws PKCS12Exception {
        this.safeObjects = objects;
    }

    byte[] derEncode(CertJ certJ, String encAlg, char[] password, int option) throws PKCS12Exception {
        ASN1Template[] bags = this.collectBags(certJ, encAlg, password, option);
        if (bags == null || bags.length == 0) {
            throw new PKCS12Exception("SafeContents.derEncode: No bag to be exported.");
        }
        int dataLen = 0;
        try {
            for (int i = 0; i < bags.length; ++i) {
                dataLen += bags[i].derEncodeInit();
            }
            int tag = 48;
            int tagLen = ASN1Lengths.getTagLen((int)tag);
            int headerLen = ASN1Lengths.getLengthLen((int)dataLen) + tagLen;
            byte[] der = new byte[headerLen + dataLen];
            ASN1Lengths.writeTag((byte[])der, (int)0, (int)tag);
            ASN1Lengths.writeLength((byte[])der, (int)tagLen, (int)dataLen);
            int offset = headerLen;
            for (int i = 0; i < bags.length; ++i) {
                offset += bags[i].derEncode(der, offset);
            }
            return der;
        }
        catch (ASN_Exception e) {
            throw new PKCS12Exception("SafeContents.derEncode: Encoding a bag failed.", (Exception)((Object)e));
        }
    }

    private void decodeSafeContents(CertJ certJ, char[] password, byte[] safeContentsBer, int special) throws PKCS12Exception {
        try {
            OfContainer seqOf = new OfContainer(special, 12288, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] safeDef = new ASN1Container[]{seqOf};
            ASN1.berDecode((byte[])safeContentsBer, (int)0, (ASN1Container[])safeDef);
            for (int indx = 0; indx < seqOf.getContainerCount(); ++indx) {
                this.decodeSafeBag(certJ, password, seqOf.containerAt((int)indx).data, seqOf.containerAt((int)indx).dataOffset);
            }
        }
        catch (ASN_Exception asnException) {
            throw new PKCS12Exception("Cannot decode the BER of the SafeContents.");
        }
    }

    private void decodeSafeBag(CertJ certJ, char[] password, byte[] safeBagBer, int offset) throws PKCS12Exception {
        try {
            SequenceContainer aSeq = new SequenceContainer(0);
            EndContainer anEnd = new EndContainer();
            OIDContainer bagId = new OIDContainer(0x1000000);
            EncodedContainer bagValue = new EncodedContainer(10616576);
            EncodedContainer bagAttributes = new EncodedContainer(78080, true, 0, null, 0, 0);
            ASN1Container[] safeContentsDef = new ASN1Container[]{aSeq, bagId, bagValue, bagAttributes, anEnd};
            ASN1.berDecode((byte[])safeBagBer, (int)offset, (ASN1Container[])safeContentsDef);
            X501Attributes x501attrs = null;
            if (bagAttributes.dataPresent && bagAttributes.dataLen > 2) {
                x501attrs = new X501Attributes(bagAttributes.data, bagAttributes.dataOffset, 0);
                for (int indx = 0; indx < x501attrs.getAttributeCount(); ++indx) {
                    x501attrs.getAttributeByIndex(indx);
                }
            }
            int bagType = bagId.data[bagId.dataOffset + bagId.dataLen - 1] & 0xFFFFFFFF;
            int skipBytes = 1;
            int bagStart = bagValue.dataOffset + (skipBytes += ASN1Lengths.determineLengthLen((byte[])bagValue.data, (int)(bagValue.dataOffset + 1)));
            switch (bagType) {
                case 1: {
                    this.safeObjects.keyAttributes.addElement(x501attrs);
                    this.decodeKeyBag(certJ, bagValue.data, bagStart);
                    break;
                }
                case 2: {
                    this.safeObjects.keyAttributes.addElement(x501attrs);
                    this.decodeShroudedKeyBag(password, certJ, bagValue.data, bagStart);
                    break;
                }
                case 3: {
                    this.safeObjects.certAttributes.addElement(x501attrs);
                    this.decodeCertBag(bagValue.data, bagStart);
                    break;
                }
                case 4: {
                    this.safeObjects.crlAttributes.addElement(x501attrs);
                    this.decodeCRLBag(certJ, bagValue.data, bagStart);
                    break;
                }
                case 5: {
                    throw new PKCS12Exception("Secret Bag is not implemented yet");
                }
                case 6: {
                    this.decodeSafeContents(certJ, password, bagValue.data, 0xA0FF00);
                    break;
                }
                default: {
                    throw new PKCS12Exception("Illegal BagType found");
                }
            }
        }
        catch (AttributeException attrException) {
            throw new PKCS12Exception(attrException);
        }
        catch (ASN_Exception asnException) {
            throw new PKCS12Exception("Cannot decode the BER of the SafeContents.");
        }
    }

    private void decodeCertBag(byte[] certBagBer, int certOffset) throws PKCS12Exception {
        try {
            SequenceContainer bSeq = new SequenceContainer(0);
            EndContainer bEnd = new EndContainer();
            OIDContainer certType = new OIDContainer(0x1000000);
            EncodedContainer certValue = new EncodedContainer(10616576);
            ASN1Container[] certBagDef = new ASN1Container[]{bSeq, certType, certValue, bEnd};
            ASN1.berDecode((byte[])certBagBer, (int)certOffset, (ASN1Container[])certBagDef);
            OctetStringContainer cert = new OctetStringContainer(0);
            ASN1Container[] certValueDef = new ASN1Container[]{cert};
            int skipBytes = 1;
            ASN1.berDecode((byte[])certValue.data, (int)(certValue.dataOffset + (skipBytes += ASN1Lengths.determineLengthLen((byte[])certValue.data, (int)(certValue.dataOffset + 1)))), (ASN1Container[])certValueDef);
            X509Certificate x509 = new X509Certificate(cert.data, cert.dataOffset, 0);
            this.safeObjects.getCertificates().addElement(x509);
            if (this.theDatabase != null) {
                this.theDatabase.insertCertificate(x509);
            }
        }
        catch (NoServiceException certjException) {
            throw new PKCS12Exception(certjException);
        }
        catch (DatabaseException dbException) {
            throw new PKCS12Exception(dbException);
        }
        catch (CertificateException certException) {
            throw new PKCS12Exception(certException);
        }
        catch (ASN_Exception asnException) {
            throw new PKCS12Exception("Cannot decode the BER of the CertBag.");
        }
    }

    private void decodeCRLBag(CertJ certJ, byte[] crlBagBer, int crlOffset) throws PKCS12Exception {
        try {
            SequenceContainer bSeq = new SequenceContainer(0);
            EndContainer bEnd = new EndContainer();
            OIDContainer crlType = new OIDContainer(0x1000000);
            EncodedContainer crlValue = new EncodedContainer(10616576);
            ASN1Container[] crlBagDef = new ASN1Container[]{bSeq, crlType, crlValue, bEnd};
            ASN1.berDecode((byte[])crlBagBer, (int)crlOffset, (ASN1Container[])crlBagDef);
            OctetStringContainer crl = new OctetStringContainer(0, true, 0, null, 0, 0);
            ASN1Container[] crlValueDef = new ASN1Container[]{crl};
            int skipBytes = 1;
            ASN1.berDecode((byte[])crlValue.data, (int)(crlValue.dataOffset + (skipBytes += ASN1Lengths.determineLengthLen((byte[])crlValue.data, (int)(crlValue.dataOffset + 1)))), (ASN1Container[])crlValueDef);
            X509CRL x509 = new X509CRL(crl.data, crl.dataOffset, 0);
            this.safeObjects.getCrls().addElement(x509);
            DatabaseService database = (DatabaseService)certJ.bindServices(1);
            if (database != null) {
                database.insertCRL(x509);
            }
        }
        catch (InvalidParameterException certjException) {
            throw new PKCS12Exception(certjException);
        }
        catch (ProviderManagementException certjException) {
            throw new PKCS12Exception(certjException);
        }
        catch (NoServiceException certjException) {
            throw new PKCS12Exception(certjException);
        }
        catch (DatabaseException dbException) {
            throw new PKCS12Exception(dbException);
        }
        catch (CertificateException certException) {
            throw new PKCS12Exception(certException);
        }
        catch (ASN_Exception asnException) {
            throw new PKCS12Exception("Cannot decode the BER of the CertBag.");
        }
    }

    private void decodeShroudedKeyBag(char[] password, CertJ certJ, byte[] keyBagBer, int keyOffset) throws PKCS12Exception {
        try {
            JSAFE_SymmetricCipher decryptor = JSAFEFactory.getSymmetricCipher(keyBagBer, keyOffset, certJ.getDevice(), certJ);
            JSAFE_SecretKey secretKey = decryptor.getBlankKey();
            secretKey.setPassword(password, 0, password.length);
            byte[] unwrappedKey = SafeContents.unwrapBER(keyBagBer, keyOffset, decryptor, secretKey);
            JSAFE_PrivateKey privateKey = JSAFE_PrivateKey.getInstance((byte[])unwrappedKey, (int)0, (String)"Java");
            this.safeObjects.getKeys().addElement(privateKey);
        }
        catch (JSAFE_InvalidParameterException jsafeException) {
            throw new PKCS12Exception((Exception)((Object)jsafeException));
        }
        catch (JSAFE_UnimplementedException jsafeException) {
            throw new PKCS12Exception((Exception)((Object)jsafeException));
        }
        catch (JSAFE_IVException jsafeException) {
            throw new PKCS12Exception((Exception)((Object)jsafeException));
        }
    }

    private static byte[] unwrapBER(byte[] wrapped, int wrappedOffset, JSAFE_SymmetricCipher cipher, JSAFE_SecretKey unwrappingKey) throws PKCS12Exception {
        int[] encKeyInfo = SafeContents.getEncryptedKeyInfo(wrapped, wrappedOffset);
        int offset = encKeyInfo[0];
        int keyLen = encKeyInfo[1];
        try {
            cipher.decryptInit(unwrappingKey);
            byte[] plain1 = cipher.decryptUpdate(wrapped, offset, keyLen);
            byte[] plain2 = cipher.decryptFinal();
            byte[] result = new byte[plain1.length + plain2.length];
            System.arraycopy(plain1, 0, result, 0, plain1.length);
            System.arraycopy(plain2, 0, result, plain1.length, plain2.length);
            return result;
        }
        catch (JSAFE_Exception e) {
            throw new PKCS12Exception((Exception)((Object)e));
        }
    }

    private static int[] getEncryptedKeyInfo(byte[] pkcs8Key, int offset) throws PKCS12Exception {
        SequenceContainer aSeq = new SequenceContainer(0);
        EndContainer anEnd = new EndContainer();
        EncodedContainer encAlgID = new EncodedContainer(12288);
        OctetStringContainer encData = new OctetStringContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{aSeq, encAlgID, encData, anEnd};
        try {
            ASN1.berDecode((byte[])pkcs8Key, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnExc) {
            throw new PKCS12Exception("Cannot build the PKCS #8 encrypted key. (" + asnExc.getMessage() + ")");
        }
        return new int[]{encData.dataOffset, encData.dataLen};
    }

    private void decodeKeyBag(CertJ certJ, byte[] keyBagBer, int keyOffset) throws PKCS12Exception {
        try {
            JSAFE_PrivateKey privateKey = JSAFEFactory.getPrivateKey(keyBagBer, keyOffset, certJ.getDevice(), certJ);
            this.safeObjects.getKeys().addElement(privateKey);
        }
        catch (JSAFE_Exception jsafeException) {
            throw new PKCS12Exception((Exception)((Object)jsafeException));
        }
    }

    private ASN1Template[] collectBags(CertJ certJ, String encAlg, char[] password, int option) throws PKCS12Exception {
        X501Attributes attrs;
        int i;
        Vector<Certificate> certs = this.safeObjects.getCertificates();
        Vector<CRL> crls = this.safeObjects.getCrls();
        Vector<JSAFE_PrivateKey> keys = this.safeObjects.getKeys();
        Vector<String> keyFormats = this.safeObjects.getKeyFormats();
        Vector<X501Attributes> certAttrs = this.safeObjects.certAttributes;
        Vector<X501Attributes> crlAttrs = this.safeObjects.crlAttributes;
        Vector<X501Attributes> keyAttrs = this.safeObjects.keyAttributes;
        int certCount = certs.size();
        int crlCount = crls.size();
        int keyCount = keys.size();
        int certAttrsCount = certAttrs.size();
        int crlAttrsCount = crlAttrs.size();
        int keyAttrsCount = keyAttrs.size();
        int keyFormatsCount = keyFormats.size();
        ASN1Template[] bags = new ASN1Template[certCount + crlCount + keyCount];
        for (i = 0; i < certCount; ++i) {
            attrs = null;
            if (certAttrsCount > i) {
                attrs = certAttrs.elementAt(i);
            }
            bags[i] = this.createSafeBagTemplate(CERT_BAG_OID, this.encodeCertBag(certs.elementAt(i)), attrs);
        }
        for (i = 0; i < crlCount; ++i) {
            attrs = null;
            if (crlAttrsCount > i) {
                attrs = crlAttrs.elementAt(i);
            }
            bags[certCount + i] = this.createSafeBagTemplate(CRL_BAG_OID, this.encodeCRLBag(crls.elementAt(i)), attrs);
        }
        byte[] oid = option == 2 ? SHROUDED_KEY_BAG_OID : KEY_BAG_OID;
        for (int i2 = 0; i2 < keyCount; ++i2) {
            X501Attributes attrs2 = null;
            if (keyAttrsCount > i2) {
                attrs2 = keyAttrs.elementAt(i2);
            }
            JSAFE_PrivateKey key = keys.elementAt(i2);
            String keyFormat = null;
            if (keyFormatsCount > i2) {
                keyFormat = keyFormats.elementAt(i2);
            }
            byte[] encoding = option == 2 ? this.encodeShroudedKeyBag(certJ, key, encAlg, password, keyFormat) : this.encodeKeyBag(key, keyFormat);
            bags[certCount + crlCount + i2] = this.createSafeBagTemplate(oid, encoding, attrs2);
        }
        return bags;
    }

    private ASN1Template createSafeBagTemplate(byte[] oid, byte[] valueEncoding, X501Attributes attrs) throws PKCS12Exception {
        byte[] attrsEncoding = this.encodeAttributes(attrs);
        try {
            SequenceContainer aSeq = new SequenceContainer(0, true, 0);
            EndContainer anEnd = new EndContainer();
            OIDContainer bagId = new OIDContainer(0x1000000, true, 0, oid, 0, oid.length);
            EncodedContainer bagValue = new EncodedContainer(0, true, 0, valueEncoding, 0, valueEncoding.length);
            EncodedContainer bagAttributes = new EncodedContainer(0, true, 0, attrsEncoding, 0, attrsEncoding.length);
            ASN1Container[] def = new ASN1Container[]{aSeq, bagId, bagValue, bagAttributes, anEnd};
            return new ASN1Template(def);
        }
        catch (ASN_Exception e) {
            throw new PKCS12Exception("SafeContents.createSafeBagTemplate: ", (Exception)((Object)e));
        }
    }

    private byte[] encodeCertBag(Certificate cert) throws PKCS12Exception {
        if (!(cert instanceof X509Certificate)) {
            throw new PKCS12Exception("SafeContents.encodeCertBag: Unknown certificate type.");
        }
        X509Certificate x509cert = (X509Certificate)cert;
        int certLen = x509cert.getDERLen(0);
        try {
            SequenceContainer aSeq = new SequenceContainer(0xA00000, true, 0);
            EndContainer anEnd = new EndContainer();
            OIDContainer certId = new OIDContainer(0x1000000, true, 0, X509_CERT_TYPE_OID, 0, X509_CERT_TYPE_OID.length);
            OctetStringContainer certValue = new OctetStringContainer(0xA10000, true, 0, null, 0, certLen);
            ASN1Container[] def = new ASN1Container[]{aSeq, certId, certValue, anEnd};
            ASN1Template template = new ASN1Template(def);
            int derLen = template.derEncodeInit();
            byte[] der = new byte[derLen];
            int offset = template.derEncode(der, 0);
            x509cert.getDEREncoding(der, offset, 0);
            return der;
        }
        catch (ASN_Exception e) {
            throw new PKCS12Exception("SafeContents.encodeCertBag: DER encoding of CertBag failed.", (Exception)((Object)e));
        }
        catch (CertificateException e) {
            throw new PKCS12Exception("SafeContents.encodeCertBag: DER encoding of X509Certificate failed.", e);
        }
    }

    private byte[] encodeCRLBag(CRL crl) throws PKCS12Exception {
        if (!(crl instanceof X509CRL)) {
            throw new PKCS12Exception("SafeContents.encodeCRLBag: Unknown CRL type.");
        }
        X509CRL x509crl = (X509CRL)crl;
        int crlLen = x509crl.getDERLen(0);
        try {
            SequenceContainer aSeq = new SequenceContainer(0xA00000, true, 0);
            EndContainer anEnd = new EndContainer();
            OIDContainer crlId = new OIDContainer(0x1000000, true, 0, X509_CRL_TYPE_OID, 0, X509_CRL_TYPE_OID.length);
            OctetStringContainer crlValue = new OctetStringContainer(0xA10000, true, 0, null, 0, crlLen);
            ASN1Container[] def = new ASN1Container[]{aSeq, crlId, crlValue, anEnd};
            ASN1Template template = new ASN1Template(def);
            int derLen = template.derEncodeInit();
            byte[] der = new byte[derLen];
            int offset = template.derEncode(der, 0);
            x509crl.getDEREncoding(der, offset, 0);
            return der;
        }
        catch (ASN_Exception e) {
            throw new PKCS12Exception("SafeContents.encodeCRLBag: DER encoding of CRLBag failed.", (Exception)((Object)e));
        }
        catch (CertificateException e) {
            throw new PKCS12Exception("SafeContents.encodeCRLBag: DER encoding of X509CRL failed.", e);
        }
    }

    private byte[] encodeKeyBag(JSAFE_PrivateKey key, String format) throws PKCS12Exception {
        byte[] privateKeyInfo = null;
        if (format == null) {
            String[] formats = key.getSupportedGetFormats();
            String preferredFormat = null;
            for (int i = 0; i < formats.length; ++i) {
                if (formats[i].endsWith("X957BER")) {
                    preferredFormat = formats[i];
                    break;
                }
                if (preferredFormat != null || !formats[i].endsWith("BER")) continue;
                preferredFormat = formats[i];
            }
            if (preferredFormat != null) {
                try {
                    privateKeyInfo = key.getKeyData(preferredFormat)[0];
                }
                catch (JSAFE_Exception e) {
                    throw new PKCS12Exception("SafeContents.encodeKeyBag: getKeyData failed.", (Exception)((Object)e));
                }
            }
        } else if (format.endsWith("BER")) {
            try {
                privateKeyInfo = key.getKeyData(format)[0];
            }
            catch (JSAFE_Exception e) {
                throw new PKCS12Exception("SafeContents.encodeKeyBag: getKeyData failed.", (Exception)((Object)e));
            }
        } else {
            throw new PKCS12Exception("SafeContents.encodeKeyBag: getKeyData failed(Wrong key format).");
        }
        if (privateKeyInfo == null) {
            throw new PKCS12Exception("SafeContents.encodeKeyBag: No BER format found for private key.");
        }
        return this.addContextExplicitHeader(privateKeyInfo);
    }

    private byte[] encodeShroudedKeyBag(CertJ certJ, JSAFE_PrivateKey key, String encAlg, char[] password, String format) throws PKCS12Exception {
        JSAFE_SymmetricCipher encryptor = null;
        try {
            encryptor = JSAFEFactory.getSymmetricCipher(encAlg, certJ.getDevice(), certJ);
            JSAFE_SecureRandom random = certJ.getRandomObject();
            byte[] salt = new byte[8];
            random.generateRandomBytes(salt, 0, 8);
            encryptor.setSalt(salt, 0, 8);
            JSAFE_SecretKey secretKey = encryptor.getBlankKey();
            secretKey.setPassword(password, 0, password.length);
            encryptor.encryptInit(secretKey);
            byte[] byArray = this.addContextExplicitHeader(encryptor.wrapPrivateKey(key, true, format));
            return byArray;
        }
        catch (JSAFE_Exception e) {
            throw new PKCS12Exception("SafeContents.encodeShroudedKeyBag: Key wrapping failed.", (Exception)((Object)e));
        }
        catch (NoServiceException e) {
            throw new PKCS12Exception("SafeContents.encodeShroudedKeyBag: Random provider not found.", e);
        }
        catch (RandomException e) {
            throw new PKCS12Exception("SafeContents.encodeShroudedKeyBag: Random provider failed.", e);
        }
        finally {
            if (encryptor != null) {
                encryptor.clearSensitiveData();
            }
        }
    }

    private byte[] addContextExplicitHeader(byte[] data) throws PKCS12Exception {
        int tag = 0xA00000;
        int tagLen = 1;
        int dataLen = data.length;
        try {
            int headerLen = ASN1Lengths.getLengthLen((int)dataLen) + tagLen;
            byte[] der = new byte[headerLen + dataLen];
            ASN1Lengths.writeTag((byte[])der, (int)0, (int)tag);
            ASN1Lengths.writeLength((byte[])der, (int)tagLen, (int)dataLen);
            System.arraycopy(data, 0, der, headerLen, dataLen);
            return der;
        }
        catch (ASN_Exception e) {
            throw new PKCS12Exception("SafeContents.addContextExplicitHeader: ", (Exception)((Object)e));
        }
    }

    private byte[] encodeAttributes(X501Attributes attrs) throws PKCS12Exception {
        if (attrs == null || attrs.getAttributeCount() == 0) {
            return EMPTY_SET;
        }
        try {
            byte[] der = new byte[attrs.getDERLen(0)];
            attrs.getDEREncoding(der, 0, 0);
            return der;
        }
        catch (AttributeException e) {
            throw new PKCS12Exception("SafeContents.encodeAttributes: DER encoding of X509Attributes failed.", e);
        }
    }
}

