/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.pkcs12;

import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.attributes.FriendlyName;
import com.rsa.certj.cert.attributes.LocalKeyID;
import com.rsa.certj.cert.attributes.X501Attribute;
import com.rsa.certj.pkcs12.PKCS12Exception;
import com.rsa.jsafe.JSAFE_PrivateKey;
import java.io.Serializable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SafeObjects
implements Cloneable,
Serializable {
    Vector<X501Attributes> certAttributes = new Vector();
    Vector<X501Attributes> keyAttributes = new Vector();
    Vector<X501Attributes> crlAttributes = new Vector();
    private Vector<Certificate> certificates = new Vector();
    private Vector<JSAFE_PrivateKey> keys = new Vector();
    private Vector<CRL> crls = new Vector();
    private Vector<String> keysFormats = new Vector();

    SafeObjects() {
    }

    SafeObjects(Certificate[] certArray, CRL[] crlArray, JSAFE_PrivateKey[] keyArray, X501Attributes[] certAttrs, X501Attributes[] crlAttrs, X501Attributes[] keyAttrs, String[] keyFormats) {
        int i;
        if (certArray != null) {
            for (i = 0; i < certArray.length; ++i) {
                this.certificates.addElement(certArray[i]);
                if (certAttrs == null || i >= certAttrs.length) {
                    this.certAttributes.addElement(null);
                    continue;
                }
                this.certAttributes.addElement(certAttrs[i]);
            }
        }
        if (crlArray != null) {
            for (i = 0; i < crlArray.length; ++i) {
                this.crls.addElement(crlArray[i]);
                if (crlAttrs == null || i >= crlAttrs.length) {
                    this.crlAttributes.addElement(null);
                    continue;
                }
                this.crlAttributes.addElement(crlAttrs[i]);
            }
        }
        if (keyArray != null) {
            for (i = 0; i < keyArray.length; ++i) {
                this.keys.addElement(keyArray[i]);
                if (keyAttrs == null || i >= keyAttrs.length) {
                    this.keyAttributes.addElement(null);
                } else {
                    this.keyAttributes.addElement(keyAttrs[i]);
                }
                if (keyFormats == null || i >= keyFormats.length) {
                    this.keysFormats.addElement(null);
                    continue;
                }
                this.keysFormats.addElement(keyFormats[i]);
            }
        }
    }

    X509Certificate findCertificateForKey(X501Attributes keyAttrs) throws PKCS12Exception {
        try {
            for (int indx = 0; indx < this.certAttributes.size(); ++indx) {
                X501Attributes certAttrs = this.certAttributes.elementAt(indx);
                if (certAttrs == null || !this.matchAttributes(keyAttrs, certAttrs)) continue;
                return (X509Certificate)this.certificates.elementAt(indx);
            }
            throw new PKCS12Exception("No Certificate found for Private Key");
        }
        catch (Exception exception) {
            throw new PKCS12Exception(exception);
        }
    }

    boolean matchAttributes(X501Attributes keyAttrs, X501Attributes certAttrs) throws PKCS12Exception {
        try {
            for (int indx = 0; indx < keyAttrs.getAttributeCount(); ++indx) {
                X501Attribute keyAttr = keyAttrs.getAttributeByIndex(indx);
                block7: for (int index = 0; index < certAttrs.getAttributeCount(); ++index) {
                    X501Attribute certAttr = certAttrs.getAttributeByIndex(index);
                    if (keyAttr.getAttributeType() != certAttr.getAttributeType()) continue;
                    int attrType = keyAttr.getAttributeType();
                    switch (attrType) {
                        case 3: {
                            FriendlyName keyName = (FriendlyName)keyAttr;
                            FriendlyName certName = (FriendlyName)certAttr;
                            if (!keyName.getFriendlyName().equals(certName.getFriendlyName())) continue block7;
                            return true;
                        }
                        case 4: {
                            LocalKeyID keyLocal = (LocalKeyID)keyAttr;
                            LocalKeyID certLocal = (LocalKeyID)certAttr;
                            byte[] keyID = keyLocal.getLocalKeyID();
                            byte[] certID = certLocal.getLocalKeyID();
                            if (keyID.length != certID.length) continue block7;
                            for (int indx1 = 0; indx1 < certID.length && keyID[indx1] == certID[indx1]; ++indx1) {
                            }
                            return true;
                        }
                    }
                }
            }
            return false;
        }
        catch (Exception exception) {
            throw new PKCS12Exception(exception);
        }
    }

    Vector<Certificate> getCertificates() {
        return this.certificates;
    }

    Vector<CRL> getCrls() {
        return this.crls;
    }

    Vector<JSAFE_PrivateKey> getKeys() {
        return this.keys;
    }

    Vector<X501Attributes> getCertsAttributes() {
        return this.certAttributes;
    }

    Vector<X501Attributes> getKeysAttributes() {
        return this.keyAttributes;
    }

    Vector<X501Attributes> getCrlsAttributes() {
        return this.crlAttributes;
    }

    Vector<String> getKeyFormats() {
        return this.keysFormats;
    }
}

