/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.pkcs7;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.certj.CertJ;
import com.rsa.certj.pkcs7.CMSData;
import com.rsa.certj.pkcs7.ContentInfo;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.certj.pkcs7.Pkcs7Util;
import com.rsa.certj.pkcs7.SignedData;
import com.rsa.certj.spi.path.CertPathCtx;
import java.util.Arrays;
import java.util.Vector;

public class CMSSignedData
extends SignedData {
    public CMSSignedData(String dottedOID, CertJ certJ, CertPathCtx pathCtx) throws PKCS7Exception {
        super(certJ, pathCtx);
        this.oid = Pkcs7Util.oidStrToArray(dottedOID);
        this.version = 3;
    }

    protected ContentInfo buildContentContainer(byte[] data, int offset, int len) throws PKCS7Exception {
        return new CMSData(this.oid);
    }

    protected byte[] initOctets(ASN1Container oid, ASN1Container encContent) throws ASN_Exception {
        return this.initDataOctets(oid, encContent);
    }

    public void setVersionNumber(int versionNumber) {
        this.version = 3;
    }

    protected byte[] getOidType() {
        return this.oid;
    }

    protected void assignDetachedMessageContentInfoSeq() {
        int oidLen = this.oid.length;
        this.contentEncoding = new byte[oidLen + 4];
        this.contentEncoding[0] = 48;
        this.contentEncoding[1] = (byte)(oidLen + 2);
        this.contentEncoding[2] = 6;
        this.contentEncoding[3] = (byte)oidLen;
        System.arraycopy(this.oid, 0, this.contentEncoding, 4, oidLen);
    }

    public Object clone() throws CloneNotSupportedException {
        CMSSignedData otherSelf = (CMSSignedData)super.clone();
        otherSelf.oid = this.oid;
        return otherSelf;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CMSSignedData)) {
            return false;
        }
        CMSSignedData other = (CMSSignedData)obj;
        if (this.oid.length != other.oid.length) {
            return false;
        }
        for (int i = 0; i < this.oid.length; ++i) {
            if (this.oid[i] == other.oid[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(this.oid);
        return result;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.version = 3;
        this.digestIDs = new Vector();
        this.digestNames = new Vector();
        this.digests = new Vector();
        this.certs = new Vector();
        this.crls = new Vector();
        this.signers = new Vector();
    }
}

