/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.pkcs7;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.pkcs7.CMSData;
import com.rsa.certj.pkcs7.CMSSignedData;
import com.rsa.certj.pkcs7.Data;
import com.rsa.certj.pkcs7.DigestedData;
import com.rsa.certj.pkcs7.EncryptedData;
import com.rsa.certj.pkcs7.EnvelopedData;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.certj.pkcs7.SignedData;
import com.rsa.certj.spi.path.CertPathCtx;
import java.io.Serializable;

public abstract class ContentInfo
implements Cloneable,
Serializable {
    public static final int DATA = 1;
    public static final int SIGNED_DATA = 2;
    public static final int ENVELOPED_DATA = 3;
    public static final int DIGESTED_DATA = 5;
    public static final int ENCRYPTED_DATA = 6;
    public static final int NO_CONTENT = 0;
    public static final int CMS_DATA = 11;
    public static final int CMS_SIGNED_DATA = 22;
    public static final int PKCS7_VERSION_NUMBER_0 = 0;
    public static final int PKCS7_VERSION_NUMBER_1 = 1;
    public static final int CMS_VERSION_NUMBER_3 = 3;
    static final byte[] P7OID = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 0};
    static final int P7OID_LEN = 9;
    protected static final int ENCODE = 0;
    protected static final int DECODE = 1;
    protected int contentType;
    protected int maxBufferSize;
    protected ContentInfo content;
    protected CertPathCtx theCertPathCtx;
    protected CertJ theCertJ;
    protected ASN1Container[] contentASN1Def;
    protected ASN1Template contentASN1Template;
    private ASN1Container[] contentInfoASN1Def;
    protected ASN1Template contentInfoASN1Template;
    protected int derLen = 0;
    protected int numberOfBytesRead;
    protected String theDevice;
    protected String[] theDeviceList;
    protected byte[] internalBuffer;
    protected int internalOffset;
    protected int internalBufferLen;
    protected byte[] contentInfoEncoding;
    protected int incompleteContainer;
    protected byte[] contentEncoding;
    protected int flag;
    protected byte[] oid;
    private static final String UNKNOWN_OID_FOUND = "Cannot build PKCS #7 content object: unknown OID.";

    protected ContentInfo() {
    }

    public static ContentInfo getInstance(int type, CertJ certJ, CertPathCtx pathCtx) throws PKCS7Exception {
        switch (type) {
            case 1: {
                return new Data();
            }
            case 2: {
                return new SignedData(certJ, pathCtx);
            }
            case 3: {
                return new EnvelopedData(certJ, pathCtx);
            }
            case 5: {
                return new DigestedData(certJ, pathCtx);
            }
            case 6: {
                return new EncryptedData(certJ, pathCtx);
            }
        }
        throw new PKCS7Exception("Cannot build PKCS #7 content object: unknown type.");
    }

    public static ContentInfo getInstance(int type, String dottedOID, CertJ certJ, CertPathCtx pathCtx) throws PKCS7Exception {
        switch (type) {
            case 11: {
                return new CMSData(dottedOID);
            }
            case 22: {
                return new CMSSignedData(dottedOID, certJ, pathCtx);
            }
        }
        throw new PKCS7Exception("Cannot build CMS content object: unknown type.");
    }

    public static ContentInfo getInstance(byte[] oid, int offset, int oidLen, CertJ certJ, CertPathCtx pathCtx) throws PKCS7Exception {
        if (oid == null || oidLen <= 0) {
            throw new PKCS7Exception("Cannot build PKCS #7 content object: OID is null.");
        }
        if (offset < 0 || offset + oidLen > oid.length) {
            throw new PKCS7Exception("Invalid content type.");
        }
        if (oidLen != 9) {
            throw new PKCS7Exception(UNKNOWN_OID_FOUND);
        }
        for (int index = 0; index < 7; ++index) {
            if (oid[index + offset] == P7OID[index]) continue;
            throw new PKCS7Exception(UNKNOWN_OID_FOUND);
        }
        int lastByte = oid[oidLen + offset - 1] & 0xFF;
        switch (lastByte) {
            case 1: {
                return new Data();
            }
            case 2: {
                return new SignedData(certJ, pathCtx);
            }
            case 3: {
                return new EnvelopedData(certJ, pathCtx);
            }
            case 5: {
                return new DigestedData(certJ, pathCtx);
            }
            case 6: {
                return new EncryptedData(certJ, pathCtx);
            }
        }
        throw new PKCS7Exception(UNKNOWN_OID_FOUND);
    }

    public static int getMessageType(byte[] data, int offset, int len) throws PKCS7Exception {
        return ContentInfo.getMessageType(data, offset, len, 0);
    }

    public static int getMessageType(byte[] data, int offset, int len, int special) throws PKCS7Exception {
        if (data == null || len <= 0) {
            throw new PKCS7Exception("Cannot read the message: data is null.");
        }
        if (offset < 0 || offset + len > data.length) {
            throw new PKCS7Exception("Invalid message data");
        }
        try {
            SequenceContainer seq = new SequenceContainer(special);
            EndContainer anEnd = new EndContainer();
            OIDContainer oid = new OIDContainer(0x1000000);
            EncodedContainer encContent = new EncodedContainer(10616576);
            ASN1Container[] asn1Def = new ASN1Container[]{seq, oid, encContent, anEnd};
            ASN1Template asn1Template = new ASN1Template(asn1Def);
            asn1Template.berDecodeInit();
            asn1Template.berDecodeUpdate(data, offset, len);
            if (!asn1Def[1].isComplete()) {
                return -1;
            }
            if (asn1Def[1].dataLen != 9) {
                throw new PKCS7Exception("Unknown OID.");
            }
            return asn1Def[1].data[asn1Def[1].dataOffset + asn1Def[1].dataLen - 1];
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Cannot read message: ", (Exception)((Object)asnException));
        }
    }

    public void setDevice(String device) {
        this.theDevice = device;
    }

    public String getDevice() {
        if (this.theDevice != null) {
            return this.theDevice;
        }
        if (this.theCertJ != null) {
            return this.theCertJ.getDevice();
        }
        return null;
    }

    protected String getDeviceOrJava() {
        String device = this.getDevice();
        if (device == null) {
            return "Java";
        }
        return device;
    }

    public String[] getDeviceList() {
        String[] returnValue = null;
        if (this.theDeviceList != null) {
            returnValue = new String[this.theDeviceList.length];
            System.arraycopy(this.theDeviceList, 0, returnValue, 0, this.theDeviceList.length);
        } else if (this.theDevice != null) {
            returnValue = new String[]{this.theDevice};
        } else if (this.theCertJ != null) {
            returnValue = new String[]{this.theCertJ.getDevice()};
        }
        return returnValue;
    }

    public int getContentType() {
        return this.contentType;
    }

    public void setCertJ(CertJ certJ) {
        this.theCertJ = certJ;
    }

    public void setCertPath(CertPathCtx pathCtx) {
        this.theCertPathCtx = pathCtx;
    }

    public ContentInfo getContent() {
        return this.content;
    }

    public int getContentInfoDERLen() throws PKCS7Exception {
        return this.getContentInfoDERLen(0);
    }

    public int estimateContentInfoDERLen() throws PKCS7Exception {
        return this.getContentInfoDERLen();
    }

    protected int estimateContentDERLen() throws PKCS7Exception {
        return this.getContentDERLen();
    }

    public int getContentInfoDERLen(int special) throws PKCS7Exception {
        this.contentInfoASN1Def = this.getASN1Containers(true, special);
        this.contentInfoASN1Template = new ASN1Template(this.contentInfoASN1Def);
        try {
            this.derLen = this.contentInfoASN1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception((Exception)((Object)asnException));
        }
        return this.derLen;
    }

    protected abstract int getContentDERLen() throws PKCS7Exception;

    public int writeMessage(byte[] output, int outOffset) throws PKCS7Exception {
        return this.writeMessage(output, outOffset, 0);
    }

    public int writeMessage(byte[] output, int outOffset, int special) throws PKCS7Exception {
        if (output == null || outOffset < 0 || output.length == 0) {
            throw new PKCS7Exception("Cannot write message: output array is null.");
        }
        int startOffset = outOffset;
        if (this.derLen == 0) {
            this.getContentInfoDERLen(special);
        }
        try {
            outOffset += this.contentInfoASN1Template.derEncode(output, outOffset);
            if (this.allowChangeContentTypeOIDLastByte()) {
                output[outOffset - 1] = (byte)this.contentType;
            }
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Cannot encode contentInfo: ", (Exception)((Object)asnException));
        }
        if (this.contentInfoEncoding != null) {
            System.arraycopy(this.contentInfoEncoding, 0, output, outOffset, this.contentInfoEncoding.length);
            outOffset += this.contentInfoEncoding.length;
        } else {
            outOffset += this.writeContent(output, outOffset);
        }
        this.derLen = 0;
        return outOffset - startOffset;
    }

    protected abstract int writeContent(byte[] var1, int var2) throws PKCS7Exception;

    public boolean readInit(byte[] input, int inOffset, int maxInputLen) throws PKCS7Exception {
        return this.readInit(input, inOffset, maxInputLen, 0);
    }

    public boolean readInit(byte[] input, int inOffset, int maxInputLen, int special) throws PKCS7Exception {
        return this.readInit(input, inOffset, maxInputLen, special, 0);
    }

    public boolean readInit(byte[] input, int inOffset, int maxInputLen, int special, int maxBufferSize) throws PKCS7Exception {
        if (input == null || maxInputLen <= 0) {
            throw new PKCS7Exception("Cannot read message: data is null.");
        }
        if (inOffset < 0 || inOffset + maxInputLen > input.length) {
            throw new PKCS7Exception("Invalid message data");
        }
        try {
            this.maxBufferSize = maxBufferSize;
            this.contentInfoASN1Def = this.getASN1Containers(false, special);
            this.contentInfoASN1Template = new ASN1Template(this.contentInfoASN1Def);
            this.contentInfoASN1Template.berDecodeInit();
            this.numberOfBytesRead = this.contentInfoASN1Template.berDecodeUpdate(input, inOffset, maxInputLen);
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Cannot read message: ", (Exception)((Object)asnException));
        }
        if (!this.contentInfoASN1Def[1].isComplete()) {
            return false;
        }
        this.contentInfoEncoding = new byte[this.contentInfoASN1Def[2].dataLen];
        if (this.contentInfoEncoding.length > 0) {
            System.arraycopy(this.contentInfoASN1Def[2].data, this.contentInfoASN1Def[2].dataOffset, this.contentInfoEncoding, 0, this.contentInfoASN1Def[2].dataLen);
            this.contentReadInit(this.contentInfoASN1Def[2].data, this.contentInfoASN1Def[2].dataOffset, this.contentInfoASN1Def[2].dataLen);
        }
        return true;
    }

    protected abstract boolean contentReadInit(byte[] var1, int var2, int var3) throws PKCS7Exception;

    public int readUpdate(byte[] input, int inOffset, int maxInputLen) throws PKCS7Exception {
        if (input == null || maxInputLen <= 0) {
            throw new PKCS7Exception("Cannot read message: data is null.");
        }
        if (inOffset < 0 || inOffset + maxInputLen > input.length) {
            throw new PKCS7Exception("Invalid message data");
        }
        if (this.contentInfoASN1Template == null) {
            throw new PKCS7Exception("Need to call readInit() before readUpdate().");
        }
        try {
            this.numberOfBytesRead += this.contentInfoASN1Template.berDecodeUpdate(input, inOffset, maxInputLen);
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Cannot readUpdate message: ", (Exception)((Object)asnException));
        }
        if (this.contentInfoEncoding != null) {
            byte[] temp = new byte[this.contentInfoEncoding.length];
            System.arraycopy(this.contentInfoEncoding, 0, temp, 0, this.contentInfoEncoding.length);
            this.contentInfoEncoding = new byte[temp.length + maxInputLen];
            System.arraycopy(temp, 0, this.contentInfoEncoding, 0, temp.length);
            System.arraycopy(input, inOffset, this.contentInfoEncoding, temp.length, maxInputLen);
        }
        return this.contentReadUpdate(input, inOffset, maxInputLen);
    }

    protected abstract int contentReadUpdate(byte[] var1, int var2, int var3) throws PKCS7Exception;

    public boolean readFinal() throws PKCS7Exception {
        if (this.contentInfoASN1Template == null) {
            throw new PKCS7Exception("Need to call readInit() before readFinal().");
        }
        try {
            this.contentInfoASN1Template.berDecodeFinal();
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Cannot call readFinal: ", (Exception)((Object)asnException));
        }
        if (!this.contentInfoASN1Template.isComplete()) {
            throw new PKCS7Exception("Cannot call readFinal, more message expected.");
        }
        return true;
    }

    public int bytesRead() {
        return this.numberOfBytesRead;
    }

    public boolean endOfMessage() {
        return this.contentASN1Def[0].isComplete();
    }

    public int getUnprocessedDataLen() {
        if (this.internalBuffer == null) {
            return 0;
        }
        return this.internalBuffer.length;
    }

    protected int copyNewData(byte[] input, int inOffset, int inLen, int maxBufferSize) {
        if (input == null) {
            return 0;
        }
        if (this.internalBuffer == null) {
            this.internalBuffer = maxBufferSize != 0 ? new byte[maxBufferSize] : new byte[inLen];
        }
        if (this.internalBuffer.length - this.internalOffset < inLen) {
            byte[] temp = new byte[this.internalBuffer.length];
            System.arraycopy(this.internalBuffer, 0, temp, 0, this.internalBuffer.length);
            this.internalBuffer = new byte[inLen + this.internalBuffer.length];
            System.arraycopy(temp, 0, this.internalBuffer, 0, temp.length);
            this.internalOffset = temp.length;
        }
        System.arraycopy(input, inOffset, this.internalBuffer, this.internalOffset, inLen);
        this.internalOffset += inLen;
        return inLen;
    }

    protected byte[] copyToOutput(ASN1Container container) {
        byte[] output;
        if (this.internalBuffer == null) {
            output = new byte[container.dataLen];
            System.arraycopy(container.data, container.dataOffset, output, 0, container.dataLen);
        } else if (this.maxBufferSize != 0 && this.internalBuffer.length >= this.maxBufferSize) {
            System.arraycopy(container.data, container.dataOffset, this.internalBuffer, this.internalOffset, container.dataLen);
            output = new byte[this.internalBuffer.length];
            System.arraycopy(this.internalBuffer, 0, output, 0, this.internalBuffer.length);
        } else {
            output = new byte[container.dataLen + this.internalBuffer.length];
            System.arraycopy(this.internalBuffer, 0, output, 0, this.internalBuffer.length);
            System.arraycopy(container.data, container.dataOffset, output, this.internalBuffer.length, container.dataLen);
        }
        this.clearInternalBuffer(this.internalBuffer);
        this.internalBuffer = null;
        this.internalOffset = 0;
        this.incompleteContainer = 0;
        return output;
    }

    protected void clearInternalBuffer(byte[] tempBuffer) {
        if (tempBuffer != null) {
            for (int index = 0; index < tempBuffer.length; ++index) {
                tempBuffer[index] = 0;
            }
        }
    }

    protected ASN1Container[] getASN1Containers(boolean encode, int special) throws PKCS7Exception {
        SequenceContainer seq = new SequenceContainer(special, true, 0);
        EndContainer anEnd = new EndContainer();
        int contentLen = 0;
        if (encode) {
            contentLen = this.contentInfoEncoding != null ? this.contentInfoEncoding.length : this.getContentDERLen();
        }
        try {
            OIDContainer localOID = this.buildOIDContainer();
            EncodedContainer encContent = new EncodedContainer(10616576, true, 0, this.maxBufferSize, null, 0, contentLen);
            ASN1Container[] returnValue = new ASN1Container[]{seq, localOID, encContent, anEnd};
            return returnValue;
        }
        catch (ASN_Exception e) {
            throw new PKCS7Exception("ContentInfo.getASN1Containers: ", (Exception)((Object)e));
        }
    }

    protected OIDContainer buildOIDContainer() throws ASN_Exception {
        return new OIDContainer(0x1000000, true, 0, P7OID, 0, 9);
    }

    protected boolean allowChangeContentTypeOIDLastByte() {
        boolean permission = true;
        if (this.oid != null) {
            permission = false;
        }
        return permission;
    }

    public Object clone() throws CloneNotSupportedException {
        ContentInfo otherSelf = (ContentInfo)super.clone();
        otherSelf.theDevice = this.theDevice;
        otherSelf.theDeviceList = this.getDeviceList();
        otherSelf.contentType = this.contentType;
        if (this.content != null) {
            otherSelf.content = (ContentInfo)this.content.clone();
        }
        otherSelf.theCertPathCtx = this.theCertPathCtx;
        otherSelf.theCertJ = this.theCertJ;
        try {
            if (this.contentInfoASN1Template != null) {
                otherSelf.getContentInfoDERLen();
            }
        }
        catch (PKCS7Exception pkcs7Exception) {
            throw new CloneNotSupportedException("Could not copy ASN1Template.");
        }
        return otherSelf;
    }

    public void clearInternalContentBuffer() {
        this.contentInfoEncoding = null;
    }

    public void clearSensitiveData() {
        if (this.content != null) {
            this.content.clearSensitiveData();
        }
        this.contentType = 0;
        this.content = null;
        this.theDevice = null;
        this.theDeviceList = null;
        this.contentInfoASN1Template = null;
        this.contentASN1Template = null;
        this.derLen = 0;
        this.clearInternalBuffer(this.internalBuffer);
        this.internalBuffer = null;
        this.internalOffset = 0;
        this.incompleteContainer = 0;
        this.theCertPathCtx = null;
        this.theCertJ = null;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

