/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.pkcs7;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.internal.CertJContext;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.certj.pkcs7.ContentInfo;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_MessageDigest;
import java.util.Arrays;

public class DigestedData
extends ContentInfo {
    protected int version = -1;
    protected byte[] digestOID;
    private String algorithmName;
    private byte[] digest;

    public DigestedData(CertJ certJ, CertPathCtx pathCtx) {
        this.contentType = 5;
        this.theCertJ = certJ;
        this.theCertPathCtx = pathCtx;
    }

    public void setContentInfo(ContentInfo content) throws PKCS7Exception {
        if (content == null) {
            throw new PKCS7Exception("Unable to set content: content is null.");
        }
        try {
            this.content = (ContentInfo)content.clone();
        }
        catch (CloneNotSupportedException cloneException) {
            throw new PKCS7Exception("Unable to clone ContentInfo type");
        }
    }

    public void setVersionNumber(int versionNumber) {
        this.version = versionNumber;
    }

    public int getVersionNumber() {
        return this.version;
    }

    public void setDigestAlgorithm(String algName) throws PKCS7Exception {
        this.digestOID = DigestedData.setDigestAlgorithmInternal(this.theCertJ, algName);
        this.algorithmName = algName;
    }

    static byte[] setDigestAlgorithmInternal(CertJ context, String algName) throws PKCS7Exception {
        if (algName == null) {
            throw new PKCS7Exception("Could not set digest algorithm: algName is null");
        }
        try {
            JSAFE_MessageDigest digestObject = JSAFEFactory.getDigest(algName, "Java", context);
            return digestObject.getDERAlgorithmID();
        }
        catch (JSAFE_Exception jsafeException) {
            throw new PKCS7Exception("Could not set algorithm algorithm: algName is invalid");
        }
    }

    static byte[] setDigestAlgorithmInternal(CertJContext context, String algName) throws PKCS7Exception {
        if (algName == null) {
            throw new PKCS7Exception("Could not set digest algorithm: algName is null");
        }
        try {
            JSAFE_MessageDigest digestObject = JSAFEFactory.getDigest(algName, "Java", context.jsafe);
            return digestObject.getDERAlgorithmID();
        }
        catch (JSAFE_Exception jsafeException) {
            throw new PKCS7Exception("Could not set algorithm algorithm: algName is invalid");
        }
    }

    public void setDigestAlgorithm(byte[] digestOID, int offset, int len) throws PKCS7Exception {
        this.digestOID = DigestedData.setDigestAlgorithmInternal(digestOID, offset, len);
    }

    static byte[] setDigestAlgorithmInternal(byte[] digestOID, int offset, int len) throws PKCS7Exception {
        if (digestOID == null || len <= 0) {
            throw new PKCS7Exception("Could not set algorithm OID: oid is null.");
        }
        if (offset < 0 || offset + len > digestOID.length) {
            throw new PKCS7Exception("Invalid digest algorithm identifier.");
        }
        byte[] dOID = new byte[len];
        System.arraycopy(digestOID, offset, dOID, 0, len);
        return dOID;
    }

    public byte[] getDigestAlgorithmOID() {
        return this.digestOID;
    }

    public String getDigestAlgorithmName() throws PKCS7Exception {
        return DigestedData.getDigestAlgorithmNameInternal(this.theCertJ, this.digestOID, this.algorithmName);
    }

    static String getDigestAlgorithmNameInternal(CertJ context, byte[] digestOID, String algorithmName) throws PKCS7Exception {
        if (digestOID == null) {
            return null;
        }
        if (algorithmName != null) {
            return algorithmName;
        }
        try {
            JSAFE_MessageDigest digestObject = JSAFEFactory.getDigest(digestOID, 0, "Java", context);
            return digestObject.getAlgorithm();
        }
        catch (JSAFE_Exception jsafeException) {
            throw new PKCS7Exception("Could not set algorithm OID: ", (Exception)((Object)jsafeException));
        }
    }

    static String getDigestAlgorithmNameInternal(CertJContext context, byte[] digestOID, String algorithmName) throws PKCS7Exception {
        if (digestOID == null) {
            return null;
        }
        if (algorithmName != null) {
            return algorithmName;
        }
        try {
            JSAFE_MessageDigest digestObject = JSAFEFactory.getDigest(digestOID, 0, "Java", context.jsafe);
            return digestObject.getAlgorithm();
        }
        catch (JSAFE_Exception jsafeException) {
            throw new PKCS7Exception("Could not set algorithm OID: ", (Exception)((Object)jsafeException));
        }
    }

    protected int getContentDERLen() throws PKCS7Exception {
        return this.contentDEREncodeInit();
    }

    protected int writeContent(byte[] output, int outOffset) throws PKCS7Exception {
        if (output == null) {
            throw new PKCS7Exception("Cannot write DigestedData: output array is null.");
        }
        try {
            if (this.contentASN1Template == null) {
                this.getContentDERLen();
            }
            int returnValue = this.contentASN1Template.derEncode(output, outOffset);
            this.contentASN1Template = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.contentASN1Template = null;
            throw new PKCS7Exception("Unable to DER encode DigestedData message: ", (Exception)((Object)asnException));
        }
    }

    private int contentDEREncodeInit() throws PKCS7Exception {
        if (this.content == null) {
            throw new PKCS7Exception("content is not set.");
        }
        if (this.flag == 0) {
            this.digest = this.getDigest();
        }
        if (this.version == -1) {
            this.version = 0;
        }
        if (this.contentEncoding == null) {
            int contentLen = this.content.getContentInfoDERLen();
            this.contentEncoding = new byte[contentLen];
            this.content.writeMessage(this.contentEncoding, 0);
        }
        try {
            EncodedContainer contentData = new EncodedContainer(0, true, 0, this.contentEncoding, 0, this.contentEncoding.length);
            SequenceContainer seq = new SequenceContainer(0xA10000, true, 0);
            EndContainer endContainer = new EndContainer();
            IntegerContainer intContainer = new IntegerContainer(0, true, 0, this.version);
            EncodedContainer localOid = new EncodedContainer(12288, true, 0, this.digestOID, 0, this.digestOID.length);
            int digestLen = 0;
            if (this.digest != null) {
                digestLen = this.digest.length;
            }
            OctetStringContainer digestData = new OctetStringContainer(0, true, 0, this.digest, 0, digestLen);
            this.contentASN1Def = new ASN1Container[6];
            this.contentASN1Def[0] = seq;
            this.contentASN1Def[1] = intContainer;
            this.contentASN1Def[2] = localOid;
            this.contentASN1Def[3] = contentData;
            this.contentASN1Def[4] = digestData;
            this.contentASN1Def[5] = endContainer;
            this.contentASN1Template = new ASN1Template(this.contentASN1Def);
            return this.contentASN1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception((Exception)((Object)asnException));
        }
    }

    public byte[] getMessageDigest() {
        if (this.digest == null) {
            return null;
        }
        byte[] result = new byte[this.digest.length];
        System.arraycopy(this.digest, 0, result, 0, this.digest.length);
        return result;
    }

    private byte[] getDigest() throws PKCS7Exception {
        byte[] octets = null;
        try {
            if (this.contentEncoding == null) {
                int contentLen = this.content.getContentInfoDERLen();
                this.contentEncoding = new byte[contentLen];
                this.content.writeMessage(this.contentEncoding, 0);
            }
            SequenceContainer seq = new SequenceContainer(0);
            EndContainer anEnd = new EndContainer();
            OIDContainer localOid = new OIDContainer(0x1000000);
            EncodedContainer encContent = new EncodedContainer(10616576);
            ASN1Container[] returnValue = new ASN1Container[]{seq, localOid, encContent, anEnd};
            ASN1.berDecode((byte[])this.contentEncoding, (int)0, (ASN1Container[])returnValue);
            if (encContent.dataPresent) {
                int skipBytes = 1;
                skipBytes += ASN1Lengths.determineLengthLen((byte[])encContent.data, (int)(encContent.dataOffset + 1));
                ++skipBytes;
                skipBytes += ASN1Lengths.determineLengthLen((byte[])encContent.data, (int)(encContent.dataOffset + skipBytes));
                octets = new byte[encContent.dataLen - skipBytes];
                System.arraycopy(encContent.data, encContent.dataOffset + skipBytes, octets, 0, encContent.dataLen - skipBytes);
            }
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Could not DER encode ContentInfo: ", (Exception)((Object)asnException));
        }
        try {
            if (octets == null) {
                return null;
            }
            JSAFE_MessageDigest digestObject = JSAFEFactory.getDigest(this.digestOID, 0, this.getDeviceOrJava(), this.theCertJ);
            digestObject.digestInit();
            digestObject.digestUpdate(octets, 0, octets.length);
            byte[] result = digestObject.digestFinal();
            digestObject.clearSensitiveData();
            return result;
        }
        catch (JSAFE_Exception jsafeException) {
            throw new PKCS7Exception("Could not digest ContentInfo: ", (Exception)((Object)jsafeException));
        }
    }

    protected boolean contentReadInit(byte[] input, int inOffset, int maxInputLen) throws PKCS7Exception {
        try {
            SequenceContainer seq = new SequenceContainer(0xA10000);
            EndContainer endContainer = new EndContainer();
            IntegerContainer intContainer = new IntegerContainer(0);
            EncodedContainer localOid = new EncodedContainer(12288);
            EncodedContainer contentData = new EncodedContainer(12288, true, 0, this.maxBufferSize, null, 0, 0);
            OctetStringContainer digestData = new OctetStringContainer(0);
            this.contentASN1Def = new ASN1Container[6];
            this.contentASN1Def[0] = seq;
            this.contentASN1Def[1] = intContainer;
            this.contentASN1Def[2] = localOid;
            this.contentASN1Def[3] = contentData;
            this.contentASN1Def[4] = digestData;
            this.contentASN1Def[5] = endContainer;
            this.contentASN1Template = new ASN1Template(this.contentASN1Def);
            this.contentASN1Template.berDecodeInit();
            this.contentASN1Template.berDecodeUpdate(input, inOffset, maxInputLen);
            if (this.contentASN1Def[0].checkTag()) {
                return false;
            }
            this.setDecodedValues();
            this.flag = 1;
            return true;
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Could not decode message: ", (Exception)((Object)asnException));
        }
    }

    private void setDecodedValues() throws PKCS7Exception {
        try {
            byte[] output;
            if (this.version == -1) {
                if (this.contentASN1Def[1].isComplete()) {
                    if (this.incompleteContainer == 1) {
                        output = this.copyToOutput(this.contentASN1Def[1]);
                        IntegerContainer integer = new IntegerContainer(0, true, 0, output, 0, output.length, true);
                        this.version = integer.getValueAsInt();
                    } else {
                        this.version = ((IntegerContainer)this.contentASN1Def[1]).getValueAsInt();
                    }
                } else {
                    if (this.contentASN1Def[1].data == null) {
                        return;
                    }
                    this.incompleteContainer = 1;
                    this.copyNewData(this.contentASN1Def[1].data, this.contentASN1Def[1].dataOffset, this.contentASN1Def[1].dataLen, 0);
                    return;
                }
            }
            if (this.digestOID == null) {
                if (this.contentASN1Def[2].isComplete()) {
                    if (this.incompleteContainer == 2) {
                        this.digestOID = this.copyToOutput(this.contentASN1Def[2]);
                    } else {
                        this.digestOID = new byte[this.contentASN1Def[2].dataLen];
                        System.arraycopy(this.contentASN1Def[2].data, this.contentASN1Def[2].dataOffset, this.digestOID, 0, this.contentASN1Def[2].dataLen);
                    }
                } else {
                    if (this.contentASN1Def[2].data == null) {
                        return;
                    }
                    this.incompleteContainer = 2;
                    this.copyNewData(this.contentASN1Def[2].data, this.contentASN1Def[2].dataOffset, this.contentASN1Def[2].dataLen, 0);
                    return;
                }
            }
            if (this.content == null) {
                if (this.contentASN1Def[3].isComplete()) {
                    if (this.incompleteContainer == 3) {
                        output = this.copyToOutput(this.contentASN1Def[3]);
                        this.decodeContent(output, 0, output.length);
                    } else {
                        this.decodeContent(this.contentASN1Def[3].data, this.contentASN1Def[3].dataOffset, this.contentASN1Def[3].dataLen);
                    }
                } else {
                    if (this.contentASN1Def[3].data == null) {
                        return;
                    }
                    this.incompleteContainer = 3;
                    this.copyNewData(this.contentASN1Def[3].data, this.contentASN1Def[3].dataOffset, this.contentASN1Def[3].dataLen, this.maxBufferSize);
                    return;
                }
            }
            byte[] newDigest = this.getDigest();
            if (this.digest == null) {
                if (this.contentASN1Def[4].isComplete()) {
                    if (this.contentASN1Def[4].data == null && newDigest == null) {
                        return;
                    }
                    if (this.incompleteContainer == 4) {
                        this.digest = this.copyToOutput(this.contentASN1Def[4]);
                    } else if (this.contentASN1Def[4].data != null) {
                        this.digest = new byte[this.contentASN1Def[4].dataLen];
                        System.arraycopy(this.contentASN1Def[4].data, this.contentASN1Def[4].dataOffset, this.digest, 0, this.contentASN1Def[4].dataLen);
                    }
                    if (!CertJUtils.byteArraysEqual(this.digest, newDigest)) {
                        throw new PKCS7Exception("Invalid digest.");
                    }
                } else if (this.contentASN1Def[4].data != null) {
                    this.incompleteContainer = 4;
                    this.copyNewData(this.contentASN1Def[4].data, this.contentASN1Def[4].dataOffset, this.contentASN1Def[4].dataLen, 0);
                }
            }
        }
        catch (Exception anyException) {
            throw new PKCS7Exception("Cannot set decoded values.", anyException);
        }
    }

    private void decodeContent(byte[] data, int offset, int len) throws PKCS7Exception {
        if (data == null || len == 0) {
            throw new PKCS7Exception("Cannot decode DigestedData: data is null.");
        }
        try {
            SequenceContainer seq = new SequenceContainer(0);
            EndContainer anEnd = new EndContainer();
            OIDContainer localOid = new OIDContainer(0x1000000);
            EncodedContainer encContent = new EncodedContainer(10616576, true, 0, this.maxBufferSize, null, 0, 0);
            ASN1Container[] returnValue = new ASN1Container[]{seq, localOid, encContent, anEnd};
            ASN1.berDecode((byte[])data, (int)offset, (ASN1Container[])returnValue);
            this.content = ContentInfo.getInstance(localOid.data, localOid.dataOffset, localOid.dataLen, this.theCertJ, this.theCertPathCtx);
            if (this.content.readInit(data, offset, len, this.maxBufferSize) && this.content.readFinal()) {
                return;
            }
        }
        catch (Exception anyException) {
            throw new PKCS7Exception("Cannot decode content.", anyException);
        }
        throw new PKCS7Exception("Cannot decode content.");
    }

    protected int contentReadUpdate(byte[] input, int inOffset, int maxInputLen) throws PKCS7Exception {
        int bytesToOutput = 0;
        if (input == null) {
            return bytesToOutput;
        }
        if (this.contentASN1Template == null) {
            throw new PKCS7Exception("Call readInit before readUpdate.");
        }
        try {
            if (this.contentASN1Template.isComplete()) {
                return bytesToOutput;
            }
            bytesToOutput = this.contentASN1Template.berDecodeUpdate(input, inOffset, maxInputLen);
            this.setDecodedValues();
            return bytesToOutput;
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Could not decode message: ", (Exception)((Object)asnException));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DigestedData otherSelf = (DigestedData)super.clone();
        otherSelf.version = this.version;
        if (this.digest != null) {
            otherSelf.digest = (byte[])this.digest.clone();
        }
        if (this.digestOID != null) {
            otherSelf.digestOID = (byte[])this.digestOID.clone();
        }
        return otherSelf;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DigestedData)) {
            return false;
        }
        DigestedData other = (DigestedData)obj;
        if (this.version != other.version) {
            return false;
        }
        if (this.content != null && !this.content.equals(other.content)) {
            return false;
        }
        return CertJUtils.byteArraysEqual(this.digest, other.digest) && CertJUtils.byteArraysEqual(this.digestOID, other.digestOID);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(this.digest);
        result = prime * result + Arrays.hashCode(this.digestOID);
        result = prime * result + this.version;
        result = prime * result + CertJInternalHelper.hashCodeValue(this.content);
        return result;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.version = -1;
        this.digestOID = null;
        this.digest = null;
    }
}

