/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.pkcs7;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OIDList;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.certj.pkcs7.ContentInfo;
import com.rsa.certj.pkcs7.EncryptedContentInfo;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.random.RandomException;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import java.security.SecureRandom;
import java.util.Arrays;

public class EncryptedData
extends ContentInfo {
    protected int version = -1;
    protected EncryptedContentInfo info = new EncryptedContentInfo();
    private String encryptionAlgName;
    private JSAFE_SecretKey theKey;
    private byte[] keyData;
    private char[] password;
    private byte[] iv;
    private byte[] salt;

    public EncryptedData(CertJ certJ, CertPathCtx pathCtx) {
        this.contentType = 6;
        this.theCertJ = certJ;
        this.theCertPathCtx = pathCtx;
    }

    public void setVersionNumber(int versionNumber) {
        this.version = versionNumber;
    }

    public int getVersionNumber() {
        return this.version;
    }

    public void setIV(byte[] iv, int offset, int len) {
        if (iv != null && len > 0 && offset >= 0 && len + offset <= iv.length) {
            this.iv = new byte[len];
            System.arraycopy(iv, offset, this.iv, 0, len);
        }
    }

    public byte[] getIV() {
        if (this.iv == null) {
            return null;
        }
        byte[] result = new byte[this.iv.length];
        System.arraycopy(this.iv, 0, result, 0, this.iv.length);
        return result;
    }

    public void setSalt(byte[] salt, int offset, int len) {
        if (salt != null && len > 0 && offset >= 0 && len + offset <= salt.length) {
            this.salt = new byte[len];
            System.arraycopy(salt, offset, this.salt, 0, len);
        }
    }

    public byte[] getSalt() {
        if (this.salt == null) {
            return null;
        }
        byte[] result = new byte[this.salt.length];
        System.arraycopy(this.salt, 0, result, 0, this.salt.length);
        return result;
    }

    public void setEncryptionAlgorithm(String algName) throws PKCS7Exception {
        if (algName == null) {
            throw new PKCS7Exception("Algorithm name is null");
        }
        this.encryptionAlgName = algName;
        try {
            JSAFE_SymmetricCipher cipher = JSAFEFactory.getSymmetricCipher(algName, this.getDeviceOrJava(), this.theCertJ);
            if (cipher.getFeedbackMode() != null && !cipher.getFeedbackMode().equals("ECB")) {
                if (this.iv == null) {
                    if (this.theCertJ == null) {
                        throw new PKCS7Exception("CertJ object is null; cannot get Random object.");
                    }
                    JSAFE_SecureRandom random = this.theCertJ.getRandomObject();
                    cipher.generateIV((SecureRandom)random);
                } else {
                    cipher.setIV(this.iv, 0, this.iv.length);
                }
            }
            if (this.salt != null) {
                cipher.setSalt(this.salt, 0, this.salt.length);
            }
            byte[] localOid = cipher.getDERAlgorithmID();
            this.info.setEncryptionAlgorithm(localOid, 0, localOid.length);
        }
        catch (JSAFE_Exception jsafeException) {
            throw new PKCS7Exception("Could not set algorithm OID: ", (Exception)((Object)jsafeException));
        }
        catch (RandomException randomException) {
            throw new PKCS7Exception("Could not set algorithm OID", randomException);
        }
        catch (NoServiceException noServiceException) {
            throw new PKCS7Exception("Could not set algorithm OID", noServiceException);
        }
    }

    public void setEncryptionAlgorithm(byte[] oid, int offset, int len) throws PKCS7Exception {
        if (oid == null || len <= 0) {
            throw new PKCS7Exception("Could not set algorithm OID: OID is null");
        }
        if (offset < 0 || offset + len > oid.length) {
            throw new PKCS7Exception("Invalid content-encryption algorithm ID");
        }
        this.info.setEncryptionAlgorithm(oid, offset, len);
    }

    public byte[] getEncryptionAlgorithmOID() {
        if (this.info == null) {
            return null;
        }
        return this.info.getEncryptionAlgorithm();
    }

    public String getEncryptionAlgorithmName() throws PKCS7Exception {
        if (this.encryptionAlgName != null) {
            return this.encryptionAlgName;
        }
        if (this.info == null) {
            return null;
        }
        byte[] localOid = this.info.getEncryptionAlgorithm();
        if (localOid == null) {
            return null;
        }
        try {
            SequenceContainer seq = new SequenceContainer(0, true, 0);
            EndContainer endContainer = new EndContainer();
            OIDContainer oidContainer = new OIDContainer(0);
            EncodedContainer encContent = new EncodedContainer(130816);
            ASN1Container[] returnValue = new ASN1Container[]{seq, oidContainer, encContent, endContainer};
            ASN1.berDecode((byte[])localOid, (int)0, (ASN1Container[])returnValue);
            return OIDList.getTrans((byte[])oidContainer.data, (int)oidContainer.dataOffset, (int)oidContainer.dataLen, (int)7);
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Encryption algorithm is not valid.", (Exception)((Object)asnException));
        }
    }

    public void setSecretKey(JSAFE_SecretKey key) throws PKCS7Exception {
        if (key == null) {
            throw new PKCS7Exception("Secret key is null.");
        }
        try {
            this.theKey = (JSAFE_SecretKey)key.clone();
        }
        catch (CloneNotSupportedException cloneException) {
            throw new PKCS7Exception("Unable to clone Secret Key");
        }
    }

    public JSAFE_SecretKey getSecretKey() throws PKCS7Exception {
        if (this.theKey == null) {
            return null;
        }
        try {
            return (JSAFE_SecretKey)this.theKey.clone();
        }
        catch (CloneNotSupportedException cloneException) {
            throw new PKCS7Exception("Unable to clone Secret Key");
        }
    }

    public void setSecretKeyData(byte[] keyData, int offset, int len) throws PKCS7Exception {
        if (keyData != null && len > 0 && offset >= 0 && offset + len <= keyData.length) {
            if (this.encryptionAlgName == null) {
                this.encryptionAlgName = this.getEncryptionAlgorithmName();
            }
            if (this.encryptionAlgName == null) {
                this.keyData = new byte[len];
                System.arraycopy(keyData, offset, this.keyData, 0, len);
            } else {
                try {
                    JSAFE_SymmetricCipher cipher = JSAFEFactory.getSymmetricCipher(this.encryptionAlgName, "Java", this.theCertJ);
                    String keyAlgName = cipher.getEncryptionAlgorithm();
                    this.theKey = JSAFEFactory.getSecretKey(keyAlgName, this.getDeviceOrJava(), this.theCertJ);
                    this.theKey.setSecretKeyData(keyData, offset, len);
                }
                catch (JSAFE_Exception jsafeException) {
                    throw new PKCS7Exception("Invalid Key Data ", (Exception)((Object)jsafeException));
                }
            }
        } else {
            throw new PKCS7Exception("NULL Key Data ");
        }
    }

    public byte[] getSecretKeyData() {
        if (this.theKey == null) {
            return null;
        }
        return this.theKey.getSecretKeyData();
    }

    public void setPassword(char[] password, int offset, int len) {
        if (password != null && len > 0 && offset >= 0 && offset + len <= password.length) {
            this.password = new char[len];
            System.arraycopy(password, offset, this.password, 0, len);
        }
    }

    public char[] getPassword() throws PKCS7Exception {
        if (this.password != null) {
            char[] result = new char[this.password.length];
            System.arraycopy(this.password, 0, result, 0, this.password.length);
            return result;
        }
        if (this.theKey == null) {
            throw new PKCS7Exception("The SecretKey and Password are not set.");
        }
        try {
            return this.theKey.getPassword();
        }
        catch (JSAFE_Exception exception) {
            throw new PKCS7Exception("The SecretKey is not set with a password.");
        }
    }

    public void setContentInfo(ContentInfo content) throws PKCS7Exception {
        if (content == null) {
            throw new PKCS7Exception("content is null.");
        }
        try {
            this.content = (ContentInfo)content.clone();
        }
        catch (CloneNotSupportedException cloneException) {
            throw new PKCS7Exception("Unable to clone ContentInfo type");
        }
    }

    protected int getContentDERLen() throws PKCS7Exception {
        return this.contentDEREncodeInit();
    }

    protected int writeContent(byte[] output, int outOffset) throws PKCS7Exception {
        if (output == null) {
            throw new PKCS7Exception("Cannot write EncryptedData: output array is null.");
        }
        try {
            if (this.contentASN1Template == null) {
                this.getContentDERLen();
            }
            int returnValue = this.contentASN1Template.derEncode(output, outOffset);
            this.contentASN1Template = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.contentASN1Template = null;
            throw new PKCS7Exception("Unable to DER encode EncryptedData message: ", (Exception)((Object)asnException));
        }
    }

    private int contentDEREncodeInit() throws PKCS7Exception {
        if (this.flag == 0) {
            this.setContentData();
        }
        try {
            SequenceContainer seq = new SequenceContainer(0xA10000, true, 0);
            EndContainer endContainer = new EndContainer();
            IntegerContainer intContainer = new IntegerContainer(0, true, 0, this.version);
            int infoLen = this.info.getDERLen(0);
            byte[] infoDER = new byte[infoLen];
            infoLen = this.info.getDEREncoding(infoDER, 0, 0);
            EncodedContainer encoding = new EncodedContainer(0, true, 0, infoDER, 0, infoLen);
            this.contentASN1Def = new ASN1Container[4];
            this.contentASN1Def[0] = seq;
            this.contentASN1Def[1] = intContainer;
            this.contentASN1Def[2] = encoding;
            this.contentASN1Def[3] = endContainer;
            this.contentASN1Template = new ASN1Template(this.contentASN1Def);
            return this.contentASN1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception((Exception)((Object)asnException));
        }
    }

    private void setContentData() throws PKCS7Exception {
        if (this.version == -1) {
            this.version = 0;
        }
        if (this.content == null) {
            throw new PKCS7Exception("There is no content to encrypt.");
        }
        int lastByte = this.content.getContentType();
        byte[] result = new byte[9];
        System.arraycopy(P7OID, 0, result, 0, 8);
        result[8] = (byte)lastByte;
        this.info.setContentType(result, 0, 9);
        byte[] octets = null;
        try {
            int contentLen = this.content.getContentInfoDERLen();
            byte[] encoding = new byte[contentLen];
            this.content.writeMessage(encoding, 0);
            SequenceContainer seq = new SequenceContainer(0);
            EndContainer anEnd = new EndContainer();
            OIDContainer localOid = new OIDContainer(0x1000000);
            EncodedContainer encContent = new EncodedContainer(10616576);
            ASN1Container[] returnValue = new ASN1Container[]{seq, localOid, encContent, anEnd};
            ASN1.berDecode((byte[])encoding, (int)0, (ASN1Container[])returnValue);
            if (encContent.dataPresent) {
                int skipBytes = 1;
                skipBytes += ASN1Lengths.determineLengthLen((byte[])encContent.data, (int)(encContent.dataOffset + 1));
                ++skipBytes;
                skipBytes += ASN1Lengths.determineLengthLen((byte[])encContent.data, (int)(encContent.dataOffset + skipBytes));
                octets = new byte[encContent.dataLen - skipBytes];
                System.arraycopy(encContent.data, encContent.dataOffset + skipBytes, octets, 0, encContent.dataLen - skipBytes);
            }
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Could not DER encode ContentInfo: ", (Exception)((Object)asnException));
        }
        try {
            if (octets == null) {
                return;
            }
            byte[] algId = this.info.getEncryptionAlgorithm();
            if (this.theCertJ == null) {
                throw new PKCS7Exception("CertJ object is null; cannot get Random object.");
            }
            JSAFE_SecureRandom random = this.theCertJ.getRandomObject();
            String device = this.getDeviceOrJava();
            JSAFE_SymmetricCipher cipher = JSAFEFactory.getSymmetricCipher(algId, 0, device, this.theCertJ);
            int outLen = cipher.getOutputBufferSize(octets.length);
            byte[] output = new byte[outLen];
            if (this.theKey == null) {
                if (this.keyData != null) {
                    String keyAlgName = cipher.getEncryptionAlgorithm();
                    this.theKey = JSAFEFactory.getSecretKey(keyAlgName, device, this.theCertJ);
                    this.theKey.setSecretKeyData(this.keyData, 0, this.keyData.length);
                } else {
                    if (this.password == null) {
                        throw new PKCS7Exception("Secret key is not set.");
                    }
                    this.theKey = cipher.getBlankKey();
                    this.theKey.setPassword(this.password, 0, this.password.length);
                }
            }
            cipher.encryptInit(this.theKey, (SecureRandom)random);
            outLen = cipher.encryptUpdate(octets, 0, octets.length, output, 0);
            outLen += cipher.encryptFinal(output, outLen);
            this.info.setEncryptedContent(output, 0, outLen);
            cipher.clearSensitiveData();
        }
        catch (JSAFE_Exception jsafeException) {
            throw new PKCS7Exception("Could not encrypt content: ", (Exception)((Object)jsafeException));
        }
        catch (RandomException randomException) {
            throw new PKCS7Exception("Could not encrypt ContentInfo", randomException);
        }
        catch (NoServiceException noServiceException) {
            throw new PKCS7Exception("Could not encrypt ContentInfo", noServiceException);
        }
    }

    protected boolean contentReadInit(byte[] input, int inOffset, int maxInputLen) throws PKCS7Exception {
        try {
            SequenceContainer seq = new SequenceContainer(0xA10000);
            EndContainer endContainer = new EndContainer();
            IntegerContainer intContainer = new IntegerContainer(0);
            EncodedContainer encoding = new EncodedContainer(12288, true, 0, this.maxBufferSize, null, 0, 0);
            this.contentASN1Def = new ASN1Container[4];
            this.contentASN1Def[0] = seq;
            this.contentASN1Def[1] = intContainer;
            this.contentASN1Def[2] = encoding;
            this.contentASN1Def[3] = endContainer;
            this.contentASN1Template = new ASN1Template(this.contentASN1Def);
            this.contentASN1Template.berDecodeInit();
            this.contentASN1Template.berDecodeUpdate(input, inOffset, maxInputLen);
            if (this.contentASN1Def[0].checkTag()) {
                return false;
            }
            this.setDecodedValues();
            this.flag = 1;
            return true;
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Could not decode message: ", (Exception)((Object)asnException));
        }
    }

    private void setDecodedValues() throws PKCS7Exception {
        try {
            byte[] output;
            if (this.version == -1) {
                if (this.contentASN1Def[1].isComplete()) {
                    if (this.incompleteContainer == 1) {
                        output = this.copyToOutput(this.contentASN1Def[1]);
                        IntegerContainer integer = new IntegerContainer(0, true, 0, output, 0, output.length, true);
                        this.version = integer.getValueAsInt();
                    } else {
                        this.version = ((IntegerContainer)this.contentASN1Def[1]).getValueAsInt();
                    }
                } else {
                    if (this.contentASN1Def[1].data == null) {
                        return;
                    }
                    this.incompleteContainer = 1;
                    this.copyNewData(this.contentASN1Def[1].data, this.contentASN1Def[1].dataOffset, this.contentASN1Def[1].dataLen, 0);
                    return;
                }
            }
            if (this.contentASN1Def[2].isComplete()) {
                if (this.incompleteContainer == 2) {
                    output = this.copyToOutput(this.contentASN1Def[2]);
                    this.decodeEncryptedContent(output, 0, output.length);
                } else {
                    this.decodeEncryptedContent(this.contentASN1Def[2].data, this.contentASN1Def[2].dataOffset, this.contentASN1Def[2].dataLen);
                }
            } else if (this.contentASN1Def[2].data != null) {
                this.incompleteContainer = 2;
                this.copyNewData(this.contentASN1Def[2].data, this.contentASN1Def[2].dataOffset, this.contentASN1Def[2].dataLen, this.maxBufferSize);
            }
        }
        catch (Exception anyException) {
            throw new PKCS7Exception("Cannot set decoded values.", anyException);
        }
    }

    private void decodeEncryptedContent(byte[] data, int offset, int len) throws PKCS7Exception {
        if (data == null || len == 0) {
            throw new PKCS7Exception("Cannot decode content: data is null.");
        }
        try {
            this.info = new EncryptedContentInfo(data, offset, 0, this.maxBufferSize);
            byte[] algID = this.info.getEncryptionAlgorithm();
            byte[] type = this.info.getContentType();
            this.content = ContentInfo.getInstance(type, 0, 9, this.theCertJ, this.theCertPathCtx);
            if (this.theCertJ == null) {
                throw new PKCS7Exception("CertJ object is null; cannot get Random object.");
            }
            JSAFE_SecureRandom random = this.theCertJ.getRandomObject();
            byte[] encryptedContent = this.info.getEncryptedContent();
            if (encryptedContent == null) {
                return;
            }
            String device = this.getDeviceOrJava();
            JSAFE_SymmetricCipher cipher = JSAFEFactory.getSymmetricCipher(algID, 0, device, this.theCertJ);
            int outLen = cipher.getOutputBufferSize(encryptedContent.length);
            byte[] output = new byte[outLen];
            if (this.theKey == null) {
                if (this.keyData != null) {
                    String keyAlgName = cipher.getEncryptionAlgorithm();
                    this.theKey = JSAFEFactory.getSecretKey(keyAlgName, device, this.theCertJ);
                    this.theKey.setSecretKeyData(this.keyData, 0, this.keyData.length);
                } else {
                    if (this.password == null) {
                        throw new PKCS7Exception("Secret key is not set.");
                    }
                    this.theKey = cipher.getBlankKey();
                    this.theKey.setPassword(this.password, 0, this.password.length);
                }
            }
            cipher.decryptInit(this.theKey, (SecureRandom)random);
            outLen = cipher.decryptUpdate(encryptedContent, 0, encryptedContent.length, output, 0);
            outLen += cipher.decryptFinal(output, outLen);
            cipher.clearSensitiveData();
            int firstLen = outLen + 1 + ASN1Lengths.getLengthLen((int)outLen);
            byte[] firstEncoding = new byte[firstLen];
            firstEncoding[0] = type[8] == 1 ? 4 : 48;
            firstLen = 1 + ASN1Lengths.writeLength((byte[])firstEncoding, (int)1, (int)outLen);
            System.arraycopy(output, 0, firstEncoding, firstLen, outLen);
            int secondLen = firstEncoding.length + 1 + ASN1Lengths.getLengthLen((int)firstEncoding.length);
            byte[] secondEncoding = new byte[secondLen];
            secondEncoding[0] = -96;
            secondLen = 1 + ASN1Lengths.writeLength((byte[])secondEncoding, (int)1, (int)firstEncoding.length);
            System.arraycopy(firstEncoding, 0, secondEncoding, secondLen, firstEncoding.length);
            SequenceContainer seq = new SequenceContainer(0, true, 0);
            EndContainer anEnd = new EndContainer();
            OIDContainer localOid = new OIDContainer(0x1000000, true, 0, type, 0, type.length);
            EncodedContainer encContent = new EncodedContainer(10616576, true, 0, secondEncoding, 0, secondEncoding.length);
            ASN1Container[] returnValue = new ASN1Container[]{seq, localOid, encContent, anEnd};
            ASN1Template template = new ASN1Template(returnValue);
            int length = template.derEncodeInit();
            byte[] outEncoding = new byte[length];
            template.derEncode(outEncoding, 0);
            if (this.content.readInit(outEncoding, 0, length, this.maxBufferSize) && this.content.readFinal()) {
                return;
            }
        }
        catch (Exception anyException) {
            throw new PKCS7Exception("Cannot decode content.", anyException);
        }
        throw new PKCS7Exception("Cannot decode content.");
    }

    protected int contentReadUpdate(byte[] input, int inOffset, int maxInputLen) throws PKCS7Exception {
        int bytesToOutput = 0;
        if (input == null) {
            return bytesToOutput;
        }
        if (this.contentASN1Template == null) {
            throw new PKCS7Exception("Call readInit before readUpdate.");
        }
        try {
            if (this.contentASN1Template.isComplete()) {
                return bytesToOutput;
            }
            bytesToOutput = this.contentASN1Template.berDecodeUpdate(input, inOffset, maxInputLen);
            this.setDecodedValues();
            return bytesToOutput;
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Could not decode message: ", (Exception)((Object)asnException));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        EncryptedData otherSelf = (EncryptedData)super.clone();
        if (this.theKey != null) {
            otherSelf.theKey = (JSAFE_SecretKey)this.theKey.clone();
        }
        otherSelf.version = this.version;
        if (this.info != null) {
            otherSelf.info = (EncryptedContentInfo)this.info.clone();
        }
        otherSelf.encryptionAlgName = this.encryptionAlgName;
        if (this.password != null) {
            otherSelf.password = new char[this.password.length];
            System.arraycopy(this.password, 0, otherSelf.password, 0, this.password.length);
        }
        if (this.iv != null) {
            otherSelf.iv = new byte[this.iv.length];
            System.arraycopy(this.iv, 0, otherSelf.iv, 0, this.iv.length);
        }
        if (this.salt != null) {
            otherSelf.salt = new byte[this.salt.length];
            System.arraycopy(this.salt, 0, otherSelf.salt, 0, this.salt.length);
        }
        return otherSelf;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof EncryptedData)) {
            return false;
        }
        EncryptedData other = (EncryptedData)obj;
        if (this.version != other.version) {
            return false;
        }
        if (this.content != null && !this.content.equals(other.content)) {
            return false;
        }
        if (this.iv != null && other.iv != null && !CertJUtils.byteArraysEqual(this.iv, other.iv)) {
            return false;
        }
        if (this.salt != null && other.salt != null && !CertJUtils.byteArraysEqual(this.salt, other.salt)) {
            return false;
        }
        if (this.info != null ? !this.info.equals(other.info) : other.info != null) {
            return false;
        }
        if (this.password != null) {
            if (other.password == null) return false;
            if (this.password.length != other.password.length) {
                return false;
            }
            for (int index = 0; index < this.password.length; ++index) {
                if (this.password[index] == other.password[index]) continue;
                return false;
            }
        } else if (other.password != null) {
            return false;
        }
        if (this.theKey != null) {
            byte[] otherData;
            if (other.theKey == null) return false;
            if (!this.theKey.getAlgorithm().equals(other.theKey.getAlgorithm())) {
                return false;
            }
            byte[] thisData = this.theKey.getSecretKeyData();
            if (CertJUtils.byteArraysEqual(thisData, otherData = other.theKey.getSecretKeyData())) return true;
            return false;
        }
        if (other.theKey == null) return true;
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + CertJInternalHelper.hashCodeValue(this.info);
        result = prime * result + CertJInternalHelper.hashCodeValue(this.content);
        result = prime * result + Arrays.hashCode(this.iv);
        result = prime * result + Arrays.hashCode(this.password);
        result = prime * result + Arrays.hashCode(this.salt);
        result = prime * result + this.version;
        if (this.theKey != null) {
            byte[] data = this.theKey.getSecretKeyData();
            result = prime * result + Arrays.hashCode(data);
            result = prime * result + CertJInternalHelper.hashCodeValue(this.theKey.getAlgorithm());
        }
        return result;
    }

    public void clearSensitiveData() {
        super.clearSensitiveData();
        if (this.theKey != null) {
            this.theKey.clearSensitiveData();
        }
        this.version = -1;
        this.info = new EncryptedContentInfo();
    }
}

