/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.pkcs7;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OIDList;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.certj.pkcs7.ContentInfo;
import com.rsa.certj.pkcs7.EncryptedContentInfo;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.certj.pkcs7.RecipientInfo;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.random.RandomException;
import com.rsa.jsafe.JSAFE_AsymmetricCipher;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import java.security.SecureRandom;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvelopedData
extends ContentInfo {
    protected int version = -1;
    protected Vector<RecipientInfo> recipients = new Vector();
    protected EncryptedContentInfo info = new EncryptedContentInfo();
    private JSAFE_SecretKey theKey;
    private int theKeyLen;
    private String algorithmName;

    public EnvelopedData(CertJ certJ, CertPathCtx pathCtx) {
        this.contentType = 3;
        this.theCertJ = certJ;
        this.theCertPathCtx = pathCtx;
    }

    public void setVersionNumber(int versionNumber) {
        this.version = versionNumber;
    }

    public int getVersionNumber() {
        return this.version;
    }

    public void setEncryptionAlgorithm(String algName, int keyLen) throws PKCS7Exception {
        if (algName == null) {
            throw new PKCS7Exception("Algorithm name is null.");
        }
        this.algorithmName = algName;
        try {
            byte[] localOid;
            if (this.theCertJ == null) {
                throw new PKCS7Exception("CertJ object is NULL; cannot get Random object.");
            }
            JSAFE_SymmetricCipher cipher = JSAFEFactory.getSymmetricCipher(algName, this.getDeviceOrJava(), this.theCertJ);
            if (cipher.getFeedbackMode() != null && !cipher.getFeedbackMode().equals("ECB")) {
                JSAFE_SecureRandom random = this.theCertJ.getRandomObject();
                cipher.generateIV((SecureRandom)random);
            }
            if ((localOid = cipher.getDERAlgorithmID()) != null) {
                this.info.setEncryptionAlgorithm(localOid, 0, localOid.length);
            }
            this.theKeyLen = keyLen;
        }
        catch (JSAFE_Exception jsafeException) {
            throw new PKCS7Exception("Could not get algorithm OID: ", (Exception)((Object)jsafeException));
        }
        catch (RandomException randomException) {
            throw new PKCS7Exception("Could not get algorithm OID", randomException);
        }
        catch (NoServiceException noServiceException) {
            throw new PKCS7Exception("Could not get algorithm OID", noServiceException);
        }
    }

    public void setEncryptionAlgorithm(byte[] oid, int offset, int len, int keyLen) throws PKCS7Exception {
        if (oid == null || len <= 0) {
            throw new PKCS7Exception("Could not set algorithm OID: OID is null");
        }
        if (offset < 0 || offset + len > oid.length) {
            throw new PKCS7Exception("invalid data");
        }
        this.info.setEncryptionAlgorithm(oid, offset, len);
        this.theKeyLen = keyLen;
    }

    public String getEncryptionAlgorithmName() throws PKCS7Exception {
        if (this.algorithmName != null) {
            return this.algorithmName;
        }
        if (this.info == null) {
            return null;
        }
        byte[] localOid = this.info.getEncryptionAlgorithm();
        if (localOid == null) {
            throw new PKCS7Exception("Encryption algorithm is not set.");
        }
        try {
            SequenceContainer seq = new SequenceContainer(0, true, 0);
            EndContainer endContainer = new EndContainer();
            OIDContainer oidContainer = new OIDContainer(0);
            EncodedContainer encContent = new EncodedContainer(130816);
            ASN1Container[] returnValue = new ASN1Container[]{seq, oidContainer, encContent, endContainer};
            ASN1.berDecode((byte[])localOid, (int)0, (ASN1Container[])returnValue);
            return OIDList.getTrans((byte[])oidContainer.data, (int)oidContainer.dataOffset, (int)oidContainer.dataLen, (int)7);
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Encryption algorithm is not valid.", (Exception)((Object)asnException));
        }
    }

    public byte[] getEncryptionAlgorithmOID() {
        if (this.info == null) {
            return null;
        }
        return this.info.getEncryptionAlgorithm();
    }

    public void setContentInfo(ContentInfo content) throws PKCS7Exception {
        if (content == null) {
            throw new PKCS7Exception("Null content");
        }
        try {
            this.content = (ContentInfo)content.clone();
        }
        catch (CloneNotSupportedException cloneException) {
            throw new PKCS7Exception("Unable to clone ContentInfo type");
        }
    }

    public void addRecipientInfo(RecipientInfo info) throws PKCS7Exception {
        if (info == null) {
            throw new PKCS7Exception("Null RecipientInfo");
        }
        try {
            this.recipients.addElement((RecipientInfo)info.clone());
        }
        catch (CloneNotSupportedException cloneException) {
            throw new PKCS7Exception("Cannot add this Recipient Information.");
        }
    }

    public Vector<RecipientInfo> getRecipientInfos() {
        return new Vector<RecipientInfo>(this.recipients);
    }

    @Override
    protected int getContentDERLen() throws PKCS7Exception {
        return this.contentDEREncodeInit();
    }

    @Override
    protected int writeContent(byte[] output, int outOffset) throws PKCS7Exception {
        if (output == null) {
            throw new PKCS7Exception("Cannot write EnvelopedData: output array is null.");
        }
        try {
            if (this.contentASN1Template == null) {
                this.getContentDERLen();
            }
            int returnValue = this.contentASN1Template.derEncode(output, outOffset);
            this.contentASN1Template = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.contentASN1Template = null;
            throw new PKCS7Exception("Unable to DER encode EnvelopedData message: ", (Exception)((Object)asnException));
        }
    }

    private int contentDEREncodeInit() throws PKCS7Exception {
        try {
            if (this.flag == 0) {
                this.setContentData();
            }
            if (this.recipients.isEmpty()) {
                throw new PKCS7Exception("RecipientInfos are not set.");
            }
            OfContainer recipientInfos = new OfContainer(0, 12544, (ASN1Container)new EncodedContainer(12288));
            Vector<OfContainer> recipientVector = new Vector<OfContainer>();
            recipientVector.addElement(recipientInfos);
            for (int index = 0; index < this.recipients.size(); ++index) {
                try {
                    RecipientInfo recipientInfo = this.recipients.elementAt(index);
                    int infoLen = recipientInfo.getDERLen(0);
                    byte[] infoDER = new byte[infoLen];
                    infoLen = recipientInfo.getDEREncoding(infoDER, 0, 0);
                    EncodedContainer tempContainer = new EncodedContainer(0, true, 0, infoDER, 0, infoLen);
                    recipientInfos.addContainer((ASN1Container)tempContainer);
                    continue;
                }
                catch (ASN_Exception asnException) {
                    throw new PKCS7Exception("Unable to encode RecipientInfos: ", (Exception)((Object)asnException));
                }
            }
            Object[] asn1Array = new ASN1Container[recipientVector.size()];
            recipientVector.copyInto(asn1Array);
            ASN1Template temp = new ASN1Template((ASN1Container[])asn1Array);
            int recipLen = temp.derEncodeInit();
            byte[] encoding = new byte[recipLen];
            recipLen = temp.derEncode(encoding, 0);
            EncodedContainer infoSet = new EncodedContainer(0, true, 0, encoding, 0, recipLen);
            int infoLen = this.info.getDERLen(0);
            byte[] infoDER = new byte[infoLen];
            infoLen = this.info.getDEREncoding(infoDER, 0, 0);
            EncodedContainer encodedContent = new EncodedContainer(0, true, 0, infoDER, 0, infoLen);
            SequenceContainer seq = new SequenceContainer(0xA10000, true, 0);
            EndContainer endContainer = new EndContainer();
            IntegerContainer intContainer = new IntegerContainer(0, true, 0, this.version);
            this.contentASN1Def = new ASN1Container[5];
            this.contentASN1Def[0] = seq;
            this.contentASN1Def[1] = intContainer;
            this.contentASN1Def[2] = infoSet;
            this.contentASN1Def[3] = encodedContent;
            this.contentASN1Def[4] = endContainer;
            this.contentASN1Template = new ASN1Template(this.contentASN1Def);
            return this.contentASN1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Could not DER encode EnvelopedData: ", (Exception)((Object)asnException));
        }
    }

    private void setContentData() throws PKCS7Exception {
        if (this.version == -1) {
            this.version = 0;
        }
        if (this.content == null) {
            throw new PKCS7Exception("There is no content to encrypt.");
        }
        int lastByte = this.content.getContentType();
        byte[] result = new byte[9];
        System.arraycopy(P7OID, 0, result, 0, 8);
        result[8] = (byte)lastByte;
        this.info.setContentType(result, 0, 9);
        byte[] octets = null;
        try {
            if (this.contentEncoding == null) {
                int contentLen = this.content.getContentInfoDERLen();
                this.contentEncoding = new byte[contentLen];
                this.content.writeMessage(this.contentEncoding, 0);
            }
            SequenceContainer seq = new SequenceContainer(0);
            EndContainer anEnd = new EndContainer();
            OIDContainer localOid = new OIDContainer(0x1000000);
            EncodedContainer encContent = new EncodedContainer(10616576);
            ASN1Container[] returnValue = new ASN1Container[]{seq, localOid, encContent, anEnd};
            ASN1.berDecode((byte[])this.contentEncoding, (int)0, (ASN1Container[])returnValue);
            if (encContent.dataPresent) {
                int skipBytes = 1;
                skipBytes += ASN1Lengths.determineLengthLen((byte[])encContent.data, (int)(encContent.dataOffset + 1));
                ++skipBytes;
                skipBytes += ASN1Lengths.determineLengthLen((byte[])encContent.data, (int)(encContent.dataOffset + skipBytes));
                octets = new byte[encContent.dataLen - skipBytes];
                System.arraycopy(encContent.data, encContent.dataOffset + skipBytes, octets, 0, encContent.dataLen - skipBytes);
            }
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Could not DER encode ContentInfo: ", (Exception)((Object)asnException));
        }
        try {
            byte[] algOID = this.info.getEncryptionAlgorithm();
            if (algOID == null) {
                throw new PKCS7Exception("Encryption Algorithm is not set.");
            }
            if (this.theCertJ == null) {
                throw new PKCS7Exception("CertJ object is NULL; cannot get Random object.");
            }
            JSAFE_SecureRandom random = this.theCertJ.getRandomObject();
            JSAFE_SymmetricCipher cipher = JSAFEFactory.getSymmetricCipher(algOID, 0, this.getDeviceOrJava(), this.theCertJ);
            String name = cipher.getEncryptionAlgorithm();
            this.theKey = JSAFEFactory.getSecretKey(name, this.getDeviceOrJava(), this.theCertJ);
            if (this.theKeyLen != 0) {
                int[] param = new int[]{this.theKeyLen};
                this.theKey.generateInit(param, (SecureRandom)random);
            } else {
                this.theKey.generateInit(null, (SecureRandom)random);
            }
            this.theKey.generate();
            if (octets != null) {
                int outLen = cipher.getOutputBufferSize(octets.length);
                byte[] output = new byte[outLen];
                cipher.encryptInit(this.theKey);
                outLen = cipher.encryptUpdate(octets, 0, octets.length, output, 0);
                outLen += cipher.encryptFinal(output, outLen);
                this.info.setEncryptedContent(output, 0, outLen);
            }
            cipher.clearSensitiveData();
        }
        catch (JSAFE_Exception jsafeException) {
            throw new PKCS7Exception("Could not encrypt content: ", (Exception)((Object)jsafeException));
        }
        catch (RandomException randomException) {
            throw new PKCS7Exception("Could not encrypt content", randomException);
        }
        catch (NoServiceException noServiceException) {
            throw new PKCS7Exception("Could not encrypt content", noServiceException);
        }
        try {
            if (this.theCertPathCtx == null) {
                throw new PKCS7Exception("CertPathCtx object is null, cannot get Database.");
            }
            DatabaseService theDatabase = this.theCertPathCtx.getDatabase();
            Vector<Certificate> certList = new Vector<Certificate>();
            if (this.theCertJ == null) {
                throw new PKCS7Exception("CertJ object is NULL; cannot get Random object.");
            }
            for (int index = 0; index < this.recipients.size(); ++index) {
                RecipientInfo recipient = this.recipients.elementAt(index);
                int certCount = theDatabase.selectCertificateByIssuerAndSerialNumber(recipient.getIssuerName(), recipient.getSerialNumber(), certList);
                if (certCount == 0) {
                    throw new PKCS7Exception("Cannot find this Recipient cert.");
                }
                X509Certificate cert = (X509Certificate)certList.elementAt(0);
                JSAFE_PublicKey publicKey = cert.getSubjectPublicKey(this.getDeviceOrJava());
                JSAFE_SecureRandom random = this.theCertJ.getRandomObject();
                byte[] encryptOID = recipient.getEncryptionAlgorithmOID();
                JSAFE_AsymmetricCipher jsafeCipher = JSAFEFactory.getAsymmetricCipher(encryptOID, 0, this.getDeviceOrJava(), this.theCertJ);
                jsafeCipher.encryptInit(publicKey, (SecureRandom)random, this.theCertJ.getPKCS11Sessions());
                byte[] encryptedKey = jsafeCipher.wrapSecretKey(this.theKey, false);
                recipient.setEncryptedKey(encryptedKey, 0, encryptedKey.length);
                publicKey.clearSensitiveData();
                jsafeCipher.clearSensitiveData();
                certList.removeAllElements();
            }
        }
        catch (JSAFE_Exception jsafeException) {
            throw new PKCS7Exception("Could not encrypt ContentInfo", (Exception)((Object)jsafeException));
        }
        catch (RandomException randomException) {
            throw new PKCS7Exception("Could not encrypt ContentInfo", randomException);
        }
        catch (NoServiceException noServiceException) {
            throw new PKCS7Exception("Could not encrypt ContentInfo", noServiceException);
        }
        catch (DatabaseException databaseExc) {
            throw new PKCS7Exception("Cannot get Cert from DB.", databaseExc);
        }
        catch (CertificateException certException) {
            throw new PKCS7Exception("Cannot get IssuerName and SerialNumber from cert.", certException);
        }
    }

    @Override
    protected boolean contentReadInit(byte[] input, int inOffset, int maxInputLen) throws PKCS7Exception {
        try {
            SequenceContainer seq = new SequenceContainer(0xA10000);
            EndContainer endContainer = new EndContainer();
            IntegerContainer intContainer = new IntegerContainer(0);
            EncodedContainer infoSet = new EncodedContainer(12544);
            EncodedContainer encoding = new EncodedContainer(12288, true, 0, this.maxBufferSize, null, 0, 0);
            this.contentASN1Def = new ASN1Container[5];
            this.contentASN1Def[0] = seq;
            this.contentASN1Def[1] = intContainer;
            this.contentASN1Def[2] = infoSet;
            this.contentASN1Def[3] = encoding;
            this.contentASN1Def[4] = endContainer;
            this.contentASN1Template = new ASN1Template(this.contentASN1Def);
            this.contentASN1Template.berDecodeInit();
            this.contentASN1Template.berDecodeUpdate(input, inOffset, maxInputLen);
            if (this.contentASN1Def[0].checkTag()) {
                return false;
            }
            this.setDecodedValues();
            this.flag = 1;
            return true;
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Could not decode message: ", (Exception)((Object)asnException));
        }
    }

    private void setDecodedValues() throws PKCS7Exception {
        try {
            byte[] output;
            if (this.version == -1) {
                if (this.contentASN1Def[1].isComplete()) {
                    if (this.incompleteContainer == 1) {
                        output = this.copyToOutput(this.contentASN1Def[1]);
                        IntegerContainer integer = new IntegerContainer(0, true, 0, output, 0, output.length, true);
                        this.version = integer.getValueAsInt();
                    } else {
                        this.version = ((IntegerContainer)this.contentASN1Def[1]).getValueAsInt();
                    }
                } else {
                    if (this.contentASN1Def[1].data == null) {
                        return;
                    }
                    this.incompleteContainer = 1;
                    this.copyNewData(this.contentASN1Def[1].data, this.contentASN1Def[1].dataOffset, this.contentASN1Def[1].dataLen, 0);
                    return;
                }
            }
            if (this.recipients.isEmpty()) {
                if (this.contentASN1Def[2].isComplete()) {
                    if (this.incompleteContainer == 2) {
                        output = this.copyToOutput(this.contentASN1Def[2]);
                        this.decodeRecipientInfos(output, 0, output.length);
                    } else {
                        this.decodeRecipientInfos(this.contentASN1Def[2].data, this.contentASN1Def[2].dataOffset, this.contentASN1Def[2].dataLen);
                    }
                } else {
                    if (this.contentASN1Def[2].data == null) {
                        return;
                    }
                    this.incompleteContainer = 2;
                    this.copyNewData(this.contentASN1Def[2].data, this.contentASN1Def[2].dataOffset, this.contentASN1Def[2].dataLen, 0);
                    return;
                }
            }
            if (this.contentASN1Def[3].isComplete()) {
                if (this.incompleteContainer == 3) {
                    output = this.copyToOutput(this.contentASN1Def[3]);
                    this.info = new EncryptedContentInfo(output, 0, 0, this.maxBufferSize);
                } else {
                    this.info = new EncryptedContentInfo(this.contentASN1Def[3].data, this.contentASN1Def[3].dataOffset, 0, this.maxBufferSize);
                }
            } else {
                if (this.contentASN1Def[3].data == null) {
                    return;
                }
                this.incompleteContainer = 3;
                this.copyNewData(this.contentASN1Def[3].data, this.contentASN1Def[3].dataOffset, this.contentASN1Def[3].dataLen, this.maxBufferSize);
                return;
            }
            this.decodeEncryptedKey();
            this.decodeEncryptedContent();
        }
        catch (Exception anyException) {
            throw new PKCS7Exception("Cannot set decoded values.", anyException);
        }
    }

    private void decodeRecipientInfos(byte[] data, int offset, int len) throws PKCS7Exception {
        if (data == null || len == 0) {
            throw new PKCS7Exception("Cannot decode RecipientInfo: data is null.");
        }
        try {
            OfContainer setOf = new OfContainer(0, 12544, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] asn1Def = new ASN1Container[]{setOf};
            ASN1.berDecode((byte[])data, (int)offset, (ASN1Container[])asn1Def);
            int recipientCount = setOf.getContainerCount();
            for (int index = 0; index < recipientCount; ++index) {
                ASN1Container nextContainer = setOf.containerAt(index);
                RecipientInfo recipient = new RecipientInfo(CertJInternalHelper.context(this.theCertJ), nextContainer.data, nextContainer.dataOffset, 0);
                this.addRecipientInfo(recipient);
            }
        }
        catch (Exception anyException) {
            throw new PKCS7Exception("Cannot decode recipientInfo.", anyException);
        }
    }

    private void decodeEncryptedContent() throws PKCS7Exception {
        try {
            byte[] type = this.info.getContentType();
            this.content = ContentInfo.getInstance(type, 0, 9, this.theCertJ, this.theCertPathCtx);
            byte[] algID = this.info.getEncryptionAlgorithm();
            if (algID == null) {
                throw new PKCS7Exception("Encryption Algorithm is not set.");
            }
            byte[] encryptedContent = this.info.getEncryptedContent();
            if (encryptedContent == null) {
                return;
            }
            JSAFE_SymmetricCipher cipher = JSAFEFactory.getSymmetricCipher(algID, 0, this.getDeviceOrJava(), this.theCertJ);
            int outLen = cipher.getOutputBufferSize(encryptedContent.length);
            byte[] output = new byte[outLen];
            cipher.decryptInit(this.theKey);
            outLen = cipher.decryptUpdate(encryptedContent, 0, encryptedContent.length, output, 0);
            outLen += cipher.decryptFinal(output, outLen);
            cipher.clearSensitiveData();
            this.theKey.clearSensitiveData();
            int firstLen = outLen + 1 + ASN1Lengths.getLengthLen((int)outLen);
            byte[] firstEncoding = new byte[firstLen];
            firstEncoding[0] = type[8] == 1 ? 4 : 48;
            firstLen = 1 + ASN1Lengths.writeLength((byte[])firstEncoding, (int)1, (int)outLen);
            System.arraycopy(output, 0, firstEncoding, firstLen, outLen);
            int secondLen = firstEncoding.length + 1 + ASN1Lengths.getLengthLen((int)firstEncoding.length);
            byte[] secondEncoding = new byte[secondLen];
            secondEncoding[0] = -96;
            secondLen = 1 + ASN1Lengths.writeLength((byte[])secondEncoding, (int)1, (int)firstEncoding.length);
            System.arraycopy(firstEncoding, 0, secondEncoding, secondLen, firstEncoding.length);
            SequenceContainer seq = new SequenceContainer(0, true, 0);
            EndContainer anEnd = new EndContainer();
            OIDContainer localOid = new OIDContainer(0x1000000, true, 0, type, 0, type.length);
            EncodedContainer encContent = new EncodedContainer(10616576, true, 0, secondEncoding, 0, secondEncoding.length);
            ASN1Container[] returnValue = new ASN1Container[]{seq, localOid, encContent, anEnd};
            ASN1Template template = new ASN1Template(returnValue);
            int length = template.derEncodeInit();
            byte[] outEncoding = new byte[length];
            template.derEncode(outEncoding, 0);
            if (this.content.readInit(outEncoding, 0, length, 0, this.maxBufferSize) && this.content.readFinal()) {
                return;
            }
        }
        catch (Exception anyException) {
            throw new PKCS7Exception("Cannot decode content.", anyException);
        }
        throw new PKCS7Exception("Cannot decode content.");
    }

    private void decodeEncryptedKey() throws PKCS7Exception {
        if (this.theCertPathCtx == null) {
            throw new PKCS7Exception("CertPathCtx object is null, cannot get Database.");
        }
        if (this.theCertJ == null) {
            throw new PKCS7Exception("CertJ object is NULL.");
        }
        DatabaseService theDatabase = this.theCertPathCtx.getDatabase();
        Vector<Certificate> certList = new Vector<Certificate>();
        JSAFE_PrivateKey privateKey = null;
        try {
            int index;
            for (index = 0; index < this.recipients.size(); ++index) {
                X509Certificate cert;
                RecipientInfo recipient = this.recipients.elementAt(index);
                int certCount = theDatabase.selectCertificateByIssuerAndSerialNumber(recipient.getIssuerName(), recipient.getSerialNumber(), certList);
                if (certCount == 0) continue;
                for (int certIndex = 0; certIndex < certCount && (privateKey = theDatabase.selectPrivateKeyByCertificate(cert = (X509Certificate)certList.elementAt(certIndex))) == null; ++certIndex) {
                }
                if (privateKey == null) {
                    certList.removeAllElements();
                    continue;
                }
                byte[] encryptedKey = recipient.getEncryptedKey();
                if (encryptedKey == null) {
                    throw new PKCS7Exception("Recipient's encrypted Secret key is not set.");
                }
                byte[] algID = this.info.getEncryptionAlgorithm();
                if (algID == null) {
                    throw new PKCS7Exception("Encryption Algorithm is not set.");
                }
                JSAFE_SymmetricCipher cipher = JSAFEFactory.getSymmetricCipher(algID, 0, "Java", this.theCertJ);
                String name = cipher.getEncryptionAlgorithm();
                byte[] encryptOID = recipient.getEncryptionAlgorithmOID();
                if (encryptOID == null) {
                    throw new PKCS7Exception("Recipient's Encryption Algorithm is not set.");
                }
                JSAFE_AsymmetricCipher jsafeCipher = JSAFEFactory.getAsymmetricCipher(encryptOID, 0, this.getDeviceOrJava(), this.theCertJ);
                jsafeCipher.decryptInit(privateKey, this.theCertJ.getPKCS11Sessions());
                byte[] decryptedKeyData = null;
                decryptedKeyData = new byte[jsafeCipher.getOutputBufferSize(encryptedKey.length)];
                int totalLen = jsafeCipher.decryptUpdate(encryptedKey, 0, encryptedKey.length, decryptedKeyData, 0);
                totalLen += jsafeCipher.decryptFinal(decryptedKeyData, totalLen);
                this.theKey = JSAFE_SecretKey.getInstance((String)name, (String)this.getDeviceOrJava());
                this.theKey.setSecretKeyData(decryptedKeyData, 0, totalLen);
                jsafeCipher.clearSensitiveData();
                privateKey.clearSensitiveData();
                certList.removeAllElements();
                break;
            }
            if (index == this.recipients.size()) {
                throw new PKCS7Exception("Private Key is not set");
            }
        }
        catch (NoServiceException noServiceExc) {
            throw new PKCS7Exception("Cannot get Cert from DB.", noServiceExc);
        }
        catch (DatabaseException databaseExc) {
            throw new PKCS7Exception("Cannot get Cert from DB.", databaseExc);
        }
        catch (JSAFE_Exception jsafeException) {
            throw new PKCS7Exception("Could not decode encrypted key", (Exception)((Object)jsafeException));
        }
    }

    @Override
    protected int contentReadUpdate(byte[] input, int inOffset, int maxInputLen) throws PKCS7Exception {
        int bytesToOutput = 0;
        if (input == null) {
            return bytesToOutput;
        }
        if (this.contentASN1Template == null) {
            throw new PKCS7Exception("Call readInit before readUpdate.");
        }
        try {
            if (this.contentASN1Template.isComplete()) {
                return bytesToOutput;
            }
            bytesToOutput = this.contentASN1Template.berDecodeUpdate(input, inOffset, maxInputLen);
            this.setDecodedValues();
            return bytesToOutput;
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Could not decode message: ", (Exception)((Object)asnException));
        }
    }

    public boolean equals(Object obj) {
        int otherLen;
        if (obj == null || !(obj instanceof EnvelopedData)) {
            return false;
        }
        EnvelopedData other = (EnvelopedData)obj;
        if (other.version != this.version) {
            return false;
        }
        if (this.content != null && !this.content.equals(other.content)) {
            return false;
        }
        int thisLen = this.recipients.size();
        if (thisLen != (otherLen = other.recipients.size())) {
            return false;
        }
        for (int index = 0; index < thisLen; ++index) {
            int otherIndex;
            if (this.recipients.elementAt(index) == null) continue;
            for (otherIndex = 0; otherIndex < otherLen && !this.recipients.elementAt(index).equals(other.recipients.elementAt(otherIndex)); ++otherIndex) {
            }
            if (otherIndex != otherLen) continue;
            return false;
        }
        return !(this.info != null ? !this.info.equals(other.info) : other.info != null);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + CertJInternalHelper.hashCodeValue(this.content);
        result = prime * result + CertJInternalHelper.hashCodeValue(this.info);
        result = prime * result + CertJInternalHelper.hashCodeValue(this.recipients);
        result = prime * result + this.version;
        return result;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EnvelopedData otherSelf = (EnvelopedData)super.clone();
        otherSelf.version = this.version;
        otherSelf.recipients = new Vector<RecipientInfo>(this.recipients);
        otherSelf.info = (EncryptedContentInfo)this.info.clone();
        return otherSelf;
    }

    @Override
    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.recipients.clear();
        this.version = -1;
        this.info = new EncryptedContentInfo();
    }
}

