/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.pkcs7;

import com.rsa.certj.pkcs7.PKCS7Exception;
import java.io.ByteArrayOutputStream;
import java.util.StringTokenizer;

final class Pkcs7Util {
    private Pkcs7Util() {
    }

    static byte[] oidStrToArray(String dottedOID) throws PKCS7Exception {
        byte[] oidArray = null;
        if (dottedOID == null) {
            throw new PKCS7Exception("OID is null");
        }
        if (dottedOID.trim().length() > 1) {
            StringTokenizer tok = new StringTokenizer(dottedOID, ".");
            int elementCount = 0;
            int firstElement = 0;
            try {
                ByteArrayOutputStream oidStream = new ByteArrayOutputStream();
                while (tok.hasMoreElements()) {
                    Integer currentElement = new Integer(tok.nextToken());
                    if (elementCount == 0) {
                        if (currentElement > 2) {
                            throw new PKCS7Exception("OID is invalid");
                        }
                        firstElement = currentElement;
                    }
                    if (elementCount == 1) {
                        if (firstElement < 2 && currentElement > 39) {
                            throw new PKCS7Exception("OID is invalid");
                        }
                        currentElement = new Integer(firstElement * 40 + currentElement);
                    }
                    if (elementCount > 0) {
                        if ((long)currentElement.intValue() < 128L) {
                            oidStream.write(currentElement);
                        } else if ((long)currentElement.intValue() < 16384L) {
                            oidStream.write(currentElement >>> 7 | 0x80);
                            oidStream.write((int)(currentElement & 0x7F));
                        } else if ((long)currentElement.intValue() < 0x200000L) {
                            oidStream.write(currentElement >>> 14 | 0x80);
                            oidStream.write((currentElement >>> 7 | 0x80) & 0xFF);
                            oidStream.write((int)(currentElement & 0x7F));
                        } else if ((long)currentElement.intValue() < 0x10000000L) {
                            oidStream.write(currentElement >>> 21 | 0x80);
                            oidStream.write((currentElement >>> 14 | 0x80) & 0xFF);
                            oidStream.write((currentElement >>> 7 | 0x80) & 0xFF);
                            oidStream.write((int)(currentElement & 0x7F));
                        } else {
                            oidStream.write(currentElement >>> 28 | 0x80);
                            oidStream.write(currentElement >>> 21 | 0x80);
                            oidStream.write((currentElement >>> 14 | 0x80) & 0xFF);
                            oidStream.write((currentElement >>> 7 | 0x80) & 0xFF);
                            oidStream.write((int)(currentElement & 0x7F));
                        }
                    }
                    ++elementCount;
                }
                oidStream.close();
                oidArray = oidStream.toByteArray();
            }
            catch (Exception e) {
                throw new PKCS7Exception("OID processing failed - error was: ", e);
            }
        }
        return oidArray;
    }
}

