/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.pkcs7;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.FIPS140Mode;
import com.rsa.certj.FIPS140Role;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.internal.CertJContext;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.jsafe.JSAFE_AsymmetricCipher;
import com.rsa.jsafe.JSAFE_Exception;
import java.io.Serializable;
import java.util.Arrays;

public class RecipientInfo
implements Cloneable,
Serializable {
    private int version = 0;
    private X500Name issuer;
    private byte[] serialNumber;
    private byte[] keyEncryptionOID;
    private byte[] encryptedKey;
    private String algorithmName;
    protected static int special;
    private ASN1Template asn1Template;
    private final CertJContext context;

    public RecipientInfo() {
        this(CertJContext.getCertJContext());
    }

    public RecipientInfo(FIPS140Mode mode) {
        this(CertJContext.getCertJContext(mode));
    }

    public RecipientInfo(FIPS140Mode mode, FIPS140Role role) {
        this(CertJContext.getCertJContext(mode, role));
    }

    protected RecipientInfo(byte[] infoBER, int offset, int special) throws PKCS7Exception {
        this(CertJContext.getCertJContext(), infoBER, offset, special);
    }

    protected RecipientInfo(byte[] infoBER, int offset, int special, FIPS140Mode mode) throws PKCS7Exception {
        this(CertJContext.getCertJContext(mode), infoBER, offset, special);
    }

    protected RecipientInfo(byte[] infoBER, int offset, int special, FIPS140Mode mode, FIPS140Role role) throws PKCS7Exception {
        this(CertJContext.getCertJContext(mode, role), infoBER, offset, special);
    }

    RecipientInfo(CertJContext context) {
        this.context = context;
    }

    RecipientInfo(CertJContext context, byte[] infoBER, int offset, int special) throws PKCS7Exception {
        this.context = context;
        if (infoBER == null) {
            throw new PKCS7Exception("Cannot create RecipientInfo: encoding is null.");
        }
        try {
            SequenceContainer aSeq = new SequenceContainer(special);
            EndContainer anEnd = new EndContainer();
            IntegerContainer vers = new IntegerContainer(0);
            EncodedContainer issuerAndserial = new EncodedContainer(12288);
            EncodedContainer encryptID = new EncodedContainer(12288);
            OctetStringContainer encryptKey = new OctetStringContainer(0);
            ASN1Container[] infoStringDef = new ASN1Container[]{aSeq, vers, issuerAndserial, encryptID, encryptKey, anEnd};
            ASN1.berDecode((byte[])infoBER, (int)offset, (ASN1Container[])infoStringDef);
            this.version = vers.getValueAsInt();
            SequenceContainer bSeq = new SequenceContainer(special);
            EncodedContainer iss = new EncodedContainer(12288);
            IntegerContainer serial = new IntegerContainer(0);
            ASN1Container[] issAndSerialDef = new ASN1Container[]{bSeq, iss, serial, anEnd};
            ASN1.berDecode((byte[])issuerAndserial.data, (int)issuerAndserial.dataOffset, (ASN1Container[])issAndSerialDef);
            this.issuer = new X500Name(iss.data, iss.dataOffset, 0);
            this.serialNumber = new byte[serial.dataLen];
            System.arraycopy(serial.data, serial.dataOffset, this.serialNumber, 0, serial.dataLen);
            this.keyEncryptionOID = new byte[encryptID.dataLen];
            System.arraycopy(encryptID.data, encryptID.dataOffset, this.keyEncryptionOID, 0, encryptID.dataLen);
            this.encryptedKey = new byte[encryptKey.dataLen];
            System.arraycopy(encryptKey.data, encryptKey.dataOffset, this.encryptedKey, 0, encryptKey.dataLen);
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Cannot decode the BER of the RecipientInfo.");
        }
        catch (NameException nameException) {
            throw new PKCS7Exception("Cannot decode the BER of the RecipientInfo.");
        }
    }

    public void setVersionNumber(int version) {
        this.version = version;
    }

    public int getVersionNumber() {
        return this.version;
    }

    public void setIssuerAndSerialNumber(X500Name name, byte[] number, int offset, int length) throws PKCS7Exception {
        if (name == null) {
            throw new PKCS7Exception("Issuer name is null.");
        }
        try {
            this.issuer = (X500Name)name.clone();
        }
        catch (CloneNotSupportedException cloneExc) {
            throw new PKCS7Exception("Invalid name.");
        }
        if (number == null || length <= 0) {
            throw new PKCS7Exception("SerialNumber is null.");
        }
        if (offset < 0 || offset + length > number.length) {
            throw new PKCS7Exception("Invalid SerialNumber");
        }
        this.serialNumber = new byte[length];
        System.arraycopy(number, offset, this.serialNumber, 0, length);
    }

    public X500Name getIssuerName() throws PKCS7Exception {
        if (this.issuer == null) {
            return null;
        }
        try {
            return (X500Name)this.issuer.clone();
        }
        catch (CloneNotSupportedException cloneExc) {
            throw new PKCS7Exception("Invalid attributes.");
        }
    }

    public byte[] getSerialNumber() {
        if (this.serialNumber == null) {
            return null;
        }
        return (byte[])this.serialNumber.clone();
    }

    public void setEncryptionAlgorithm(String algName) throws PKCS7Exception {
        if (algName == null) {
            throw new PKCS7Exception("Could not set algorithm OID: name is null.");
        }
        this.algorithmName = algName;
        try {
            JSAFE_AsymmetricCipher jsafeCipher = JSAFEFactory.getAsymmetricCipher(algName, "Java", this.context.jsafe);
            this.keyEncryptionOID = jsafeCipher.getDERAlgorithmID();
        }
        catch (JSAFE_Exception jsafeException) {
            throw new PKCS7Exception("Could not set algorithm OID: ", (Exception)((Object)jsafeException));
        }
    }

    public void setEncryptionAlgorithm(byte[] encryptOID, int offset, int len) throws PKCS7Exception {
        if (encryptOID == null || len <= 0) {
            throw new PKCS7Exception("Could not set algorithm OID: OID is null");
        }
        if (offset < 0 || offset + len > encryptOID.length) {
            throw new PKCS7Exception("Invalid Encryption Algorithm Identifier.");
        }
        this.keyEncryptionOID = new byte[len];
        System.arraycopy(encryptOID, offset, this.keyEncryptionOID, 0, len);
    }

    public byte[] getEncryptionAlgorithmOID() {
        if (this.keyEncryptionOID == null) {
            return null;
        }
        return (byte[])this.keyEncryptionOID.clone();
    }

    public String getEncryptionAlgorithmName() throws PKCS7Exception {
        if (this.keyEncryptionOID == null) {
            return null;
        }
        if (this.algorithmName != null) {
            return this.algorithmName;
        }
        try {
            JSAFE_AsymmetricCipher jsafeCipher = JSAFEFactory.getAsymmetricCipher(this.keyEncryptionOID, 0, "Java", this.context.jsafe);
            return jsafeCipher.getEncryptionAlgorithm();
        }
        catch (JSAFE_Exception jsafeException) {
            throw new PKCS7Exception("Could not get algorithm OID: ", (Exception)((Object)jsafeException));
        }
    }

    protected void setEncryptedKey(byte[] keyData, int offset, int len) {
        this.encryptedKey = new byte[len];
        System.arraycopy(keyData, offset, this.encryptedKey, 0, len);
    }

    public byte[] getEncryptedKey() {
        if (this.encryptedKey == null) {
            return null;
        }
        return (byte[])this.encryptedKey.clone();
    }

    protected static int getNextBEROffset(byte[] infoBER, int offset) throws PKCS7Exception {
        if (infoBER == null) {
            throw new PKCS7Exception("Encoding is null.");
        }
        if (infoBER[offset] == 0 && infoBER[offset + 1] == 0) {
            return offset + 2;
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])infoBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])infoBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Unable to determine length of the BER: ", (Exception)((Object)asnException));
        }
    }

    protected int getDERLen(int special) throws PKCS7Exception {
        RecipientInfo.special = special;
        return this.derEncodeInit();
    }

    protected int getDEREncoding(byte[] encoding, int offset, int special) throws PKCS7Exception {
        if (encoding == null) {
            throw new PKCS7Exception("Specified array is null.");
        }
        try {
            int len;
            if ((this.asn1Template == null || special != RecipientInfo.special) && (len = this.getDERLen(special)) == 0) {
                throw new PKCS7Exception("Unable to encode RecipientInfo.");
            }
            int returnValue = this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new PKCS7Exception("Unable to encode RecipientInfo: ", (Exception)((Object)asnException));
        }
    }

    private int derEncodeInit() {
        try {
            if (this.issuer == null) {
                return 0;
            }
            int len = this.issuer.getDERLen(0);
            if (len == 0) {
                return 0;
            }
            byte[] encoding0 = new byte[len];
            this.issuer.getDEREncoding(encoding0, 0, 0);
            SequenceContainer bSeq = new SequenceContainer(0, true, 0);
            EndContainer anEnd = new EndContainer();
            EncodedContainer iss = new EncodedContainer(12288, true, 0, encoding0, 0, encoding0.length);
            if (this.serialNumber == null) {
                return 0;
            }
            IntegerContainer serial = (this.serialNumber[0] & 0x80) >> 7 == 0 ? new IntegerContainer(0, true, 0, this.serialNumber, 0, this.serialNumber.length, true) : new IntegerContainer(0, true, 0, this.serialNumber, 0, this.serialNumber.length, false);
            ASN1Container[] issAndSerialDef = new ASN1Container[]{bSeq, iss, serial, anEnd};
            ASN1Template issTemplate = new ASN1Template(issAndSerialDef);
            len = issTemplate.derEncodeInit();
            byte[] encoding = new byte[len];
            issTemplate.derEncode(encoding, 0);
            if (this.keyEncryptionOID == null) {
                return 0;
            }
            if (this.encryptedKey == null) {
                return 0;
            }
            SequenceContainer aSeq = new SequenceContainer(special, true, 0);
            IntegerContainer vers = new IntegerContainer(0, true, 0, this.version);
            EncodedContainer issuerAndserial = new EncodedContainer(12288, true, 0, encoding, 0, encoding.length);
            EncodedContainer keyEncryptID = new EncodedContainer(12288, true, 0, this.keyEncryptionOID, 0, this.keyEncryptionOID.length);
            OctetStringContainer encryptKey = new OctetStringContainer(0, true, 0, this.encryptedKey, 0, this.encryptedKey.length);
            ASN1Container[] infoStringDef = new ASN1Container[]{aSeq, vers, issuerAndserial, keyEncryptID, encryptKey, anEnd};
            this.asn1Template = new ASN1Template(infoStringDef);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
        catch (NameException nameException) {
            return 0;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RecipientInfo)) {
            return false;
        }
        RecipientInfo other = (RecipientInfo)obj;
        if (this.version != other.version) {
            return false;
        }
        if (this.issuer != null ? !this.issuer.equals(other.issuer) : other.issuer != null) {
            return false;
        }
        return CertJUtils.byteArraysEqual(this.serialNumber, other.serialNumber) && CertJUtils.byteArraysEqual(this.keyEncryptionOID, other.keyEncryptionOID) && CertJUtils.byteArraysEqual(this.encryptedKey, other.encryptedKey);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(this.encryptedKey);
        result = prime * result + CertJInternalHelper.hashCodeValue(this.issuer);
        result = prime * result + Arrays.hashCode(this.keyEncryptionOID);
        result = prime * result + Arrays.hashCode(this.serialNumber);
        result = prime * result + this.version;
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        RecipientInfo otherSelf = new RecipientInfo(this.context);
        otherSelf.version = this.version;
        if (this.issuer != null) {
            otherSelf.issuer = (X500Name)this.issuer.clone();
        }
        if (this.serialNumber != null) {
            otherSelf.serialNumber = new byte[this.serialNumber.length];
            System.arraycopy(this.serialNumber, 0, otherSelf.serialNumber, 0, this.serialNumber.length);
        }
        if (this.keyEncryptionOID != null) {
            otherSelf.keyEncryptionOID = new byte[this.keyEncryptionOID.length];
            System.arraycopy(this.keyEncryptionOID, 0, otherSelf.keyEncryptionOID, 0, this.keyEncryptionOID.length);
        }
        if (this.encryptedKey != null) {
            otherSelf.encryptedKey = new byte[this.encryptedKey.length];
            System.arraycopy(this.encryptedKey, 0, otherSelf.encryptedKey, 0, this.encryptedKey.length);
        }
        if (this.asn1Template != null) {
            otherSelf.derEncodeInit();
        }
        return otherSelf;
    }
}

