/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.pkcs7;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OIDList;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJException;
import com.rsa.certj.CertJInternalHelper;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.Provider;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.attributes.ContentType;
import com.rsa.certj.cert.attributes.MessageDigest;
import com.rsa.certj.cert.attributes.X501Attribute;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.certj.pkcs7.ContentInfo;
import com.rsa.certj.pkcs7.DigestedData;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.certj.pkcs7.SignerInfo;
import com.rsa.certj.provider.db.MemoryDB;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.path.CertPathException;
import com.rsa.certj.spi.random.RandomException;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_MessageDigest;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_Signature;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignedData
extends ContentInfo {
    protected static final int CONTENT_INFO_PREFIX_LEN = 4;
    protected int version = -1;
    protected Vector<byte[]> digestIDs = new Vector();
    protected Vector<byte[]> digests = new Vector();
    protected Vector<Integer> digestLengths = new Vector();
    protected Vector<String> digestNames = new Vector();
    protected Vector<X509Certificate> certs = new Vector();
    protected Vector<X509CRL> crls = new Vector();
    protected Vector<SignerInfo> signers = new Vector();
    private boolean detachedFlag = false;
    protected boolean preDigestFlag = false;
    private Vector<SignerInfo> failSigners = new Vector();
    private Vector<SignerInfo> failedPathSigners = new Vector();
    private Vector<SignerInfo> notFoundCertSigners = new Vector();
    private static final String JAVA = "Java";

    public SignedData(CertJ certJ, CertPathCtx pathCtx) {
        this.contentType = 2;
        this.theCertJ = certJ;
        this.theCertPathCtx = pathCtx;
    }

    public void setContentInfo(ContentInfo content) throws PKCS7Exception {
        if (content == null) {
            throw new PKCS7Exception("Unable to set: content is null.");
        }
        try {
            this.content = (ContentInfo)content.clone();
        }
        catch (CloneNotSupportedException cloneException) {
            throw new PKCS7Exception("Unable to clone content ", cloneException);
        }
    }

    public void setVersionNumber(int versionNumber) {
        this.version = versionNumber;
    }

    public void setDigest(byte[] digest, String algName) throws PKCS7Exception {
        int index = this.digestNames.indexOf(algName);
        if (index == -1) {
            byte[] algID = DigestedData.setDigestAlgorithmInternal(this.theCertJ, algName);
            this.digestIDs.addElement(algID);
            this.digestNames.addElement(algName);
            this.digests.addElement(digest);
            this.digestLengths.addElement(new Integer(digest.length));
        } else {
            this.digests.setElementAt(digest, index);
            this.digestLengths.setElementAt(new Integer(digest.length), index);
        }
        this.preDigestFlag = true;
    }

    public int getVersionNumber() {
        return this.version;
    }

    public void addCertificate(X509Certificate cert) throws PKCS7Exception {
        if (cert == null) {
            throw new PKCS7Exception("Certificate is null.");
        }
        this.certs.addElement(cert);
    }

    public Vector<X509Certificate> getCertificates() throws PKCS7Exception {
        return new Vector<X509Certificate>(this.certs);
    }

    public Vector<X509CRL> getCRLs() throws PKCS7Exception {
        return new Vector<X509CRL>(this.crls);
    }

    public void addCRL(X509CRL crl) throws PKCS7Exception {
        if (crl == null) {
            throw new PKCS7Exception("CRL is null.");
        }
        this.crls.addElement(crl);
    }

    public void addSignerInfo(SignerInfo info) throws PKCS7Exception {
        if (info == null) {
            throw new PKCS7Exception("Cannot add this Signer Information: it is null.");
        }
        try {
            this.signers.addElement((SignerInfo)info.clone());
        }
        catch (CloneNotSupportedException cloneException) {
            throw new PKCS7Exception("Cannot add this Signer Information: ", cloneException);
        }
    }

    public void createDetachedSignature() {
        this.detachedFlag = true;
    }

    public Vector<SignerInfo> getSignerInfos() {
        return new Vector<SignerInfo>(this.signers);
    }

    @Override
    protected int getContentDERLen() throws PKCS7Exception {
        return this.contentDEREncodeInit();
    }

    @Override
    protected int writeContent(byte[] output, int outOffset) throws PKCS7Exception {
        if (output == null) {
            throw new PKCS7Exception("Specified array is null.");
        }
        try {
            if (this.contentASN1Template == null) {
                this.getContentDERLen();
            }
            int returnValue = this.contentASN1Template.derEncode(output, outOffset);
            this.contentASN1Template = null;
            return returnValue;
        }
        catch (ASN_Exception asnException) {
            this.contentASN1Template = null;
            throw new PKCS7Exception("Unable to DER encode SignedData message: ", (Exception)((Object)asnException));
        }
    }

    @Override
    public int estimateContentInfoDERLen() throws PKCS7Exception {
        SequenceContainer seq = new SequenceContainer(0, true, 0);
        EndContainer anEnd = new EndContainer();
        try {
            OIDContainer localOid = new OIDContainer(0x1000000, true, 0, null, 0, 9);
            EncodedContainer encContent = new EncodedContainer(10616576, true, 0, this.maxBufferSize, null, 0, this.estimateContentDERLen());
            ASN1Container[] contentInfoType = new ASN1Container[]{seq, localOid, encContent, anEnd};
            return new ASN1Template(contentInfoType).derEncodeInit();
        }
        catch (ASN_Exception e) {
            throw new PKCS7Exception("ContentInfo.getASN1Containers: ", (Exception)((Object)e));
        }
    }

    @Override
    protected int estimateContentDERLen() throws PKCS7Exception {
        try {
            EncodedContainer infoSet;
            EncodedContainer tempContainer;
            EncodedContainer oidSet;
            ASN1Template temp;
            Object[] asn1Array;
            Vector<SignerInfo> clonedSigners = new Vector<SignerInfo>();
            Iterator<SignerInfo> signersIter = this.signers.iterator();
            try {
                while (signersIter.hasNext()) {
                    clonedSigners.add((SignerInfo)signersIter.next().clone());
                }
            }
            catch (CloneNotSupportedException e) {
                throw new PKCS7Exception(e);
            }
            if (this.flag == 0) {
                this.estimationSetContentData(clonedSigners);
            }
            if (!this.digestIDs.isEmpty()) {
                EncodedContainer oidTemp = new EncodedContainer(12288, true, 0, null, 0, 0);
                OfContainer digestOIDs = new OfContainer(0, true, 0, 12544, (ASN1Container)oidTemp);
                Vector<OfContainer> digestVector = new Vector<OfContainer>();
                digestVector.addElement(digestOIDs);
                for (int index = 0; index < this.digestIDs.size(); ++index) {
                    try {
                        byte[] digest = this.digestIDs.elementAt(index);
                        EncodedContainer localOid = new EncodedContainer(12288, true, 0, null, 0, digest.length);
                        digestOIDs.addContainer((ASN1Container)localOid);
                        continue;
                    }
                    catch (ASN_Exception asnException) {
                        throw new PKCS7Exception("Unable to encode digest Alg IDs: ", (Exception)((Object)asnException));
                    }
                }
                asn1Array = new ASN1Container[digestVector.size()];
                digestVector.copyInto(asn1Array);
                temp = new ASN1Template((ASN1Container[])asn1Array);
                int oidLen = temp.derEncodeInit();
                oidSet = new EncodedContainer(0, true, 0, null, 0, oidLen);
            } else {
                oidSet = new EncodedContainer(0, true, 0, null, 0, 2);
            }
            if (!clonedSigners.isEmpty()) {
                OfContainer signerInfos = new OfContainer(0, true, 0, 12544, (ASN1Container)new EncodedContainer(12288));
                Vector<OfContainer> signerVector = new Vector<OfContainer>();
                signerVector.addElement(signerInfos);
                DatabaseService theDatabase = this.theCertPathCtx.getDatabase();
                if (theDatabase == null) {
                    throw new PKCS7Exception("database field of theCertPathCtx object cannot be null.");
                }
                for (int index = 0; index < clonedSigners.size(); ++index) {
                    try {
                        SignerInfo clonedSigner = clonedSigners.elementAt(index);
                        int infoLen = clonedSigner.getDERLen(0);
                        tempContainer = new EncodedContainer(0, true, 0, null, 0, infoLen);
                        signerInfos.addContainer((ASN1Container)tempContainer);
                        continue;
                    }
                    catch (ASN_Exception asnException) {
                        throw new PKCS7Exception("Unable to encode SignerInfos: ", (Exception)((Object)asnException));
                    }
                }
                asn1Array = new ASN1Container[signerVector.size()];
                signerVector.copyInto(asn1Array);
                temp = new ASN1Template((ASN1Container[])asn1Array);
                int signLen = temp.derEncodeInit();
                infoSet = new EncodedContainer(0, true, 0, null, 0, signLen);
            } else {
                infoSet = new EncodedContainer(0, true, 0, null, 0, 2);
            }
            EncodedContainer certSet = null;
            if (!this.certs.isEmpty()) {
                int certLen;
                OfContainer certsOf = new OfContainer(0x810000, true, 0, 12544, (ASN1Container)new EncodedContainer(12288));
                Vector<OfContainer> certVector = new Vector<OfContainer>();
                certVector.addElement(certsOf);
                for (X509Certificate cert : this.certs) {
                    try {
                        certLen = cert.getDERLen(0);
                        tempContainer = new EncodedContainer(0, true, 0, null, 0, certLen);
                        certsOf.addContainer((ASN1Container)tempContainer);
                    }
                    catch (ASN_Exception asnException) {
                        throw new PKCS7Exception("Unable to encode Certificates: ", (Exception)((Object)asnException));
                    }
                }
                asn1Array = new ASN1Container[certVector.size()];
                certVector.copyInto(asn1Array);
                temp = new ASN1Template((ASN1Container[])asn1Array);
                certLen = temp.derEncodeInit();
                certSet = new EncodedContainer(0, true, 0, null, 0, certLen);
            }
            EncodedContainer crlSet = null;
            if (!this.crls.isEmpty()) {
                int crlLen;
                OfContainer crlsOf = new OfContainer(0x810001, true, 0, 12544, (ASN1Container)new EncodedContainer(12288));
                Vector<OfContainer> crlVector = new Vector<OfContainer>();
                crlVector.addElement(crlsOf);
                for (X509CRL crl : this.crls) {
                    try {
                        crlLen = crl.getDERLen(0);
                        tempContainer = new EncodedContainer(0, true, 0, null, 0, crlLen);
                        crlsOf.addContainer((ASN1Container)tempContainer);
                    }
                    catch (ASN_Exception asnException) {
                        throw new PKCS7Exception("Unable to encode CRLs: ", (Exception)((Object)asnException));
                    }
                }
                Object[] asn1Array2 = new ASN1Container[crlVector.size()];
                crlVector.copyInto(asn1Array2);
                ASN1Template temp2 = new ASN1Template((ASN1Container[])asn1Array2);
                crlLen = temp2.derEncodeInit();
                crlSet = new EncodedContainer(0, true, 0, null, 0, crlLen);
            }
            if (this.content == null && !this.preDigestFlag) {
                throw new PKCS7Exception("Content is NULL.");
            }
            int contentLen = this.detachedFlag ? (this.oid == null ? 13 : this.oid.length + 4) : (this.contentEncoding == null ? this.content.estimateContentInfoDERLen() : this.contentEncoding.length);
            EncodedContainer contentData = new EncodedContainer(0, true, 0, null, 0, contentLen);
            if (this.version == -1) {
                this.version = 1;
            }
            SequenceContainer seq = new SequenceContainer(0xA10000, true, 0);
            EndContainer endContainer = new EndContainer();
            IntegerContainer intContainer = new IntegerContainer(0, true, 0, this.version);
            if (!this.crls.isEmpty()) {
                if (!this.certs.isEmpty()) {
                    ASN1Container[] contentASN1Def1 = new ASN1Container[]{seq, intContainer, oidSet, contentData, certSet, crlSet, infoSet, endContainer};
                    this.contentASN1Template = new ASN1Template(contentASN1Def1);
                } else {
                    ASN1Container[] contentASN1Def2 = new ASN1Container[]{seq, intContainer, oidSet, contentData, crlSet, infoSet, endContainer};
                    this.contentASN1Template = new ASN1Template(contentASN1Def2);
                }
            } else if (!this.certs.isEmpty()) {
                ASN1Container[] contentASN1Def3 = new ASN1Container[]{seq, intContainer, oidSet, contentData, certSet, infoSet, endContainer};
                this.contentASN1Template = new ASN1Template(contentASN1Def3);
            } else {
                ASN1Container[] contentASN1Def4 = new ASN1Container[]{seq, intContainer, oidSet, contentData, infoSet, endContainer};
                this.contentASN1Template = new ASN1Template(contentASN1Def4);
            }
            return this.contentASN1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Could not DER encode SignedData: ", (Exception)((Object)asnException));
        }
    }

    private int contentDEREncodeInit() throws PKCS7Exception {
        try {
            EncodedContainer infoSet;
            EncodedContainer tempContainer;
            EncodedContainer oidSet;
            byte[] encoding;
            Object[] asn1Array;
            if (this.flag == 0) {
                this.setContentData();
            }
            if (!this.digestIDs.isEmpty()) {
                EncodedContainer oidTemp = new EncodedContainer(12288, true, 0, null, 0, 0);
                OfContainer digestOIDs = new OfContainer(0, true, 0, 12544, (ASN1Container)oidTemp);
                Vector<OfContainer> digestVector = new Vector<OfContainer>();
                digestVector.addElement(digestOIDs);
                for (byte[] digest : this.digestIDs) {
                    try {
                        EncodedContainer localOid = new EncodedContainer(12288, true, 0, digest, 0, digest.length);
                        digestOIDs.addContainer((ASN1Container)localOid);
                    }
                    catch (ASN_Exception asnException) {
                        throw new PKCS7Exception("Unable to encode digest Alg IDs: ", (Exception)((Object)asnException));
                    }
                }
                asn1Array = new ASN1Container[digestVector.size()];
                digestVector.copyInto(asn1Array);
                ASN1Template temp = new ASN1Template((ASN1Container[])asn1Array);
                int oidLen = temp.derEncodeInit();
                encoding = new byte[oidLen];
                oidLen = temp.derEncode(encoding, 0);
                oidSet = new EncodedContainer(0, true, 0, encoding, 0, oidLen);
            } else {
                byte[] encoding2 = new byte[]{49, 0};
                oidSet = new EncodedContainer(0, true, 0, encoding2, 0, 2);
            }
            if (!this.signers.isEmpty()) {
                OfContainer signerInfos = new OfContainer(0, true, 0, 12544, (ASN1Container)new EncodedContainer(12288));
                Vector<OfContainer> signerVector = new Vector<OfContainer>();
                signerVector.addElement(signerInfos);
                for (SignerInfo info : this.signers) {
                    try {
                        int infoLen = info.getDERLen(0);
                        byte[] infoDER = new byte[infoLen];
                        infoLen = info.getDEREncoding(infoDER, 0, 0);
                        tempContainer = new EncodedContainer(0, true, 0, infoDER, 0, infoLen);
                        signerInfos.addContainer((ASN1Container)tempContainer);
                    }
                    catch (ASN_Exception asnException) {
                        throw new PKCS7Exception("Unable to encode SignerInfos: ", (Exception)((Object)asnException));
                    }
                }
                Object[] asn1Array2 = new ASN1Container[signerVector.size()];
                signerVector.copyInto(asn1Array2);
                ASN1Template temp = new ASN1Template((ASN1Container[])asn1Array2);
                int signLen = temp.derEncodeInit();
                byte[] encoding3 = new byte[signLen];
                signLen = temp.derEncode(encoding3, 0);
                infoSet = new EncodedContainer(0, true, 0, encoding3, 0, signLen);
            } else {
                byte[] encoding4 = new byte[]{49, 0};
                infoSet = new EncodedContainer(0, true, 0, encoding4, 0, 2);
            }
            EncodedContainer certSet = null;
            if (!this.certs.isEmpty()) {
                OfContainer certsOf = new OfContainer(0x810000, true, 0, 12544, (ASN1Container)new EncodedContainer(12288));
                Vector<OfContainer> certVector = new Vector<OfContainer>();
                certVector.addElement(certsOf);
                for (X509Certificate cert : this.certs) {
                    try {
                        int certLen = cert.getDERLen(0);
                        byte[] certDER = new byte[certLen];
                        certLen = cert.getDEREncoding(certDER, 0, 0);
                        tempContainer = new EncodedContainer(0, true, 0, certDER, 0, certLen);
                        certsOf.addContainer((ASN1Container)tempContainer);
                    }
                    catch (ASN_Exception asnException) {
                        throw new PKCS7Exception("Unable to encode Certificates: ", (Exception)((Object)asnException));
                    }
                    catch (CertificateException certException) {
                        throw new PKCS7Exception("Unable to encode Certificates: ", certException);
                    }
                }
                asn1Array = new ASN1Container[certVector.size()];
                certVector.copyInto(asn1Array);
                ASN1Template temp = new ASN1Template((ASN1Container[])asn1Array);
                int certLen = temp.derEncodeInit();
                encoding = new byte[certLen];
                certLen = temp.derEncode(encoding, 0);
                certSet = new EncodedContainer(0, true, 0, encoding, 0, certLen);
            }
            EncodedContainer crlSet = null;
            if (!this.crls.isEmpty()) {
                OfContainer crlsOf = new OfContainer(0x810001, true, 0, 12544, (ASN1Container)new EncodedContainer(12288));
                Vector<OfContainer> crlVector = new Vector<OfContainer>();
                crlVector.addElement(crlsOf);
                for (X509CRL crl : this.crls) {
                    try {
                        int crlLen = crl.getDERLen(0);
                        byte[] crlDER = new byte[crlLen];
                        crlLen = crl.getDEREncoding(crlDER, 0, 0);
                        tempContainer = new EncodedContainer(0, true, 0, crlDER, 0, crlLen);
                        crlsOf.addContainer((ASN1Container)tempContainer);
                    }
                    catch (ASN_Exception asnException) {
                        throw new PKCS7Exception("Unable to encode CRLs: ", (Exception)((Object)asnException));
                    }
                    catch (CertificateException certException) {
                        throw new PKCS7Exception("Unable to encode CRLs: ", certException);
                    }
                }
                Object[] asn1Array3 = new ASN1Container[crlVector.size()];
                crlVector.copyInto(asn1Array3);
                ASN1Template temp = new ASN1Template((ASN1Container[])asn1Array3);
                int crlLen = temp.derEncodeInit();
                byte[] encoding5 = new byte[crlLen];
                crlLen = temp.derEncode(encoding5, 0);
                crlSet = new EncodedContainer(0, true, 0, encoding5, 0, crlLen);
            }
            if (this.content == null && !this.preDigestFlag) {
                throw new PKCS7Exception("Content is NULL.");
            }
            if (this.detachedFlag) {
                this.assignDetachedMessageContentInfoSeq();
            } else if (this.contentEncoding == null) {
                int contentLen = this.content.getContentInfoDERLen();
                this.contentEncoding = new byte[contentLen];
                this.content.writeMessage(this.contentEncoding, 0);
            }
            EncodedContainer contentData = new EncodedContainer(0, true, 0, this.contentEncoding, 0, this.contentEncoding.length);
            if (this.version == -1) {
                this.version = 1;
            }
            SequenceContainer seq = new SequenceContainer(0xA10000, true, 0);
            EndContainer endContainer = new EndContainer();
            IntegerContainer intContainer = new IntegerContainer(0, true, 0, this.version);
            if (!this.crls.isEmpty()) {
                if (!this.certs.isEmpty()) {
                    ASN1Container[] contentASN1Def1 = new ASN1Container[]{seq, intContainer, oidSet, contentData, certSet, crlSet, infoSet, endContainer};
                    this.contentASN1Template = new ASN1Template(contentASN1Def1);
                } else {
                    ASN1Container[] contentASN1Def2 = new ASN1Container[]{seq, intContainer, oidSet, contentData, crlSet, infoSet, endContainer};
                    this.contentASN1Template = new ASN1Template(contentASN1Def2);
                }
            } else if (!this.certs.isEmpty()) {
                ASN1Container[] contentASN1Def3 = new ASN1Container[]{seq, intContainer, oidSet, contentData, certSet, infoSet, endContainer};
                this.contentASN1Template = new ASN1Template(contentASN1Def3);
            } else {
                ASN1Container[] contentASN1Def4 = new ASN1Container[]{seq, intContainer, oidSet, contentData, infoSet, endContainer};
                this.contentASN1Template = new ASN1Template(contentASN1Def4);
            }
            return this.contentASN1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Could not DER encode SignedData: ", (Exception)((Object)asnException));
        }
    }

    protected void assignDetachedMessageContentInfoSeq() {
        this.contentEncoding = new byte[13];
        this.contentEncoding[0] = 48;
        this.contentEncoding[1] = 11;
        this.contentEncoding[2] = 6;
        this.contentEncoding[3] = 9;
        System.arraycopy(P7OID, 0, this.contentEncoding, 4, 9);
        this.contentEncoding[12] = this.preDigestFlag ? (byte)1 : (byte)this.content.getContentType();
    }

    protected void digestContentData(int usage) throws PKCS7Exception {
        byte[] octets = null;
        if (!this.preDigestFlag) {
            if (this.contentEncoding == null) {
                if (this.content == null) {
                    throw new PKCS7Exception("There is no content to sign.");
                }
                int contentLen = this.content.getContentInfoDERLen();
                this.contentEncoding = new byte[contentLen];
                this.content.writeMessage(this.contentEncoding, 0);
            }
            octets = this.getEncodedContent();
        }
        try {
            if (usage == 0) {
                for (SignerInfo signer : this.signers) {
                    String signerDigestAlgName = signer.getDigestAlgorithmName();
                    if (signerDigestAlgName == null) {
                        throw new PKCS7Exception("Could not DER encode ContentInfo: Signer's digest algorithm is not set.");
                    }
                    this.addDigestAlgorithm(signer.getDigestAlgorithmOID(), signerDigestAlgName);
                }
            }
            if (octets == null) {
                return;
            }
            if (!this.preDigestFlag) {
                for (int index = 0; index < this.digestIDs.size(); ++index) {
                    byte[] digestOID = this.digestIDs.elementAt(index);
                    JSAFE_MessageDigest digestObject = JSAFEFactory.getDigest(digestOID, 0, this.getDeviceOrJava(), this.theCertJ);
                    byte[] digest = this.digests.elementAt(index);
                    if (digest != null) continue;
                    digestObject.digestInit();
                    digestObject.digestUpdate(octets, 0, octets.length);
                    byte[] digestOctets = digestObject.digestFinal();
                    digestObject.clearSensitiveData();
                    this.digests.setElementAt(digestOctets, index);
                    this.digestLengths.setElementAt(new Integer(digestOctets.length), index);
                }
            }
        }
        catch (JSAFE_Exception jsafeException) {
            throw new PKCS7Exception("Could not digest ContentInfo: ", (Exception)((Object)jsafeException));
        }
    }

    protected byte[] initOctets(ASN1Container oid, ASN1Container encContent) throws ASN_Exception {
        byte[] octets = null;
        if (CertJUtils.byteArraysEqual(oid.data, oid.dataOffset, oid.dataLen - 1, P7OID, 0, P7OID.length - 1)) {
            switch (oid.data[oid.dataOffset + oid.dataLen - 1]) {
                case 1: {
                    octets = this.initDataOctets(oid, encContent);
                    break;
                }
                default: {
                    int skipBytes = 1;
                    skipBytes += ASN1Lengths.determineLengthLen((byte[])encContent.data, (int)(encContent.dataOffset + 1));
                    ++skipBytes;
                    skipBytes += ASN1Lengths.determineLengthLen((byte[])encContent.data, (int)(encContent.dataOffset + skipBytes));
                    octets = new byte[encContent.dataLen - skipBytes];
                    System.arraycopy(encContent.data, encContent.dataOffset + skipBytes, octets, 0, encContent.dataLen - skipBytes);
                }
            }
        }
        return octets;
    }

    protected byte[] initDataOctets(ASN1Container oid, ASN1Container encContent) throws ASN_Exception {
        byte[] octets;
        OctetStringContainer octetStringContainer = new OctetStringContainer(0xA10000, true, 0, encContent.data, encContent.dataOffset, encContent.dataLen);
        ASN1Container[] octetDef = new ASN1Container[]{octetStringContainer};
        ASN1.berDecode((byte[])encContent.data, (int)encContent.dataOffset, (ASN1Container[])octetDef);
        if (octetStringContainer.data == null || octetStringContainer.dataLen == 0) {
            octets = new byte[]{};
        } else {
            octets = new byte[octetStringContainer.dataLen];
            System.arraycopy(octetStringContainer.data, octetStringContainer.dataOffset, octets, 0, octetStringContainer.dataLen);
        }
        return octets;
    }

    protected void estimateDigestLens() throws PKCS7Exception {
        Enumeration<SignerInfo> e = this.signers.elements();
        while (e.hasMoreElements()) {
            SignerInfo signer = e.nextElement();
            this.addDigestAlgorithm(signer.getDigestAlgorithmOID(), signer.getDigestAlgorithmName());
        }
        if (!this.preDigestFlag) {
            for (int index = 0; index < this.digestIDs.size(); ++index) {
                JSAFE_MessageDigest digestObject;
                byte[] digestOID = this.digestIDs.elementAt(index);
                try {
                    digestObject = JSAFEFactory.getDigest(digestOID, 0, this.getDeviceOrJava(), this.theCertJ);
                }
                catch (JSAFE_Exception jsafeException) {
                    throw new PKCS7Exception("Could not digest ContentInfo: ", (Exception)((Object)jsafeException));
                }
                int digestLen = digestObject.getDigestSize();
                this.digestLengths.setElementAt(new Integer(digestLen), index);
            }
        }
    }

    private void addDigestAlgorithm(byte[] digestOID, String digestAlgName) throws PKCS7Exception {
        if (digestOID == null) {
            throw new PKCS7Exception("Cannot add digest algorithm. Digest OID is null.");
        }
        if (digestAlgName == null) {
            digestAlgName = DigestedData.getDigestAlgorithmNameInternal(this.theCertJ, digestOID, null);
        }
        if (!this.digestNames.contains(digestAlgName)) {
            this.digestNames.addElement(digestAlgName);
            this.digestIDs.addElement(digestOID);
            this.digests.addElement(null);
            this.digestLengths.addElement(null);
        }
    }

    private void estimationSetContentData(Vector<SignerInfo> signersCopy) throws PKCS7Exception {
        this.estimateDigestLens();
        if (signersCopy.isEmpty()) {
            return;
        }
        if (this.theCertJ == null) {
            throw new PKCS7Exception("CertJ object cannot be null.");
        }
        if (this.theCertPathCtx == null) {
            throw new PKCS7Exception("CertPathCtx object cannot be null.");
        }
        DatabaseService theDatabase = this.theCertPathCtx.getDatabase();
        if (theDatabase == null) {
            throw new PKCS7Exception("database field of theCertPathCtx object cannot be null.");
        }
        for (SignerInfo signer : signersCopy) {
            int signLen = 0;
            this.estimationSetSignerDigest(signer);
            String algName = signer.getEncryptionAlgorithmName();
            if ("DSA".equals(algName)) {
                signLen = 48;
            }
            if (signLen == 0) {
                Certificate certificate = null;
                for (X509Certificate cert : this.certs) {
                    if (!cert.getIssuerName().equals(signer.getIssuerName()) || !CertJUtils.byteArraysEqual(cert.getSerialNumber(), signer.getSerialNumber())) continue;
                    certificate = cert;
                    break;
                }
                if (certificate == null) {
                    int certCount;
                    Vector<Certificate> certList = new Vector<Certificate>();
                    try {
                        certCount = theDatabase.selectCertificateByIssuerAndSerialNumber(signer.getIssuerName(), signer.getSerialNumber(), certList);
                    }
                    catch (NoServiceException noServiceException) {
                        throw new PKCS7Exception("Could not estimate SignedData length: ", noServiceException);
                    }
                    catch (DatabaseException databaseExc) {
                        throw new PKCS7Exception("Cannot get Cert from DB: ", databaseExc);
                    }
                    if (certCount == 0) {
                        throw new PKCS7Exception("Certificate is missing.");
                    }
                    certificate = (X509Certificate)certList.elementAt(0);
                }
                try {
                    JSAFE_PublicKey pubKey = certificate.getSubjectPublicKey(JAVA);
                    signLen = pubKey.getKeyData()[0].length;
                }
                catch (CertificateException e) {
                    throw new PKCS7Exception("Cannot estimate signature length: ", e);
                }
            }
            byte[] signature = new byte[signLen];
            signer.setEncryptedDigest(signature, 0, signature.length);
        }
    }

    private void estimationSetSignerDigest(SignerInfo signerCopy) throws PKCS7Exception {
        if (signerCopy == null) {
            throw new PKCS7Exception("Cannot set SignerDigest: SignerInfo is null");
        }
        String digestAlgName = signerCopy.getDigestAlgorithmName();
        if (digestAlgName == null) {
            throw new PKCS7Exception("Signer's digest algorithm is not set.");
        }
        int digestIndex = this.digestNames.indexOf(digestAlgName);
        Integer digestLen = this.digestLengths.elementAt(digestIndex);
        if (digestLen == null) {
            throw new PKCS7Exception("Cannot determine digest length");
        }
        X501Attributes attr = signerCopy.getAuthenticatedAttrs();
        if (attr != null || this.content != null && this.content.getContentType() != 1) {
            ContentType type;
            if (attr == null) {
                attr = new X501Attributes();
            }
            if ((type = (ContentType)attr.getAttributeByType(14)) == null) {
                type = new ContentType();
            }
            int localOid = this.preDigestFlag ? 1 : this.content.getContentType();
            byte[] oidType = new byte[9];
            System.arraycopy(P7OID, 0, oidType, 0, 9);
            oidType[8] = (byte)localOid;
            type.setContentType(oidType, 0, 9);
            attr.addAttribute(type);
            MessageDigest md = (MessageDigest)attr.getAttributeByType(15);
            if (md == null) {
                md = new MessageDigest();
            }
            byte[] finalDigest = new byte[digestLen.intValue()];
            md.setMessageDigest(finalDigest, 0, finalDigest.length);
            attr.addAttribute(md);
            signerCopy.setAuthenticatedAttrs(attr);
        }
    }

    private void setContentData() throws PKCS7Exception {
        this.digestContentData(0);
        if (this.signers.isEmpty()) {
            return;
        }
        if (this.theCertJ == null) {
            throw new PKCS7Exception("CertJ object cannot be null.");
        }
        if (this.theCertPathCtx == null) {
            throw new PKCS7Exception("CertPathCtx object cannot be null.");
        }
        DatabaseService theDatabase = this.theCertPathCtx.getDatabase();
        if (theDatabase == null) {
            throw new PKCS7Exception("Database field of the CertPathCtx object cannot be null");
        }
        DatabaseService theDB = null;
        MemoryDB tempDB = null;
        if (!this.certs.isEmpty()) {
            tempDB = this.storeIntoTempDB(this.certs, null);
            theDB = this.addTempDB(theDatabase, tempDB.getName());
        }
        DatabaseService dbToUse = theDB == null ? theDatabase : theDB;
        for (SignerInfo signer : this.signers) {
            String signerAlgName = signer.getEncryptionAlgorithmName();
            this.setupAttributes(signer, 0);
            byte[] signature = signerAlgName.indexOf("DSA") != -1 ? this.signDSAECDSA(signer, dbToUse) : this.signRSA(signer, dbToUse);
            signer.setEncryptedDigest(signature, 0, signature.length);
        }
        if (theDB != null) {
            this.theCertJ.unbindService(theDB);
        }
        if (tempDB != null) {
            try {
                this.theCertJ.unregisterService(1, tempDB.getName());
            }
            catch (InvalidParameterException e) {
                // empty catch block
            }
        }
    }

    private void checkAttributes(SignerInfo signer) throws PKCS7Exception {
        X501Attributes attr = signer.getAuthenticatedAttrs();
        if (attr != null || this.content != null && this.content.getContentType() != 1) {
            X501Attribute type;
            if (attr == null) {
                attr = new X501Attributes();
            }
            if ((type = attr.getAttributeByType(14)) == null) {
                throw new PKCS7Exception("ContentType attribute is missing");
            }
            X501Attribute md = attr.getAttributeByType(15);
            if (md == null) {
                throw new PKCS7Exception("MessageDigest attribute is missing");
            }
        }
    }

    private byte[] getHashOfContent(SignerInfo signer) throws PKCS7Exception {
        String digestAlgName = signer.getDigestAlgorithmName();
        if (digestAlgName == null) {
            throw new PKCS7Exception("Signers digest algorithm is not set");
        }
        this.setupAttributes(signer, 1);
        int digestIndex = this.digestNames.indexOf(digestAlgName);
        byte[] finalMessage = this.digests.elementAt(digestIndex);
        X501Attributes attr = signer.getAuthenticatedAttrs();
        if (attr != null || this.content != null && this.content.getContentType() != 1) {
            byte[] attrEncoding = this.getEncodedAttributes(signer);
            finalMessage = this.hashMessage(digestAlgName, attrEncoding);
        }
        return finalMessage;
    }

    private void setupAttributes(SignerInfo signer, int operation) throws PKCS7Exception {
        X501Attributes attr = signer.getAuthenticatedAttrs();
        if (attr != null || this.content != null && this.content.getContentType() != 1) {
            X501Attribute type;
            String digestAlgName = signer.getDigestAlgorithmName();
            int digestIndex = this.digestNames.indexOf(digestAlgName);
            byte[] finalDigest = this.digests.elementAt(digestIndex);
            if (attr == null) {
                attr = new X501Attributes();
            }
            if ((type = attr.getAttributeByType(14)) == null) {
                type = new ContentType();
            }
            byte[] oidType = this.getOidType();
            ((ContentType)type).setContentType(oidType, 0, oidType.length);
            attr.addAttribute(type);
            X501Attribute md = attr.getAttributeByType(15);
            if (md == null) {
                md = new MessageDigest();
            }
            if (operation == 0) {
                if (finalDigest != null) {
                    ((MessageDigest)md).setMessageDigest(finalDigest, 0, finalDigest.length);
                    attr.addAttribute(md);
                    signer.setAuthenticatedAttrs(attr);
                }
            } else {
                byte[] attributeDigest = ((MessageDigest)md).getMessageDigest();
                if (!CertJUtils.byteArraysEqual(attributeDigest, finalDigest)) {
                    throw new PKCS7Exception("MessageDigest attribute value can not be verified.");
                }
            }
        }
    }

    private byte[] signDSAECDSA(SignerInfo signer, DatabaseService db) throws PKCS7Exception {
        String digestAlgName = signer.getDigestAlgorithmName();
        String algName = signer.getEncryptionAlgorithmName();
        byte[] message = null;
        X501Attributes attr = signer.getAuthenticatedAttrs();
        String finalAlgName = digestAlgName + "/" + algName + "/NoPad";
        if (attr != null) {
            message = this.getEncodedAttributes(signer);
        }
        if (message == null) {
            message = this.getEncodedContent();
        }
        JSAFE_PrivateKey privateKey = this.getPrivateKeyFromDatabase(db, signer);
        JSAFE_Signature signObject = null;
        try {
            signObject = JSAFEFactory.getSignature(finalAlgName, this.getDeviceOrJava(), this.theCertJ);
            JSAFE_SecureRandom random = this.theCertJ.getRandomObject();
            signObject.signInit(privateKey, null, (SecureRandom)random, this.theCertJ.getPKCS11Sessions());
            int signLen = signObject.getSignatureSize();
            byte[] signature = new byte[signLen];
            signObject.signUpdate(message, 0, message.length);
            signLen = signObject.signFinal(signature, 0);
            if (signLen != signature.length) {
                byte[] retSig = new byte[signLen];
                System.arraycopy(signature, 0, retSig, 0, retSig.length);
                byte[] byArray = retSig;
                return byArray;
            }
            byte[] byArray = signature;
            return byArray;
        }
        catch (JSAFE_Exception e) {
            throw new PKCS7Exception("Could not perform Signing " + (Object)((Object)e));
        }
        catch (NoServiceException e) {
            throw new PKCS7Exception("Could not perform Signing " + e);
        }
        catch (RandomException e) {
            throw new PKCS7Exception("Could not perform Signing " + e);
        }
        finally {
            if (signObject != null) {
                signObject.clearSensitiveData();
            }
            if (privateKey != null) {
                privateKey.clearSensitiveData();
            }
        }
    }

    private void verifyDSAECDSASignature(SignerInfo signer, JSAFE_PublicKey publicKey, byte[] signature) throws PKCS7Exception {
        String digestAlgName = signer.getDigestAlgorithmName();
        String algName = signer.getEncryptionAlgorithmName();
        byte[] message = null;
        X501Attributes attr = signer.getAuthenticatedAttrs();
        String finalAlgName = digestAlgName + "/" + algName + "/NoPad";
        if (attr != null) {
            message = this.getEncodedAttributes(signer);
        }
        if (message == null) {
            message = this.getEncodedContent();
        }
        JSAFE_Signature verifyObject = null;
        try {
            verifyObject = JSAFEFactory.getSignature(finalAlgName, this.getDeviceOrJava(), this.theCertJ);
            JSAFE_SecureRandom random = this.theCertJ.getRandomObject();
            verifyObject.verifyInit(publicKey, null, (SecureRandom)random, this.theCertJ.getPKCS11Sessions());
            verifyObject.verifyUpdate(message, 0, message.length);
            if (!verifyObject.verifyFinal(signature, 0, signature.length)) {
                byte[] newSignature = this.recodeSignature(signature);
                if (newSignature == null) {
                    this.failSigners.addElement(signer);
                } else {
                    verifyObject.verifyReInit();
                    verifyObject.verifyUpdate(message, 0, message.length);
                    if (!verifyObject.verifyFinal(newSignature, 0, newSignature.length)) {
                        this.failSigners.addElement(signer);
                    }
                }
            }
        }
        catch (JSAFE_Exception e) {
            throw new PKCS7Exception("Could not verify: ", (Exception)((Object)e));
        }
        catch (NoServiceException e) {
            throw new PKCS7Exception("Could not verify: ", e);
        }
        catch (RandomException e) {
            throw new PKCS7Exception("Could not verify: ", e);
        }
        finally {
            if (verifyObject != null) {
                verifyObject.clearSensitiveData();
            }
        }
    }

    private byte[] recodeSignature(byte[] signature) {
        SequenceContainer aSeq = new SequenceContainer(0);
        EndContainer anEnd = new EndContainer();
        IntegerContainer theR = new IntegerContainer(0);
        IntegerContainer theS = new IntegerContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{aSeq, theR, theS, anEnd};
        try {
            ASN1.berDecode((byte[])signature, (int)0, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception ex) {
            return null;
        }
        byte[] rArray = new byte[theR.dataLen];
        byte[] sArray = new byte[theS.dataLen];
        System.arraycopy(theR.data, theR.dataOffset, rArray, 0, rArray.length);
        System.arraycopy(theS.data, theS.dataOffset, sArray, 0, sArray.length);
        for (int i = theS.dataOffset + theS.dataLen; i < signature.length; ++i) {
            if (signature[i] == 0) continue;
            return null;
        }
        SequenceContainer aSeq2 = new SequenceContainer(0, true, 0);
        EndContainer anEnd2 = new EndContainer();
        try {
            IntegerContainer theR2 = new IntegerContainer(0, true, 0, rArray, 0, rArray.length, true);
            IntegerContainer theS2 = new IntegerContainer(0, true, 0, sArray, 0, sArray.length, true);
            ASN1Container[] asn1Def2 = new ASN1Container[]{aSeq2, theR2, theS2, anEnd2};
            ASN1Template template = new ASN1Template(asn1Def2);
            template.derEncodeInit();
            byte[] newSignature = new byte[rArray.length + sArray.length + 6];
            template.derEncode(newSignature, 0);
            return newSignature;
        }
        catch (ASN_Exception ex) {
            return null;
        }
    }

    private void verifyRSASignature(SignerInfo signer, JSAFE_PublicKey publicKey, byte[] signature) throws PKCS7Exception {
        String algName = signer.getEncryptionAlgorithmName();
        String finalAlgName = "NoDigest/" + algName + "/PKCS1Block01Pad";
        byte[] message = this.getHashOfContent(signer);
        byte[] digestInfo = this.getDigestInfoBER(signer.getDigestAlgorithmOID(), message);
        JSAFE_Signature verifyObject = null;
        try {
            verifyObject = JSAFEFactory.getSignature(finalAlgName, this.getDeviceOrJava(), this.theCertJ);
            JSAFE_SecureRandom random = this.theCertJ.getRandomObject();
            verifyObject.verifyInit(publicKey, null, (SecureRandom)random, this.theCertJ.getPKCS11Sessions());
            verifyObject.verifyUpdate(digestInfo, 0, digestInfo.length);
            if (!verifyObject.verifyFinal(signature, 0, signature.length)) {
                this.failSigners.addElement(signer);
            }
        }
        catch (JSAFE_Exception e) {
            throw new PKCS7Exception("Could not verify: ", (Exception)((Object)e));
        }
        catch (NoServiceException e) {
            throw new PKCS7Exception("Could not verify: ", e);
        }
        catch (RandomException e) {
            throw new PKCS7Exception("Could not verify: ", e);
        }
        finally {
            if (verifyObject != null) {
                verifyObject.clearSensitiveData();
            }
        }
    }

    private byte[] getEncodedAttributes(SignerInfo signer) throws PKCS7Exception {
        X501Attributes attr = signer.getAuthenticatedAttrs();
        byte[] attrEncoding = signer.getAuthenticatedAttrsBer();
        if (attrEncoding == null) {
            attrEncoding = new byte[attr.getDERLen(0)];
            try {
                attr.getDEREncoding(attrEncoding, 0, 0);
            }
            catch (AttributeException e) {
                throw new PKCS7Exception("Could not get Attribute Encoding", e);
            }
        }
        return attrEncoding;
    }

    private byte[] getEncodedContent() throws PKCS7Exception {
        byte[] octets = null;
        if (this.contentEncoding == null) {
            if (this.content == null) {
                throw new PKCS7Exception("There is no content to sign.");
            }
            int contentLen = this.content.getContentInfoDERLen();
            this.contentEncoding = new byte[contentLen];
            this.content.writeMessage(this.contentEncoding, 0);
        }
        SequenceContainer seq = new SequenceContainer(0);
        EndContainer anEnd = new EndContainer();
        OIDContainer localOid = new OIDContainer(0x1000000);
        EncodedContainer encContent = new EncodedContainer(10616576);
        ASN1Container[] returnValue = new ASN1Container[]{seq, localOid, encContent, anEnd};
        try {
            ASN1.berDecode((byte[])this.contentEncoding, (int)0, (ASN1Container[])returnValue);
            octets = encContent.dataPresent ? this.initOctets((ASN1Container)localOid, (ASN1Container)encContent) : new byte[]{};
        }
        catch (ASN_Exception e) {
            throw new PKCS7Exception("Could not DER encode ContentInfo: ", (Exception)((Object)e));
        }
        return octets;
    }

    private byte[] signRSA(SignerInfo signer, DatabaseService db) throws PKCS7Exception {
        String algName = signer.getEncryptionAlgorithmName();
        byte[] hash = this.getHashOfContent(signer);
        byte[] digestInfo = this.getDigestInfoBER(signer.getDigestAlgorithmOID(), hash);
        String finalAlg = "NoDigest/" + algName + "/PKCS1Block01Pad";
        JSAFE_PrivateKey privateKey = this.getPrivateKeyFromDatabase(db, signer);
        JSAFE_Signature signObject = null;
        try {
            signObject = JSAFEFactory.getSignature(finalAlg, this.getDeviceOrJava(), this.theCertJ);
            JSAFE_SecureRandom random = this.theCertJ.getRandomObject();
            signObject.signInit(privateKey, null, (SecureRandom)random, this.theCertJ.getPKCS11Sessions());
            int signLen = signObject.getSignatureSize();
            byte[] signature = new byte[signLen];
            signObject.signUpdate(digestInfo, 0, digestInfo.length);
            signLen = signObject.signFinal(signature, 0);
            if (signLen != signature.length) {
                byte[] retSig = new byte[signLen];
                System.arraycopy(signature, 0, retSig, 0, retSig.length);
                byte[] byArray = retSig;
                return byArray;
            }
            byte[] byArray = signature;
            return byArray;
        }
        catch (NoServiceException e) {
            throw new PKCS7Exception("Could not perform Signing " + e);
        }
        catch (JSAFE_Exception e) {
            throw new PKCS7Exception("Could not perform Signing " + (Object)((Object)e));
        }
        catch (RandomException e) {
            throw new PKCS7Exception("Could not perform Signing " + e);
        }
        finally {
            if (signObject != null) {
                signObject.clearSensitiveData();
            }
            if (privateKey != null) {
                privateKey.clearSensitiveData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void verifySignature() throws PKCS7Exception {
        block34: {
            if (this.signers.isEmpty()) {
                return;
            }
            if (this.theCertJ == null) {
                throw new PKCS7Exception("CertJ context object is null.");
            }
            DatabaseService theDatabase = null;
            if (this.theCertPathCtx != null) {
                theDatabase = this.theCertPathCtx.getDatabase();
            }
            DatabaseService theDB = null;
            Provider tempDB = null;
            String tempDBName = null;
            try {
                DatabaseService dbToBeUsed;
                if (!(this.theCertPathCtx == null || this.certs.isEmpty() && this.crls.isEmpty())) {
                    tempDB = this.storeIntoTempDB(this.certs, this.crls);
                    tempDBName = tempDB.getName();
                    theDB = this.addTempDB(theDatabase, tempDBName);
                }
                DatabaseService databaseService = dbToBeUsed = theDB == null ? theDatabase : theDB;
                if (this.certs.isEmpty() && dbToBeUsed == null) {
                    throw new PKCS7Exception("Cannot get a certificate for all signers.");
                }
                for (SignerInfo signer : this.signers) {
                    JSAFE_PublicKey publicKey;
                    CertPathCtx pathCtx = null;
                    try {
                        Vector<Certificate> certList = new Vector<Certificate>();
                        X509Certificate cert = null;
                        if (dbToBeUsed != null) {
                            CertPathCtx pathCtxToBeUsed;
                            int certCount = dbToBeUsed.selectCertificateByIssuerAndSerialNumber(signer.getIssuerName(), signer.getSerialNumber(), certList);
                            if (certCount == 0) {
                                this.notFoundCertSigners.addElement(signer);
                                continue;
                            }
                            cert = (X509Certificate)certList.elementAt(0);
                            if (theDB != null && this.theCertPathCtx != null) {
                                pathCtx = new CertPathCtx(this.theCertPathCtx.getPathOptions(), this.theCertPathCtx.getTrustedCerts(), this.theCertPathCtx.getPolicies(), this.theCertPathCtx.getValidationTime(), theDB);
                            }
                            CertPathCtx certPathCtx = pathCtxToBeUsed = pathCtx == null ? this.theCertPathCtx : pathCtx;
                            if (!this.theCertJ.buildCertPath(pathCtxToBeUsed, cert, null, null, null, null)) {
                                this.failedPathSigners.addElement(signer);
                            }
                        } else {
                            if (this.certs.size() > 0) {
                                if (signer.getIssuerName() == null) throw new PKCS7Exception("Signer's name or serial number is not set.");
                                if (signer.getSerialNumber() == null) {
                                    throw new PKCS7Exception("Signer's name or serial number is not set.");
                                }
                            }
                            for (X509Certificate localCert : this.certs) {
                                if (!signer.getIssuerName().equals(localCert.getIssuerName()) || !CertJUtils.byteArraysEqual(signer.getSerialNumber(), localCert.getSerialNumber())) continue;
                                cert = localCert;
                                break;
                            }
                            if (cert == null) {
                                this.notFoundCertSigners.addElement(signer);
                                continue;
                            }
                            this.failedPathSigners.addElement(signer);
                        }
                        if (cert == null) {
                            throw new PKCS7Exception("Cannot find signer's certificate.");
                        }
                        publicKey = cert.getSubjectPublicKey(this.getDeviceOrJava());
                    }
                    catch (NoServiceException noServiceExc) {
                        throw new PKCS7Exception("Cannot get Cert from DB: ", noServiceExc);
                    }
                    catch (DatabaseException databaseExc) {
                        throw new PKCS7Exception("Cannot get Cert from DB: ", databaseExc);
                    }
                    catch (CertificateException certException) {
                        throw new PKCS7Exception("Cannot get IssuerName and SerialNumber from cert: ", certException);
                    }
                    catch (CertPathException certPathExc) {
                        throw new PKCS7Exception("Cannot validate cert path: ", certPathExc);
                    }
                    catch (InvalidParameterException paramExc) {
                        throw new PKCS7Exception("Cannot validate cert path: ", paramExc);
                    }
                    byte[] digestOID = signer.getDigestAlgorithmOID();
                    if (digestOID == null) {
                        this.failSigners.addElement(signer);
                        continue;
                    }
                    String algName = signer.getEncryptionAlgorithmName();
                    String digestName = signer.getDigestAlgorithmName();
                    if (algName == null) throw new PKCS7Exception("Encryption Algorithm name or Digest name cannot be null");
                    if (digestName == null) {
                        throw new PKCS7Exception("Encryption Algorithm name or Digest name cannot be null");
                    }
                    this.checkAttributes(signer);
                    if (algName.indexOf("DSA") != -1) {
                        this.verifyDSAECDSASignature(signer, publicKey, signer.getEncryptedDigest());
                        continue;
                    }
                    this.verifyRSASignature(signer, publicKey, signer.getEncryptedDigest());
                }
                if (theDB != null) {
                    this.theCertJ.unbindService(theDB);
                }
                if (tempDB == null) break block34;
            }
            catch (Throwable throwable) {
                if (theDB != null) {
                    this.theCertJ.unbindService(theDB);
                }
                if (tempDB == null) throw throwable;
                try {
                    this.theCertJ.unregisterService(1, tempDB.getName());
                    throw throwable;
                }
                catch (InvalidParameterException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.theCertJ.unregisterService(1, tempDB.getName());
            }
            catch (InvalidParameterException e) {}
        }
        if (!this.failSigners.isEmpty()) throw new PKCS7Exception(this.createExceptionMessage());
        if (!this.failedPathSigners.isEmpty()) {
            if (this.theCertPathCtx != null) throw new PKCS7Exception(this.createExceptionMessage());
        }
        if (this.notFoundCertSigners.isEmpty()) return;
        throw new PKCS7Exception(this.createExceptionMessage());
    }

    private JSAFE_PrivateKey getPrivateKeyFromDatabase(DatabaseService db, SignerInfo signer) throws PKCS7Exception {
        JSAFE_PrivateKey privateKey = null;
        Vector<Certificate> certList = new Vector<Certificate>();
        try {
            Certificate cert;
            int certCount = db.selectCertificateByIssuerAndSerialNumber(signer.getIssuerName(), signer.getSerialNumber(), certList);
            if (certCount == 0) {
                throw new PKCS7Exception("Certificate is missing.");
            }
            Iterator<Certificate> i$ = certList.iterator();
            while (i$.hasNext() && (privateKey = db.selectPrivateKeyByCertificate(cert = i$.next())) == null) {
            }
        }
        catch (NoServiceException e) {
            throw new PKCS7Exception("Could not perform Signing: " + e);
        }
        catch (DatabaseException e) {
            throw new PKCS7Exception("Could not perform Signing: " + e);
        }
        if (privateKey == null) {
            throw new PKCS7Exception("Private key is missing.");
        }
        certList.removeAllElements();
        return privateKey;
    }

    private byte[] hashMessage(String digestAlgName, byte[] message) throws PKCS7Exception {
        byte[] digest;
        int digestIndex = this.digestNames.indexOf(digestAlgName);
        byte[] digestAlgId = this.digestIDs.elementAt(digestIndex);
        JSAFE_MessageDigest digestObject = null;
        try {
            digestObject = JSAFEFactory.getDigest(digestAlgId, 0, JAVA, this.theCertJ);
            digestObject.digestInit();
            digestObject.digestUpdate(message, 0, message.length);
            digest = digestObject.digestFinal();
        }
        catch (JSAFE_Exception e) {
            throw new PKCS7Exception("Could not create hash object");
        }
        return digest;
    }

    protected byte[] getSignerDigest(SignerInfo signer, int usage) throws PKCS7Exception {
        byte[] finalDigest;
        if (signer == null) {
            throw new PKCS7Exception("Cannot set SignerDigest: SignerInfo is null");
        }
        try {
            String digestAlgName = signer.getDigestAlgorithmName();
            if (digestAlgName == null) {
                throw new PKCS7Exception("Signer's digest algorithm is not set.");
            }
            int digestIndex = this.digestNames.indexOf(digestAlgName);
            finalDigest = this.digests.elementAt(digestIndex);
            byte[] digestAlgId = this.digestIDs.elementAt(digestIndex);
            JSAFE_MessageDigest digestObject = JSAFEFactory.getDigest(digestAlgId, 0, JAVA, this.theCertJ);
            X501Attributes attr = signer.getAuthenticatedAttrs();
            if (attr != null || this.content != null && this.content.getContentType() != 1) {
                int attrLen;
                X501Attribute md;
                X501Attribute type;
                if (attr == null) {
                    attr = new X501Attributes();
                }
                if ((type = attr.getAttributeByType(14)) == null) {
                    if (usage == 1) {
                        throw new PKCS7Exception("While decoding, ContentType attribute is missing");
                    }
                    type = new ContentType();
                }
                if (usage == 0) {
                    byte[] oidType = this.getOidType();
                    ((ContentType)type).setContentType(oidType, 0, oidType.length);
                    attr.addAttribute(type);
                }
                if ((md = attr.getAttributeByType(15)) == null) {
                    if (usage == 1) {
                        throw new PKCS7Exception("While decoding, MessageDigest attribute is missing");
                    }
                    md = new MessageDigest();
                }
                if (usage == 0) {
                    if (finalDigest != null) {
                        ((MessageDigest)md).setMessageDigest(finalDigest, 0, finalDigest.length);
                    }
                    attr.addAttribute(md);
                    signer.setAuthenticatedAttrs(attr);
                } else {
                    byte[] message = ((MessageDigest)md).getMessageDigest();
                    if (!CertJUtils.byteArraysEqual(message, finalDigest)) {
                        throw new PKCS7Exception("Value in MessageDigest attribute does not contain the right digest.");
                    }
                }
                byte[] attrEncoding = signer.getAuthenticatedAttrsBer();
                if (attrEncoding == null) {
                    attrEncoding = new byte[attr.getDERLen(0)];
                    attrLen = attr.getDEREncoding(attrEncoding, 0, 0);
                } else {
                    attrLen = attrEncoding.length;
                }
                digestObject.digestInit();
                digestObject.digestUpdate(attrEncoding, 0, attrLen);
                finalDigest = digestObject.digestFinal();
                digestObject.clearSensitiveData();
            }
        }
        catch (JSAFE_Exception jsafeException) {
            throw new PKCS7Exception("Could not digest ContentInfo: ", (Exception)((Object)jsafeException));
        }
        catch (AttributeException attrException) {
            throw new PKCS7Exception("Could not DER encode Attributes: ", attrException);
        }
        return finalDigest;
    }

    protected byte[] getOidType() {
        int localOid = this.preDigestFlag ? 1 : this.content.getContentType();
        byte[] oidType = new byte[9];
        System.arraycopy(P7OID, 0, oidType, 0, 9);
        oidType[8] = (byte)localOid;
        return oidType;
    }

    private byte[] checkOID(byte[] algorithmOID) throws PKCS7Exception {
        byte[] retEncoding;
        SequenceContainer aSeq = new SequenceContainer(0, true, 0);
        EndContainer anEnd = new EndContainer();
        EncodedContainer param = new EncodedContainer(65536);
        OIDContainer localOid = new OIDContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{aSeq, localOid, param, anEnd};
        OIDList.getTrans((byte[])algorithmOID, (int)0, (int)algorithmOID.length, (int)-1);
        try {
            ASN1.berDecode((byte[])algorithmOID, (int)0, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Cannot decode algorithm OID: ", (Exception)((Object)asnException));
        }
        if (param.data == null) {
            byte[] nullParam = new byte[]{5, 0};
            try {
                param.addData(nullParam, 0, nullParam.length, true, true);
                retEncoding = ASN1.derEncode((ASN1Container[])asn1Def);
            }
            catch (ASN_Exception asnException) {
                throw new PKCS7Exception("Cannot encode algorithm OID: ", (Exception)((Object)asnException));
            }
        } else {
            retEncoding = algorithmOID;
        }
        return retEncoding;
    }

    private byte[] getDigestInfoBER(byte[] digestAlgorithm, byte[] digest) throws PKCS7Exception {
        if (digestAlgorithm == null) {
            throw new PKCS7Exception("DigestAlgorithm OID is null.");
        }
        try {
            byte[] tmpDigAlgo = this.checkOID(digestAlgorithm);
            SequenceContainer aSeq = new SequenceContainer(0, true, 0);
            EndContainer anEnd = new EndContainer();
            EncodedContainer localOid = new EncodedContainer(12288, true, 0, tmpDigAlgo, 0, tmpDigAlgo.length);
            int digestLen = 0;
            if (digest != null) {
                digestLen = digest.length;
            }
            OctetStringContainer octets = new OctetStringContainer(0, true, 0, digest, 0, digestLen);
            ASN1Container[] asn1Def = new ASN1Container[]{aSeq, localOid, octets, anEnd};
            ASN1Template templ = new ASN1Template(asn1Def);
            int len = templ.derEncodeInit();
            byte[] output = new byte[len];
            templ.derEncode(output, 0);
            return output;
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Cannot encode digestInfo: ", (Exception)((Object)asnException));
        }
    }

    @Override
    protected boolean contentReadInit(byte[] input, int inOffset, int maxInputLen) throws PKCS7Exception {
        try {
            SequenceContainer seq = new SequenceContainer(0xA10000);
            EndContainer endContainer = new EndContainer();
            IntegerContainer intContainer = new IntegerContainer(0);
            EncodedContainer oidSet = new EncodedContainer(12544);
            EncodedContainer contentData = new EncodedContainer(12288, true, 0, this.maxBufferSize, null, 0, 0);
            EncodedContainer certSet = new EncodedContainer(8466688);
            EncodedContainer crlSet = new EncodedContainer(8466689);
            EncodedContainer infoSet = new EncodedContainer(12544);
            this.contentASN1Def = new ASN1Container[8];
            this.contentASN1Def[0] = seq;
            this.contentASN1Def[1] = intContainer;
            this.contentASN1Def[2] = oidSet;
            this.contentASN1Def[3] = contentData;
            this.contentASN1Def[4] = certSet;
            this.contentASN1Def[5] = crlSet;
            this.contentASN1Def[6] = infoSet;
            this.contentASN1Def[7] = endContainer;
            this.contentASN1Template = new ASN1Template(this.contentASN1Def);
            this.contentASN1Template.berDecodeInit();
            this.contentASN1Template.berDecodeUpdate(input, inOffset, maxInputLen);
            if (this.contentASN1Def[0].checkTag()) {
                return false;
            }
            this.setDecodedValues();
            this.flag = 1;
            return true;
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Could not decode message: ", (Exception)((Object)asnException));
        }
    }

    private void setDecodedValues() throws PKCS7Exception {
        try {
            byte[] output;
            if (this.version == -1) {
                if (this.contentASN1Def[1].isComplete()) {
                    if (this.incompleteContainer == 1) {
                        output = this.copyToOutput(this.contentASN1Def[1]);
                        IntegerContainer integer = new IntegerContainer(0, true, 0, output, 0, output.length, true);
                        this.version = integer.getValueAsInt();
                    } else {
                        this.version = ((IntegerContainer)this.contentASN1Def[1]).getValueAsInt();
                    }
                } else {
                    if (this.contentASN1Def[1].data == null) {
                        return;
                    }
                    this.incompleteContainer = 1;
                    this.copyNewData(this.contentASN1Def[1].data, this.contentASN1Def[1].dataOffset, this.contentASN1Def[1].dataLen, 0);
                    return;
                }
            }
            if (this.digestIDs.isEmpty()) {
                if (!this.contentASN1Def[2].isComplete()) {
                    if (this.contentASN1Def[2].data == null) {
                        return;
                    }
                    this.incompleteContainer = 2;
                    this.copyNewData(this.contentASN1Def[2].data, this.contentASN1Def[2].dataOffset, this.contentASN1Def[2].dataLen, 0);
                    return;
                }
                if (this.incompleteContainer == 2) {
                    output = this.copyToOutput(this.contentASN1Def[2]);
                    this.decodeDigestOIDs(output, 0);
                } else {
                    this.decodeDigestOIDs(this.contentASN1Def[2].data, this.contentASN1Def[2].dataOffset);
                }
            }
            if (this.content == null) {
                if (this.contentASN1Def[3].isComplete()) {
                    if (this.incompleteContainer == 3) {
                        output = this.copyToOutput(this.contentASN1Def[3]);
                        this.decodeContent(output, 0, output.length);
                    } else {
                        this.decodeContent(this.contentASN1Def[3].data, this.contentASN1Def[3].dataOffset, this.contentASN1Def[3].dataLen);
                    }
                } else {
                    if (this.contentASN1Def[3].data == null) {
                        return;
                    }
                    this.incompleteContainer = 3;
                    this.copyNewData(this.contentASN1Def[3].data, this.contentASN1Def[3].dataOffset, this.contentASN1Def[3].dataLen, this.maxBufferSize);
                    return;
                }
            }
            if (this.noDigestsCalculated()) {
                this.digestContentData(1);
            }
            if (this.certs.isEmpty()) {
                if (this.contentASN1Def[4].isComplete()) {
                    if (this.contentASN1Def[4].dataPresent) {
                        if (this.incompleteContainer == 4) {
                            output = this.copyToOutput(this.contentASN1Def[4]);
                            this.decodeCerts(output, 0);
                        } else {
                            this.decodeCerts(this.contentASN1Def[4].data, this.contentASN1Def[4].dataOffset);
                        }
                    }
                } else {
                    if (this.contentASN1Def[4].data == null) {
                        return;
                    }
                    this.incompleteContainer = 4;
                    this.copyNewData(this.contentASN1Def[4].data, this.contentASN1Def[4].dataOffset, this.contentASN1Def[4].dataLen, 0);
                    return;
                }
            }
            if (this.crls.isEmpty()) {
                if (this.contentASN1Def[5].isComplete()) {
                    if (this.contentASN1Def[5].dataPresent) {
                        if (this.incompleteContainer == 5) {
                            output = this.copyToOutput(this.contentASN1Def[5]);
                            this.decodeCRLs(output, 0);
                        } else {
                            this.decodeCRLs(this.contentASN1Def[5].data, this.contentASN1Def[5].dataOffset);
                        }
                    }
                } else {
                    if (this.contentASN1Def[5].data == null) {
                        return;
                    }
                    this.incompleteContainer = 5;
                    this.copyNewData(this.contentASN1Def[5].data, this.contentASN1Def[5].dataOffset, this.contentASN1Def[5].dataLen, 0);
                    return;
                }
            }
            if (this.signers.isEmpty()) {
                if (this.contentASN1Def[6].isComplete()) {
                    if (this.incompleteContainer == 6) {
                        output = this.copyToOutput(this.contentASN1Def[6]);
                        this.decodeSignerInfos(output, 0);
                    } else {
                        this.decodeSignerInfos(this.contentASN1Def[6].data, this.contentASN1Def[6].dataOffset);
                    }
                } else {
                    if (this.contentASN1Def[6].data == null) {
                        return;
                    }
                    this.incompleteContainer = 6;
                    this.copyNewData(this.contentASN1Def[6].data, this.contentASN1Def[6].dataOffset, this.contentASN1Def[6].dataLen, 0);
                    return;
                }
            }
            if (!this.signers.isEmpty()) {
                this.verifySignature();
            }
        }
        catch (Exception anyException) {
            throw new PKCS7Exception("Cannot set decoded values: ", anyException);
        }
    }

    private void decodeDigestOIDs(byte[] data, int offset) throws PKCS7Exception {
        if (data == null) {
            throw new PKCS7Exception("Digest OIDs data is null.");
        }
        try {
            OfContainer setOf = new OfContainer(0, 12544, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] asn1Def = new ASN1Container[]{setOf};
            ASN1.berDecode((byte[])data, (int)offset, (ASN1Container[])asn1Def);
            int oidCount = setOf.getContainerCount();
            for (int index = 0; index < oidCount; ++index) {
                ASN1Container nextContainer = setOf.containerAt(index);
                EncodedContainer localOid = new EncodedContainer(12288, true, 0, null, 0, 0);
                ASN1Container[] oidDef = new ASN1Container[]{localOid};
                ASN1.berDecode((byte[])nextContainer.data, (int)nextContainer.dataOffset, (ASN1Container[])oidDef);
                byte[] digestOID = new byte[localOid.dataLen];
                System.arraycopy(localOid.data, localOid.dataOffset, digestOID, 0, localOid.dataLen);
                this.addDigestAlgorithm(digestOID, null);
            }
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Cannot decode digest OIDs: ", (Exception)((Object)asnException));
        }
    }

    protected void decodeContent(byte[] data, int offset, int len) throws PKCS7Exception {
        if (data == null) {
            throw new PKCS7Exception("Content data is null.");
        }
        try {
            SequenceContainer seq = new SequenceContainer(0);
            EndContainer anEnd = new EndContainer();
            OIDContainer localOid = new OIDContainer(0x1000000);
            EncodedContainer encContent = new EncodedContainer(10616576, true, 0, this.maxBufferSize, null, 0, 0);
            ASN1Container[] returnValue = new ASN1Container[]{seq, localOid, encContent, anEnd};
            ASN1.berDecode((byte[])data, (int)offset, (ASN1Container[])returnValue);
            this.content = this.buildContentContainer(localOid.data, localOid.dataOffset, localOid.dataLen);
            if (this.content.readInit(data, offset, len, this.maxBufferSize) && this.content.readFinal()) {
                return;
            }
        }
        catch (Exception anyException) {
            throw new PKCS7Exception("Cannot decode content: ", anyException);
        }
        throw new PKCS7Exception("Cannot decode content.");
    }

    protected ContentInfo buildContentContainer(byte[] data, int offset, int len) throws PKCS7Exception {
        return ContentInfo.getInstance(data, offset, len, this.theCertJ, this.theCertPathCtx);
    }

    private void decodeCerts(byte[] data, int offset) throws PKCS7Exception {
        if (data == null) {
            throw new PKCS7Exception("Certs data is null.");
        }
        try {
            OfContainer setOf = new OfContainer(0x810000, 12544, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] asn1Def = new ASN1Container[]{setOf};
            ASN1.berDecode((byte[])data, (int)offset, (ASN1Container[])asn1Def);
            int certCount = setOf.getContainerCount();
            for (int index = 0; index < certCount; ++index) {
                ASN1Container nextContainer = setOf.containerAt(index);
                X509Certificate cert = new X509Certificate(nextContainer.data, nextContainer.dataOffset, 0);
                this.addCertificate(cert);
            }
        }
        catch (Exception anyException) {
            throw new PKCS7Exception("Cannot decode certs: ", anyException);
        }
    }

    private void decodeCRLs(byte[] data, int offset) throws PKCS7Exception {
        if (data == null) {
            throw new PKCS7Exception("CRLs data is null.");
        }
        try {
            OfContainer setOf = new OfContainer(0x810001, 12544, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] asn1Def = new ASN1Container[]{setOf};
            ASN1.berDecode((byte[])data, (int)offset, (ASN1Container[])asn1Def);
            int crlCount = setOf.getContainerCount();
            for (int index = 0; index < crlCount; ++index) {
                ASN1Container nextContainer = setOf.containerAt(index);
                X509CRL crl = new X509CRL(nextContainer.data, nextContainer.dataOffset, 0);
                this.addCRL(crl);
            }
        }
        catch (Exception anyException) {
            throw new PKCS7Exception("Cannot decode crls: ", anyException);
        }
    }

    private void decodeSignerInfos(byte[] data, int offset) throws PKCS7Exception {
        if (data == null) {
            throw new PKCS7Exception("SignerInfo data is null.");
        }
        try {
            OfContainer setOf = new OfContainer(0, 12544, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] asn1Def = new ASN1Container[]{setOf};
            ASN1.berDecode((byte[])data, (int)offset, (ASN1Container[])asn1Def);
            int signerCount = setOf.getContainerCount();
            for (int index = 0; index < signerCount; ++index) {
                ASN1Container nextContainer = setOf.containerAt(index);
                SignerInfo signer = new SignerInfo(CertJInternalHelper.context(this.theCertJ), nextContainer.data, nextContainer.dataOffset, 0);
                this.addSignerInfo(signer);
            }
        }
        catch (Exception anyException) {
            throw new PKCS7Exception("Cannot decode signerInfo: ", anyException);
        }
    }

    private String createExceptionMessage() {
        StringBuffer message = new StringBuffer();
        if (!this.notFoundCertSigners.isEmpty()) {
            message.append("Cannot find certificates for signers: ");
            for (SignerInfo signer : this.notFoundCertSigners) {
                try {
                    if (signer.getIssuerName() == null || signer.getSerialNumber() == null) continue;
                    message.append("\nIssuer Name ");
                    message.append(signer.getIssuerName().toString());
                    message.append(" , Serial Number ");
                    message.append(this.printBuffer(signer.getSerialNumber()));
                }
                catch (PKCS7Exception p7Exception) {}
            }
        }
        if (!this.failedPathSigners.isEmpty()) {
            message.append("\nCannot build and verify certPath for signers: ");
            for (SignerInfo signer : this.failedPathSigners) {
                try {
                    if (signer.getIssuerName() == null || signer.getSerialNumber() == null) continue;
                    message.append("\n Issuer Name ");
                    message.append(signer.getIssuerName().toString());
                    message.append(" , Serial Number ");
                    message.append(this.printBuffer(signer.getSerialNumber()));
                }
                catch (PKCS7Exception p7Exception) {}
            }
        }
        if (!this.failSigners.isEmpty()) {
            message.append("\nCannot verify signature for signers: ");
            for (SignerInfo signer : this.failSigners) {
                try {
                    if (signer.getIssuerName() == null || signer.getSerialNumber() == null) continue;
                    message.append("\n Issuer Name ");
                    message.append(signer.getIssuerName().toString());
                    message.append(" , Serial Number ");
                    message.append(this.printBuffer(signer.getSerialNumber()));
                }
                catch (PKCS7Exception p7Exception) {}
            }
        }
        return message.toString();
    }

    private String printBuffer(byte[] buffer) {
        return this.printBuffer(buffer, 0, buffer.length);
    }

    private String printBuffer(byte[] buffer, int offset, int length) {
        StringBuffer theLine = new StringBuffer();
        while (length > 0) {
            int index = 0;
            while (index < 8 && length != 0) {
                int temp = buffer[offset] & 0xFF;
                String hexVal = Integer.toHexString(temp);
                if (hexVal.length() == 1) {
                    theLine.append(" 0");
                } else {
                    theLine.append(" ");
                }
                theLine.append(hexVal);
                --length;
                ++index;
                ++offset;
            }
            theLine.append("\n");
        }
        return theLine.toString();
    }

    public Vector<SignerInfo> getFailedSigners() {
        if (this.failSigners.isEmpty()) {
            return null;
        }
        return new Vector<SignerInfo>(this.failSigners);
    }

    public Vector<SignerInfo> getFailedCertPathSigners() {
        if (this.failedPathSigners.isEmpty()) {
            return null;
        }
        return new Vector<SignerInfo>(this.failedPathSigners);
    }

    @Override
    protected int contentReadUpdate(byte[] input, int inOffset, int maxInputLen) throws PKCS7Exception {
        int bytesToOutput = 0;
        if (input == null) {
            return bytesToOutput;
        }
        if (this.contentASN1Template == null) {
            throw new PKCS7Exception("Call readInit before readUpdate.");
        }
        try {
            if (this.contentASN1Template.isComplete()) {
                return bytesToOutput;
            }
            bytesToOutput = this.contentASN1Template.berDecodeUpdate(input, inOffset, maxInputLen);
            this.setDecodedValues();
            return bytesToOutput;
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Could not decode message: ", (Exception)((Object)asnException));
        }
    }

    protected boolean contentReadFinal() throws PKCS7Exception {
        try {
            this.contentASN1Template.berDecodeFinal();
        }
        catch (ASN_Exception asnException) {
            throw new PKCS7Exception("Cannot call readFinal: ", (Exception)((Object)asnException));
        }
        if (!this.contentASN1Template.isComplete()) {
            throw new PKCS7Exception("Cannot call readFinal, more message expected.");
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SignedData otherSelf = (SignedData)super.clone();
        otherSelf.version = this.version;
        otherSelf.detachedFlag = this.detachedFlag;
        otherSelf.preDigestFlag = this.preDigestFlag;
        if (this.digestIDs != null) {
            otherSelf.digestIDs = new Vector<byte[]>(this.digestIDs);
        }
        if (this.digestNames != null) {
            otherSelf.digestNames = new Vector<String>(this.digestNames);
        }
        if (this.digestIDs != null) {
            otherSelf.digests = new Vector<byte[]>(this.digests);
        }
        if (this.certs != null) {
            otherSelf.certs = new Vector<X509Certificate>(this.certs);
        }
        if (this.crls != null) {
            otherSelf.crls = new Vector<X509CRL>(this.crls);
        }
        if (this.signers != null) {
            otherSelf.signers = new Vector<SignerInfo>(this.signers);
        }
        return otherSelf;
    }

    public boolean equals(Object obj) {
        int otherIndex;
        int index;
        int otherLen;
        if (obj == null || !(obj instanceof SignedData)) {
            return false;
        }
        SignedData other = (SignedData)obj;
        if (other.version != this.version) {
            return false;
        }
        if (this.content != null && !this.content.equals(other.content)) {
            return false;
        }
        if (other.preDigestFlag != this.preDigestFlag) {
            return false;
        }
        int thisLen = this.signers.size();
        if (thisLen != (otherLen = other.signers.size())) {
            return false;
        }
        for (index = 0; index < thisLen; ++index) {
            if (this.signers.elementAt(index) == null) continue;
            for (otherIndex = 0; otherIndex < otherLen && !this.signers.elementAt(index).equals(other.signers.elementAt(otherIndex)); ++otherIndex) {
            }
            if (otherIndex != otherLen) continue;
            return false;
        }
        thisLen = this.digestIDs.size();
        if (thisLen != (otherLen = other.digestIDs.size())) {
            return false;
        }
        for (index = 0; index < thisLen; ++index) {
            otherIndex = 0;
            if (this.digestIDs.elementAt(index) != null) {
                for (otherIndex = 0; otherIndex < otherLen && !CertJUtils.byteArraysEqual(this.digestIDs.elementAt(index), other.digestIDs.elementAt(otherIndex)); ++otherIndex) {
                }
                if (otherIndex == otherLen) {
                    return false;
                }
            }
            String thisDigestName = this.digestNames.elementAt(index);
            byte[] thisDigest = this.digests.elementAt(index);
            String otherDigestName = other.digestNames.elementAt(otherIndex);
            byte[] otherDigest = other.digests.elementAt(otherIndex);
            if (thisDigestName == null) {
                if (otherDigestName != null) {
                    return false;
                }
            } else {
                if (otherDigestName == null) {
                    return false;
                }
                if (!thisDigestName.equals(otherDigestName)) {
                    return false;
                }
            }
            if (thisDigest == null) {
                if (otherDigest == null) continue;
                return false;
            }
            if (otherDigest == null) {
                return false;
            }
            if (CertJUtils.byteArraysEqual(thisDigest, otherDigest)) continue;
            return false;
        }
        thisLen = this.failSigners.size();
        if (thisLen != (otherLen = other.failSigners.size())) {
            return false;
        }
        for (index = 0; index < thisLen; ++index) {
            if (!(this.failSigners.elementAt(index) != null ? !this.failSigners.elementAt(index).equals(other.failSigners.elementAt(index)) : other.failSigners.elementAt(index) != null)) continue;
            return false;
        }
        thisLen = this.certs.size();
        if (thisLen != (otherLen = other.certs.size())) {
            return false;
        }
        for (index = 0; index < thisLen; ++index) {
            if (this.certs.elementAt(index) == null) continue;
            for (otherIndex = 0; otherIndex < otherLen && !this.certs.elementAt(index).equals(other.certs.elementAt(otherIndex)); ++otherIndex) {
            }
            if (otherIndex != otherLen) continue;
            return false;
        }
        thisLen = this.crls.size();
        if (thisLen != (otherLen = other.crls.size())) {
            return false;
        }
        for (index = 0; index < thisLen; ++index) {
            if (this.crls.elementAt(index) == null) continue;
            for (otherIndex = 0; otherIndex < otherLen && !this.crls.elementAt(index).equals(other.crls.elementAt(otherIndex)); ++otherIndex) {
            }
            if (otherIndex != otherLen) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + CertJInternalHelper.hashCodeValue(this.certs);
        result = 31 * result + CertJInternalHelper.hashCodeValue(this.crls);
        result = 31 * result + CertJInternalHelper.hashCodeValue(this.digestIDs);
        result = 31 * result + CertJInternalHelper.hashCodeValue(this.digestNames);
        result = 31 * result + CertJInternalHelper.hashCodeValue(this.digests);
        result = 31 * result + CertJInternalHelper.hashCodeValue(this.failSigners);
        result = 31 * result + CertJInternalHelper.hashCodeValue(this.signers);
        result = 31 * result + (this.preDigestFlag ? 1231 : 1237);
        result = 31 * result + this.version;
        return result;
    }

    @Override
    public void clearSensitiveData() {
        super.clearSensitiveData();
        this.version = -1;
        this.digestIDs = new Vector();
        this.digestNames = new Vector();
        this.digests = new Vector();
        this.digestLengths = new Vector();
        this.certs = new Vector();
        this.crls = new Vector();
        this.signers = new Vector();
    }

    private MemoryDB storeIntoTempDB(Vector<X509Certificate> certs, Vector<X509CRL> crls) throws PKCS7Exception {
        if ((certs == null || certs.isEmpty()) && (crls == null || crls.isEmpty())) {
            return null;
        }
        if (this.theCertJ == null) {
            throw new PKCS7Exception("SignedData.storeIntoTempDB: theCertJ should not be null.");
        }
        DatabaseService tempService = null;
        try {
            int i;
            String tempDBName = this.findUniqueDBName("Temp Memory DB");
            MemoryDB tempDB = new MemoryDB(tempDBName);
            this.theCertJ.registerService(tempDB);
            tempService = (DatabaseService)this.theCertJ.bindService(1, tempDBName);
            if (certs != null && !certs.isEmpty()) {
                for (i = 0; i < certs.size(); ++i) {
                    tempService.insertCertificate(certs.elementAt(i));
                }
            }
            if (crls != null && !crls.isEmpty()) {
                for (i = 0; i < crls.size(); ++i) {
                    tempService.insertCRL(crls.elementAt(i));
                }
            }
            MemoryDB memoryDB = tempDB;
            if (tempService != null) {
                this.theCertJ.unbindService(tempService);
            }
            return memoryDB;
        }
        catch (CertJException e) {
            try {
                throw new PKCS7Exception("SignedData.storeIntoTempDB: ", e);
            }
            catch (Throwable throwable) {
                if (tempService != null) {
                    this.theCertJ.unbindService(tempService);
                }
                throw throwable;
            }
        }
    }

    private DatabaseService addTempDB(DatabaseService db, String tempDB) throws PKCS7Exception {
        try {
            String[] dbProviders = db.listProviderNames();
            String[] newDbProviders = new String[dbProviders.length + 1];
            System.arraycopy(dbProviders, 0, newDbProviders, 0, dbProviders.length);
            newDbProviders[dbProviders.length] = tempDB;
            return (DatabaseService)this.theCertJ.bindServices(1, newDbProviders);
        }
        catch (CertJException e) {
            throw new PKCS7Exception("SignedData.addTempDB: ", e);
        }
    }

    private String findUniqueDBName(String preferredName) {
        String[] existingNames = this.theCertJ.listProviderNames(1);
        if (!this.nameAlreadyExists(preferredName, existingNames)) {
            return preferredName;
        }
        int i = 0;
        String candidate;
        while (this.nameAlreadyExists(candidate = preferredName + i, existingNames)) {
            ++i;
        }
        return candidate;
    }

    private boolean nameAlreadyExists(String name, String[] existingNames) {
        for (int i = 0; i < existingNames.length; ++i) {
            if (!name.equals(existingNames[i])) continue;
            return true;
        }
        return false;
    }

    private boolean noDigestsCalculated() {
        Enumeration<byte[]> e = this.digests.elements();
        while (e.hasMoreElements()) {
            if (e.nextElement() == null) continue;
            return false;
        }
        return true;
    }
}

