/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.db;

import com.rsa.certj.CertJ;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.provider.db.EnhancedFlatFileDBImpl;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Hashtable;

public final class EnhancedFlatFileDB
extends Provider {
    File path;
    char[] passphrase;
    byte[] salt;
    static Hashtable<File, Object> accessHash = new Hashtable();

    public EnhancedFlatFileDB(String name, File path, char[] passphrase, byte[] salt) throws InvalidParameterException {
        super(1, name);
        if (path == null) {
            throw new InvalidParameterException("Error: path should not be null.");
        }
        if (passphrase == null) {
            throw new InvalidParameterException("Error: passphrase should not be null.");
        }
        if (salt == null) {
            throw new InvalidParameterException("Error: salt should not be null.");
        }
        this.path = path;
        this.passphrase = (char[])passphrase.clone();
        this.salt = (byte[])salt.clone();
    }

    public static boolean delete(File path) throws InvalidParameterException {
        if (path == null) {
            throw new InvalidParameterException("Path should not be null.");
        }
        if (!path.exists()) {
            return false;
        }
        if (accessHash.get(path) != null) {
            throw new InvalidParameterException("Cannot delete database currently in use.");
        }
        EnhancedFlatFileDB.cleanupDirectory(new File(path, "certs"), "cer");
        EnhancedFlatFileDB.cleanupDirectory(new File(path, "crls"), "crl");
        EnhancedFlatFileDB.cleanupDirectory(new File(path, "privs"), "prv");
        EnhancedFlatFileDB.cleanupDirectory(new File(path, "pubs"), "pub");
        boolean success = path.delete();
        if (success) {
            accessHash.remove(path);
        }
        return success;
    }

    private static void cleanupDirectory(File directory, String extension) {
        if (!directory.exists()) {
            return;
        }
        DbFilenameFilter filter = new DbFilenameFilter(extension);
        File[] files = directory.listFiles(filter);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
        }
        directory.delete();
    }

    public synchronized ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        try {
            return new EnhancedFlatFileDBImpl(this, certJ, this.getName());
        }
        catch (InvalidParameterException e) {
            throw new ProviderManagementException(e);
        }
    }

    private static class DbFilenameFilter
    implements FilenameFilter {
        private String basefilename;

        public DbFilenameFilter(String extension) {
            this.basefilename = "." + extension;
        }

        public boolean accept(File directory, String filename) {
            return filename.endsWith(this.basefilename);
        }
    }
}

